/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.system;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ServiceUtil {
    private ServiceUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Set getAllRunningService(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List infos = activityManager.getRunningServices(Integer.MAX_VALUE);
        HashSet<String> names = new HashSet<String>();
        if (infos == null || infos.size() == 0) {
            return null;
        }
        for (ActivityManager.RunningServiceInfo info : infos) {
            names.add(info.service.getClassName());
        }
        return names;
    }

    public static boolean isServiceRunning(Context context, String className) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List infos = activityManager.getRunningServices(Integer.MAX_VALUE);
        if (infos == null || infos.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningServiceInfo info : infos) {
            if (!className.equals(info.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static boolean stopService(Context context, String className) {
        try {
            Intent intent = new Intent(context, Class.forName(className));
            return context.stopService(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

