/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.system;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.webkit.MimeTypeMap;
import com.liujc.baseutils.file.FileUtil;
import java.io.File;

public class IntentUtil {
    private IntentUtil() {
        throw new UnsupportedOperationException("u can't fuck me...");
    }

    public static Intent getInstallAppIntent(String filePath) {
        return IntentUtil.getInstallAppIntent(FileUtil.getFileByPath(filePath));
    }

    public static Intent getInstallAppIntent(File file) {
        if (file == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        String type = Build.VERSION.SDK_INT < 23 ? "application/vnd.android.package-archive" : MimeTypeMap.getSingleton().getMimeTypeFromExtension(FileUtil.getFileExtension(file));
        intent.setDataAndType(Uri.fromFile((File)file), type);
        return intent.addFlags(0x10000000);
    }

    public static Intent getUninstallAppIntent(String packageName) {
        Intent intent = new Intent("android.intent.action.DELETE");
        intent.setData(Uri.parse((String)("package:" + packageName)));
        return intent.addFlags(0x10000000);
    }

    public static Intent getLaunchAppIntent(Context context, String packageName) {
        return context.getPackageManager().getLaunchIntentForPackage(packageName);
    }

    public static Intent getAppDetailsSettingsIntent(String packageName) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + packageName)));
        return intent.addFlags(0x10000000);
    }

    public static Intent getShareTextIntent(String content) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", content);
        return intent.setFlags(0x10000000);
    }

    public static Intent getShareImageIntent(String content, String imagePath) {
        return IntentUtil.getShareImageIntent(content, FileUtil.getFileByPath(imagePath));
    }

    public static Intent getShareImageIntent(String content, File image) {
        if (!FileUtil.isFileExists(image)) {
            return null;
        }
        return IntentUtil.getShareImageIntent(content, Uri.fromFile((File)image));
    }

    public static Intent getShareImageIntent(String content, Uri uri) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.TEXT", content);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
        intent.setType("image/*");
        return intent.setFlags(0x10000000);
    }

    public static Intent getComponentIntent(String packageName, String className) {
        return IntentUtil.getComponentIntent(packageName, className, null);
    }

    public static Intent getComponentIntent(String packageName, String className, Bundle bundle) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        ComponentName cn = new ComponentName(packageName, className);
        intent.setComponent(cn);
        return intent.addFlags(0x10000000);
    }

    public static Intent getShutdownIntent() {
        Intent intent = new Intent("android.intent.action.ACTION_SHUTDOWN");
        return intent.addFlags(0x10000000);
    }

    public static Intent getCaptureIntent(Uri outUri) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)outUri);
        return intent.addFlags(0x10000001);
    }
}

