/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.system.AuthCode;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import com.liujc.baseutils.common.LogUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VerificationCodeAutoFill
implements LoaderManager.LoaderCallbacks<Cursor> {
    private Context context;
    private OnNewMessageListener listener;
    private String msgRegular;

    public VerificationCodeAutoFill(Context context) {
        this(context, null, null);
    }

    public VerificationCodeAutoFill(Context context, OnNewMessageListener listener) {
        this(context, listener, null);
    }

    public VerificationCodeAutoFill(Context context, OnNewMessageListener listener, String msgRegular) {
        this.context = context;
        this.listener = listener;
        this.msgRegular = msgRegular;
    }

    public VerificationCodeAutoFill registerTo(int id, LoaderManager manager) {
        manager.initLoader(id, null, (LoaderManager.LoaderCallbacks)this);
        return this;
    }

    public Loader<Cursor> onCreateLoader(int id, Bundle args) {
        return new CursorLoader(this.context, Uri.parse((String)"content://sms/inbox"), new String[]{"_id", "address", "read", "body"}, " read=?", new String[]{"0"}, "_id desc");
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        if (data != null && data.getCount() > 0) {
            ContentValues values = new ContentValues();
            values.put("read", "1");
            data.moveToNext();
            int smsbodyColumn = data.getColumnIndex("body");
            String smsBody = data.getString(smsbodyColumn);
            LogUtil.d("smsBody:" + smsBody);
            if (this.listener != null) {
                this.listener.onNewMessage(this.getDynamicPassword(smsBody, this.msgRegular));
            }
        }
    }

    public void onLoaderReset(Loader<Cursor> loader) {
    }

    private String getDynamicPassword(String str, String regular) {
        if (regular == null) {
            return str;
        }
        Pattern continuousNumberPattern = Pattern.compile(this.msgRegular);
        Matcher m = continuousNumberPattern.matcher(str);
        String dynamicPassword = "";
        while (m.find()) {
            System.out.print(m.group());
            dynamicPassword = m.group();
        }
        return dynamicPassword;
    }

    public static interface OnNewMessageListener {
        public void onNewMessage(String var1);
    }
}

