/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.system.AuthCode;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.provider.Telephony;
import android.support.annotation.Nullable;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import android.util.Log;
import com.liujc.baseutils.system.AuthCode.CodeConfig;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReadSmsService
extends Service {
    private static final String TAG = ReadSmsService.class.getSimpleName();
    private static final String SMS_RECEIVED_ACTION = "android.provider.Telephony.SMS_RECEIVED";
    private static final String SMS_INBOX_URI = "content://sms/inbox";
    private static final String SMS_URI = "content://sms";
    static final String[] PROJECTION = new String[]{"_id", "address", "body", "date"};
    public static final String EXTRAS_MESSAGER = "com.liujc.baseutils.system.AuthCode.ReadSmsService.EXTRAS_MESSAGER";
    public static final String EXTRAS_COFIG = "com.liujc.baseutils.system.AuthCode.ReadSmsService.EXTRAS_COFIG";
    public static final int RECEIVER_SMS_CODE_MSG = 0;
    public static final int OBSERVER_SMS_CODE_MSG = 1;
    private Messenger mMessenger;
    private CodeConfig mCodeConfig;
    private ContentObserver mReadSmsObserver = new ContentObserver(new Handler()){

        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            Cursor cursor = ReadSmsService.this.getContentResolver().query(Uri.parse((String)ReadSmsService.SMS_INBOX_URI), PROJECTION, "read=?", new String[]{"0"}, "date DESC");
            ReadSmsService.this.getSmsCodeFromObserver(cursor);
        }
    };
    private BroadcastReceiver mReadSmsCodeReceiver = new ReadSmsCodeReceiver();

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            Bundle bundle = intent.getExtras();
            if (bundle == null) {
                Log.e((String)"AutoInputAuthCode", (String)"bundle = null");
            } else {
                this.register();
                this.mMessenger = (Messenger)bundle.getParcelable(EXTRAS_MESSAGER);
                this.mCodeConfig = (CodeConfig)bundle.getParcelable(EXTRAS_COFIG);
            }
        }
        return 2;
    }

    public void onDestroy() {
        super.onDestroy();
        this.unRegister();
    }

    void getSmsCodeFromReceiver(Intent intent) {
        SmsMessage[] messages = null;
        if (Build.VERSION.SDK_INT >= 19 ? (messages = Telephony.Sms.Intents.getMessagesFromIntent((Intent)intent)) == null : (messages = this.getSmsUnder19(intent)) == null) {
            return;
        }
        if (messages.length > 0) {
            for (int i = 0; i < messages.length; ++i) {
                SmsMessage sms = messages[i];
                String smsSender = sms.getOriginatingAddress();
                String smsBody = sms.getMessageBody();
                if (!this.checkSmsSender(smsSender) || !this.checkSmsBody(smsBody)) continue;
                String smsCode = this.parseSmsBody(smsBody);
                this.sendMsg2Register(1, smsCode);
                break;
            }
        }
    }

    @Nullable
    private SmsMessage[] getSmsUnder19(Intent intent) {
        Bundle bundle = intent.getExtras();
        Object[] pdus = (Object[])bundle.get("pdus");
        if (pdus == null || pdus.length == 0) {
            return null;
        }
        SmsMessage[] messages = new SmsMessage[pdus.length];
        for (int i = 0; i < pdus.length; ++i) {
            messages[i] = SmsMessage.createFromPdu((byte[])((byte[])pdus[i]));
        }
        return messages;
    }

    void getSmsCodeFromObserver(Cursor cursor) {
        if (cursor == null) {
            return;
        }
        while (cursor.moveToNext()) {
            String address = cursor.getString(cursor.getColumnIndex("address"));
            String smsBody = cursor.getString(cursor.getColumnIndex("body"));
            if (!this.checkSmsSender(address) || !this.checkSmsBody(smsBody)) continue;
            String smsCode = this.parseSmsBody(smsBody);
            this.sendMsg2Register(0, smsCode);
            break;
        }
        this.closeCursor(cursor);
    }

    private void closeCursor(Cursor cursor) {
        if (cursor == null || cursor.isClosed()) {
            return;
        }
        if (!cursor.isClosed()) {
            cursor.close();
        }
    }

    private boolean checkSmsBody(String smsBody) {
        if (!TextUtils.isEmpty((CharSequence)this.mCodeConfig.getSmsBodyStart()) && !TextUtils.isEmpty((CharSequence)this.mCodeConfig.getSmsBodyContains())) {
            return smsBody.startsWith(this.mCodeConfig.getSmsBodyStart()) && smsBody.contains(this.mCodeConfig.getSmsBodyContains());
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCodeConfig.getSmsBodyStart())) {
            return smsBody.startsWith(this.mCodeConfig.getSmsBodyStart());
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCodeConfig.getSmsBodyContains())) {
            return smsBody.contains(this.mCodeConfig.getSmsBodyContains());
        }
        return true;
    }

    private boolean checkSmsSender(String smsSender) {
        if (this.mCodeConfig.getSmsFrom() != 0L) {
            return smsSender.equals(String.valueOf(this.mCodeConfig.getSmsFrom()));
        }
        return smsSender.contains(String.valueOf(this.mCodeConfig.getSmsFromStart()));
    }

    private void register() {
        this.registerReceiver();
        this.registerObserver();
    }

    private void registerReceiver() {
        IntentFilter filter = new IntentFilter(SMS_RECEIVED_ACTION);
        filter.addAction(SMS_RECEIVED_ACTION);
        filter.setPriority(1000);
        this.registerReceiver(this.mReadSmsCodeReceiver, filter);
    }

    private void registerObserver() {
        this.getContentResolver().registerContentObserver(Uri.parse((String)SMS_URI), true, this.mReadSmsObserver);
    }

    private void unRegister() {
        this.unRegisterReceiver();
        this.unRegisterObserver();
    }

    private void unRegisterReceiver() {
        if (this.mReadSmsCodeReceiver == null) {
            return;
        }
        this.unregisterReceiver(this.mReadSmsCodeReceiver);
        this.mReadSmsCodeReceiver = null;
    }

    private void unRegisterObserver() {
        if (this.mReadSmsObserver == null) {
            return;
        }
        this.getContentResolver().unregisterContentObserver(this.mReadSmsObserver);
        this.mReadSmsObserver = null;
    }

    private String parseSmsBody(String smsBody) {
        int len = this.mCodeConfig.getCodeLen();
        String regex = new String("(\\d{" + len + "})");
        String smsCode = "";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(smsBody);
        while (matcher.find()) {
            smsCode = matcher.group(0);
        }
        return smsCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMsg2Register(int msgWhat, String msgObj) {
        if (this.mMessenger != null) {
            Message msg = Message.obtain();
            msg.what = msgWhat;
            msg.obj = msgObj;
            try {
                this.mMessenger.send(msg);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            finally {
                this.stopSelf();
            }
        }
    }

    private class ReadSmsCodeReceiver
    extends BroadcastReceiver {
        private ReadSmsCodeReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(ReadSmsService.SMS_RECEIVED_ACTION)) {
                ReadSmsService.this.getSmsCodeFromReceiver(intent);
            }
        }
    }
}

