/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.system.AuthCode;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import android.widget.TextView;
import com.liujc.baseutils.system.AuthCode.CodeConfig;
import com.liujc.baseutils.system.AuthCode.ReadSmsService;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;

public class AuthCode {
    private Context mContext;
    private CodeConfig mCodeConfig;
    private Intent mAuthcodeIntent;
    private Handler mHandler;
    private static AuthCode sInstance;

    private AuthCode() {
    }

    public static synchronized AuthCode getInstance() {
        if (sInstance == null) {
            sInstance = new AuthCode();
        }
        return sInstance;
    }

    public AuthCode with(Context context) {
        this.mContext = context;
        return this;
    }

    public AuthCode config(CodeConfig config) {
        if (this.mContext == null) {
            throw new NullPointerException("mContext is null.Please call with(Context) first.");
        }
        this.mCodeConfig = config;
        return this;
    }

    public void into(TextView codeView) {
        if (this.mCodeConfig == null) {
            throw new NullPointerException("mCodeConfig is null.Please call config(CodeConfig) before this.");
        }
        this.mHandler = new AuthCodeHandler(codeView);
        if (this.checkPermission()) {
            this.startReadSmsService();
        } else {
            Log.e((String)"AutoInputAuthCode", (String)"Please allow app to read your sms for auto input auth code.");
        }
    }

    private boolean checkPermission() {
        return ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.RECEIVE_SMS") == 0 && ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.READ_SMS") == 0;
    }

    private void startReadSmsService() {
        this.mAuthcodeIntent = new Intent(this.mContext, ReadSmsService.class);
        this.mAuthcodeIntent.putExtra("com.liujc.baseutils.system.AuthCode.ReadSmsService.EXTRAS_MESSAGER", (Parcelable)new Messenger(this.mHandler));
        this.mAuthcodeIntent.putExtra("com.liujc.baseutils.system.AuthCode.ReadSmsService.EXTRAS_COFIG", (Parcelable)this.mCodeConfig);
        this.mContext.startService(this.mAuthcodeIntent);
    }

    static class AuthCodeHandler
    extends Handler {
        private Reference<TextView> mTextViewRef;

        public AuthCodeHandler(TextView codeView) {
            this.mTextViewRef = new SoftReference<TextView>(codeView);
        }

        @RequiresApi(api=9)
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            TextView mAuthCode = this.mTextViewRef.get();
            if (mAuthCode == null) {
                return;
            }
            if (!mAuthCode.getText().toString().isEmpty()) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    mAuthCode.setText((CharSequence)((String)msg.obj));
                    sInstance = null;
                    break;
                }
                case 0: {
                    mAuthCode.setText((CharSequence)((String)msg.obj));
                    sInstance = null;
                    break;
                }
            }
        }
    }
}

