/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import com.liujc.baseutils.common.LogUtil;

public class TimeReceiver
extends BroadcastReceiver {
    private TimeListener timeListener;

    public void onReceive(Context context, Intent intent) {
        LogUtil.d("action: " + intent.getAction());
        LogUtil.d("intent : ");
        Bundle bundle = intent.getExtras();
        for (String key : bundle.keySet()) {
            LogUtil.d(key + " : " + bundle.get(key));
        }
        if ("android.intent.action.TIME_TICK".equals(intent.getAction())) {
            if (this.timeListener != null) {
                this.timeListener.onTimeTick();
            }
        } else if ("android.intent.action.TIME_SET".equals(intent.getAction())) {
            if (this.timeListener != null) {
                this.timeListener.onTimeChanged();
            }
        } else if ("android.intent.action.TIMEZONE_CHANGED".equals(intent.getAction()) && this.timeListener != null) {
            this.timeListener.onTimeZoneChanged();
        }
    }

    public void registerReceiver(Context context, TimeListener timeListener) {
        try {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.TIME_TICK");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            filter.setPriority(Integer.MAX_VALUE);
            context.registerReceiver((BroadcastReceiver)this, filter);
            this.timeListener = timeListener;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unRegisterReceiver(Context context) {
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface TimeListener {
        public void onTimeZoneChanged();

        public void onTimeChanged();

        public void onTimeTick();
    }
}

