/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import com.liujc.baseutils.common.EmptyUtil;
import com.liujc.baseutils.common.LogUtil;

public class PhoneReceiver
extends BroadcastReceiver {
    private static final String RINGING = "RINGING";
    private static final String OFFHOOK = "OFFHOOK";
    private static final String IDLE = "IDLE";
    private static final String PHONE_STATE = "android.intent.action.PHONE_STATE";
    private static final String NEW_OUTGOING_CALL = "android.intent.action.NEW_OUTGOING_CALL";
    private static final String INTENT_STATE = "state";
    private static final String INTENT_INCOMING_NUMBER = "incoming_number";
    private PhoneListener phoneListener;
    private boolean isDialOut;
    private String number;

    public void onReceive(Context context, Intent intent) {
        LogUtil.d("action: " + intent.getAction());
        LogUtil.d("intent : ");
        Bundle bundle = intent.getExtras();
        for (String key : bundle.keySet()) {
            LogUtil.d(key + " : " + bundle.get(key));
        }
        if (NEW_OUTGOING_CALL.equals(intent.getAction())) {
            this.isDialOut = true;
            String outNumber = intent.getStringExtra("android.intent.extra.PHONE_NUMBER");
            if (!EmptyUtil.isEmpty(outNumber)) {
                this.number = outNumber;
            }
            if (this.phoneListener != null) {
                this.phoneListener.onPhoneStateChanged(CallState.Outgoing, this.number);
            }
        } else if (PHONE_STATE.equals(intent.getAction())) {
            String state = intent.getStringExtra(INTENT_STATE);
            String inNumber = intent.getStringExtra(INTENT_INCOMING_NUMBER);
            if (!EmptyUtil.isEmpty(inNumber)) {
                this.number = inNumber;
            }
            if (RINGING.equals(state)) {
                this.isDialOut = false;
                if (this.phoneListener != null) {
                    this.phoneListener.onPhoneStateChanged(CallState.IncomingRing, this.number);
                }
            } else if (OFFHOOK.equals(state)) {
                if (!this.isDialOut && this.phoneListener != null) {
                    this.phoneListener.onPhoneStateChanged(CallState.Incoming, this.number);
                }
            } else if (IDLE.equals(state)) {
                if (this.isDialOut) {
                    if (this.phoneListener != null) {
                        this.phoneListener.onPhoneStateChanged(CallState.OutgoingEnd, this.number);
                    }
                } else if (this.phoneListener != null) {
                    this.phoneListener.onPhoneStateChanged(CallState.IncomingEnd, this.number);
                }
            }
        }
    }

    public void registerReceiver(Context context, PhoneListener phoneListener) {
        try {
            IntentFilter filter = new IntentFilter();
            filter.addAction(PHONE_STATE);
            filter.addAction(NEW_OUTGOING_CALL);
            filter.setPriority(Integer.MAX_VALUE);
            context.registerReceiver((BroadcastReceiver)this, filter);
            this.phoneListener = phoneListener;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unRegisterReceiver(Context context) {
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum CallState {
        Outgoing,
        OutgoingEnd,
        IncomingRing,
        Incoming,
        IncomingEnd;

    }

    public static interface PhoneListener {
        public void onPhoneStateChanged(CallState var1, String var2);
    }
}

