/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.file;

import android.os.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetFilesUtil {
    public static final String FILE_TYPE_FOLDER = "wFl2d";
    public static final String FILE_INFO_NAME = "fName";
    public static final String FILE_INFO_ISFOLDER = "fIsDir";
    public static final String FILE_INFO_TYPE = "fFileType";
    public static final String FILE_INFO_NUM_SONDIRS = "fSonDirs";
    public static final String FILE_INFO_NUM_SONFILES = "fSonFiles";
    public static final String FILE_INFO_PATH = "fPath";
    private static GetFilesUtil gfu;

    private GetFilesUtil() {
    }

    public static synchronized GetFilesUtil getInstance() {
        if (gfu == null) {
            gfu = new GetFilesUtil();
        }
        return gfu;
    }

    public List<Map<String, Object>> getSonNode(File path) {
        if (path.isDirectory()) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            File[] files = path.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    HashMap<String, Object> fileInfo = new HashMap<String, Object>();
                    fileInfo.put(FILE_INFO_NAME, files[i].getName());
                    if (files[i].isDirectory()) {
                        fileInfo.put(FILE_INFO_ISFOLDER, true);
                        File[] bFiles = files[i].listFiles();
                        if (bFiles == null) {
                            fileInfo.put(FILE_INFO_NUM_SONDIRS, 0);
                            fileInfo.put(FILE_INFO_NUM_SONFILES, 0);
                        } else {
                            int getNumOfDir = 0;
                            for (int j = 0; j < bFiles.length; ++j) {
                                if (!bFiles[j].isDirectory()) continue;
                                ++getNumOfDir;
                            }
                            fileInfo.put(FILE_INFO_NUM_SONDIRS, getNumOfDir);
                            fileInfo.put(FILE_INFO_NUM_SONFILES, bFiles.length - getNumOfDir);
                        }
                        fileInfo.put(FILE_INFO_TYPE, FILE_TYPE_FOLDER);
                    } else {
                        fileInfo.put(FILE_INFO_ISFOLDER, false);
                        fileInfo.put(FILE_INFO_NUM_SONDIRS, 0);
                        fileInfo.put(FILE_INFO_NUM_SONFILES, 0);
                        fileInfo.put(FILE_INFO_TYPE, this.getFileType(files[i].getName()));
                    }
                    fileInfo.put(FILE_INFO_PATH, files[i].getAbsoluteFile());
                    list.add(fileInfo);
                }
                return list;
            }
            return null;
        }
        return null;
    }

    public List<Map<String, Object>> getSonNode(String pathStr) {
        File path = new File(pathStr);
        return this.getSonNode(path);
    }

    public List<Map<String, Object>> getBrotherNode(File path) {
        if (path.getParentFile() != null) {
            return this.getSonNode(path.getParentFile());
        }
        return null;
    }

    public List<Map<String, Object>> getBrotherNode(String pathStr) {
        File path = new File(pathStr);
        return this.getBrotherNode(path);
    }

    public String getParentPath(File path) {
        if (path.getParentFile() == null) {
            return null;
        }
        return path.getParent();
    }

    public String getParentPath(String pathStr) {
        File path = new File(pathStr);
        if (path.getParentFile() == null) {
            return null;
        }
        return path.getParent();
    }

    public String getSDPath() {
        String sdcard = Environment.getExternalStorageState();
        if (sdcard.equals("mounted")) {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        return null;
    }

    public String getBasePath() {
        String basePath = this.getSDPath();
        if (basePath == null) {
            return Environment.getDataDirectory().getAbsolutePath();
        }
        return basePath;
    }

    public String getFileSize(File path) throws IOException {
        if (path.exists()) {
            DecimalFormat df = new DecimalFormat("#.00");
            String sizeStr = "";
            FileInputStream fis = new FileInputStream(path);
            long size = fis.available();
            fis.close();
            sizeStr = size < 1024L ? size + "B" : (size < 0x100000L ? df.format((double)size / 1024.0) + "KB" : (size < 0x40000000L ? df.format((double)size / 1048576.0) + "MB" : df.format((double)size / 1.073741824E9) + "GB"));
            return sizeStr;
        }
        return null;
    }

    public String getFileSize(String fpath) {
        File path = new File(fpath);
        if (path.exists()) {
            DecimalFormat df = new DecimalFormat("#.00");
            String sizeStr = "";
            long size = 0L;
            try {
                FileInputStream fis = new FileInputStream(path);
                size = fis.available();
                fis.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return "\u672a\u77e5\u5927\u5c0f";
            }
            catch (IOException e) {
                e.printStackTrace();
                return "\u672a\u77e5\u5927\u5c0f";
            }
            sizeStr = size < 1024L ? size + "B" : (size < 0x100000L ? df.format((double)size / 1024.0) + "KB" : (size < 0x40000000L ? df.format((double)size / 1048576.0) + "MB" : df.format((double)size / 1.073741824E9) + "GB"));
            return sizeStr;
        }
        return "\u672a\u77e5\u5927\u5c0f";
    }

    public String getFileType(String fileName) {
        if (fileName != "" && fileName.length() > 3) {
            int dot = fileName.lastIndexOf(".");
            if (dot > 0) {
                return fileName.substring(dot + 1);
            }
            return "";
        }
        return "";
    }

    public Comparator<Map<String, Object>> defaultOrder() {
        String orderBy0 = FILE_INFO_ISFOLDER;
        String orderBy1 = FILE_INFO_TYPE;
        String orderBy2 = FILE_INFO_NAME;
        Comparator<Map<String, Object>> order = new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> lhs, Map<String, Object> rhs) {
                int right0;
                int left0 = lhs.get(GetFilesUtil.FILE_INFO_ISFOLDER).equals(true) ? 0 : 1;
                int n = right0 = rhs.get(GetFilesUtil.FILE_INFO_ISFOLDER).equals(true) ? 0 : 1;
                if (left0 == right0) {
                    String right1;
                    String left1 = lhs.get(GetFilesUtil.FILE_INFO_TYPE).toString();
                    if (left1.compareTo(right1 = rhs.get(GetFilesUtil.FILE_INFO_TYPE).toString()) == 0) {
                        String left2 = lhs.get(GetFilesUtil.FILE_INFO_NAME).toString();
                        String right2 = rhs.get(GetFilesUtil.FILE_INFO_NAME).toString();
                        return left2.compareTo(right2);
                    }
                    return left1.compareTo(right1);
                }
                return left0 - right0;
            }
        };
        return order;
    }
}

