/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.file;

import android.content.Context;
import com.liujc.baseutils.file.FileUtil;
import com.liujc.baseutils.file.SDCardUtil;
import java.io.File;

public class CleanUtil {
    private CleanUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean cleanInternalCache(Context context) {
        return FileUtil.deleteFilesInDir(context.getCacheDir());
    }

    public static boolean cleanInternalFiles(Context context) {
        return FileUtil.deleteFilesInDir(context.getFilesDir());
    }

    public static boolean cleanInternalDbs(Context context) {
        return FileUtil.deleteFilesInDir(context.getFilesDir().getParent() + File.separator + "databases");
    }

    public static boolean cleanInternalDbByName(Context context, String dbName) {
        return context.deleteDatabase(dbName);
    }

    public static boolean cleanInternalSP(Context context) {
        return FileUtil.deleteFilesInDir(context.getFilesDir().getParent() + File.separator + "shared_prefs");
    }

    public static boolean cleanExternalCache(Context context) {
        return SDCardUtil.isSDCardEnable() && FileUtil.deleteFilesInDir(context.getExternalCacheDir());
    }

    public static boolean cleanCustomCache(String dirPath) {
        return FileUtil.deleteFilesInDir(dirPath);
    }

    public static boolean cleanCustomCache(File dir) {
        return FileUtil.deleteFilesInDir(dir);
    }
}

