/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.file;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.os.Environment;
import android.text.TextUtils;
import com.liujc.baseutils.common.LogUtil;
import com.liujc.baseutils.file.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class AssetDatabaseOpenHelper {
    private Context context;
    private String databaseName;

    public AssetDatabaseOpenHelper(Context context, String databaseName) {
        this.context = context;
        this.databaseName = databaseName;
    }

    public synchronized SQLiteDatabase getWritableDatabase() {
        File dbFile = this.context.getDatabasePath(this.databaseName);
        if (dbFile != null && !dbFile.exists()) {
            try {
                this.copyDatabase(dbFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating source database", e);
            }
        }
        assert (dbFile != null);
        return SQLiteDatabase.openDatabase((String)dbFile.getPath(), null, (int)0);
    }

    public synchronized SQLiteDatabase getReadableDatabase() {
        File dbFile = this.context.getDatabasePath(this.databaseName);
        if (dbFile != null && !dbFile.exists()) {
            try {
                this.copyDatabase(dbFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating source database", e);
            }
        }
        return SQLiteDatabase.openDatabase((String)dbFile.getPath(), null, (int)1);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    private void copyDatabase(File dbFile) throws IOException {
        InputStream stream = this.context.getAssets().open(this.databaseName);
        FileUtil.writeFileFromIS(dbFile, stream, false);
        stream.close();
    }

    public boolean startExportDatabase(Context context, String targetFile, String databaseName) {
        String destFilePath;
        if (!"mounted".equals(Environment.getExternalStorageState())) {
            return false;
        }
        String sourceFilePath = Environment.getDataDirectory() + "/data/" + context.getPackageName() + "/databases/" + databaseName;
        boolean isCopySuccess = FileUtil.copyFile(sourceFilePath, destFilePath = Environment.getExternalStorageDirectory() + (TextUtils.isEmpty((CharSequence)targetFile) ? context.getPackageName() + ".db" : targetFile));
        if (isCopySuccess) {
            LogUtil.d("copy database file success. target file : " + destFilePath);
        } else {
            LogUtil.d("copy database file failure");
        }
        return isCopySuccess;
    }
}

