package com.liujc.baseutils.file;

import java.io.Closeable;
import java.io.IOException;

/**
 * 类名称：CloseUtil
 * 创建者：Create by liujc
 * 创建时间：Create on 2016/11/15 13:57
 * 描述：关闭相关工具类
 * 最近修改时间：2016/11/15 13:57
 * 修改人：Modify by liujc
 */
public class CloseUtil {
    private CloseUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    /**
     * 关闭IO
     *
     * @param closeables closeable
     */
    public static void closeIO(Closeable... closeables) {
        if (closeables == null) return;
        for (Closeable closeable : closeables) {
            if (closeable != null) {
                try {
                    closeable.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 安静关闭IO
     *
     * @param closeables closeable
     */
    public static void closeIOQuietly(Closeable... closeables) {
        if (closeables == null) return;
        for (Closeable closeable : closeables) {
            if (closeable != null) {
                try {
                    closeable.close();
                } catch (IOException ignored) {
                }
            }
        }
    }
}
