package com.liujc.baseutils.common;

import android.os.Build;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

/**
 * 类名称：EmptyUtil
 * 创建者：Create by liujc
 * 创建时间：Create on 2017/6/12 11:05
 * 描述：判空处理
 */
public class EmptyUtil {
    /**
     * 判断对象是否为空
     *
     * @param obj 对象
     * @return {@code true}: 为空<br>{@code false}: 不为空
     */
    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String && obj.toString().length() == 0) {
            return true;
        }
        if (obj.getClass().isArray() && Array.getLength(obj) == 0) {
            return true;
        }
        if (obj instanceof Collection && ((Collection) obj).isEmpty()) {
            return true;
        }
        if (obj instanceof Map && ((Map) obj).isEmpty()) {
            return true;
        }
        if (obj instanceof SparseArray && ((SparseArray) obj).size() == 0) {
            return true;
        }
        if (obj instanceof SparseBooleanArray && ((SparseBooleanArray) obj).size() == 0) {
            return true;
        }
        if (obj instanceof SparseIntArray && ((SparseIntArray) obj).size() == 0) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR2) {
            if (obj instanceof SparseLongArray && ((SparseLongArray) obj).size() == 0) {
                return true;
            }
        }
        return false;
    }

//    public static boolean isEmpty(CharSequence str) {
//        return isNull(str) || str.length() == 0;
//    }
//
//    public static boolean isEmpty(Object[] os) {
//        return isNull(os) || os.length == 0;
//    }
//
//    public static boolean isEmpty(Collection<?> l) {
//        return isNull(l) || l.isEmpty();
//    }
//
//    public static boolean isEmpty(Map<?, ?> m) {
//        return isNull(m) || m.isEmpty();
//    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    /**
     * 判断对象是否非空
     *
     * @param obj 对象
     * @return {@code true}: 非空<br>{@code false}: 空
     */
    public static boolean isNotEmpty(Object obj) {
        return !isEmpty(obj);
    }
}
