/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.resources.ScreenOrientation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdBuilder;
import com.android.sdklib.internal.avd.AvdCamera;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdNetworkLatency;
import com.android.sdklib.internal.avd.AvdNetworkSpeed;
import com.android.sdklib.internal.avd.BootMode;
import com.android.sdklib.internal.avd.CompositeBinding;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.EnumConverter;
import com.android.sdklib.internal.avd.GenericSkin;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.internal.avd.MapBinding;
import com.android.sdklib.internal.avd.MapBindingKt;
import com.android.sdklib.internal.avd.PropertyMapBinding;
import com.android.sdklib.internal.avd.QuickBoot;
import com.android.sdklib.internal.avd.SdCard;
import com.android.sdklib.internal.avd.SdCards;
import com.android.sdklib.internal.avd.Skin;
import com.android.sdklib.internal.avd.Skins;
import com.android.sdklib.internal.avd.StorageConverter;
import com.android.sdklib.internal.avd.ValueConverter;
import java.awt.Dimension;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 |2\u00020\u0001:\u0001|B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010x\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110yJ\u0006\u0010z\u001a\u00020{R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0014\"\u0004\b/\u0010\u0016R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001a\"\u0004\b8\u0010\u001cR\u001a\u00109\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\r\"\u0004\bF\u0010\u000fR\u001a\u0010G\u001a\u00020HX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u001a\u0010M\u001a\u00020NX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u001a\u0010S\u001a\u00020@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010B\"\u0004\bU\u0010DR\u001a\u0010V\u001a\u00020WX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R\u001c\u0010\\\u001a\u0004\u0018\u00010]X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010_\"\u0004\b`\u0010aR\u001a\u0010b\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u00103\"\u0004\bd\u00105R\u001c\u0010e\u001a\u0004\u0018\u00010fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR\u001c\u0010k\u001a\u0004\u0018\u00010lX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010n\"\u0004\bo\u0010pR\u001d\u0010q\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110r\u00a2\u0006\b\n\u0000\u001a\u0004\bs\u0010tR\u001a\u0010u\u001a\u00020@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bv\u0010B\"\u0004\bw\u0010D\u00a8\u0006}"}, d2={"Lcom/android/sdklib/internal/avd/AvdBuilder;", "", "metadataIniPath", "Ljava/nio/file/Path;", "avdFolder", "device", "Lcom/android/sdklib/devices/Device;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/android/sdklib/devices/Device;)V", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "getAndroidVersion", "()Lcom/android/sdklib/AndroidVersion;", "getAvdFolder", "()Ljava/nio/file/Path;", "setAvdFolder", "(Ljava/nio/file/Path;)V", "name", "", "avdName", "getAvdName", "()Ljava/lang/String;", "setAvdName", "(Ljava/lang/String;)V", "backCamera", "Lcom/android/sdklib/internal/avd/AvdCamera;", "getBackCamera", "()Lcom/android/sdklib/internal/avd/AvdCamera;", "setBackCamera", "(Lcom/android/sdklib/internal/avd/AvdCamera;)V", "bootMode", "Lcom/android/sdklib/internal/avd/BootMode;", "getBootMode", "()Lcom/android/sdklib/internal/avd/BootMode;", "setBootMode", "(Lcom/android/sdklib/internal/avd/BootMode;)V", "cpuCoreCount", "", "getCpuCoreCount", "()I", "setCpuCoreCount", "(I)V", "getDevice", "()Lcom/android/sdklib/devices/Device;", "setDevice", "(Lcom/android/sdklib/devices/Device;)V", "displayName", "getDisplayName", "setDisplayName", "enableKeyboard", "", "getEnableKeyboard", "()Z", "setEnableKeyboard", "(Z)V", "frontCamera", "getFrontCamera", "setFrontCamera", "gpuMode", "Lcom/android/sdklib/internal/avd/GpuMode;", "getGpuMode", "()Lcom/android/sdklib/internal/avd/GpuMode;", "setGpuMode", "(Lcom/android/sdklib/internal/avd/GpuMode;)V", "internalStorage", "Lcom/android/sdklib/devices/Storage;", "getInternalStorage", "()Lcom/android/sdklib/devices/Storage;", "setInternalStorage", "(Lcom/android/sdklib/devices/Storage;)V", "getMetadataIniPath", "setMetadataIniPath", "networkLatency", "Lcom/android/sdklib/internal/avd/AvdNetworkLatency;", "getNetworkLatency", "()Lcom/android/sdklib/internal/avd/AvdNetworkLatency;", "setNetworkLatency", "(Lcom/android/sdklib/internal/avd/AvdNetworkLatency;)V", "networkSpeed", "Lcom/android/sdklib/internal/avd/AvdNetworkSpeed;", "getNetworkSpeed", "()Lcom/android/sdklib/internal/avd/AvdNetworkSpeed;", "setNetworkSpeed", "(Lcom/android/sdklib/internal/avd/AvdNetworkSpeed;)V", "ram", "getRam", "setRam", "screenOrientation", "Lcom/android/resources/ScreenOrientation;", "getScreenOrientation", "()Lcom/android/resources/ScreenOrientation;", "setScreenOrientation", "(Lcom/android/resources/ScreenOrientation;)V", "sdCard", "Lcom/android/sdklib/internal/avd/SdCard;", "getSdCard", "()Lcom/android/sdklib/internal/avd/SdCard;", "setSdCard", "(Lcom/android/sdklib/internal/avd/SdCard;)V", "showDeviceFrame", "getShowDeviceFrame", "setShowDeviceFrame", "skin", "Lcom/android/sdklib/internal/avd/Skin;", "getSkin", "()Lcom/android/sdklib/internal/avd/Skin;", "setSkin", "(Lcom/android/sdklib/internal/avd/Skin;)V", "systemImage", "Lcom/android/sdklib/ISystemImage;", "getSystemImage", "()Lcom/android/sdklib/ISystemImage;", "setSystemImage", "(Lcom/android/sdklib/ISystemImage;)V", "userSettings", "", "getUserSettings", "()Ljava/util/Map;", "vmHeap", "getVmHeap", "setVmHeap", "configProperties", "", "initializeFromDevice", "", "Companion", "sdklib"})
@SourceDebugExtension(value={"SMAP\nAvdBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvdBuilder.kt\ncom/android/sdklib/internal/avd/AvdBuilder\n+ 2 MapBinding.kt\ncom/android/sdklib/internal/avd/MapBindingKt\n*L\n1#1,163:1\n74#2:164\n150#2:165\n70#2:166\n147#2:167\n70#2:168\n147#2:169\n70#2:170\n147#2:171\n70#2:172\n147#2:173\n70#2:174\n147#2:175\n*S KotlinDebug\n*F\n+ 1 AvdBuilder.kt\ncom/android/sdklib/internal/avd/AvdBuilder\n*L\n130#1:164\n130#1:165\n138#1:166\n138#1:167\n139#1:168\n139#1:169\n140#1:170\n140#1:171\n142#1:172\n142#1:173\n143#1:174\n143#1:175\n*E\n"})
public final class AvdBuilder {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private Path metadataIniPath;
    @NotNull
    private Path avdFolder;
    @NotNull
    private Device device;
    @NotNull
    private String displayName;
    @Nullable
    private ISystemImage systemImage;
    @Nullable
    private SdCard sdCard;
    @Nullable
    private Skin skin;
    private boolean showDeviceFrame;
    @NotNull
    private ScreenOrientation screenOrientation;
    private int cpuCoreCount;
    @NotNull
    private Storage ram;
    @NotNull
    private Storage vmHeap;
    @NotNull
    private Storage internalStorage;
    @NotNull
    private AvdCamera frontCamera;
    @NotNull
    private AvdCamera backCamera;
    @NotNull
    private GpuMode gpuMode;
    private boolean enableKeyboard;
    @NotNull
    private AvdNetworkLatency networkLatency;
    @NotNull
    private AvdNetworkSpeed networkSpeed;
    @NotNull
    private BootMode bootMode;
    @NotNull
    private final Map<String, String> userSettings;
    @NotNull
    private static final Map<String, String> defaultConfigKeys;
    @NotNull
    private static final CompositeBinding<AvdBuilder> binding;

    public AvdBuilder(@NotNull Path metadataIniPath, @NotNull Path avdFolder, @NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)metadataIniPath, (String)"metadataIniPath");
        Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        this.metadataIniPath = metadataIniPath;
        this.avdFolder = avdFolder;
        this.device = device;
        this.displayName = "";
        this.showDeviceFrame = true;
        this.screenOrientation = ScreenOrientation.PORTRAIT;
        this.cpuCoreCount = 1;
        this.ram = new Storage(0L);
        this.vmHeap = new Storage(0L);
        this.internalStorage = new Storage(0L);
        this.frontCamera = AvdCamera.NONE;
        this.backCamera = AvdCamera.NONE;
        this.gpuMode = GpuMode.OFF;
        this.enableKeyboard = true;
        this.networkLatency = AvdNetworkLatency.NONE;
        this.networkSpeed = AvdNetworkSpeed.FULL;
        this.bootMode = QuickBoot.INSTANCE;
        this.userSettings = new LinkedHashMap();
    }

    @NotNull
    public final Path getMetadataIniPath() {
        return this.metadataIniPath;
    }

    public final void setMetadataIniPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.metadataIniPath = path;
    }

    @NotNull
    public final Path getAvdFolder() {
        return this.avdFolder;
    }

    public final void setAvdFolder(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.avdFolder = path;
    }

    @NotNull
    public final Device getDevice() {
        return this.device;
    }

    public final void setDevice(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"<set-?>");
        this.device = device;
    }

    @NotNull
    public final String getAvdName() {
        return StringsKt.removeSuffix((String)PathsKt.getName((Path)this.metadataIniPath), (CharSequence)".ini");
    }

    public final void setAvdName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Path path = this.metadataIniPath.resolveSibling(name + ".ini");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
        this.metadataIniPath = path;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.displayName = string;
    }

    @Nullable
    public final ISystemImage getSystemImage() {
        return this.systemImage;
    }

    public final void setSystemImage(@Nullable ISystemImage iSystemImage) {
        this.systemImage = iSystemImage;
    }

    @Nullable
    public final SdCard getSdCard() {
        return this.sdCard;
    }

    public final void setSdCard(@Nullable SdCard sdCard) {
        this.sdCard = sdCard;
    }

    @Nullable
    public final Skin getSkin() {
        return this.skin;
    }

    public final void setSkin(@Nullable Skin skin) {
        this.skin = skin;
    }

    public final boolean getShowDeviceFrame() {
        return this.showDeviceFrame;
    }

    public final void setShowDeviceFrame(boolean bl) {
        this.showDeviceFrame = bl;
    }

    @NotNull
    public final ScreenOrientation getScreenOrientation() {
        return this.screenOrientation;
    }

    public final void setScreenOrientation(@NotNull ScreenOrientation screenOrientation) {
        Intrinsics.checkNotNullParameter((Object)screenOrientation, (String)"<set-?>");
        this.screenOrientation = screenOrientation;
    }

    public final int getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public final void setCpuCoreCount(int n) {
        this.cpuCoreCount = n;
    }

    @NotNull
    public final Storage getRam() {
        return this.ram;
    }

    public final void setRam(@NotNull Storage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"<set-?>");
        this.ram = storage;
    }

    @NotNull
    public final Storage getVmHeap() {
        return this.vmHeap;
    }

    public final void setVmHeap(@NotNull Storage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"<set-?>");
        this.vmHeap = storage;
    }

    @NotNull
    public final Storage getInternalStorage() {
        return this.internalStorage;
    }

    public final void setInternalStorage(@NotNull Storage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"<set-?>");
        this.internalStorage = storage;
    }

    @NotNull
    public final AvdCamera getFrontCamera() {
        return this.frontCamera;
    }

    public final void setFrontCamera(@NotNull AvdCamera avdCamera) {
        Intrinsics.checkNotNullParameter((Object)avdCamera, (String)"<set-?>");
        this.frontCamera = avdCamera;
    }

    @NotNull
    public final AvdCamera getBackCamera() {
        return this.backCamera;
    }

    public final void setBackCamera(@NotNull AvdCamera avdCamera) {
        Intrinsics.checkNotNullParameter((Object)avdCamera, (String)"<set-?>");
        this.backCamera = avdCamera;
    }

    @NotNull
    public final GpuMode getGpuMode() {
        return this.gpuMode;
    }

    public final void setGpuMode(@NotNull GpuMode gpuMode) {
        Intrinsics.checkNotNullParameter((Object)gpuMode, (String)"<set-?>");
        this.gpuMode = gpuMode;
    }

    public final boolean getEnableKeyboard() {
        return this.enableKeyboard;
    }

    public final void setEnableKeyboard(boolean bl) {
        this.enableKeyboard = bl;
    }

    @NotNull
    public final AvdNetworkLatency getNetworkLatency() {
        return this.networkLatency;
    }

    public final void setNetworkLatency(@NotNull AvdNetworkLatency avdNetworkLatency) {
        Intrinsics.checkNotNullParameter((Object)avdNetworkLatency, (String)"<set-?>");
        this.networkLatency = avdNetworkLatency;
    }

    @NotNull
    public final AvdNetworkSpeed getNetworkSpeed() {
        return this.networkSpeed;
    }

    public final void setNetworkSpeed(@NotNull AvdNetworkSpeed avdNetworkSpeed) {
        Intrinsics.checkNotNullParameter((Object)avdNetworkSpeed, (String)"<set-?>");
        this.networkSpeed = avdNetworkSpeed;
    }

    @NotNull
    public final BootMode getBootMode() {
        return this.bootMode;
    }

    public final void setBootMode(@NotNull BootMode bootMode) {
        Intrinsics.checkNotNullParameter((Object)bootMode, (String)"<set-?>");
        this.bootMode = bootMode;
    }

    @NotNull
    public final Map<String, String> getUserSettings() {
        return this.userSettings;
    }

    @Nullable
    public final AndroidVersion getAndroidVersion() {
        ISystemImage iSystemImage = this.systemImage;
        return iSystemImage != null ? iSystemImage.getAndroidVersion() : null;
    }

    public final void initializeFromDevice() {
        GenericSkin genericSkin;
        Map<String, String> map = DeviceManager.getHardwareProperties(this.device);
        Intrinsics.checkNotNullExpressionValue(map, (String)"getHardwareProperties(...)");
        binding.read(this, map);
        AvdBuilder avdBuilder = this;
        Dimension dimension = this.device.getScreenSize(this.device.getDefaultState().getOrientation());
        if (dimension != null) {
            Dimension it = dimension;
            AvdBuilder avdBuilder2 = avdBuilder;
            boolean bl = false;
            genericSkin = new GenericSkin(it.width, it.height);
            avdBuilder = avdBuilder2;
        } else {
            genericSkin = null;
        }
        avdBuilder.skin = genericSkin;
        Storage storage = EmulatedProperties.defaultRamSize(this.device);
        Intrinsics.checkNotNullExpressionValue((Object)storage, (String)"defaultRamSize(...)");
        this.ram = storage;
        Storage storage2 = EmulatedProperties.defaultVmHeapSize(this.device);
        Intrinsics.checkNotNullExpressionValue((Object)storage2, (String)"defaultVmHeapSize(...)");
        this.vmHeap = storage2;
        Storage storage3 = EmulatedProperties.defaultInternalStorage(this.device);
        Intrinsics.checkNotNullExpressionValue((Object)storage3, (String)"defaultInternalStorage(...)");
        this.internalStorage = storage3;
    }

    @NotNull
    public final Map<String, String> configProperties() {
        Map properties = new LinkedHashMap();
        properties.putAll(defaultConfigKeys);
        Map<String, String> map = DeviceManager.getHardwareProperties(this.device);
        Intrinsics.checkNotNullExpressionValue(map, (String)"getHardwareProperties(...)");
        properties.putAll(map);
        properties.put("hw.gpu.enabled", this.gpuMode == GpuMode.OFF ? "no" : "yes");
        properties.put("AvdId", this.getAvdName());
        properties.putAll(this.bootMode.properties());
        binding.write(this, properties);
        return properties;
    }

    static {
        KMutableProperty1 $this$bindToKey$iv;
        Companion = new Companion(null);
        defaultConfigKeys = MapsKt.mapOf((Pair)TuplesKt.to((Object)"skin.dynamic", (Object)"yes"));
        MapBinding[] mapBindingArray = new MapBinding[13];
        mapBindingArray[0] = MapBindingKt.bindToKeyString((KMutableProperty1)Companion.binding.1.INSTANCE, "avd.ini.displayname");
        KMutableProperty1 kMutableProperty1 = (KMutableProperty1)Companion.binding.2.INSTANCE;
        String key$iv = "hw.initialOrientation";
        boolean $i$f$bindToKeyResourceEnum = false;
        boolean $i$f$resourceEnumConverter = false;
        mapBindingArray[1] = new PropertyMapBinding((ValueConverter)new EnumConverter<ScreenOrientation>(ScreenOrientation.class, MapBindingKt.resourceEnumConverter.1.INSTANCE), key$iv, $this$bindToKey$iv);
        mapBindingArray[2] = MapBindingKt.bindToKeyBoolean((KMutableProperty1)Companion.binding.3.INSTANCE, "showDeviceFrame");
        mapBindingArray[3] = MapBindingKt.bindToKeyInt((KMutableProperty1)Companion.binding.4.INSTANCE, "hw.cpu.ncore");
        mapBindingArray[4] = MapBindingKt.bindVia((KMutableProperty1)Companion.binding.5.INSTANCE, new StorageConverter(null, 1, null)).toKey("hw.ramSize");
        mapBindingArray[5] = MapBindingKt.bindVia((KMutableProperty1)Companion.binding.6.INSTANCE, new StorageConverter(null, 1, null)).toKey("vm.heapSize");
        mapBindingArray[6] = MapBindingKt.bindVia((KMutableProperty1)Companion.binding.7.INSTANCE, new StorageConverter(Storage.Unit.B)).toKey("disk.dataPartition.size");
        $this$bindToKey$iv = (KMutableProperty1)Companion.binding.8.INSTANCE;
        key$iv = "hw.camera.front";
        boolean $i$f$bindToKeyConfigEnum = false;
        boolean $i$f$enumConverter = false;
        mapBindingArray[7] = new PropertyMapBinding((ValueConverter)new EnumConverter<AvdCamera>(AvdCamera.class, MapBindingKt.enumConverter.1.INSTANCE), key$iv, $this$bindToKey$iv);
        $this$bindToKey$iv = (KMutableProperty1)Companion.binding.9.INSTANCE;
        key$iv = "hw.camera.back";
        $i$f$bindToKeyConfigEnum = false;
        $i$f$enumConverter = false;
        mapBindingArray[8] = new PropertyMapBinding((ValueConverter)new EnumConverter<AvdCamera>(AvdCamera.class, MapBindingKt.enumConverter.1.INSTANCE), key$iv, $this$bindToKey$iv);
        $this$bindToKey$iv = (KMutableProperty1)Companion.binding.10.INSTANCE;
        key$iv = "hw.gpu.mode";
        $i$f$bindToKeyConfigEnum = false;
        $i$f$enumConverter = false;
        mapBindingArray[9] = new PropertyMapBinding((ValueConverter)new EnumConverter<GpuMode>(GpuMode.class, MapBindingKt.enumConverter.1.INSTANCE), key$iv, $this$bindToKey$iv);
        mapBindingArray[10] = MapBindingKt.bindToKeyBoolean((KMutableProperty1)Companion.binding.11.INSTANCE, "hw.keyboard");
        $this$bindToKey$iv = (KMutableProperty1)Companion.binding.12.INSTANCE;
        key$iv = "runtime.network.latency";
        $i$f$bindToKeyConfigEnum = false;
        $i$f$enumConverter = false;
        mapBindingArray[11] = new PropertyMapBinding((ValueConverter)new EnumConverter<AvdNetworkLatency>(AvdNetworkLatency.class, MapBindingKt.enumConverter.1.INSTANCE), key$iv, $this$bindToKey$iv);
        $this$bindToKey$iv = (KMutableProperty1)Companion.binding.13.INSTANCE;
        key$iv = "runtime.network.speed";
        $i$f$bindToKeyConfigEnum = false;
        $i$f$enumConverter = false;
        mapBindingArray[12] = new PropertyMapBinding((ValueConverter)new EnumConverter<AvdNetworkSpeed>(AvdNetworkSpeed.class, MapBindingKt.enumConverter.1.INSTANCE), key$iv, $this$bindToKey$iv);
        binding = new CompositeBinding(mapBindingArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/android/sdklib/internal/avd/AvdBuilder$Companion;", "", "()V", "binding", "Lcom/android/sdklib/internal/avd/CompositeBinding;", "Lcom/android/sdklib/internal/avd/AvdBuilder;", "getBinding$sdklib", "()Lcom/android/sdklib/internal/avd/CompositeBinding;", "defaultConfigKeys", "", "", "getDefaultConfigKeys", "()Ljava/util/Map;", "createForExistingDevice", "device", "Lcom/android/sdklib/devices/Device;", "avdInfo", "Lcom/android/sdklib/internal/avd/AvdInfo;", "sdklib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getDefaultConfigKeys() {
            return defaultConfigKeys;
        }

        @NotNull
        public final CompositeBinding<AvdBuilder> getBinding$sdklib() {
            return binding;
        }

        @NotNull
        public final AvdBuilder createForExistingDevice(@NotNull Device device, @NotNull AvdInfo avdInfo) {
            AvdBuilder avdBuilder;
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            Intrinsics.checkNotNullParameter((Object)avdInfo, (String)"avdInfo");
            Path path = avdInfo.getIniFile();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getIniFile(...)");
            Path path2 = avdInfo.getDataFolderPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getDataFolderPath(...)");
            AvdBuilder $this$createForExistingDevice_u24lambda_u240 = avdBuilder = new AvdBuilder(path, path2, device);
            boolean bl = false;
            $this$createForExistingDevice_u24lambda_u240.setSystemImage(avdInfo.getSystemImage());
            Map<String, String> map = avdInfo.getProperties();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getProperties(...)");
            $this$createForExistingDevice_u24lambda_u240.setSdCard(SdCards.sdCardFromConfig(map));
            Map<String, String> map2 = avdInfo.getProperties();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getProperties(...)");
            $this$createForExistingDevice_u24lambda_u240.setSkin(Skins.skinFromConfig(map2));
            Map<String, String> map3 = avdInfo.getProperties();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"getProperties(...)");
            $this$createForExistingDevice_u24lambda_u240.setBootMode(BootMode.Companion.fromProperties(map3));
            CompositeBinding<AvdBuilder> compositeBinding = Companion.getBinding$sdklib();
            Map<String, String> map4 = avdInfo.getProperties();
            Intrinsics.checkNotNullExpressionValue(map4, (String)"getProperties(...)");
            compositeBinding.read($this$createForExistingDevice_u24lambda_u240, map4);
            Map<String, String> map5 = $this$createForExistingDevice_u24lambda_u240.getUserSettings();
            Map<String, String> map6 = avdInfo.getUserSettings();
            Intrinsics.checkNotNullExpressionValue(map6, (String)"getUserSettings(...)");
            map5.putAll(map6);
            $this$createForExistingDevice_u24lambda_u240.getUserSettings().remove("avd.ini.encoding");
            return avdBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

