/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.repository.Revision;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.repository.IdDisplay;
import java.nio.file.Path;
import java.util.List;

public interface ISystemImage {
    public static final String WEAR_CN_DIRECTORY = "android-wear-cn";

    public Path getLocation();

    @Deprecated
    default public IdDisplay getTag() {
        return this.getTags().stream().findFirst().orElse(SystemImageTags.DEFAULT_TAG);
    }

    public List<IdDisplay> getTags();

    public IdDisplay getAddonVendor();

    public String getPrimaryAbiType();

    public List<String> getAbiTypes();

    public List<String> getTranslatedAbiTypes();

    public List<Path> getSkins();

    public Revision getRevision();

    public AndroidVersion getAndroidVersion();

    public boolean obsolete();

    default public boolean hasGoogleApis() {
        return SystemImageTags.hasGoogleApi(this.getTags());
    }

    default public boolean hasPlayStore() {
        return SystemImageTags.hasGooglePlay(this.getTags(), this.getAndroidVersion(), this.getPackage());
    }

    public RepoPackage getPackage();
}

