/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.installer;

import com.android.io.CancellableFileIo;
import com.android.repository.Revision;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;

public class MavenInstallListener
implements PackageOperation.StatusChangeListener {
    public static final String MAVEN_DIR_NAME = "m2repository";
    public static final String MAVEN_METADATA_FILE_NAME = "maven-metadata.xml";

    public void statusChanged(PackageOperation installer, ProgressIndicator progress) throws PackageOperation.StatusChangeListenerException {
        Path dir;
        if (installer.getInstallStatus() == PackageOperation.InstallStatus.COMPLETE && !this.updateMetadata((dir = installer.getLocation(progress)).getParent(), progress)) {
            throw new PackageOperation.StatusChangeListenerException("Failed to update maven metadata for " + installer.getPackage().getDisplayName());
        }
    }

    private boolean updateMetadata(Path root, ProgressIndicator progress) {
        MavenMetadata metadata = null;
        for (Path version : FileOpUtils.listFiles((Path)root)) {
            if (!CancellableFileIo.isDirectory((Path)version, (LinkOption[])new LinkOption[0])) continue;
            metadata = MavenInstallListener.createOrUpdateMetadata(version, metadata, progress);
        }
        Path metadataFile = root.resolve(MAVEN_METADATA_FILE_NAME);
        if (metadata != null) {
            progress.logVerbose("Writing Maven metadata to " + metadataFile.toAbsolutePath());
            return MavenInstallListener.writeMetadata(metadata, metadataFile, progress);
        }
        progress.logVerbose("Deleting Maven metadata " + metadataFile.toAbsolutePath());
        return MavenInstallListener.deleteMetadataFiles(metadataFile, progress);
    }

    private static boolean deleteMetadataFiles(Path metadataFile, ProgressIndicator progress) {
        try {
            Files.deleteIfExists(metadataFile);
        }
        catch (IOException unused) {
            progress.logError("Failed to delete " + metadataFile.toAbsolutePath());
            return false;
        }
        Path md5File = MavenInstallListener.getMetadataHashFile(metadataFile, "MD5");
        try {
            Files.deleteIfExists(md5File);
        }
        catch (IOException unused) {
            progress.logError("Failed to delete " + md5File.toAbsolutePath());
            return false;
        }
        Path sha1File = MavenInstallListener.getMetadataHashFile(metadataFile, "SHA1");
        try {
            Files.deleteIfExists(sha1File);
        }
        catch (IOException unused) {
            progress.logError("Failed to delete " + sha1File.toAbsolutePath());
            return false;
        }
        return true;
    }

    private static boolean writeMetadata(MavenMetadata metadata, Path file, ProgressIndicator progress) {
        Marshaller marshaller;
        Revision max = null;
        for (String s : metadata.versioning.versions.version) {
            Revision rev = Revision.parseRevision((String)s);
            if (max != null && (rev.isPreview() || rev.compareTo(max) <= 0)) continue;
            max = rev;
        }
        if (max != null) {
            metadata.versioning.release = max.toString();
        }
        metadata.versioning.lastUpdated = System.currentTimeMillis();
        try {
            JAXBContext context;
            try {
                context = JAXBContext.newInstance((Class[])new Class[]{MavenMetadata.class});
            }
            catch (JAXBException e) {
                progress.logError("Failed to create JAXBContext", (Throwable)e);
                return false;
            }
            marshaller = context.createMarshaller();
        }
        catch (JAXBException e) {
            progress.logError("Failed to create Marshaller", (Throwable)e);
            return false;
        }
        ByteArrayOutputStream metadataOutBytes = new ByteArrayOutputStream();
        try {
            marshaller.marshal((Object)new JAXBElement(new QName("metadata"), MavenMetadata.class, (Object)metadata), (OutputStream)metadataOutBytes);
        }
        catch (JAXBException e) {
            progress.logWarning("Failed to write maven metadata: ", (Throwable)e);
            return false;
        }
        try (OutputStream metadataOutFile = Files.newOutputStream(file, new OpenOption[0]);){
            metadataOutFile.write(metadataOutBytes.toByteArray());
        }
        catch (IOException e) {
            progress.logWarning("Failed to write metadata file.", (Throwable)e);
            return false;
        }
        if (!MavenInstallListener.writeHashFile(file, "MD5", progress, metadataOutBytes)) {
            return false;
        }
        return MavenInstallListener.writeHashFile(file, "SHA1", progress, metadataOutBytes);
    }

    private static MavenMetadata createOrUpdateMetadata(Path versionPath, MavenMetadata metadata, ProgressIndicator progress) {
        PackageInfo info;
        Path pomFile = versionPath.resolve(String.format("%1$s-%2$s.pom", versionPath.getParent().getFileName(), versionPath.getFileName()));
        if (CancellableFileIo.exists((Path)pomFile, (LinkOption[])new LinkOption[0]) && (info = MavenInstallListener.unmarshal(pomFile, PackageInfo.class, progress)) != null) {
            if (metadata == null) {
                metadata = new MavenMetadata();
                metadata.artifactId = info.artifactId;
                metadata.groupId = info.groupId;
                metadata.versioning = new MavenMetadata.Versioning();
                metadata.versioning.versions = new MavenMetadata.Versioning.Versions();
                metadata.versioning.versions.version = Lists.newArrayList();
            }
            metadata.versioning.versions.version.add(info.version);
        }
        return metadata;
    }

    @VisibleForTesting
    static <T> T unmarshal(Path f, Class<T> clazz, ProgressIndicator progress) {
        Object result;
        InputStream metadataInputStream;
        Unmarshaller unmarshaller;
        JAXBContext context;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException e) {
            progress.logError("Failed to create JAXBContext", (Throwable)e);
            return null;
        }
        try {
            unmarshaller = context.createUnmarshaller();
            unmarshaller.setEventHandler(event -> true);
        }
        catch (JAXBException e) {
            progress.logError("Failed to create unmarshaller", (Throwable)e);
            return null;
        }
        try {
            metadataInputStream = CancellableFileIo.newInputStream((Path)f, (OpenOption[])new OpenOption[0]);
        }
        catch (IOException e) {
            return null;
        }
        try {
            result = unmarshaller.unmarshal(metadataInputStream);
        }
        catch (JAXBException e) {
            progress.logWarning("Couldn't parse maven metadata file: " + f, (Throwable)e);
            return null;
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeHashFile(Path file, String algorithm, ProgressIndicator progress, ByteArrayOutputStream metadataOutBytes) {
        OutputStream hashOutputStream;
        MessageDigest digest;
        Path hashFile = MavenInstallListener.getMetadataHashFile(file, algorithm);
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            progress.logError(algorithm + " algorithm not found", (Throwable)e);
            return false;
        }
        try {
            hashOutputStream = Files.newOutputStream(hashFile, new OpenOption[0]);
        }
        catch (IOException e) {
            progress.logWarning("Failed to open " + algorithm + " file");
            return false;
        }
        try {
            hashOutputStream.write(DatatypeConverter.printHexBinary((byte[])digest.digest(metadataOutBytes.toByteArray())).getBytes());
        }
        catch (IOException e) {
            progress.logWarning("Failed to write " + algorithm + " file");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                hashOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private static Path getMetadataHashFile(Path file, String algorithm) {
        return file.getParent().resolve("maven-metadata.xml." + algorithm.toLowerCase());
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="metadata")
    @VisibleForTesting
    static class MavenMetadata {
        protected String groupId;
        protected String artifactId;
        protected Versioning versioning;

        MavenMetadata() {
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        public static class Versioning {
            protected String release;
            protected Versions versions;
            protected long lastUpdated;

            @XmlAccessorType(value=XmlAccessType.FIELD)
            public static class Versions {
                protected List<String> version;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="project", namespace="http://maven.apache.org/POM/4.0.0")
    private static class PackageInfo {
        @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
        public String artifactId;
        @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
        public String groupId;
        @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
        public String version;

        private PackageInfo() {
        }
    }
}

