/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy;

import com.android.sdklib.AndroidVersion;
import java.util.Properties;

public class AndroidVersionHelper {
    public static AndroidVersion create(Properties properties) throws AndroidVersion.AndroidVersionException {
        String isBaseExtensionProperty;
        int apiLevel;
        String apiLevelProperty = properties.getProperty("AndroidVersion.ApiLevel");
        if (apiLevelProperty == null) {
            throw new AndroidVersion.AndroidVersionException("AndroidVersion.ApiLevel not found!", null);
        }
        try {
            apiLevel = Integer.parseInt(apiLevelProperty);
        }
        catch (NumberFormatException e) {
            throw new AndroidVersion.AndroidVersionException("AndroidVersion.ApiLevel does not contain a parsable integer!", null);
        }
        String codeNameProperty = properties.getProperty("AndroidVersion.CodeName", null);
        String extensionLevelProperty = properties.getProperty("AndroidVersion.ExtensionLevel");
        Integer extensionLevel = null;
        if (extensionLevelProperty != null) {
            try {
                extensionLevel = Integer.parseInt(extensionLevelProperty);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean isBaseExtension = (isBaseExtensionProperty = properties.getProperty("AndroidVersion.IsBaseSdk")) == null || AndroidVersionHelper.parseBoolean(isBaseExtensionProperty);
        return new AndroidVersion(apiLevel, codeNameProperty, extensionLevel, isBaseExtension);
    }

    private static boolean parseBoolean(String booleanStringValue) {
        return !"false".equals(booleanStringValue);
    }
}

