/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.SdkConstants;
import com.android.annotations.concurrency.Slow;
import com.android.io.CancellableFileIo;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.prefs.AndroidLocationsException;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.utils.FileUtils;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class AvdManager {
    private Path mBaseAvdFolder;
    private static final Pattern INI_LINE_PATTERN = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    public static final String AVD_FOLDER_EXTENSION = ".avd";
    public static final String AVD_INI_ENCODING = "avd.ini.encoding";
    public static final String AVD_INFO_ABS_PATH = "path";
    public static final String AVD_INFO_REL_PATH = "path.rel";
    public static final String AVD_INFO_TARGET = "target";
    public static final String AVD_INI_TAG_ID = "tag.id";
    public static final String AVD_INI_TAG_DISPLAY = "tag.display";
    public static final String AVD_INI_ABI_TYPE = "abi.type";
    public static final String AVD_INI_AVD_ID = "AvdId";
    public static final String AVD_INI_PLAYSTORE_ENABLED = "PlayStore.enabled";
    public static final String AVD_INI_CPU_ARCH = "hw.cpu.arch";
    public static final String AVD_INI_CPU_MODEL = "hw.cpu.model";
    public static final String AVD_INI_CPU_CORES = "hw.cpu.ncore";
    public static final String AVD_INI_DEVICE_MANUFACTURER = "hw.device.manufacturer";
    public static final String AVD_INI_DEVICE_NAME = "hw.device.name";
    public static final String AVD_INI_ARC = "hw.arc";
    public static final String AVD_INI_DISPLAY_NAME = "avd.ini.displayname";
    public static final String AVD_INI_SKIN_PATH = "skin.path";
    public static final String AVD_INI_BACKUP_SKIN_PATH = "skin.path.backup";
    public static final String AVD_INI_SKIN_NAME = "skin.name";
    public static final String AVD_INI_SKIN_DYNAMIC = "skin.dynamic";
    public static final String AVD_INI_SDCARD_PATH = "sdcard.path";
    public static final String AVD_INI_SDCARD_SIZE = "sdcard.size";
    public static final String AVD_INI_IMAGES_1 = "image.sysdir.1";
    public static final String AVD_INI_IMAGES_2 = "image.sysdir.2";
    public static final String AVD_INI_SNAPSHOT_PRESENT = "snapshot.present";
    public static final String AVD_INI_GPU_EMULATION = "hw.gpu.enabled";
    public static final String AVD_INI_GPU_MODE = "hw.gpu.mode";
    public static final String AVD_INI_FORCE_COLD_BOOT_MODE = "fastboot.forceColdBoot";
    public static final String AVD_INI_FORCE_CHOSEN_SNAPSHOT_BOOT_MODE = "fastboot.forceChosenSnapshotBoot";
    public static final String AVD_INI_FORCE_FAST_BOOT_MODE = "fastboot.forceFastBoot";
    public static final String AVD_INI_CHOSEN_SNAPSHOT_FILE = "fastboot.chosenSnapshotFile";
    public static final String AVD_INI_CAMERA_FRONT = "hw.camera.front";
    public static final String AVD_INI_CAMERA_BACK = "hw.camera.back";
    public static final String AVD_INI_RAM_SIZE = "hw.ramSize";
    public static final String AVD_INI_VM_HEAP_SIZE = "vm.heapSize";
    public static final String AVD_INI_DATA_PARTITION_SIZE = "disk.dataPartition.size";
    public static final String AVD_INI_DEVICE_HASH_V1 = "hw.device.hash";
    public static final String AVD_INI_DEVICE_HASH_V2 = "hw.device.hash2";
    public static final String AVD_INI_DISPLAY_SETTINGS_FILE = "display.settings.xml";
    public static final String AVD_INI_HINGE = "hw.sensor.hinge";
    public static final String AVD_INI_HINGE_COUNT = "hw.sensor.hinge.count";
    public static final String AVD_INI_HINGE_TYPE = "hw.sensor.hinge.type";
    public static final String AVD_INI_HINGE_SUB_TYPE = "hw.sensor.hinge.sub_type";
    public static final String AVD_INI_HINGE_RANGES = "hw.sensor.hinge.ranges";
    public static final String AVD_INI_HINGE_DEFAULTS = "hw.sensor.hinge.defaults";
    public static final String AVD_INI_HINGE_AREAS = "hw.sensor.hinge.areas";
    public static final String AVD_INI_POSTURE_LISTS = "hw.sensor.posture_list";
    public static final String AVD_INI_FOLD_AT_POSTURE = "hw.sensor.hinge.fold_to_displayRegion.0.1_at_posture";
    public static final String AVD_INI_HINGE_ANGLES_POSTURE_DEFINITIONS = "hw.sensor.hinge_angles_posture_definitions";
    public static final String AVD_INI_ROLL = "hw.sensor.roll";
    public static final String AVD_INI_ROLL_COUNT = "hw.sensor.roll.count";
    public static final String AVD_INI_ROLL_RANGES = "hw.sensor.roll.ranges";
    public static final String AVD_INI_ROLL_DEFAULTS = "hw.sensor.roll.defaults";
    public static final String AVD_INI_ROLL_RADIUS = "hw.sensor.roll.radius";
    public static final String AVD_INI_ROLL_DIRECTION = "hw.sensor.roll.direction";
    public static final String AVD_INI_ROLL_RESIZE_1_AT_POSTURE = "hw.sensor.roll.resize_to_displayRegion.0.1_at_posture";
    public static final String AVD_INI_ROLL_RESIZE_2_AT_POSTURE = "hw.sensor.roll.resize_to_displayRegion.0.2_at_posture";
    public static final String AVD_INI_ROLL_RESIZE_3_AT_POSTURE = "hw.sensor.roll.resize_to_displayRegion.0.3_at_posture";
    public static final String AVD_INI_ROLL_PERCENTAGES_POSTURE_DEFINITIONS = "hw.sensor.roll_percentages_posture_definitions";
    public static final String AVD_INI_ANDROID_API = "image.androidVersion.api";
    public static final String AVD_INI_ANDROID_CODENAME = "image.androidVersion.codename";
    public static final Pattern NUMERIC_SKIN_SIZE = Pattern.compile("([0-9]{2,})x([0-9]{2,})");
    public static final String DATA_FOLDER = "data";
    public static final String USERDATA_IMG = "userdata.img";
    public static final String USERDATA_QEMU_IMG = "userdata-qemu.img";
    public static final String SNAPSHOTS_DIRECTORY = "snapshots";
    private static final String BOOT_PROP = "boot.prop";
    static final String CONFIG_INI = "config.ini";
    private static final String HARDWARE_QEMU_INI = "hardware-qemu.ini";
    private static final String SDCARD_IMG = "sdcard.img";
    static final String INI_EXTENSION = ".ini";
    private static final Pattern INI_NAME_PATTERN = Pattern.compile("(.+)\\.ini$", 2);
    private static final Pattern IMAGE_NAME_PATTERN = Pattern.compile("(.+)\\.img$", 2);
    private static final Pattern SDCARD_SIZE_PATTERN = Pattern.compile("(\\d+)([KMG])");
    public static final long SDCARD_MIN_BYTE_SIZE = 0x900000L;
    public static final long SDCARD_MAX_BYTE_SIZE = 0xFFC0000000L;
    public static final int SDCARD_SIZE_NOT_IN_RANGE = 0;
    public static final int SDCARD_SIZE_INVALID = -1;
    public static final int SDCARD_NOT_SIZE_PATTERN = -2;
    public static final String HARDWARE_INI = "hardware.ini";
    private static final Map<AvdManagerCacheKey, WeakReference<AvdManager>> mManagers = new HashMap<AvdManagerCacheKey, WeakReference<AvdManager>>();
    private final ArrayList<AvdInfo> mAllAvdList = new ArrayList();
    private AvdInfo[] mValidAvdList;
    private AvdInfo[] mBrokenAvdList;
    private final AndroidSdkHandler mSdkHandler;
    private final Map<ILogger, DeviceManager> mDeviceManagers = new HashMap<ILogger, DeviceManager>();
    private final FileOp mFop;

    protected AvdManager(AndroidSdkHandler sdkHandler, Path baseAvdFolder, ILogger log, FileOp fop) throws AndroidLocationsException {
        this.mSdkHandler = sdkHandler;
        this.mFop = fop;
        this.mBaseAvdFolder = baseAvdFolder;
        this.buildAvdList(this.mAllAvdList, log);
    }

    public static AvdManager getInstance(AndroidSdkHandler sdkHandler, ILogger log) throws AndroidLocationsException {
        return AvdManager.getInstance(sdkHandler, AndroidLocationsSingleton.INSTANCE.getAvdLocation(), log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AvdManager getInstance(AndroidSdkHandler sdkHandler, Path avdHomeFolder, ILogger log) throws AndroidLocationsException {
        if (sdkHandler.getLocation() == null) {
            throw new AndroidLocationsException("Local SDK path not set!");
        }
        Map<AvdManagerCacheKey, WeakReference<AvdManager>> map = mManagers;
        synchronized (map) {
            AvdManager manager;
            FileOp fop = sdkHandler.getFileOp();
            AvdManagerCacheKey key = new AvdManagerCacheKey(sdkHandler.getLocation(), avdHomeFolder);
            WeakReference<AvdManager> ref = mManagers.get(key);
            if (ref != null && (manager = (AvdManager)ref.get()) != null) {
                return manager;
            }
            try {
                manager = new AvdManager(sdkHandler, avdHomeFolder, log, fop);
            }
            catch (AndroidLocationsException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Throwable)e, "Exception during AvdManager initialization", new Object[0]);
                return null;
            }
            mManagers.put(key, new WeakReference<AvdManager>(manager));
            return manager;
        }
    }

    public Path getBaseAvdFolder() {
        return this.mBaseAvdFolder;
    }

    public static long parseSdcardSize(String sdcard, String[] parsedStrings) {
        Matcher m;
        if (parsedStrings != null) {
            assert (parsedStrings.length == 2);
            parsedStrings[0] = null;
            parsedStrings[1] = null;
        }
        if ((m = SDCARD_SIZE_PATTERN.matcher(sdcard)).matches()) {
            if (parsedStrings != null) {
                assert (parsedStrings.length == 2);
                parsedStrings[0] = m.group(1);
                parsedStrings[1] = m.group(2);
            }
            try {
                long sdcardSize = Long.parseLong(m.group(1));
                String sdcardSizeModifier = m.group(2);
                if ("K".equals(sdcardSizeModifier)) {
                    sdcardSize <<= 10;
                } else if ("M".equals(sdcardSizeModifier)) {
                    sdcardSize <<= 20;
                } else if ("G".equals(sdcardSizeModifier)) {
                    sdcardSize <<= 30;
                }
                if (sdcardSize < 0x900000L || sdcardSize > 0xFFC0000000L) {
                    return 0L;
                }
                return sdcardSize;
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getAllAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            return this.mAllAvdList.toArray(new AvdInfo[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getValidAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mValidAvdList == null) {
                ArrayList<AvdInfo> list = new ArrayList<AvdInfo>();
                for (AvdInfo avd : this.mAllAvdList) {
                    if (avd.getStatus() != AvdInfo.AvdStatus.OK) continue;
                    list.add(avd);
                }
                this.mValidAvdList = list.toArray(new AvdInfo[0]);
            }
            return this.mValidAvdList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo getAvd(String name, boolean validAvdOnly) {
        boolean ignoreCase;
        boolean bl = ignoreCase = SdkConstants.currentPlatform() == 2;
        if (validAvdOnly) {
            for (AvdInfo info : this.getValidAvds()) {
                String name2 = info.getName();
                if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                return info;
            }
        } else {
            ArrayList<AvdInfo> arrayList = this.mAllAvdList;
            synchronized (arrayList) {
                for (AvdInfo info : this.mAllAvdList) {
                    String name2 = info.getName();
                    if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                    return info;
                }
            }
        }
        return null;
    }

    @Slow
    public boolean isAvdRunning(AvdInfo info, ILogger logger) {
        String pid;
        try {
            pid = this.getAvdPid(info);
        }
        catch (IOException e) {
            logger.error((Throwable)e, "IOException while getting PID", new Object[0]);
            return true;
        }
        if (pid != null) {
            String command = SdkConstants.currentPlatform() == 2 ? "cmd /c \"tasklist /FI \"PID eq " + pid + "\" | findstr " + pid + "\"" : "kill -0 " + pid;
            try {
                Process p = Runtime.getRuntime().exec(command);
                return p.waitFor() == 0;
            }
            catch (IOException e) {
                logger.warning("Got IOException while checking running processes:\n%s", new Object[]{Arrays.toString(e.getStackTrace())});
                return true;
            }
            catch (InterruptedException e) {
                logger.warning("Got InterruptedException while checking running processes:\n%s", new Object[]{Arrays.toString(e.getStackTrace())});
                return true;
            }
        }
        return false;
    }

    @Slow
    public void logRunningAvdInfo(AvdInfo info, ILogger logger) {
        int numTermChars;
        String command;
        String pid;
        try {
            pid = this.getAvdPid(info);
        }
        catch (IOException ex) {
            logger.error((Throwable)ex, "AVD not launched but got IOException while getting PID", new Object[0]);
            return;
        }
        if (pid == null) {
            logger.warning("AVD not launched but PID is null. Should not have indicated that the AVD is running.", new Object[0]);
            return;
        }
        logger.warning("AVD not launched because an instance appears to be running on PID " + pid, new Object[0]);
        if (SdkConstants.currentPlatform() == 2) {
            command = "cmd /c \"tasklist /FI \"PID eq " + pid + "\" /FO csv /V /NH\"";
            numTermChars = 2;
        } else {
            command = "ps -o pid= -o user= -o pcpu= -o tty= -o stat= -o time= -o etime= -o cmd= -p " + pid;
            numTermChars = 1;
        }
        try {
            Process proc = Runtime.getRuntime().exec(command);
            if (proc.waitFor() != 0) {
                logger.warning("Could not get info for that AVD process", new Object[0]);
            } else {
                InputStream procInfoStream = proc.getInputStream();
                int strMax = 256;
                byte[] procInfo = new byte[256];
                int nRead = procInfoStream.read(procInfo, 0, 256);
                if (nRead <= numTermChars) {
                    logger.warning("Info for that AVD process is null", new Object[0]);
                } else {
                    logger.warning("AVD process info: [" + new String(procInfo, 0, nRead - numTermChars) + "]", new Object[0]);
                }
            }
        }
        catch (IOException | InterruptedException ex) {
            logger.warning("Got exception when getting info on that AVD process:\n%s", new Object[]{Arrays.toString(ex.getStackTrace())});
        }
    }

    @Slow
    public void stopAvd(AvdInfo info) {
        try {
            String pid = this.getAvdPid(info);
            if (pid != null) {
                String command = SdkConstants.currentPlatform() == 2 ? "cmd /c \"taskkill /PID " + pid + "\"" : "kill " + pid;
                try {
                    Process p = Runtime.getRuntime().exec(command);
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getAvdPid(AvdInfo info) throws IOException {
        Path dataFolderPath = this.mBaseAvdFolder.resolve(info.getDataFolderPath());
        Path f = dataFolderPath.resolve("hardware-qemu.ini.lock");
        if (SdkConstants.currentPlatform() == 2) {
            f = f.resolve("pid");
        }
        Path alternative = dataFolderPath.resolve("userdata-qemu.img.lock");
        if (SdkConstants.currentPlatform() == 2) {
            alternative = alternative.resolve("pid");
        }
        try {
            return CancellableFileIo.readString((Path)f).trim();
        }
        catch (NoSuchFileException noSuchFileException) {
            try {
                return CancellableFileIo.readString((Path)alternative).trim();
            }
            catch (NoSuchFileException noSuchFileException2) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    public void reloadAvds(ILogger log) throws AndroidLocationsException {
        ArrayList<AvdInfo> allList = new ArrayList<AvdInfo>();
        this.buildAvdList(allList, log);
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            this.mAllAvdList.clear();
            this.mAllAvdList.addAll(allList);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    public AvdInfo reloadAvd(AvdInfo avdInfo, ILogger log) {
        AvdInfo newInfo = this.parseAvdInfo(this.mFop.toPath(avdInfo.getIniFile()), log);
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            int index = this.mAllAvdList.indexOf(avdInfo);
            if (index >= 0) {
                this.replaceAvd(avdInfo, newInfo);
            }
        }
        return newInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Slow
    public AvdInfo createAvd(Path avdFolder, String avdName, ISystemImage systemImage, Path skinFolder, String skinName, String sdcard, Map<String, String> hardwareConfig, Map<String, String> bootProps, boolean deviceHasPlayStore, boolean removePrevious, boolean editExisting, ILogger log) {
        block34: {
            block32: {
                block33: {
                    block29: {
                        block30: {
                            block31: {
                                block37: {
                                    block36: {
                                        iniFile = null;
                                        needCleanup = false;
                                        newAvdInfo = null;
                                        configValues = new HashMap<String, String>();
                                        if (CancellableFileIo.exists((Path)avdFolder, (LinkOption[])new LinkOption[0])) break block36;
                                        Files.createDirectories(avdFolder, new FileAttribute[0]);
                                        AvdManager.inhibitCopyOnWrite(avdFolder, log);
                                        editExisting = false;
                                        ** GOTO lbl48
                                    }
                                    if (!removePrevious) break block37;
                                    try {
                                        this.deleteContentOf(avdFolder);
                                        AvdManager.inhibitCopyOnWrite(avdFolder, log);
                                    }
                                    catch (SecurityException e) {
                                        log.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath(), e});
                                    }
                                    ** GOTO lbl48
                                }
                                if (editExisting) ** GOTO lbl48
                                oldAvdFolderPath = avdFolder.toAbsolutePath().toString();
                                newAvdInfo = this.duplicateAvd(avdFolder, avdName, systemImage, log);
                                if (newAvdInfo != null) break block29;
                                var18_23 = null;
                                if (!needCleanup) break block30;
                                if (iniFile == null) break block31;
                                FileOpUtils.deleteFileOrFolder((Path)iniFile);
                            }
                            try {
                                FileOpUtils.deleteFileOrFolder((Path)avdFolder);
                            }
                            catch (SecurityException e) {
                                log.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath(), e});
                            }
                        }
                        return var18_23;
                    }
                    avdFolder = this.mFop.toPath(newAvdInfo.getDataFolderPath());
                    configValues.putAll(newAvdInfo.getProperties());
                    if (hardwareConfig != null && (oldSdCardPath = hardwareConfig.get("sdcard.path")) != null && oldSdCardPath.startsWith(oldAvdFolderPath)) {
                        hardwareConfig.put("sdcard.path", oldSdCardPath.replace(oldAvdFolderPath, newAvdInfo.getDataFolderPath()));
                    }
lbl48:
                    // 7 sources

                    iniFile = this.createAvdIniFile(avdName, avdFolder, removePrevious, systemImage.getAndroidVersion());
                    needCleanup = true;
                    this.createAvdUserdata(systemImage, avdFolder, log);
                    this.createAvdConfigFile(systemImage, configValues, log);
                    tag = systemImage.getTag();
                    configValues.put("tag.id", tag.getId());
                    configValues.put("tag.display", tag.getDisplay());
                    configValues.put("abi.type", systemImage.getAbiType());
                    configValues.put("PlayStore.enabled", Boolean.toString(deviceHasPlayStore != false && systemImage.hasPlayStore() != false));
                    configValues.put("hw.arc", Boolean.toString(SystemImage.CHROMEOS_TAG.equals(tag)));
                    this.createAvdSkin(skinFolder == null ? null : skinFolder, skinName, configValues, log);
                    this.createAvdSdCard(sdcard, editExisting, configValues, avdFolder, log);
                    if (hardwareConfig == null) {
                        hardwareConfig = new HashMap<String, String>();
                    }
                    this.writeCpuArch(systemImage, hardwareConfig, log);
                    this.addHardwareConfig(systemImage, skinFolder, avdFolder, hardwareConfig, configValues, log);
                    if (bootProps != null && !bootProps.isEmpty()) {
                        bootPropsFile = avdFolder.resolve("boot.prop");
                        this.writeIniFile(bootPropsFile, bootProps, false);
                    }
                    oldAvdInfo = this.getAvd(avdName, false);
                    if (newAvdInfo == null) {
                        newAvdInfo = this.createAvdInfoObject(systemImage, avdName, removePrevious, editExisting, iniFile, avdFolder, oldAvdInfo, configValues);
                    }
                    if ((removePrevious || editExisting) && oldAvdInfo != null && !oldAvdInfo.getDataFolderPath().equals(newAvdInfo.getDataFolderPath())) {
                        log.warning("Removing previous AVD directory at %s", new Object[]{oldAvdInfo.getDataFolderPath()});
                        if (!FileOpUtils.deleteFileOrFolder((Path)this.mBaseAvdFolder.resolve(oldAvdInfo.getDataFolderPath()))) {
                            log.warning("Failed to delete %1$s: %2$s", new Object[]{oldAvdInfo.getDataFolderPath()});
                        }
                    }
                    needCleanup = false;
                    var19_26 = newAvdInfo;
                    if (!needCleanup) break block32;
                    if (iniFile == null) break block33;
                    FileOpUtils.deleteFileOrFolder((Path)iniFile);
                }
                try {
                    FileOpUtils.deleteFileOrFolder((Path)avdFolder);
                }
                catch (SecurityException e) {
                    log.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath(), e});
                }
            }
            return var19_26;
            catch (AvdMgrException newAvdInfo) {
                if (needCleanup) {
                    if (iniFile != null) {
                        FileOpUtils.deleteFileOrFolder(iniFile);
                    }
                    try {
                        FileOpUtils.deleteFileOrFolder((Path)avdFolder);
                    }
                    catch (SecurityException e) {
                        log.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath(), e});
                    }
                }
                break block34;
            }
            catch (AndroidLocationsException | IOException | SecurityException e) {
                block35: {
                    log.warning("%1$s", new Object[]{e});
                    if (!needCleanup) break block34;
                    if (iniFile == null) break block35;
                    {
                        catch (Throwable var21_28) {
                            if (needCleanup) {
                                if (iniFile != null) {
                                    FileOpUtils.deleteFileOrFolder(iniFile);
                                }
                                try {
                                    FileOpUtils.deleteFileOrFolder((Path)avdFolder);
                                }
                                catch (SecurityException e) {
                                    log.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath(), e});
                                }
                            }
                            throw var21_28;
                        }
                    }
                    FileOpUtils.deleteFileOrFolder(iniFile);
                }
                try {
                    FileOpUtils.deleteFileOrFolder((Path)avdFolder);
                }
                catch (SecurityException e) {
                    log.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath(), e});
                }
            }
        }
        return null;
    }

    private AvdInfo duplicateAvd(Path origAvd, String newAvdName, ISystemImage systemImage, ILogger log) {
        try {
            Path destAvdFolder = origAvd.getParent().resolve(newAvdName + AVD_FOLDER_EXTENSION);
            AvdManager.inhibitCopyOnWrite(destAvdFolder, log);
            ConsoleProgressIndicator progInd = new ConsoleProgressIndicator();
            progInd.setText("Copying files");
            progInd.setIndeterminate(true);
            FileOpUtils.recursiveCopy((Path)origAvd, (Path)destAvdFolder, (boolean)false, (ProgressIndicator)progInd);
            Path configIni = destAvdFolder.resolve(CONFIG_INI);
            Map<String, String> configVals = AvdManager.parseIniFile(new PathFileWrapper(configIni), log);
            configVals.put(AVD_INI_AVD_ID, newAvdName);
            configVals.put(AVD_INI_DISPLAY_NAME, newAvdName);
            this.writeIniFile(configIni, configVals, true);
            String origAvdName = origAvd.getFileName().toString().replace(AVD_FOLDER_EXTENSION, "");
            String origAvdPath = origAvd.toAbsolutePath().toString();
            String newAvdPath = destAvdFolder.toAbsolutePath().toString();
            configVals = this.updateNameAndIniPaths(configIni, origAvdName, origAvdPath, newAvdName, newAvdPath, log);
            Path hwQemu = destAvdFolder.resolve(HARDWARE_QEMU_INI);
            this.updateNameAndIniPaths(hwQemu, origAvdName, origAvdPath, newAvdName, newAvdPath, log);
            Path iniFile = this.createAvdIniFile(newAvdName, destAvdFolder, false, systemImage.getAndroidVersion());
            return new AvdInfo(newAvdName, this.mFop.toFile(iniFile), destAvdFolder.toAbsolutePath().toString(), systemImage, configVals);
        }
        catch (AndroidLocationsException | IOException e) {
            log.warning("Exception while duplicating an AVD: %1$s", new Object[]{e});
            return null;
        }
    }

    private Map<String, String> updateNameAndIniPaths(Path iniFile, String oldName, String oldPath, String newName, String newPath, ILogger log) throws IOException {
        Map<String, String> iniVals = AvdManager.parseIniFile(new PathFileWrapper(iniFile), log);
        if (iniVals != null) {
            for (Map.Entry<String, String> iniEntry : iniVals.entrySet()) {
                String origIniValue = iniEntry.getValue();
                if (origIniValue.equals(oldName)) {
                    iniVals.put(iniEntry.getKey(), newName);
                }
                if (!origIniValue.startsWith(oldPath)) continue;
                String newIniValue = origIniValue.replace(oldPath, newPath);
                iniVals.put(iniEntry.getKey(), newIniValue);
            }
            this.writeIniFile(iniFile, iniVals, true);
        }
        return iniVals;
    }

    private String getImageRelativePath(ISystemImage systemImage) throws InvalidTargetPathException {
        String[] list;
        String sdkLocation;
        Path folder = systemImage.getLocation();
        String imageFullPath = folder.toAbsolutePath().toString();
        if (!imageFullPath.startsWith(sdkLocation = this.mSdkHandler.getLocation().toAbsolutePath().toString())) {
            assert (false);
            throw new InvalidTargetPathException("Target location is not inside the SDK.");
        }
        try (Stream contents = CancellableFileIo.list((Path)folder);){
            list = (String[])contents.map(path -> path.getFileName().toString()).filter(path -> IMAGE_NAME_PATTERN.matcher((CharSequence)path).matches()).toArray(String[]::new);
        }
        catch (IOException e) {
            return null;
        }
        if (list.length > 0) {
            if ((imageFullPath = imageFullPath.substring(sdkLocation.length())).charAt(0) == File.separatorChar) {
                imageFullPath = imageFullPath.substring(1);
            }
            if (!imageFullPath.endsWith(File.separator)) {
                imageFullPath = imageFullPath + File.separator;
            }
            return imageFullPath;
        }
        return null;
    }

    private Path createAvdIniFile(String name, Path avdFolder, boolean removePrevious, AndroidVersion version) throws AndroidLocationsException, IOException {
        Path iniFile = AvdInfo.getDefaultIniFile(this, name);
        if (removePrevious) {
            if (CancellableFileIo.isRegularFile((Path)iniFile, (LinkOption[])new LinkOption[0])) {
                Files.delete(iniFile);
            } else if (CancellableFileIo.isDirectory((Path)iniFile, (LinkOption[])new LinkOption[0])) {
                FileOpUtils.deleteFileOrFolder((Path)iniFile);
            }
        }
        String absPath = avdFolder.toAbsolutePath().toString();
        String relPath = null;
        Path androidFolder = this.mSdkHandler.getAndroidFolder();
        if (androidFolder == null) {
            throw new AndroidLocationsException("Can't locate Android SDK installation directory for the AVD .ini file.");
        }
        String androidPath = androidFolder.toAbsolutePath() + File.separator;
        if (absPath.startsWith(androidPath)) {
            relPath = absPath.substring(androidPath.length());
        }
        HashMap<String, String> values = new HashMap<String, String>();
        if (relPath != null) {
            values.put(AVD_INFO_REL_PATH, relPath);
        }
        values.put(AVD_INFO_ABS_PATH, absPath);
        values.put(AVD_INFO_TARGET, AndroidTargetHash.getPlatformHashString(version));
        this.writeIniFile(iniFile, values, true);
        return iniFile;
    }

    private Path createAvdIniFile(AvdInfo info) throws AndroidLocationsException, IOException {
        return this.createAvdIniFile(info.getName(), this.mBaseAvdFolder.resolve(info.getDataFolderPath()), false, info.getAndroidVersion());
    }

    @Slow
    public boolean deleteAvd(AvdInfo avdInfo, ILogger log) {
        try {
            boolean error = false;
            Path f = this.mFop.toPath(avdInfo.getIniFile());
            try {
                Files.deleteIfExists(f);
            }
            catch (IOException exception) {
                log.warning("Failed to delete %1$s\n", new Object[]{f});
                error = true;
            }
            String path = avdInfo.getDataFolderPath();
            f = this.mBaseAvdFolder.resolve(path);
            if (!FileOpUtils.deleteFileOrFolder((Path)f) && CancellableFileIo.exists((Path)f, (LinkOption[])new LinkOption[0])) {
                log.warning("Failed to delete %1$s\n", new Object[]{f});
                error = true;
            }
            this.removeAvd(avdInfo);
            if (!error) {
                log.info("\nAVD '%1$s' deleted.\n", new Object[]{avdInfo.getName()});
                return true;
            }
            log.info("\nAVD '%1$s' deleted with errors. See errors above.\n", new Object[]{avdInfo.getName()});
        }
        catch (SecurityException e) {
            log.warning("%1$s", new Object[]{e});
        }
        return false;
    }

    @Slow
    public boolean moveAvd(AvdInfo avdInfo, String newName, String paramFolderPath, ILogger log) {
        try {
            if (paramFolderPath != null) {
                Path f = this.mBaseAvdFolder.resolve(avdInfo.getDataFolderPath());
                log.info("Moving '%1$s' to '%2$s'.\n", new Object[]{avdInfo.getDataFolderPath(), paramFolderPath});
                try {
                    Files.move(f, this.mBaseAvdFolder.resolve(paramFolderPath), new CopyOption[0]);
                }
                catch (IOException exception) {
                    log.error((Throwable)exception, "Failed to move '%1$s' to '%2$s'.\n", new Object[]{avdInfo.getDataFolderPath(), paramFolderPath});
                    return false;
                }
                AvdInfo info = new AvdInfo(avdInfo.getName(), avdInfo.getIniFile(), paramFolderPath, avdInfo.getSystemImage(), avdInfo.getProperties());
                this.replaceAvd(avdInfo, info);
                this.createAvdIniFile(info);
            }
            if (newName != null) {
                Path oldIniFile = this.mFop.toPath(avdInfo.getIniFile());
                Path newIniFile = AvdInfo.getDefaultIniFile(this, newName);
                log.warning("Moving '%1$s' to '%2$s'.", new Object[]{oldIniFile, newIniFile});
                try {
                    Files.move(oldIniFile, newIniFile, new CopyOption[0]);
                }
                catch (IOException exception) {
                    log.warning(null, new Object[]{"Failed to move '%1$s' to '%2$s'.", oldIniFile, newIniFile});
                    return false;
                }
                AvdInfo info = new AvdInfo(newName, avdInfo.getIniFile(), avdInfo.getDataFolderPath(), avdInfo.getSystemImage(), avdInfo.getProperties());
                this.replaceAvd(avdInfo, info);
            }
            log.info("AVD '%1$s' moved.\n", new Object[]{avdInfo.getName()});
        }
        catch (AndroidLocationsException | IOException e) {
            log.warning("$1%s", new Object[]{e});
            return false;
        }
        return true;
    }

    private boolean deleteContentOf(Path folder) throws SecurityException {
        boolean success = true;
        try (DirectoryStream<Path> entries = Files.newDirectoryStream(folder);){
            for (Path entry : entries) {
                success &= FileOpUtils.deleteFileOrFolder((Path)entry);
            }
        }
        catch (IOException exception) {
            return false;
        }
        return true;
    }

    private Path[] buildAvdFilesList() throws AndroidLocationsException {
        if (CancellableFileIo.isRegularFile((Path)this.mBaseAvdFolder, (LinkOption[])new LinkOption[0])) {
            throw new AndroidLocationsException(String.format("%1$s is not a valid folder.", this.mBaseAvdFolder.toAbsolutePath()));
        }
        if (CancellableFileIo.notExists((Path)this.mBaseAvdFolder, (LinkOption[])new LinkOption[0])) {
            try {
                Files.createDirectories(this.mBaseAvdFolder, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        Path[] avds = new Path[]{};
        try (Stream contents = CancellableFileIo.list((Path)this.mBaseAvdFolder);){
            avds = (Path[])contents.filter(path -> {
                if (INI_NAME_PATTERN.matcher(path.getFileName().toString()).matches()) {
                    return Files.isRegularFile(path, new LinkOption[0]);
                }
                return false;
            }).toArray(Path[]::new);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return avds;
    }

    private void buildAvdList(ArrayList<AvdInfo> allList, ILogger log) throws AndroidLocationsException {
        Path[] avds = this.buildAvdFilesList();
        if (avds != null) {
            for (Path avd : avds) {
                AvdInfo info = this.parseAvdInfo(avd, log);
                if (info == null || allList.contains(info)) continue;
                allList.add(info);
            }
        }
    }

    private DeviceManager getDeviceManager(ILogger logger) {
        DeviceManager manager = this.mDeviceManagers.get(logger);
        if (manager == null) {
            manager = DeviceManager.createInstance(this.mSdkHandler, logger);
            manager.registerListener(this.mDeviceManagers::clear);
            this.mDeviceManagers.put(logger, manager);
        }
        return manager;
    }

    @Slow
    @VisibleForTesting
    public AvdInfo parseAvdInfo(Path iniPath, ILogger log) {
        AndroidVersion version;
        String targetHash;
        String name;
        Matcher matcher;
        String relPath;
        Map<String, String> map = AvdManager.parseIniFile(new PathFileWrapper(iniPath), log);
        String avdPath = null;
        if (!(map == null || (avdPath = map.get(AVD_INFO_ABS_PATH)) != null && CancellableFileIo.isDirectory((Path)this.mBaseAvdFolder.resolve(avdPath), (LinkOption[])new LinkOption[0]) || (relPath = map.get(AVD_INFO_REL_PATH)) == null)) {
            Path f;
            Path androidFolder = this.mSdkHandler.getAndroidFolder();
            Path path = f = androidFolder == null ? this.mSdkHandler.toCompatiblePath(relPath) : androidFolder.resolve(relPath);
            if (CancellableFileIo.isDirectory((Path)f, (LinkOption[])new LinkOption[0])) {
                avdPath = f.toAbsolutePath().toString();
            }
        }
        if (avdPath == null || !CancellableFileIo.isDirectory((Path)this.mBaseAvdFolder.resolve(avdPath), (LinkOption[])new LinkOption[0])) {
            String avdName = iniPath.getFileName().toString();
            if (avdName.endsWith(INI_EXTENSION)) {
                avdName = avdName.substring(0, avdName.length() - 4);
            }
            return new AvdInfo(avdName, this.mFop.toFile(iniPath), iniPath.toString(), null, null, AvdInfo.AvdStatus.ERROR_CORRUPTED_INI);
        }
        PathFileWrapper configIniFile = null;
        Map<String, String> properties = null;
        LoggerProgressIndicatorWrapper progress = new LoggerProgressIndicatorWrapper(log){

            @Override
            public void logVerbose(String s) {
            }
        };
        if (avdPath != null) {
            configIniFile = new PathFileWrapper(this.mFop.toPath(avdPath).resolve(CONFIG_INI));
        }
        if (configIniFile != null) {
            if (!configIniFile.exists()) {
                log.warning("Missing file '%1$s'.", new Object[]{configIniFile.getOsLocation()});
            } else {
                properties = AvdManager.parseIniFile(configIniFile, log);
            }
        }
        if ((matcher = INI_NAME_PATTERN.matcher(name = iniPath.getFileName().toString())).matches()) {
            name = matcher.group(1);
        }
        boolean validImageSysdir = true;
        String imageSysDir = null;
        ISystemImage sysImage = null;
        if (properties != null && (imageSysDir = properties.get(AVD_INI_IMAGES_1)) != null) {
            Path sdkLocation = this.mSdkHandler.getLocation();
            Path imageDir = sdkLocation == null ? this.mFop.toPath(imageSysDir) : sdkLocation.resolve(imageSysDir);
            sysImage = this.mSdkHandler.getSystemImageManager((ProgressIndicator)progress).getImageAt(imageDir);
        }
        DeviceManager.DeviceStatus deviceStatus = null;
        boolean updateHashV2 = false;
        if (properties != null) {
            String deviceName = properties.get(AVD_INI_DEVICE_NAME);
            String deviceMfctr = properties.get(AVD_INI_DEVICE_MANUFACTURER);
            if (deviceName != null && deviceMfctr != null) {
                DeviceManager devMan = this.getDeviceManager(log);
                Device d = devMan.getDevice(deviceName, deviceMfctr);
                DeviceManager.DeviceStatus deviceStatus2 = deviceStatus = d == null ? DeviceManager.DeviceStatus.MISSING : DeviceManager.DeviceStatus.EXISTS;
                if (d != null) {
                    String hashV1;
                    updateHashV2 = true;
                    String hashV2 = properties.get(AVD_INI_DEVICE_HASH_V2);
                    if (hashV2 != null) {
                        String newHashV2 = DeviceManager.hasHardwarePropHashChanged(d, hashV2);
                        if (newHashV2 == null) {
                            updateHashV2 = false;
                        } else {
                            properties.put(AVD_INI_DEVICE_HASH_V2, newHashV2);
                        }
                    }
                    if ((hashV1 = properties.get(AVD_INI_DEVICE_HASH_V1)) != null) {
                        properties.remove(AVD_INI_DEVICE_HASH_V1);
                    }
                }
            }
        }
        AvdInfo.AvdStatus status = avdPath == null ? AvdInfo.AvdStatus.ERROR_PATH : (configIniFile == null ? AvdInfo.AvdStatus.ERROR_CONFIG : (properties == null || imageSysDir == null ? AvdInfo.AvdStatus.ERROR_PROPERTIES : (!validImageSysdir ? AvdInfo.AvdStatus.ERROR_IMAGE_DIR : (deviceStatus == DeviceManager.DeviceStatus.CHANGED ? AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED : (deviceStatus == DeviceManager.DeviceStatus.MISSING ? AvdInfo.AvdStatus.ERROR_DEVICE_MISSING : (sysImage == null ? AvdInfo.AvdStatus.ERROR_IMAGE_MISSING : AvdInfo.AvdStatus.OK))))));
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        if (!properties.containsKey(AVD_INI_ANDROID_API) && !properties.containsKey(AVD_INI_ANDROID_CODENAME) && (targetHash = map.get(AVD_INFO_TARGET)) != null && (version = AndroidTargetHash.getVersionFromHash(targetHash)) != null) {
            properties.put(AVD_INI_ANDROID_API, Integer.toString(version.getApiLevel()));
            if (version.getCodename() != null) {
                properties.put(AVD_INI_ANDROID_CODENAME, version.getCodename());
            }
        }
        AvdInfo info = new AvdInfo(name, this.mFop.toFile(iniPath), avdPath, sysImage, properties, status);
        if (updateHashV2) {
            try {
                return this.updateDeviceChanged(info, log);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return info;
    }

    private void writeIniFile(Path iniFile, Map<String, String> values, boolean addEncoding) throws IOException {
        Charset charset = Charsets.UTF_8;
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(iniFile, new OpenOption[0]), charset);){
            if (addEncoding) {
                values.put(AVD_INI_ENCODING, charset.name());
            }
            ArrayList<String> keys = new ArrayList<String>(values.keySet());
            keys.remove(AVD_INI_ANDROID_API);
            keys.remove(AVD_INI_ANDROID_CODENAME);
            Collections.sort(keys);
            for (String key : keys) {
                String value = values.get(key);
                if (value == null) continue;
                writer.write(String.format("%1$s=%2$s\n", key, value));
            }
        }
    }

    @Slow
    public static Map<String, String> parseIniFile(IAbstractFile propFile, ILogger log) {
        return AvdManager.parseIniFileImpl(propFile, log, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> parseIniFileImpl(IAbstractFile propFile, ILogger log, Charset charset) {
        reader = null;
        try {
            canChangeCharset = false;
            if (charset == null) {
                canChangeCharset = true;
                charset = Charsets.ISO_8859_1;
            }
            reader = new BufferedReader(new InputStreamReader(propFile.getContents(), charset));
            line = null;
            map = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                block26: {
                    if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                    m = AvdManager.INI_LINE_PATTERN.matcher(line);
                    if (!m.matches()) break block26;
                    key = m.group(1);
                    value = m.group(2);
                    if (canChangeCharset && "avd.ini.encoding".equals(key) && !charset.name().equals(value) && Charset.isSupported(value)) {
                        charset = Charset.forName(value);
                        var10_16 = AvdManager.parseIniFileImpl(propFile, log, charset);
                        ** try [egrp 1[TRYBLOCK] [0 : 170->178)] { 
lbl20:
                        // 1 sources

                    } else {
                        map.put(key, value);
                        continue;
                    }
                }
                if (log != null) {
                    log.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", new Object[]{propFile.getOsLocation(), line});
                }
                var8_12 = null;
                ** try [egrp 3[TRYBLOCK] [1 : 232->240)] { 
lbl29:
                // 1 sources

                ** GOTO lbl-1000
            }
            var7_11 = map;
            ** try [egrp 5[TRYBLOCK] [2 : 252->260)] { 
lbl32:
            // 1 sources

            ** GOTO lbl-1000
        }
        catch (FileNotFoundException canChangeCharset) {
            try {
                Closeables.close(reader, (boolean)true);
                return null;
            }
            catch (IOException canChangeCharset) {
                return null;
            }
        }
        catch (StreamException | IOException e) {
            if (log == null) return null;
            log.warning("Error parsing '%1$s': %2$s.", new Object[]{propFile.getOsLocation(), e.getMessage()});
            return null;
        }
        {
            Closeables.close((Closeable)reader, (boolean)true);
            return var10_16;
        }
lbl48:
        // 1 sources

        catch (IOException var11_17) {
            // empty catch block
        }
        return var10_16;
lbl-1000:
        // 1 sources

        {
            Closeables.close((Closeable)reader, (boolean)true);
            return var8_12;
        }
lbl53:
        // 1 sources

        catch (IOException var9_15) {
            // empty catch block
        }
        return var8_12;
lbl-1000:
        // 1 sources

        {
            Closeables.close((Closeable)reader, (boolean)true);
            return var7_11;
        }
lbl58:
        // 1 sources

        catch (IOException var8_13) {
            // empty catch block
        }
        return var7_11;
        finally {
            try {
                Closeables.close(reader, (boolean)true);
            }
            catch (IOException var4_8) {}
        }
    }

    @VisibleForTesting
    protected boolean createSdCard(String toolLocation, String size, String location, ILogger log) {
        try {
            String[] command = new String[]{toolLocation, size, location};
            Process process = Runtime.getRuntime().exec(command);
            final ArrayList errorOutput = new ArrayList();
            final ArrayList stdOutput = new ArrayList();
            int status = GrabProcessOutput.grabProcessOutput((Process)process, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(){

                public void out(String line) {
                    if (line != null) {
                        stdOutput.add(line);
                    }
                }

                public void err(String line) {
                    if (line != null) {
                        errorOutput.add(line);
                    }
                }
            });
            if (status == 0) {
                return true;
            }
            for (String error : errorOutput) {
                log.warning("%1$s", new Object[]{error});
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        log.warning("Failed to create the SD card.", new Object[0]);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAvd(AvdInfo avdInfo) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mAllAvdList.remove(avdInfo)) {
                this.mBrokenAvdList = null;
                this.mValidAvdList = null;
                return true;
            }
        }
        return false;
    }

    @Slow
    public AvdInfo updateAvd(AvdInfo avd, Map<String, String> newProperties) throws IOException {
        Path configIniFile = this.mFop.toPath(avd.getDataFolderPath()).resolve(CONFIG_INI);
        this.writeIniFile(configIniFile, newProperties, true);
        AvdInfo newAvd = new AvdInfo(avd.getName(), avd.getIniFile(), avd.getDataFolderPath(), avd.getSystemImage(), newProperties);
        this.replaceAvd(avd, newAvd);
        return newAvd;
    }

    @Slow
    public AvdInfo updateDeviceChanged(AvdInfo avd, ILogger log) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>(avd.getProperties());
        DeviceManager devMan = this.getDeviceManager(log);
        Collection<Device> devices = devMan.getDevices(DeviceManager.ALL_DEVICES);
        String name = (String)properties.get(AVD_INI_DEVICE_NAME);
        String manufacturer = (String)properties.get(AVD_INI_DEVICE_MANUFACTURER);
        if (name != null && manufacturer != null) {
            for (Device d : devices) {
                if (!d.getId().equals(name) || !d.getManufacturer().equals(manufacturer)) continue;
                Map<String, String> deviceHwProperties = DeviceManager.getHardwareProperties(d);
                deviceHwProperties.remove(AVD_INI_RAM_SIZE);
                properties.putAll(deviceHwProperties);
                try {
                    return this.updateAvd(avd, properties);
                }
                catch (IOException e) {
                    log.warning("%1$s", new Object[]{e});
                }
            }
        } else {
            log.warning("Base device information incomplete or missing.", new Object[0]);
        }
        return null;
    }

    private boolean setImagePathProperties(ISystemImage image, Map<String, String> properties, ILogger log) {
        properties.remove(AVD_INI_IMAGES_1);
        properties.remove(AVD_INI_IMAGES_2);
        try {
            String property = AVD_INI_IMAGES_1;
            String imagePath = this.getImageRelativePath(image);
            if (imagePath != null) {
                properties.put(property, imagePath);
                return true;
            }
        }
        catch (InvalidTargetPathException e) {
            log.warning("%1$s", new Object[]{e});
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAvd(AvdInfo oldAvd, AvdInfo newAvd) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            this.mAllAvdList.remove(oldAvd);
            this.mAllAvdList.add(newAvd);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
    }

    private void createAvdUserdata(ISystemImage systemImage, Path avdFolder, ILogger log) throws IOException, AvdMgrException {
        Path imageFolder = systemImage.getLocation();
        Path userdataSrc = imageFolder.resolve(USERDATA_IMG);
        String abiType = systemImage.getAbiType();
        if (CancellableFileIo.notExists((Path)userdataSrc, (LinkOption[])new LinkOption[0])) {
            if (CancellableFileIo.isDirectory((Path)imageFolder.resolve(DATA_FOLDER), (LinkOption[])new LinkOption[0])) {
                return;
            }
            log.warning("Unable to find a '%1$s' file for ABI %2$s to copy into the AVD folder.", new Object[]{USERDATA_IMG, abiType});
            throw new AvdMgrException();
        }
        Path userdataDest = avdFolder.resolve(USERDATA_IMG);
        if (CancellableFileIo.notExists((Path)userdataDest, (LinkOption[])new LinkOption[0])) {
            FileUtils.copyFile((Path)userdataSrc, (Path)userdataDest);
            if (CancellableFileIo.notExists((Path)userdataDest, (LinkOption[])new LinkOption[0])) {
                log.warning("Unable to create '%1$s' file in the AVD folder.", new Object[]{userdataDest});
                throw new AvdMgrException();
            }
        }
    }

    private void createAvdConfigFile(ISystemImage systemImage, HashMap<String, String> values, ILogger log) throws AvdMgrException {
        if (!this.setImagePathProperties(systemImage, values, log)) {
            log.warning("Failed to set image path properties in the AVD folder.", new Object[0]);
            throw new AvdMgrException();
        }
    }

    private void writeCpuArch(ISystemImage systemImage, Map<String, String> values, ILogger log) throws AvdMgrException {
        String abiType = systemImage.getAbiType();
        Abi abi = Abi.getEnum(abiType);
        if (abi != null) {
            String arch = abi.getCpuArch();
            if (arch.equals("x86") && SystemImage.CHROMEOS_TAG.equals(systemImage.getTag())) {
                arch = "x86_64";
            }
            values.put(AVD_INI_CPU_ARCH, arch);
            String model = abi.getCpuModel();
            if (model != null) {
                values.put(AVD_INI_CPU_MODEL, model);
            }
        } else {
            log.warning("ABI %1$s is not supported by this version of the SDK Tools", new Object[]{abiType});
            throw new AvdMgrException();
        }
    }

    private void createAvdSkin(Path skinFolder, String skinName, Map<String, String> values, ILogger log) throws AvdMgrException {
        String skinPath = null;
        if (skinFolder == null && skinName != null && NUMERIC_SKIN_SIZE.matcher(skinName).matches()) {
            skinPath = skinName;
        } else if (skinFolder != null && skinName == null) {
            skinName = skinFolder.getFileName().toString();
        }
        if (skinFolder != null) {
            if (CancellableFileIo.notExists((Path)skinFolder, (LinkOption[])new LinkOption[0])) {
                log.warning("Skin '%1$s' does not exist at %2$s.", new Object[]{skinName, skinFolder});
                throw new AvdMgrException();
            }
            skinPath = skinFolder.startsWith(this.mSdkHandler.getLocation()) ? this.mSdkHandler.getLocation().relativize(skinFolder).toString() : skinFolder.toAbsolutePath().toString();
        }
        if (skinName != null) {
            values.put(AVD_INI_SKIN_NAME, skinName);
        }
        if (skinPath != null) {
            values.put(AVD_INI_SKIN_PATH, skinPath);
        }
    }

    private void createAvdSdCard(String sdcard, boolean editExisting, Map<String, String> values, Path avdFolder, ILogger log) throws AvdMgrException {
        if (sdcard == null || sdcard.isEmpty()) {
            return;
        }
        long sdcardSize = AvdManager.parseSdcardSize(sdcard, null);
        if (sdcardSize == 0L) {
            log.warning("SD Card size must be in the range 9 MiB..1023 GiB.", new Object[0]);
            throw new AvdMgrException();
        }
        if (sdcardSize == -1L) {
            log.warning("Unable to parse SD Card size", new Object[0]);
            throw new AvdMgrException();
        }
        if (sdcardSize == -2L) {
            Path sdcardFile = this.mBaseAvdFolder.resolve(sdcard);
            if (!CancellableFileIo.isRegularFile((Path)sdcardFile, (LinkOption[])new LinkOption[0])) {
                log.warning("'%1$s' is not recognized as a valid sdcard value.\nValue should be:\n1. path to an sdcard.\n2. size of the sdcard to create: <size>[K|M]", new Object[]{sdcard});
                throw new AvdMgrException();
            }
            values.put(AVD_INI_SDCARD_PATH, sdcard);
            return;
        }
        Path sdcardFile = avdFolder.resolve(SDCARD_IMG);
        boolean runMkSdcard = true;
        try {
            if (CancellableFileIo.size((Path)sdcardFile) == sdcardSize && editExisting) {
                runMkSdcard = false;
                log.info("SD Card already present with same size, was not changed.\n", new Object[0]);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException exception) {
            AvdMgrException wrapper = new AvdMgrException();
            wrapper.initCause(exception);
            throw wrapper;
        }
        if (this.mFop.getClass().getSimpleName().equals("MockFileOp")) {
            runMkSdcard = false;
        }
        if (runMkSdcard) {
            String path = sdcardFile.toAbsolutePath().toString();
            LoggerProgressIndicatorWrapper progress = new LoggerProgressIndicatorWrapper(log);
            LocalPackage p = this.mSdkHandler.getLocalPackage("emulator", (ProgressIndicator)progress);
            if (p == null) {
                progress.logWarning(String.format("Unable to find %1$s in the %2$s component", SdkConstants.mkSdCardCmdName(), "emulator"));
                throw new AvdMgrException();
            }
            Path mkSdCard = p.getLocation().resolve(SdkConstants.mkSdCardCmdName());
            if (!CancellableFileIo.isRegularFile((Path)mkSdCard, (LinkOption[])new LinkOption[0])) {
                log.warning("'%1$s' is missing from the SDK tools folder.", new Object[]{mkSdCard.getFileName()});
                throw new AvdMgrException();
            }
            if (!this.createSdCard(mkSdCard.toAbsolutePath().toString(), sdcard, path, log)) {
                log.warning("Failed to create sdcard in the AVD folder.", new Object[0]);
                throw new AvdMgrException();
            }
        }
        values.put(AVD_INI_SDCARD_SIZE, sdcard);
    }

    private void addHardwareConfig(ISystemImage systemImage, Path skinFolder, Path avdFolder, Map<String, String> hardwareConfig, Map<String, String> values, ILogger log) throws IOException {
        Map<String, String> skinHardwareConfig;
        PathFileWrapper skinHardwareFile;
        Map<String, String> imageHardwardConfig;
        HashMap<String, String> finalHardwareValues = new HashMap<String, String>();
        PathFileWrapper sysImgHardwareFile = new PathFileWrapper(systemImage.getLocation().resolve(HARDWARE_INI));
        if (sysImgHardwareFile.exists() && (imageHardwardConfig = ProjectProperties.parsePropertyFile(sysImgHardwareFile, log)) != null) {
            finalHardwareValues.putAll(imageHardwardConfig);
        }
        if (skinFolder != null && (skinHardwareFile = new PathFileWrapper(skinFolder.resolve(HARDWARE_INI))).exists() && (skinHardwareConfig = ProjectProperties.parsePropertyFile(skinHardwareFile, log)) != null) {
            finalHardwareValues.putAll(skinHardwareConfig);
        }
        if (hardwareConfig != null) {
            finalHardwareValues.putAll(hardwareConfig);
        }
        if (values == null) {
            values = new HashMap<String, String>();
        }
        values.putAll(finalHardwareValues);
        Path configIniFile = avdFolder.resolve(CONFIG_INI);
        this.writeIniFile(configIniFile, values, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AvdInfo createAvdInfoObject(ISystemImage systemImage, String avdName, boolean removePrevious, boolean editExisting, Path iniFile, Path avdFolder, AvdInfo oldAvdInfo, Map<String, String> values) throws AvdMgrException {
        AvdInfo theAvdInfo = new AvdInfo(avdName, this.mFop.toFile(iniFile), avdFolder.toAbsolutePath().toString(), systemImage, values);
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (oldAvdInfo != null && (removePrevious || editExisting)) {
                this.mAllAvdList.remove(oldAvdInfo);
            }
            this.mAllAvdList.add(theAvdInfo);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
        return theAvdInfo;
    }

    private static void inhibitCopyOnWrite(Path avdFolder, ILogger log) {
        if (SdkConstants.CURRENT_PLATFORM != 1) {
            return;
        }
        try {
            String[] chattrCommand = new String[]{"chattr", "+C", avdFolder.toAbsolutePath().toString()};
            Process chattrProcess = Runtime.getRuntime().exec(chattrCommand);
            final ArrayList errorOutput = new ArrayList();
            GrabProcessOutput.grabProcessOutput((Process)chattrProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(){

                public void out(String line) {
                }

                public void err(String line) {
                    if (line != null && !line.startsWith("chattr: Operation not supported")) {
                        errorOutput.add(line);
                    }
                }
            });
            if (!errorOutput.isEmpty()) {
                log.warning("Failed 'chattr' for %1$s:", new Object[]{avdFolder.toAbsolutePath().toString()});
                for (String error : errorOutput) {
                    log.warning(" -- %1$s", new Object[]{error});
                }
            }
        }
        catch (IOException | InterruptedException ee) {
            log.warning("Failed 'chattr' for %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath().toString(), ee});
        }
    }

    protected static final class AvdManagerCacheKey {
        private final Path mSdkLocation;
        private final Path mAvdHomeFolder;

        protected AvdManagerCacheKey(Path sdkLocation, Path avdHomeFolder) {
            this.mSdkLocation = sdkLocation;
            this.mAvdHomeFolder = avdHomeFolder;
        }

        public int hashCode() {
            return Objects.hash(this.mSdkLocation, this.mAvdHomeFolder);
        }

        public boolean equals(Object other) {
            if (!(other instanceof AvdManagerCacheKey)) {
                return false;
            }
            AvdManagerCacheKey otherKey = (AvdManagerCacheKey)other;
            return this.mSdkLocation.equals(otherKey.mSdkLocation) && this.mAvdHomeFolder.equals(otherKey.mAvdHomeFolder);
        }
    }

    private class AvdMgrException
    extends Exception {
        private AvdMgrException() {
        }
    }

    private static final class InvalidTargetPathException
    extends Exception {
        private static final long serialVersionUID = 1L;

        InvalidTargetPathException(String message) {
            super(message);
        }
    }
}

