/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy.remote;

import com.android.SdkConstants;
import com.android.repository.Revision;
import com.android.repository.api.License;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.CommonFactory;
import com.android.sdklib.repository.legacy.descriptors.IPkgDesc;
import com.android.sdklib.repository.legacy.remote.internal.archives.Archive;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemotePackageParserUtils;
import com.android.sdklib.repository.legacy.remote.internal.sources.SdkSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.w3c.dom.Node;

@Deprecated
public abstract class RemotePkgInfo
implements Comparable<RemotePkgInfo> {
    protected IPkgDesc mPkgDesc;
    protected final String mObsolete;
    protected final License mLicense;
    protected final String mListDisplay;
    protected final String mDescription;
    protected final String mDescUrl;
    protected Revision mRevision;
    protected final Archive[] mArchives;
    protected final SdkSource mSource;
    private static final boolean sUsingUnixPerm = SdkConstants.CURRENT_PLATFORM == 3 || SdkConstants.CURRENT_PLATFORM == 1;

    public RemotePkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        this.mSource = source;
        this.mListDisplay = RemotePackageParserUtils.getXmlString(packageNode, "list-display");
        this.mDescription = RemotePackageParserUtils.getXmlString(packageNode, "description");
        this.mDescUrl = RemotePackageParserUtils.getXmlString(packageNode, "desc-url");
        this.mObsolete = RemotePackageParserUtils.getOptionalXmlString(packageNode, "obsolete");
        this.mLicense = this.parseLicense(packageNode, licenses);
        this.mArchives = this.parseArchives(RemotePackageParserUtils.findChildElement(packageNode, "archives"));
        this.mRevision = RemotePackageParserUtils.parseRevisionElement(RemotePackageParserUtils.findChildElement(packageNode, "revision"));
    }

    public IPkgDesc getPkgDesc() {
        return this.mPkgDesc;
    }

    @Override
    public int compareTo(RemotePkgInfo o) {
        return this.mPkgDesc.compareTo(o.mPkgDesc);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mPkgDesc == null ? 0 : this.mPkgDesc.hashCode());
        return result;
    }

    private License parseLicense(Node packageNode, Map<String, String> licenses) {
        Node ref;
        Node usesLicense = RemotePackageParserUtils.findChildElement(packageNode, "uses-license");
        if (usesLicense != null && (ref = usesLicense.getAttributes().getNamedItem("ref")) != null) {
            String licenseRef = ref.getNodeValue();
            CommonFactory f = (CommonFactory)RepoManager.getCommonModule().createLatestFactory();
            License l = f.createLicenseType();
            l.setId(licenseRef);
            l.setValue(licenses.get(licenseRef));
            return l;
        }
        return null;
    }

    private Archive[] parseArchives(Node archivesNode) {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        if (archivesNode != null) {
            String nsUri = archivesNode.getNamespaceURI();
            for (Node child = archivesNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !"archive".equals(child.getLocalName())) continue;
                archives.add(this.parseArchive(child));
            }
        }
        return archives.toArray(new Archive[archives.size()]);
    }

    private Archive parseArchive(Node archiveNode) {
        Archive a = new Archive(this, RemotePackageParserUtils.parseArchFilter(archiveNode), RemotePackageParserUtils.getXmlString(archiveNode, "url"), RemotePackageParserUtils.getXmlLong(archiveNode, "size", 0L), RemotePackageParserUtils.getXmlString(archiveNode, "checksum"));
        return a;
    }

    public boolean isObsolete() {
        return this.mObsolete != null;
    }

    public Revision getRevision() {
        return this.mRevision;
    }

    public License getLicense() {
        return this.mLicense;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getListDisplay() {
        return this.mListDisplay;
    }

    public String getDescUrl() {
        return this.mDescUrl;
    }

    public Archive[] getArchives() {
        return this.mArchives;
    }

    public String toString() {
        String s = this.getShortDescription();
        if (s != null) {
            return s;
        }
        return super.toString();
    }

    public final String getShortDescription() {
        return this.getPkgDesc().getDescriptionShort();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemotePkgInfo)) {
            return false;
        }
        RemotePkgInfo other = (RemotePkgInfo)obj;
        if (!Arrays.equals(this.mArchives, other.mArchives)) {
            return false;
        }
        if (this.mSource == null ? other.mSource != null : !this.mSource.equals(other.mSource)) {
            return false;
        }
        return this.getPkgDesc().equals(other.getPkgDesc());
    }
}

