/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.prefs.AndroidLocation;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.Navigation;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceParser;
import com.android.sdklib.devices.DeviceWriter;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.PowerType;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.State;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.xml.sax.SAXException;

public class DeviceManager {
    private static final String DEVICE_PROFILES_PROP = "DeviceProfiles";
    private static final Pattern PATH_PROPERTY_PATTERN = Pattern.compile("^Extra.Path=DeviceProfiles$");
    private ILogger mLog;
    private Table<String, String, Device> mVendorDevices;
    private Table<String, String, Device> mSysImgDevices;
    private Table<String, String, Device> mUserDevices;
    private Table<String, String, Device> mDefaultDevices;
    private final Object mLock = new Object();
    private final List<DevicesChangedListener> sListeners = new ArrayList<DevicesChangedListener>();
    private final String mOsSdkPath;
    public static final EnumSet<DeviceFilter> ALL_DEVICES = EnumSet.allOf(DeviceFilter.class);

    public static DeviceManager createInstance(File sdkLocation, ILogger log) {
        return new DeviceManager(sdkLocation == null ? null : sdkLocation.getPath(), log);
    }

    private DeviceManager(String osSdkPath, ILogger log) {
        this.mOsSdkPath = osSdkPath;
        this.mLog = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(DevicesChangedListener listener) {
        List<DevicesChangedListener> list = this.sListeners;
        synchronized (list) {
            if (!this.sListeners.contains(listener)) {
                this.sListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterListener(DevicesChangedListener listener) {
        List<DevicesChangedListener> list = this.sListeners;
        synchronized (list) {
            return this.sListeners.remove(listener);
        }
    }

    public DeviceStatus getDeviceStatus(String name, String manufacturer) {
        Device d = this.getDevice(name, manufacturer);
        if (d == null) {
            return DeviceStatus.MISSING;
        }
        return DeviceStatus.EXISTS;
    }

    public Device getDevice(String id, String manufacturer) {
        this.initDevicesLists();
        Device d = (Device)this.mUserDevices.get((Object)id, (Object)manufacturer);
        if (d != null) {
            return d;
        }
        d = (Device)this.mSysImgDevices.get((Object)id, (Object)manufacturer);
        if (d != null) {
            return d;
        }
        d = (Device)this.mDefaultDevices.get((Object)id, (Object)manufacturer);
        if (d != null) {
            return d;
        }
        d = (Device)this.mVendorDevices.get((Object)id, (Object)manufacturer);
        return d;
    }

    private Device getDeviceImpl(Iterable<Device> devicesList, String id, String manufacturer) {
        for (Device d : devicesList) {
            if (!d.getId().equals(id) || !d.getManufacturer().equals(manufacturer)) continue;
            return d;
        }
        return null;
    }

    public Collection<Device> getDevices(DeviceFilter deviceFilter) {
        return this.getDevices(EnumSet.of(deviceFilter));
    }

    public Collection<Device> getDevices(EnumSet<DeviceFilter> deviceFilter) {
        this.initDevicesLists();
        HashBasedTable devices = HashBasedTable.create();
        if (this.mUserDevices != null && deviceFilter.contains((Object)DeviceFilter.USER)) {
            devices.putAll(this.mUserDevices);
        }
        if (this.mDefaultDevices != null && deviceFilter.contains((Object)DeviceFilter.DEFAULT)) {
            devices.putAll(this.mDefaultDevices);
        }
        if (this.mVendorDevices != null && deviceFilter.contains((Object)DeviceFilter.VENDOR)) {
            devices.putAll(this.mVendorDevices);
        }
        if (this.mSysImgDevices != null && deviceFilter.contains((Object)DeviceFilter.SYSTEM_IMAGES)) {
            devices.putAll(this.mSysImgDevices);
        }
        return Collections.unmodifiableCollection(devices.values());
    }

    private void initDevicesLists() {
        boolean changed = this.initDefaultDevices();
        changed |= this.initVendorDevices();
        changed |= this.initSysImgDevices();
        if (changed |= this.initUserDevices()) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initDefaultDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDefaultDevices != null) {
                return false;
            }
            InputStream stream = DeviceManager.class.getResourceAsStream("devices.xml");
            try {
                assert (stream != null) : "devices.xml not bundled in sdklib.";
                this.mDefaultDevices = DeviceParser.parse(stream);
                boolean bl = true;
                return bl;
            }
            catch (IllegalStateException e) {
                this.mLog.error((Throwable)e, null, new Object[0]);
                this.mDefaultDevices = HashBasedTable.create();
            }
            catch (Exception e) {
                this.mLog.error((Throwable)e, "Error reading default devices", new Object[0]);
                this.mDefaultDevices = HashBasedTable.create();
            }
            finally {
                Closeables.closeQuietly((InputStream)stream);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initVendorDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVendorDevices != null) {
                return false;
            }
            this.mVendorDevices = HashBasedTable.create();
            InputStream stream = DeviceManager.class.getResourceAsStream("nexus.xml");
            try {
                this.mVendorDevices.putAll(DeviceParser.parse(stream));
            }
            catch (Exception e) {
                this.mLog.error((Throwable)e, "Could not load nexus devices", new Object[0]);
            }
            finally {
                Closeables.closeQuietly((InputStream)stream);
            }
            stream = DeviceManager.class.getResourceAsStream("wear.xml");
            try {
                this.mVendorDevices.putAll(DeviceParser.parse(stream));
            }
            catch (Exception e) {
                this.mLog.error((Throwable)e, "Could not load wear devices", new Object[0]);
            }
            finally {
                Closeables.closeQuietly((InputStream)stream);
            }
            stream = DeviceManager.class.getResourceAsStream("tv.xml");
            try {
                this.mVendorDevices.putAll(DeviceParser.parse(stream));
            }
            catch (Exception e) {
                this.mLog.error((Throwable)e, "Could not load tv devices", new Object[0]);
            }
            finally {
                Closeables.closeQuietly((InputStream)stream);
            }
            if (this.mOsSdkPath != null) {
                File extrasFolder = new File(this.mOsSdkPath, "extras");
                List<File> deviceDirs = this.getExtraDirs(extrasFolder);
                for (File deviceDir : deviceDirs) {
                    File deviceXml = new File(deviceDir, "devices.xml");
                    if (!deviceXml.isFile()) continue;
                    this.mVendorDevices.putAll(this.loadDevices(deviceXml));
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initSysImgDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSysImgDevices != null) {
                return false;
            }
            this.mSysImgDevices = HashBasedTable.create();
            if (this.mOsSdkPath == null) {
                return false;
            }
            FileOp fop = FileOpUtils.create();
            File sysImgFolder = new File(this.mOsSdkPath, "system-images");
            for (File platformFolder : fop.listFiles(sysImgFolder)) {
                if (!fop.isDirectory(platformFolder)) continue;
                for (File tagFolder : fop.listFiles(platformFolder)) {
                    if (!fop.isDirectory(tagFolder)) continue;
                    for (File abiFolder : fop.listFiles(tagFolder)) {
                        File deviceXml;
                        if (!fop.isDirectory(abiFolder) || !fop.isFile(deviceXml = new File(abiFolder, "devices.xml"))) continue;
                        this.mSysImgDevices.putAll(this.loadDevices(deviceXml));
                    }
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initUserDevices() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices != null) {
                return false;
            }
            this.mUserDevices = HashBasedTable.create();
            File userDevicesFile = null;
            try {
                userDevicesFile = new File(AndroidLocation.getFolder(), "devices.xml");
                if (userDevicesFile.exists()) {
                    this.mUserDevices.putAll(DeviceParser.parse(userDevicesFile));
                    return true;
                }
            }
            catch (AndroidLocation.AndroidLocationException e) {
                this.mLog.warning("Couldn't load user devices: %1$s", new Object[]{e.getMessage()});
            }
            catch (SAXException e) {
                if (userDevicesFile != null) {
                    String base = userDevicesFile.getAbsoluteFile() + ".old";
                    File renamedConfig = new File(base);
                    int i = 0;
                    while (renamedConfig.exists()) {
                        renamedConfig = new File(base + '.' + i++);
                    }
                    this.mLog.error((Throwable)e, "Error parsing %1$s, backing up to %2$s", new Object[]{userDevicesFile.getAbsolutePath(), renamedConfig.getAbsolutePath()});
                    userDevicesFile.renameTo(renamedConfig);
                }
            }
            catch (ParserConfigurationException e) {
                this.mLog.error((Throwable)e, "Error parsing %1$s", new Object[]{userDevicesFile == null ? "(null)" : userDevicesFile.getAbsolutePath()});
            }
            catch (IOException e) {
                this.mLog.error((Throwable)e, "Error parsing %1$s", new Object[]{userDevicesFile == null ? "(null)" : userDevicesFile.getAbsolutePath()});
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserDevice(Device d) {
        boolean changed = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
                assert (this.mUserDevices != null);
            }
            if (this.mUserDevices != null) {
                this.mUserDevices.put((Object)d.getId(), (Object)d.getManufacturer(), (Object)d);
            }
            changed = true;
        }
        if (changed) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserDevice(Device d) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
                assert (this.mUserDevices != null);
            }
            if (this.mUserDevices != null && this.mUserDevices.contains((Object)d.getId(), (Object)d.getManufacturer())) {
                this.mUserDevices.remove((Object)d.getId(), (Object)d.getManufacturer());
                this.notifyListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceUserDevice(Device d) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserDevices == null) {
                this.initUserDevices();
            }
            this.removeUserDevice(d);
            this.addUserDevice(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserDevices() {
        if (this.mUserDevices == null) {
            return;
        }
        File userDevicesFile = null;
        try {
            userDevicesFile = new File(AndroidLocation.getFolder(), "devices.xml");
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.mLog.warning("Couldn't find user directory: %1$s", new Object[]{e.getMessage()});
            return;
        }
        if (this.mUserDevices.isEmpty()) {
            userDevicesFile.delete();
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mUserDevices.isEmpty()) {
                try {
                    DeviceWriter.writeToXml(new FileOutputStream(userDevicesFile), this.mUserDevices.values());
                }
                catch (FileNotFoundException e) {
                    this.mLog.warning("Couldn't open file: %1$s", new Object[]{e.getMessage()});
                }
                catch (ParserConfigurationException e) {
                    this.mLog.warning("Error writing file: %1$s", new Object[]{e.getMessage()});
                }
                catch (TransformerFactoryConfigurationError e) {
                    this.mLog.warning("Error writing file: %1$s", new Object[]{e.getMessage()});
                }
                catch (TransformerException e) {
                    this.mLog.warning("Error writing file: %1$s", new Object[]{e.getMessage()});
                }
            }
        }
    }

    public static Map<String, String> getHardwareProperties(State s) {
        Hardware hw = s.getHardware();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hw.mainKeys", DeviceManager.getBooleanVal(hw.getButtonType().equals((Object)ButtonType.HARD)));
        props.put("hw.trackBall", DeviceManager.getBooleanVal(hw.getNav().equals((Object)Navigation.TRACKBALL)));
        props.put("hw.keyboard", DeviceManager.getBooleanVal(hw.getKeyboard().equals((Object)Keyboard.QWERTY)));
        props.put("hw.dPad", DeviceManager.getBooleanVal(hw.getNav().equals((Object)Navigation.DPAD)));
        Set<Sensor> sensors = hw.getSensors();
        props.put("hw.gps", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.GPS)));
        props.put("hw.battery", DeviceManager.getBooleanVal(hw.getChargeType().equals((Object)PowerType.BATTERY)));
        props.put("hw.accelerometer", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.ACCELEROMETER)));
        props.put("hw.sensors.orientation", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.GYROSCOPE)));
        props.put("hw.audioInput", DeviceManager.getBooleanVal(hw.hasMic()));
        props.put("hw.sdCard", DeviceManager.getBooleanVal(!hw.getRemovableStorage().isEmpty()));
        props.put("hw.lcd.density", Integer.toString(hw.getScreen().getPixelDensity().getDpiValue()));
        props.put("hw.sensors.proximity", DeviceManager.getBooleanVal(sensors.contains((Object)Sensor.PROXIMITY_SENSOR)));
        return props;
    }

    public static Map<String, String> getHardwareProperties(Device d) {
        Map<String, String> props = DeviceManager.getHardwareProperties(d.getDefaultState());
        for (State s : d.getAllStates()) {
            if (!s.getKeyState().equals((Object)KeyboardState.HIDDEN)) continue;
            props.put("hw.keyboard.lid", DeviceManager.getBooleanVal(true));
        }
        HashFunction md5 = Hashing.md5();
        Hasher hasher = md5.newHasher();
        ArrayList<String> keys = new ArrayList<String>(props.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            if (key == null) continue;
            hasher.putString((CharSequence)key, Charsets.UTF_8);
            String value = props.get(key);
            hasher.putString((CharSequence)(value == null ? "null" : value), Charsets.UTF_8);
        }
        String hash = "MD5:" + hasher.hash().toString();
        props.put("hw.device.hash2", hash);
        props.remove("hw.device.hash");
        props.put("hw.device.name", d.getId());
        props.put("hw.device.manufacturer", d.getManufacturer());
        return props;
    }

    public static String hasHardwarePropHashChanged(Device d, String hashV2) {
        Map<String, String> props = DeviceManager.getHardwareProperties(d);
        String newHash = props.get("hw.device.hash2");
        if (newHash != null && newHash.equals(hashV2)) {
            return null;
        }
        return newHash;
    }

    private static String getBooleanVal(boolean bool) {
        if (bool) {
            return "yes";
        }
        return "no";
    }

    private Table<String, String, Device> loadDevices(File deviceXml) {
        try {
            return DeviceParser.parse(deviceXml);
        }
        catch (SAXException e) {
            this.mLog.error((Throwable)e, "Error parsing %1$s", new Object[]{deviceXml.getAbsolutePath()});
        }
        catch (ParserConfigurationException e) {
            this.mLog.error((Throwable)e, "Error parsing %1$s", new Object[]{deviceXml.getAbsolutePath()});
        }
        catch (IOException e) {
            this.mLog.error((Throwable)e, "Error reading %1$s", new Object[]{deviceXml.getAbsolutePath()});
        }
        catch (AssertionError e) {
            this.mLog.error((Throwable)((Object)e), "Error parsing %1$s", new Object[]{deviceXml.getAbsolutePath()});
        }
        catch (IllegalStateException e) {
            this.mLog.error((Throwable)e, null, new Object[0]);
        }
        return HashBasedTable.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        List<DevicesChangedListener> list = this.sListeners;
        synchronized (list) {
            for (DevicesChangedListener listener : this.sListeners) {
                listener.onDevicesChanged();
            }
        }
    }

    private List<File> getExtraDirs(File extrasFolder) {
        ArrayList<File> extraDirs = new ArrayList<File>();
        if (extrasFolder != null && extrasFolder.isDirectory()) {
            for (File vendor : extrasFolder.listFiles()) {
                if (!vendor.isDirectory()) continue;
                for (File item : vendor.listFiles()) {
                    if (!item.isDirectory() || !this.isDevicesExtra(item)) continue;
                    extraDirs.add(item);
                }
            }
        }
        return extraDirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDevicesExtra(File item) {
        File properties = new File(item, "source.properties");
        try (BufferedReader propertiesReader = new BufferedReader(new FileReader(properties));){
            String line;
            Matcher m;
            do {
                if ((line = propertiesReader.readLine()) == null) return false;
            } while (!(m = PATH_PROPERTY_PATTERN.matcher(line)).matches());
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static interface DevicesChangedListener {
        public void onDevicesChanged();
    }

    public static enum DeviceStatus {
        EXISTS,
        CHANGED,
        MISSING;

    }

    public static enum DeviceFilter {
        DEFAULT,
        USER,
        VENDOR,
        SYSTEM_IMAGES;

    }
}

