/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.descriptors;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IAddonDesc;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;

final class PkgDescAddon
extends PkgDesc {
    public static final String ADDON_NAME = "name";
    public static final String ADDON_VENDOR = "vendor";
    public static final String ADDON_API = "api";
    public static final String ADDON_DESCRIPTION = "description";
    public static final String ADDON_LIBRARIES = "libraries";
    public static final String ADDON_DEFAULT_SKIN = "skin";
    public static final String ADDON_USB_VENDOR = "usb-vendor";
    public static final String ADDON_REVISION = "revision";
    public static final String ADDON_REVISION_OLD = "version";
    @NonNull
    private final AndroidVersion mVersion;
    @NonNull
    private final MajorRevision mRevision;
    @Nullable
    private final String mAddonPath;
    @Nullable
    private final String mAddonVendor;
    @Nullable
    private final IAddonDesc mTargetHashProvider;

    PkgDescAddon(@NonNull AndroidVersion version, @NonNull MajorRevision revision, @NonNull IAddonDesc targetHashProvider) {
        this.mVersion = version;
        this.mRevision = revision;
        this.mTargetHashProvider = targetHashProvider;
        this.mAddonPath = null;
        this.mAddonVendor = null;
    }

    PkgDescAddon(@NonNull AndroidVersion version, @NonNull MajorRevision revision, @NonNull String addonVendor, @NonNull String addonName) {
        this.mVersion = version;
        this.mRevision = revision;
        this.mAddonVendor = addonVendor;
        this.mTargetHashProvider = null;
        this.mAddonPath = AndroidTargetHash.getAddonHashString(addonVendor, addonName, version);
    }

    @Override
    @NonNull
    public PkgType getType() {
        return PkgType.PKG_ADDONS;
    }

    @Override
    @NonNull
    public AndroidVersion getAndroidVersion() {
        return this.mVersion;
    }

    @Override
    public MajorRevision getMajorRevision() {
        return this.mRevision;
    }

    @Override
    public String getVendorId() {
        if (this.mTargetHashProvider != null) {
            return this.mTargetHashProvider.getVendorId();
        }
        return this.mAddonVendor;
    }

    @Override
    @NonNull
    public String getPath() {
        if (this.mTargetHashProvider != null) {
            return this.mTargetHashProvider.getTargetHash();
        }
        return this.mAddonPath;
    }

    @Override
    public FullRevision getMinToolsRev() {
        return null;
    }

    @Override
    public boolean isUpdateFor(IPkgDesc existingDesc) {
        return this.isGenericUpdateFor(existingDesc);
    }
}

