/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.androidTarget.PlatformTarget;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.AddonPackage;
import com.android.sdklib.internal.repository.packages.BuildToolPackage;
import com.android.sdklib.internal.repository.packages.DocPackage;
import com.android.sdklib.internal.repository.packages.ExtraPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PlatformPackage;
import com.android.sdklib.internal.repository.packages.PlatformToolPackage;
import com.android.sdklib.internal.repository.packages.SamplePackage;
import com.android.sdklib.internal.repository.packages.SourcePackage;
import com.android.sdklib.internal.repository.packages.SystemImagePackage;
import com.android.sdklib.internal.repository.packages.ToolPackage;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class LocalSdkParser {
    private Package[] mPackages;
    public static final int PARSE_ALL = 65535;
    public static final int PARSE_TOOLS = PkgType.PKG_TOOLS.getIntValue();
    public static final int PARSE_PLATFORM_TOOLS = PkgType.PKG_PLATFORM_TOOLS.getIntValue();
    public static final int PARSE_DOCS = PkgType.PKG_DOCS.getIntValue();
    public static final int PARSE_PLATFORMS = PkgType.PKG_PLATFORMS.getIntValue();
    public static final int PARSE_ADDONS = PkgType.PKG_ADDONS.getIntValue();
    public static final int PARSE_SAMPLES = PkgType.PKG_SAMPLES.getIntValue();
    public static final int PARSE_SOURCES = PkgType.PKG_SOURCES.getIntValue();
    public static final int PARSE_EXTRAS = PkgType.PKG_EXTRAS.getIntValue();
    public static final int PARSE_BUILD_TOOLS = PkgType.PKG_BUILD_TOOLS.getIntValue();

    public Package[] getPackages() {
        return this.mPackages;
    }

    public void clearPackages() {
        this.mPackages = null;
    }

    @NonNull
    public Package[] parseSdk(@NonNull String osSdkRoot, @NonNull SdkManager sdkManager, @NonNull ITaskMonitor monitor) {
        return this.parseSdk(osSdkRoot, sdkManager, 65535, monitor);
    }

    @NonNull
    public Package[] parseSdk(@NonNull String osSdkRoot, @NonNull SdkManager sdkManager, int parseFilter, @NonNull ITaskMonitor monitor) {
        ArrayList<Package> packages = new ArrayList<Package>();
        HashSet<File> visited = new HashSet<File>();
        monitor.setProgressMax(11);
        File dir = null;
        Package pkg = null;
        if ((parseFilter & PARSE_DOCS) != 0 && (pkg = this.scanDoc(dir = new File(osSdkRoot, "docs"), monitor)) != null) {
            packages.add(pkg);
            visited.add(dir);
        }
        monitor.incProgress(1);
        if ((parseFilter & PARSE_TOOLS) != 0 && (pkg = this.scanTools(dir = new File(osSdkRoot, "tools"), monitor)) != null) {
            packages.add(pkg);
            visited.add(dir);
        }
        monitor.incProgress(1);
        if ((parseFilter & PARSE_PLATFORM_TOOLS) != 0 && (pkg = this.scanPlatformTools(dir = new File(osSdkRoot, "platform-tools"), monitor)) != null) {
            packages.add(pkg);
            visited.add(dir);
        }
        monitor.incProgress(1);
        if ((parseFilter & PARSE_BUILD_TOOLS) != 0) {
            this.scanBuildTools(sdkManager, visited, packages, monitor);
        }
        monitor.incProgress(1);
        if ((parseFilter & (PARSE_ADDONS | PARSE_PLATFORMS)) != 0) {
            File samplesRoot = new File(osSdkRoot, "samples");
            for (IAndroidTarget target : sdkManager.getTargets()) {
                Properties props = this.parseProperties(new File(target.getLocation(), "source.properties"));
                try {
                    pkg = null;
                    if (target.isPlatform() && (parseFilter & PARSE_PLATFORMS) != 0) {
                        File samplesDir;
                        pkg = PlatformPackage.create(target, props);
                        if (samplesRoot.isDirectory() && (samplesDir = new File(target.getPath(4))).exists() && samplesDir.getParentFile().equals(samplesRoot)) {
                            Properties samplesProps = this.parseProperties(new File(samplesDir, "source.properties"));
                            if (samplesProps != null) {
                                Package pkg2 = SamplePackage.create(target, samplesProps);
                                packages.add(pkg2);
                            }
                            visited.add(samplesDir);
                        }
                    } else if ((parseFilter & PARSE_ADDONS) != 0) {
                        pkg = AddonPackage.create(target, props);
                    }
                    if (pkg != null) {
                        for (ISystemImage systemImage : target.getSystemImages()) {
                            File siDir;
                            if (systemImage.getLocationType() != ISystemImage.LocationType.IN_SYSTEM_IMAGE || !(siDir = systemImage.getLocation()).isDirectory()) continue;
                            Properties siProps = this.parseProperties(new File(siDir, "source.properties"));
                            SystemImagePackage pkg2 = new SystemImagePackage(target.getVersion(), 0, systemImage.getAbiType(), siProps, siDir.getAbsolutePath());
                            packages.add(pkg2);
                            visited.add(siDir);
                        }
                    }
                }
                catch (Exception e) {
                    monitor.error(e, null, new Object[0]);
                }
                if (pkg == null) continue;
                packages.add(pkg);
                visited.add(new File(target.getLocation()));
            }
        }
        monitor.incProgress(1);
        if ((parseFilter & PARSE_PLATFORMS) != 0) {
            this.scanMissingSystemImages(sdkManager, visited, packages, monitor);
        }
        monitor.incProgress(1);
        if ((parseFilter & PARSE_ADDONS) != 0) {
            this.scanMissingAddons(sdkManager, visited, packages, monitor);
        }
        monitor.incProgress(1);
        if ((parseFilter & PARSE_SAMPLES) != 0) {
            this.scanMissingSamples(sdkManager, visited, packages, monitor);
        }
        monitor.incProgress(1);
        if ((parseFilter & PARSE_EXTRAS) != 0) {
            this.scanExtras(sdkManager, visited, packages, monitor);
        }
        monitor.incProgress(1);
        if ((parseFilter & PARSE_EXTRAS) != 0) {
            this.scanExtrasDirectory(osSdkRoot, visited, packages, monitor);
        }
        monitor.incProgress(1);
        if ((parseFilter & PARSE_SOURCES) != 0) {
            this.scanSources(sdkManager, visited, packages, monitor);
        }
        monitor.incProgress(1);
        Collections.sort(packages);
        this.mPackages = packages.toArray(new Package[packages.size()]);
        return this.mPackages;
    }

    private void scanExtras(SdkManager sdkManager, HashSet<File> visited, ArrayList<Package> packages, ILogger log) {
        File root = new File(sdkManager.getLocation(), "extras");
        if (!root.isDirectory()) {
            return;
        }
        for (File vendor : root.listFiles()) {
            if (!vendor.isDirectory()) continue;
            this.scanExtrasDirectory(vendor.getAbsolutePath(), visited, packages, log);
        }
    }

    private void scanExtrasDirectory(String extrasRoot, HashSet<File> visited, ArrayList<Package> packages, ILogger log) {
        File root = new File(extrasRoot);
        if (!root.isDirectory()) {
            return;
        }
        for (File dir : root.listFiles()) {
            Properties props;
            if (!dir.isDirectory() || visited.contains(dir) || (props = this.parseProperties(new File(dir, "source.properties"))) == null) continue;
            try {
                Package pkg = ExtraPackage.create(null, props, null, dir.getName(), 0, null, null, null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), dir.getPath());
                packages.add(pkg);
                visited.add(dir);
            }
            catch (Exception e) {
                log.error((Throwable)e, null, new Object[0]);
            }
        }
    }

    private void scanMissingSamples(SdkManager sdkManager, HashSet<File> visited, ArrayList<Package> packages, ILogger log) {
        File root = new File(sdkManager.getLocation());
        if (!(root = new File(root, "samples")).isDirectory()) {
            return;
        }
        for (File dir : root.listFiles()) {
            Properties props;
            if (!dir.isDirectory() || visited.contains(dir) || (props = this.parseProperties(new File(dir, "source.properties"))) == null) continue;
            try {
                Package pkg = SamplePackage.create(dir.getAbsolutePath(), props);
                packages.add(pkg);
                visited.add(dir);
            }
            catch (Exception e) {
                log.error((Throwable)e, null, new Object[0]);
            }
        }
    }

    private void scanMissingAddons(SdkManager sdkManager, HashSet<File> visited, ArrayList<Package> packages, ILogger log) {
        File addons = new File(new File(sdkManager.getLocation()), "add-ons");
        File[] files = addons.listFiles();
        if (files == null) {
            return;
        }
        for (File dir : files) {
            if (!dir.isDirectory() || visited.contains(dir)) continue;
            Pair<Map<String, String>, String> infos = LocalSdkParser.parseAddonProperties(dir, sdkManager.getTargets(), log);
            Properties sourceProps = this.parseProperties(new File(dir, "source.properties"));
            Map addonProps = (Map)infos.getFirst();
            String error = (String)infos.getSecond();
            try {
                Package pkg = AddonPackage.createBroken(dir.getAbsolutePath(), sourceProps, addonProps, error);
                packages.add(pkg);
                visited.add(dir);
            }
            catch (Exception e) {
                log.error((Throwable)e, null, new Object[0]);
            }
        }
    }

    @Deprecated
    @NonNull
    public static Pair<Map<String, String>, String> parseAddonProperties(@NonNull File addonDir, @NonNull IAndroidTarget[] targetList, @NonNull ILogger log) {
        String error;
        Map<String, String> propertyMap;
        block5: {
            block10: {
                String api;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                FileWrapper addOnManifest;
                                block4: {
                                    propertyMap = null;
                                    error = null;
                                    addOnManifest = new FileWrapper(addonDir, "manifest.ini");
                                    if (addOnManifest.isFile()) break block4;
                                    error = String.format("File not found: %1$s", "manifest.ini");
                                    break block5;
                                }
                                propertyMap = ProjectProperties.parsePropertyFile((IAbstractFile)addOnManifest, log);
                                if (propertyMap != null) break block6;
                                error = String.format("Failed to parse properties from %1$s", "manifest.ini");
                                break block5;
                            }
                            String name = propertyMap.get("name");
                            if (name != null) break block7;
                            error = String.format("'%1$s' is missing from %2$s.", "name", "manifest.ini");
                            break block5;
                        }
                        String vendor = propertyMap.get("vendor");
                        if (vendor != null) break block8;
                        error = String.format("'%1$s' is missing from %2$s.", "vendor", "manifest.ini");
                        break block5;
                    }
                    api = propertyMap.get("api");
                    if (api != null) break block9;
                    error = String.format("'%1$s' is missing from %2$s.", "api", "manifest.ini");
                    break block5;
                }
                PlatformTarget baseTarget = null;
                for (IAndroidTarget target : targetList) {
                    if (!target.isPlatform() || !target.getVersion().equals(api)) continue;
                    baseTarget = (PlatformTarget)target;
                    break;
                }
                if (baseTarget != null) break block10;
                error = String.format("Unable to find base platform with API level '%1$s'", api);
                break block5;
            }
            String revision = propertyMap.get("revision");
            if (revision == null) {
                revision = propertyMap.get("version");
            }
            if (revision == null) break block5;
            try {
                Integer.parseInt(revision);
            }
            catch (NumberFormatException e) {
                error = String.format("%1$s is not a valid number in %2$s.", "revision", "build.prop");
            }
        }
        return Pair.of(propertyMap, (Object)error);
    }

    private void scanMissingSystemImages(SdkManager sdkManager, HashSet<File> visited, ArrayList<Package> packages, ILogger log) {
        File siRoot = new File(sdkManager.getLocation(), "system-images");
        File[] files = siRoot.listFiles();
        if (files == null) {
            return;
        }
        for (File platformDir : files) {
            if (!platformDir.isDirectory() || visited.contains(platformDir)) continue;
            visited.add(platformDir);
            File[] platformFiles = platformDir.listFiles();
            if (platformFiles == null) continue;
            for (File abiDir : platformFiles) {
                if (!abiDir.isDirectory() || visited.contains(abiDir)) continue;
                visited.add(abiDir);
                File[] abiFiles = abiDir.listFiles();
                if (abiFiles == null || abiFiles.length <= 0) continue;
                Properties props = this.parseProperties(new File(abiDir, "source.properties"));
                try {
                    Package pkg = SystemImagePackage.createBroken(abiDir, props);
                    packages.add(pkg);
                }
                catch (Exception e) {
                    log.error((Throwable)e, null, new Object[0]);
                }
            }
        }
    }

    private void scanSources(SdkManager sdkManager, HashSet<File> visited, ArrayList<Package> packages, ILogger log) {
        File srcRoot = new File(sdkManager.getLocation(), "sources");
        File[] subDirs = srcRoot.listFiles();
        if (subDirs == null) {
            return;
        }
        for (File platformDir : subDirs) {
            if (!platformDir.isDirectory() || visited.contains(platformDir)) continue;
            visited.add(platformDir);
            File[] srcFiles = platformDir.listFiles();
            if (srcFiles == null || srcFiles.length <= 0) continue;
            Properties props = this.parseProperties(new File(platformDir, "source.properties"));
            try {
                Package pkg = SourcePackage.create(platformDir, props);
                packages.add(pkg);
            }
            catch (Exception e) {
                log.error((Throwable)e, null, new Object[0]);
            }
        }
    }

    private Package scanTools(File toolFolder, ILogger log) {
        Properties props = this.parseProperties(new File(toolFolder, "source.properties"));
        boolean hasEmulator = false;
        boolean hasAndroid = false;
        String android1 = SdkConstants.androidCmdName().replace(".bat", ".exe");
        String android2 = android1.indexOf(46) == -1 ? null : android1.replace(".exe", ".bat");
        File[] files = toolFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (SdkConstants.FN_EMULATOR.equals(name)) {
                    hasEmulator = true;
                }
                if (!android1.equals(name) && (android2 == null || !android2.equals(name))) continue;
                hasAndroid = true;
            }
        }
        if (!hasAndroid || !hasEmulator) {
            return null;
        }
        try {
            Package pkg = ToolPackage.create(null, props, 0, null, "Tools", null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), toolFolder.getPath());
            return pkg;
        }
        catch (Exception e) {
            log.error((Throwable)e, null, new Object[0]);
            return null;
        }
    }

    private Package scanPlatformTools(File platformToolsFolder, ILogger log) {
        Properties props = this.parseProperties(new File(platformToolsFolder, "source.properties"));
        if (platformToolsFolder.listFiles() == null) {
            return null;
        }
        try {
            Package pkg = PlatformToolPackage.create(null, props, 0, null, "Platform Tools", null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), platformToolsFolder.getPath());
            return pkg;
        }
        catch (Exception e) {
            log.error((Throwable)e, null, new Object[0]);
            return null;
        }
    }

    private void scanBuildTools(SdkManager sdkManager, HashSet<File> visited, ArrayList<Package> packages, ILogger log) {
        File buildToolRoot = new File(sdkManager.getLocation(), "build-tools");
        File[] subDirs = buildToolRoot.listFiles();
        if (subDirs == null) {
            return;
        }
        for (File buildToolDir : subDirs) {
            if (!buildToolDir.isDirectory() || visited.contains(buildToolDir)) continue;
            visited.add(buildToolDir);
            File[] srcFiles = buildToolDir.listFiles();
            if (srcFiles == null || srcFiles.length <= 0) continue;
            Properties props = this.parseProperties(new File(buildToolDir, "source.properties"));
            try {
                Package pkg = BuildToolPackage.create(buildToolDir, props);
                packages.add(pkg);
            }
            catch (Exception e) {
                log.error((Throwable)e, null, new Object[0]);
            }
        }
    }

    private Package scanDoc(File docFolder, ILogger log) {
        Properties props = this.parseProperties(new File(docFolder, "source.properties"));
        if (new File(docFolder, "index.html").isFile()) {
            try {
                Package pkg = DocPackage.create(null, props, 0, null, 0, null, null, null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), docFolder.getPath());
                return pkg;
            }
            catch (Exception e) {
                log.error((Throwable)e, null, new Object[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties parseProperties(File propsFile) {
        FileInputStream fis = null;
        try {
            if (propsFile.exists()) {
                fis = new FileInputStream(propsFile);
                Properties props = new Properties();
                props.load(fis);
                if (props.size() > 0) {
                    Properties properties = props;
                    return properties;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

