/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.SdkConstants;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.io.FileOp;
import java.io.File;
import java.util.Locale;

public class SystemImage
implements ISystemImage {
    public static final String ANDROID_PREFIX = "android-";
    private final ISystemImage.LocationType mLocationtype;
    private final String mAbiType;
    private final File mLocation;

    public SystemImage(File location, ISystemImage.LocationType locationType, String abiType) {
        this.mLocation = location;
        this.mLocationtype = locationType;
        this.mAbiType = abiType;
    }

    public SystemImage(SdkManager sdkManager, IAndroidTarget target, ISystemImage.LocationType locationType, String abiType) {
        this.mLocationtype = locationType;
        this.mAbiType = abiType;
        File location = null;
        switch (locationType) {
            case IN_PLATFORM_LEGACY: {
                location = new File(target.getLocation(), SdkConstants.OS_IMAGES_FOLDER);
                break;
            }
            case IN_PLATFORM_SUBFOLDER: {
                location = FileOp.append(target.getLocation(), SdkConstants.OS_IMAGES_FOLDER, abiType);
                break;
            }
            case IN_SYSTEM_IMAGE: {
                if (!target.isPlatform()) {
                    throw new IllegalArgumentException("Add-ons do not support the system-image location type");
                }
                location = SystemImage.getCanonicalFolder(sdkManager.getLocation(), target.getVersion(), abiType);
                break;
            }
            default: {
                assert (false) : "SystemImage used with an incorrect locationType";
                break;
            }
        }
        this.mLocation = location;
    }

    public static File getCanonicalFolder(String sdkOsPath, AndroidVersion platformVersion, String abiType) {
        File root = FileOp.append(sdkOsPath, "system-images", ANDROID_PREFIX + platformVersion.getApiString());
        if (abiType == null) {
            return root;
        }
        return FileOp.append(root, abiType);
    }

    @Override
    public File getLocation() {
        return this.mLocation;
    }

    @Override
    public ISystemImage.LocationType getLocationType() {
        return this.mLocationtype;
    }

    @Override
    public String getAbiType() {
        return this.mAbiType;
    }

    @Override
    public int compareTo(ISystemImage other) {
        return this.getAbiType().compareToIgnoreCase(other.getAbiType());
    }

    public String toString() {
        return String.format("SystemImage ABI=%s, location %s='%s'", this.mAbiType, this.mLocationtype.toString().replace('_', ' ').toLowerCase(Locale.US), this.mLocation);
    }
}

