/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.util;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class GrabProcessOutput {
    public static int grabProcessOutput(final @NonNull Process process, Wait waitMode, final @Nullable IProcessOutput output) throws InterruptedException {
        Thread threadErr = new Thread("stderr"){

            @Override
            public void run() {
                InputStreamReader is = new InputStreamReader(process.getErrorStream());
                BufferedReader errReader = new BufferedReader(is);
                try {
                    String line;
                    do {
                        line = errReader.readLine();
                        if (output == null) continue;
                        output.err(line);
                    } while (line != null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Thread threadOut = new Thread("stdout"){

            @Override
            public void run() {
                InputStreamReader is = new InputStreamReader(process.getInputStream());
                BufferedReader outReader = new BufferedReader(is);
                try {
                    String line;
                    do {
                        line = outReader.readLine();
                        if (output == null) continue;
                        output.out(line);
                    } while (line != null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        threadErr.start();
        threadOut.start();
        if (waitMode == Wait.ASYNC) {
            return 0;
        }
        if (waitMode == Wait.WAIT_FOR_READERS) {
            try {
                threadErr.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                threadOut.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return process.waitFor();
    }

    public static interface IProcessOutput {
        public void out(@Nullable String var1);

        public void err(@Nullable String var1);
    }

    public static enum Wait {
        ASYNC,
        WAIT_FOR_PROCESS,
        WAIT_FOR_READERS;

    }
}

