/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class MavenRepositories {
    private static final String MAVEN_METADATA_FILE_NAME = "maven-metadata.xml";

    private MavenRepositories() {
    }

    public static GradleCoordinate getHighestInstalledVersion(String groupId, String artifactId, File repository, String filter, boolean allowPreview, FileOp fileOp) {
        File versionDir = MavenRepositories.getArtifactIdDirectory(repository, groupId, artifactId);
        File[] versions = fileOp.listFiles(versionDir);
        ArrayList versionCoordinates = Lists.newArrayList();
        for (File dir : versions) {
            GradleCoordinate gc;
            if (!fileOp.isDirectory(dir) || filter != null && !dir.getName().startsWith(filter) || (gc = GradleCoordinate.parseCoordinateString(groupId + ":" + artifactId + ":" + dir.getName())) == null || !allowPreview && MavenRepositories.isPreview(gc)) continue;
            versionCoordinates.add(gc);
        }
        if (groupId.equals("com.android.support.constraint") && artifactId.equals("constraint-layout")) {
            versionCoordinates.add(GradleCoordinate.parseCoordinateString(groupId + ':' + artifactId + ':' + "1.0.0-alpha4"));
        }
        if (!versionCoordinates.isEmpty()) {
            return Collections.max(versionCoordinates, GradleCoordinate.COMPARE_PLUS_HIGHER);
        }
        return null;
    }

    public static boolean isPreview(GradleCoordinate coordinate) {
        if (coordinate.isPreview()) {
            return true;
        }
        return "com.google.android.gms".equals(coordinate.getGroupId()) && "play-services".equals(coordinate.getArtifactId()) && "5.2.08".equals(coordinate.getRevision());
    }

    @Deprecated
    public static GradleCoordinate getHighestInstalledVersion(String groupId, String artifactId, File repository, String filter, boolean allowPreview) {
        return MavenRepositories.getHighestInstalledVersion(groupId, artifactId, repository, filter, allowPreview, FileOpUtils.create());
    }

    public static File getArtifactIdDirectory(File repository, String groupId, String artifactId) {
        return new File(repository, groupId.replace('.', File.separatorChar) + File.separator + artifactId);
    }

    public static File getArtifactDirectory(File repository, GradleCoordinate coordinate) {
        Preconditions.checkNotNull((Object)coordinate.getGroupId());
        Preconditions.checkNotNull((Object)coordinate.getArtifactId());
        File artifactIdDirectory = MavenRepositories.getArtifactIdDirectory(repository, coordinate.getGroupId(), coordinate.getArtifactId());
        return new File(artifactIdDirectory, coordinate.getRevision());
    }

    public static File getMavenMetadataFile(File repository, String groupId, String artifactId) {
        return new File(MavenRepositories.getArtifactIdDirectory(repository, groupId, artifactId), MAVEN_METADATA_FILE_NAME);
    }
}

