/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelDependencyGraph;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelLibraryResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\rH\u0016R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/model/DefaultLintModelDependencyGraph;", "Lcom/android/tools/lint/model/LintModelDependencyGraph;", "roots", "", "Lcom/android/tools/lint/model/LintModelDependency;", "libraryResolver", "Lcom/android/tools/lint/model/LintModelLibraryResolver;", "(Ljava/util/List;Lcom/android/tools/lint/model/LintModelLibraryResolver;)V", "allItems", "allLibraries", "Lcom/android/tools/lint/model/LintModelLibrary;", "mavenTransitiveDependencies", "", "", "getRoots", "()Ljava/util/List;", "transitiveDependencies", "findLibrary", "mavenName", "direct", "", "getAllGraphItems", "getAllLibraries", "register", "", "item", "toString", "lint-model"})
public final class DefaultLintModelDependencyGraph
implements LintModelDependencyGraph {
    @NotNull
    private final List<LintModelDependency> roots;
    @NotNull
    private final LintModelLibraryResolver libraryResolver;
    @NotNull
    private final Map<String, LintModelDependency> transitiveDependencies;
    @NotNull
    private final Map<String, LintModelDependency> mavenTransitiveDependencies;
    @Nullable
    private List<? extends LintModelLibrary> allLibraries;
    @Nullable
    private List<? extends LintModelDependency> allItems;

    public DefaultLintModelDependencyGraph(@NotNull List<? extends LintModelDependency> roots2, @NotNull LintModelLibraryResolver libraryResolver) {
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)libraryResolver, (String)"libraryResolver");
        this.roots = roots2;
        this.libraryResolver = libraryResolver;
        boolean bl = false;
        this.transitiveDependencies = new LinkedHashMap();
        bl = false;
        this.mavenTransitiveDependencies = new LinkedHashMap();
        for (LintModelDependency item : this.getRoots()) {
            this.register(item);
        }
    }

    @Override
    @NotNull
    public List<LintModelDependency> getRoots() {
        return this.roots;
    }

    private final void register(LintModelDependency item) {
        if (this.transitiveDependencies.containsKey(item.getArtifactAddress())) {
            return;
        }
        Object object = this.transitiveDependencies;
        String string = item.getArtifactAddress();
        boolean bl = false;
        object.put((String)string, (LintModelDependency)item);
        if (!Intrinsics.areEqual((Object)item.getArtifactName(), (Object)":")) {
            object = this.mavenTransitiveDependencies;
            string = item.getArtifactName();
            bl = false;
            object.put(string, item);
        }
        for (LintModelDependency dependsOn : item.getDependencies()) {
            this.register(dependsOn);
        }
    }

    @Override
    @Nullable
    public LintModelLibrary findLibrary(@NotNull String mavenName, boolean direct) {
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)mavenName, (String)"mavenName");
        if (direct) {
            Object v0;
            block4: {
                Iterable $this$firstOrNull$iv = this.getRoots();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    LintModelDependency it = (LintModelDependency)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getArtifactName(), (Object)mavenName)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            object = v0;
            string = object == null ? null : object.getArtifactAddress();
        } else {
            object = this.mavenTransitiveDependencies.get(mavenName);
            string = object == null ? null : object.getArtifactAddress();
        }
        String artifactAddress = string;
        object = artifactAddress;
        if (object == null) {
            return null;
        }
        return this.libraryResolver.getLibrary(artifactAddress);
    }

    @Override
    @NotNull
    public List<LintModelDependency> getAllGraphItems() {
        List list;
        List list2 = this.allItems;
        if (list2 == null) {
            List list3 = CollectionsKt.toList((Iterable)this.transitiveDependencies.values());
            boolean bl = false;
            boolean bl2 = false;
            List it = list3;
            boolean bl3 = false;
            this.allItems = it;
            list = list3;
        } else {
            list = list2;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LintModelLibrary> getAllLibraries() {
        List list;
        List list2 = this.allLibraries;
        if (list2 == null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.getAllGraphItems();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LintModelLibrary lintModelLibrary;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                LintModelDependency it = (LintModelDependency)element$iv$iv;
                boolean bl2 = false;
                if (this.libraryResolver.getLibrary(it.getArtifactAddress()) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                LintModelLibrary it$iv$iv = lintModelLibrary;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            boolean bl = false;
            boolean bl6 = false;
            List it = list3;
            boolean bl7 = false;
            this.allLibraries = it;
            list = list3;
        } else {
            list = list2;
        }
        return list;
    }

    @NotNull
    public String toString() {
        return this.getRoots().toString();
    }
}

