/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.LintModelModuleAndroidLibraryProject;
import com.android.tools.lint.detector.api.LintModelModuleJavaLibraryProject;
import com.android.tools.lint.detector.api.LintModelModuleLibraryProject;
import com.android.tools.lint.detector.api.LintModelModuleProject;
import com.android.tools.lint.gradle.LintGradleClient;
import com.android.tools.lint.gradle.LintJavaProject;
import com.android.tools.lint.model.DefaultLintModelMavenName;
import com.android.tools.lint.model.LintModelAndroidLibrary;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelDependencyGraph;
import com.android.tools.lint.model.LintModelFactory;
import com.android.tools.lint.model.LintModelJavaLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleLoader;
import com.android.tools.lint.model.LintModelModuleLoaderProvider;
import com.android.tools.lint.model.LintModelVariant;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J$\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J0\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002J \u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0002J \u0010\"\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J,\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0002J\"\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/gradle/ProjectSearch;", "", "()V", "appProjects", "", "Lorg/gradle/api/Project;", "Lcom/android/tools/lint/detector/api/Project;", "gradleProjects", "Lcom/android/tools/lint/model/LintModelModule;", "javaLibraryProjects", "Lcom/android/tools/lint/model/LintModelJavaLibrary;", "javaLibraryProjectsByCoordinate", "Lcom/android/tools/lint/model/LintModelMavenName;", "Lcom/android/tools/lint/detector/api/LintModelModuleLibraryProject;", "libraryProjects", "Lcom/android/tools/lint/model/LintModelAndroidLibrary;", "libraryProjectsByCoordinate", "namedProjects", "", "createLintBuildModel", "client", "Lcom/android/tools/lint/gradle/LintGradleClient;", "gradleProject", "createNonAgpProject", "Lcom/android/tools/lint/gradle/LintJavaProject;", "lintClient", "variantName", "getBuildModule", "getLibrary", "libraryItem", "Lcom/android/tools/lint/model/LintModelDependency;", "library", "variant", "Lcom/android/tools/lint/model/LintModelVariant;", "getProject", "path", "lint-gradle"})
public final class ProjectSearch {
    private final Map<LintModelAndroidLibrary, com.android.tools.lint.detector.api.Project> libraryProjects;
    private final Map<LintModelMavenName, LintModelModuleLibraryProject> libraryProjectsByCoordinate;
    private final Map<String, com.android.tools.lint.detector.api.Project> namedProjects;
    private final Map<LintModelJavaLibrary, com.android.tools.lint.detector.api.Project> javaLibraryProjects;
    private final Map<LintModelMavenName, LintModelModuleLibraryProject> javaLibraryProjectsByCoordinate;
    private final Map<Project, com.android.tools.lint.detector.api.Project> appProjects;
    private final Map<Project, LintModelModule> gradleProjects;

    private final LintModelModule getBuildModule(LintGradleClient lintClient, Project gradleProject) {
        LintModelModule lintModelModule = this.gradleProjects.get(gradleProject);
        if (lintModelModule == null) {
            ProjectSearch projectSearch = this;
            boolean bl = false;
            boolean bl2 = false;
            ProjectSearch $this$run = projectSearch;
            boolean bl3 = false;
            LintModelModule newModel = $this$run.createLintBuildModel(lintClient, gradleProject);
            if (newModel != null) {
                $this$run.gradleProjects.put(gradleProject, newModel);
            }
            lintModelModule = newModel;
        }
        return lintModelModule;
    }

    @Nullable
    public final com.android.tools.lint.detector.api.Project getProject(@NotNull LintGradleClient lintClient, @NotNull Project gradleProject, @Nullable String variantName) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)lintClient), (String)"lintClient");
        Intrinsics.checkParameterIsNotNull((Object)gradleProject, (String)"gradleProject");
        LintModelModule module = this.getBuildModule(lintClient, gradleProject);
        if (module != null && variantName != null) {
            LintModelVariant variant = module.findVariant(variantName);
            if (variant != null) {
                return this.getProject(lintClient, variant, gradleProject);
            }
            LintModelVariant lintModelVariant = module.defaultVariant();
            if (lintModelVariant != null) {
                LintModelVariant lintModelVariant2 = lintModelVariant;
                boolean bl = false;
                boolean bl2 = false;
                LintModelVariant defaultVariant = lintModelVariant2;
                boolean bl3 = false;
                return this.getProject(lintClient, defaultVariant, gradleProject);
            }
        }
        return this.createNonAgpProject(gradleProject, lintClient, variantName);
    }

    private final LintJavaProject createNonAgpProject(Project gradleProject, LintGradleClient lintClient, String variantName) {
        Configuration compileConfiguration;
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)gradleProject.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaPluginConvention == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)javaPluginConvention, (String)"gradleProject.convention\u2026\n        ) ?: return null");
        JavaPluginConvention convention = javaPluginConvention;
        LanguageLevel language = LanguageLevel.parse((String)convention.getSourceCompatibility().name());
        SourceSetContainer sourceSets = convention.getSourceSets();
        boolean bl = false;
        List sources = new ArrayList();
        boolean bl2 = false;
        List classes = new ArrayList();
        boolean bl3 = false;
        List libs = new ArrayList();
        boolean bl4 = false;
        List tests = new ArrayList();
        Iterator iterator = sourceSets.iterator();
        while (iterator.hasNext()) {
            SourceDirectorySet javaSrc;
            SourceSet sourceSet;
            SourceSet sourceSet2 = sourceSet = (SourceSet)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet2, (String)"sourceSet");
            if (Intrinsics.areEqual((Object)sourceSet2.getName(), (Object)"test")) {
                SourceDirectorySet sourceDirectorySet = javaSrc = sourceSet.getJava();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceDirectorySet, (String)"javaSrc");
                for (File dir : sourceDirectorySet.getSrcDirs()) {
                    if (!dir.exists()) continue;
                    File file = dir;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dir");
                    tests.add(file);
                }
                continue;
            }
            SourceDirectorySet sourceDirectorySet = javaSrc = sourceSet.getJava();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceDirectorySet, (String)"javaSrc");
            for (File dir : sourceDirectorySet.getSrcDirs()) {
                if (!dir.exists()) continue;
                File file = dir;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dir");
                sources.add(file);
            }
            SourceSetOutput sourceSetOutput = sourceSet.getOutput();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceSetOutput, (String)"sourceSet.output");
            for (File file : sourceSetOutput.getClassesDirs()) {
                if (!file.exists()) continue;
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                classes.add(file2);
            }
            FileCollection fileCollection = sourceSet.getCompileClasspath();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"sourceSet.compileClasspath");
            for (File file : fileCollection.getFiles()) {
                if (!file.exists()) continue;
                File file3 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file");
                libs.add(file3);
            }
        }
        File projectDir = gradleProject.getProjectDir();
        boolean javaSrc = false;
        List dependencies = new ArrayList();
        LintJavaProject project = new LintJavaProject(lintClient, projectDir, dependencies, sources, classes, libs, tests, language);
        ConfigurationContainer configurations = gradleProject.getConfigurations();
        Configuration configuration = compileConfiguration = configurations.getByName("compileClasspath");
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"compileConfiguration");
        for (Dependency dependency : configuration.getAllDependencies()) {
            Set files;
            if (dependency instanceof ProjectDependency) {
                com.android.tools.lint.detector.api.Project lintProject;
                Project p;
                Project project2 = p = ((ProjectDependency)dependency).getDependencyProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"p");
                String string = project2.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"p.path");
                if (this.getProject(lintClient, string, p, variantName) == null) {
                    continue;
                }
                dependencies.add(lintProject);
                continue;
            }
            if (dependency instanceof ExternalDependency) {
                LintModelModuleLibraryProject javaLib;
                String version;
                String group;
                String name = dependency.getName();
                if (dependency.getGroup() == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)group, (String)"dependency.getGroup() ?: continue");
                if (dependency.getVersion() == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"dependency.getVersion() ?: continue");
                String string = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                DefaultLintModelMavenName coordinates = new DefaultLintModelMavenName(group, string, version);
                if (this.javaLibraryProjectsByCoordinate.get(coordinates) == null) {
                    continue;
                }
                javaLib.setExternalLibrary(true);
                dependencies.add(javaLib);
                continue;
            }
            if (!(dependency instanceof FileCollectionDependency)) continue;
            Set set = files = ((FileCollectionDependency)dependency).resolve();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"files");
            libs.addAll(set);
        }
        return project;
    }

    private final com.android.tools.lint.detector.api.Project getProject(LintGradleClient client2, LintModelVariant variant, Project gradleProject) {
        Configuration compileConfiguration;
        com.android.tools.lint.detector.api.Project cached = this.appProjects.get(gradleProject);
        if (cached != null) {
            return cached;
        }
        File dir = gradleProject.getProjectDir();
        File manifest = client2.getMergedManifest();
        LintClient lintClient = (LintClient)client2;
        File file = dir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dir");
        LintModelModuleProject lintProject = new LintModelModuleProject(lintClient, file, dir, variant, manifest);
        this.appProjects.put(gradleProject, (com.android.tools.lint.detector.api.Project)lintProject);
        lintProject.gradleProject = true;
        LintModelDependencyGraph dependencies = variant.getMainArtifact().getDependencies().getCompileDependencies();
        for (LintModelDependency item : dependencies.getRoots()) {
            LintModelLibrary library;
            if (item.findLibrary() == null) {
                continue;
            }
            if (!(library instanceof LintModelAndroidLibrary)) continue;
            lintProject.addDirectLibrary(this.getLibrary(client2, item, (LintModelAndroidLibrary)library, gradleProject, variant));
        }
        List processedProjects = null;
        ConfigurationContainer configurations = gradleProject.getConfigurations();
        Configuration configuration = compileConfiguration = configurations.getByName(variant.getName() + "CompileClasspath");
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"compileConfiguration");
        for (Dependency dependency : configuration.getAllDependencies()) {
            Project p;
            if (!(dependency instanceof ProjectDependency)) continue;
            Project project = p = ((ProjectDependency)dependency).getDependencyProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"p");
            com.android.tools.lint.detector.api.Project depProject = this.getProject(client2, project, variant.getName());
            if (depProject == null) continue;
            if (processedProjects == null) {
                boolean bl = false;
                processedProjects = new ArrayList();
            }
            processedProjects.add(p.getPath());
            lintProject.addDirectLibrary(depProject);
        }
        for (LintModelDependency libraryItem : dependencies.getRoots()) {
            LintModelLibrary library = libraryItem.findLibrary();
            if (!(library instanceof LintModelJavaLibrary)) continue;
            String projectName = library.getProjectPath();
            if (projectName != null) {
                if (processedProjects != null && processedProjects.contains(projectName)) continue;
                com.android.tools.lint.detector.api.Project libLintProject = this.getProject(client2, projectName, gradleProject, variant.getName());
                if (libLintProject != null) {
                    lintProject.addDirectLibrary(libLintProject);
                    continue;
                }
            }
            lintProject.addDirectLibrary(this.getLibrary(client2, libraryItem, (LintModelJavaLibrary)library));
        }
        return (com.android.tools.lint.detector.api.Project)lintProject;
    }

    private final com.android.tools.lint.detector.api.Project getProject(LintGradleClient client2, String path, Project gradleProject, String variantName) {
        com.android.tools.lint.detector.api.Project project;
        com.android.tools.lint.detector.api.Project cached = this.namedProjects.get(path);
        if (cached != null) {
            return cached;
        }
        Project namedProject = gradleProject.findProject(path);
        if (namedProject != null && (project = this.getProject(client2, namedProject, variantName)) != null) {
            this.namedProjects.put(path, project);
            return project;
        }
        return null;
    }

    private final com.android.tools.lint.detector.api.Project getLibrary(LintGradleClient client2, LintModelDependency libraryItem, LintModelAndroidLibrary library, Project gradleProject, LintModelVariant variant) {
        com.android.tools.lint.detector.api.Project cached = this.libraryProjects.get(library);
        if (cached != null) {
            return cached;
        }
        LintModelMavenName coordinates = library.getResolvedCoordinates();
        cached = (com.android.tools.lint.detector.api.Project)this.libraryProjectsByCoordinate.get(coordinates);
        if (cached != null) {
            return cached;
        }
        if (library.getProjectPath() != null) {
            com.android.tools.lint.detector.api.Project project;
            String string = library.getProjectPath();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((project = this.getProject(client2, string, gradleProject, variant.getName())) != null) {
                this.libraryProjects.put(library, project);
                return project;
            }
        }
        File dir = library.getFolder();
        LintModelModuleAndroidLibraryProject project = new LintModelModuleAndroidLibraryProject((LintClient)client2, dir, dir, libraryItem, library);
        project.setMavenCoordinates(coordinates);
        if (library.getProjectPath() == null) {
            project.setExternalLibrary(true);
        }
        this.libraryProjects.put(library, (com.android.tools.lint.detector.api.Project)project);
        this.libraryProjectsByCoordinate.put(coordinates, (LintModelModuleLibraryProject)project);
        for (LintModelDependency dependentItem : libraryItem.getDependencies()) {
            LintModelLibrary dependent;
            if (dependentItem.findLibrary() == null) {
                continue;
            }
            if (!(dependent instanceof LintModelAndroidLibrary)) continue;
            project.addDirectLibrary(this.getLibrary(client2, dependentItem, (LintModelAndroidLibrary)dependent, gradleProject, variant));
        }
        return (com.android.tools.lint.detector.api.Project)project;
    }

    private final com.android.tools.lint.detector.api.Project getLibrary(LintGradleClient client2, LintModelDependency libraryItem, LintModelJavaLibrary library) {
        com.android.tools.lint.detector.api.Project cached = this.javaLibraryProjects.get(library);
        if (cached != null) {
            return cached;
        }
        LintModelMavenName coordinates = library.getResolvedCoordinates();
        cached = (com.android.tools.lint.detector.api.Project)this.javaLibraryProjectsByCoordinate.get(coordinates);
        if (cached != null) {
            return cached;
        }
        File dir = (File)CollectionsKt.first((List)library.getJarFiles());
        LintModelModuleJavaLibraryProject project = new LintModelModuleJavaLibraryProject((LintClient)client2, dir, dir, libraryItem, library);
        project.setMavenCoordinates(coordinates);
        project.setExternalLibrary(true);
        this.javaLibraryProjects.put(library, (com.android.tools.lint.detector.api.Project)project);
        this.javaLibraryProjectsByCoordinate.put(coordinates, (LintModelModuleLibraryProject)project);
        for (LintModelDependency dependentItem : libraryItem.getDependencies()) {
            LintModelLibrary dependent;
            if (dependentItem.findLibrary() == null) {
                continue;
            }
            if (!(dependent instanceof LintModelJavaLibrary)) continue;
            project.addDirectLibrary(this.getLibrary(client2, dependentItem, (LintModelJavaLibrary)dependent));
        }
        return (com.android.tools.lint.detector.api.Project)project;
    }

    private final LintModelModule createLintBuildModel(LintGradleClient client2, Project gradleProject) {
        PluginContainer pluginContainer = gradleProject.getPlugins();
        for (Plugin p : pluginContainer) {
            Plugin plugin = p;
            if (!(plugin instanceof LintModelModuleLoaderProvider)) {
                plugin = null;
            }
            LintModelModuleLoaderProvider lintModelModuleLoaderProvider = (LintModelModuleLoaderProvider)plugin;
            if (lintModelModuleLoaderProvider == null) {
                continue;
            }
            LintModelModuleLoaderProvider provider = lintModelModuleLoaderProvider;
            LintModelFactory factory = new LintModelFactory();
            factory.setKotlinSourceFolderLookup((Function1)new Function1<String, List<? extends File>>(client2, gradleProject){
                final /* synthetic */ LintGradleClient $client;
                final /* synthetic */ Project $gradleProject;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<File> invoke(@NotNull String variantName) {
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
                    Iterable $this$filter$iv = this.$client.getKotlinSourceFolders(this.$gradleProject, variantName);
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        File it = (File)element$iv$iv;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"java") ^ true)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
                {
                    this.$client = lintGradleClient;
                    this.$gradleProject = project;
                    super(1);
                }
            });
            LintModelModuleLoader lintModelModuleLoader = provider.getModuleLoader();
            String string = gradleProject.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gradleProject.path");
            return lintModelModuleLoader.getModule(string, factory);
        }
        return null;
    }

    public ProjectSearch() {
        Map map;
        ProjectSearch projectSearch = this;
        boolean bl = false;
        projectSearch.libraryProjects = map = (Map)new LinkedHashMap();
        projectSearch = this;
        bl = false;
        projectSearch.libraryProjectsByCoordinate = map = (Map)new LinkedHashMap();
        projectSearch = this;
        bl = false;
        projectSearch.namedProjects = map = (Map)new LinkedHashMap();
        projectSearch = this;
        bl = false;
        projectSearch.javaLibraryProjects = map = (Map)new LinkedHashMap();
        projectSearch = this;
        bl = false;
        projectSearch.javaLibraryProjectsByCoordinate = map = (Map)new LinkedHashMap();
        projectSearch = this;
        bl = false;
        projectSearch.appProjects = map = (Map)new LinkedHashMap();
        projectSearch = this;
        bl = false;
        projectSearch.gradleProjects = map = (Map)new LinkedHashMap();
    }
}

