/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintFixPerformer;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.XmlReporter;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.checks.NonAndroidIssueRegistry;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.gradle.KotlinSourceFoldersResolver;
import com.android.tools.lint.gradle.LintGradleClient;
import com.android.tools.lint.gradle.LintGradleExecution;
import com.android.tools.lint.gradle.SyncOptionsKt;
import com.android.tools.lint.gradle.api.LintExecutionRequest;
import com.android.tools.lint.gradle.api.VariantInputs;
import com.android.tools.lint.model.LintModelLintOptions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0006\u0010\u001a\u001a\u00020\u0013J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0016\u0010\u001d\u001a\u00020\u00132\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\b\u0010!\u001a\u00020\u0013H\u0002J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020 H\u0002J8\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170&2\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fH\u0002JN\u0010(\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\u0006\u0012\u0004\u0018\u00010*0)2\b\u0010#\u001a\u0004\u0018\u00010 2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006H\u0002JV\u00100\u001a\u00020\u00132\b\u00101\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00102\u001a\u0002032\b\u0010#\u001a\u0004\u0018\u00010 2\u0006\u00104\u001a\u0002052\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010-\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u00068"}, d2={"Lcom/android/tools/lint/gradle/LintGradleExecution;", "", "descriptor", "Lcom/android/tools/lint/gradle/api/LintExecutionRequest;", "(Lcom/android/tools/lint/gradle/api/LintExecutionRequest;)V", "isFatalOnly", "", "()Z", "lintOptions", "Lcom/android/tools/lint/model/LintModelLintOptions;", "getLintOptions", "()Lcom/android/tools/lint/model/LintModelLintOptions;", "reportsDir", "Ljava/io/File;", "getReportsDir", "()Ljava/io/File;", "sdkHome", "getSdkHome", "abort", "", "client", "Lcom/android/tools/lint/gradle/LintGradleClient;", "warnings", "", "Lcom/android/tools/lint/Warning;", "isAndroid", "analyze", "createIssueRegistry", "Lcom/android/tools/lint/checks/BuiltinIssueRegistry;", "lintAllVariants", "variantNames", "", "", "lintNonAndroid", "lintSingleVariant", "variantName", "mergeWarnings", "warningMap", "", "allVariants", "runLint", "Lkotlin/Pair;", "Lcom/android/tools/lint/client/api/LintBaseline;", "variantInputs", "Lcom/android/tools/lint/gradle/api/VariantInputs;", "report", "allowFix", "dispose", "syncOptions", "options", "flags", "Lcom/android/tools/lint/LintCliFlags;", "project", "Lorg/gradle/api/Project;", "fatalOnly", "allowAutoFix", "lint-gradle"})
public final class LintGradleExecution {
    private final LintExecutionRequest descriptor;

    public final void analyze() throws IOException {
        if (this.descriptor.getAndroid()) {
            String variantName = this.descriptor.getVariantName();
            if (variantName != null) {
                this.lintSingleVariant(variantName);
            } else {
                Set variantNames = this.descriptor.getVariantNames();
                if (variantNames.size() == 1) {
                    this.lintSingleVariant((String)variantNames.iterator().next());
                } else {
                    this.lintAllVariants(variantNames);
                }
            }
        } else {
            this.lintNonAndroid();
        }
    }

    private final LintModelLintOptions getLintOptions() {
        return this.descriptor.getLintOptions();
    }

    private final File getSdkHome() {
        return this.descriptor.getSdkHome();
    }

    private final boolean isFatalOnly() {
        return this.descriptor.isFatalOnly();
    }

    private final File getReportsDir() {
        return this.descriptor.getReportsDir();
    }

    private final void abort(LintGradleClient client2, List<? extends Warning> warnings, boolean isAndroid) {
        String message;
        String string = isAndroid ? (this.isFatalOnly() ? "Lint found fatal errors while assembling a release target.\n\nTo proceed, either fix the issues identified by lint, or modify your build script as follows:\n...\nandroid {\n    lintOptions {\n        checkReleaseBuilds false\n        // Or, if you prefer, you can continue to check for errors in release builds,\n        // but continue the build even when errors are found:\n        abortOnError false\n    }\n}\n..." : "Lint found errors in the project; aborting build.\n\nFix the issues identified by lint, or add the following to your build script to proceed with errors:\n...\nandroid {\n    lintOptions {\n        abortOnError false\n    }\n}\n...") : (message = "Lint found errors in the project; aborting build.\n\nFix the issues identified by lint, or add the following to your build script to proceed with errors:\n...\nlintOptions {\n    abortOnError false\n}\n...");
        if (warnings != null && client2 != null) {
            boolean bl;
            block8: {
                List list = client2.getFlags().getReporters();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"client.flags.reporters");
                Sequence $this$none$iv = CollectionsKt.asSequence((Iterable)list);
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    Reporter reporter = (Reporter)element$iv;
                    boolean bl2 = false;
                    if (!(reporter instanceof TextReporter)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
            if (bl) {
                List errors2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)warnings), (Function1)abort.errors.1.INSTANCE));
                Collection $i$f$none = errors2;
                boolean bl3 = false;
                if (!$i$f$none.isEmpty()) {
                    StringWriter writer = new StringWriter();
                    if (errors2.size() > 3) {
                        writer.append("\nThe first 3 errors (out of " + errors2.size() + ") were:\n\n");
                        errors2 = CollectionsKt.listOf((Object[])new Warning[]{(Warning)errors2.get(0), (Warning)errors2.get(1), (Warning)errors2.get(2)});
                    } else {
                        writer.append("\nErrors found:\n\n");
                    }
                    LintCliFlags flags = client2.getFlags();
                    flags.setExplainIssues(false);
                    TextReporter reporter = Reporter.createTextReporter((LintCliClient)client2, (LintCliFlags)flags, null, (Writer)writer, (boolean)false);
                    try {
                        LintStats stats = LintStats.Companion.create(errors2.size(), 0);
                        reporter.setWriteStats(false);
                        reporter.write(stats, errors2);
                        message = message + writer.toString();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        throw (Throwable)new GradleException(message);
    }

    private final Pair<List<Warning>, LintBaseline> runLint(String variantName, VariantInputs variantInputs, boolean report, boolean isAndroid, boolean allowFix, boolean dispose) {
        IssueRegistry registry = (IssueRegistry)this.createIssueRegistry(isAndroid);
        LintCliFlags flags = new LintCliFlags();
        LintGradleClient client2 = new LintGradleClient(this.descriptor.getGradlePluginVersion(), registry, flags, this.descriptor.getProject(), this.descriptor.getSdkHome(), variantName, variantInputs, this.descriptor.getBuildToolsRevision(), new KotlinSourceFoldersResolver((Function2<? super String, ? super Project, ? extends List<? extends File>>)((Function2)new Function2<String, Project, List<? extends File>>(this){
            final /* synthetic */ LintGradleExecution this$0;

            @NotNull
            public final List<File> invoke(@NotNull String name, @Nullable Project project) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return LintGradleExecution.access$getDescriptor$p(this.this$0).getKotlinSourceFolders(name, project);
            }
            {
                this.this$0 = lintGradleExecution;
                super(2);
            }
        })), isAndroid, variantName);
        boolean fatalOnly = this.descriptor.isFatalOnly();
        if (fatalOnly) {
            flags.setFatalOnly(true);
        }
        boolean autoFixing = allowFix & this.descriptor.getAutoFix();
        LintModelLintOptions lintOptions = this.descriptor.getLintOptions();
        if (lintOptions != null) {
            this.syncOptions(lintOptions, client2, flags, variantName, this.descriptor.getProject(), this.descriptor.getReportsDir(), report, fatalOnly, allowFix);
        } else {
            flags.getReporters().add(Reporter.createTextReporter((LintCliClient)client2, (LintCliFlags)flags, null, (Writer)new PrintWriter(System.out, true), (boolean)false));
            if (!autoFixing) {
                File html = SyncOptionsKt.validateOutputFile(SyncOptionsKt.createOutputPath(this.descriptor.getProject(), null, ".html", null, flags.isFatalOnly()));
                File xml = SyncOptionsKt.validateOutputFile(SyncOptionsKt.createOutputPath(this.descriptor.getProject(), null, ".xml", null, flags.isFatalOnly()));
                try {
                    flags.getReporters().add(Reporter.createHtmlReporter((LintCliClient)client2, (File)html, (LintCliFlags)flags));
                    flags.getReporters().add(Reporter.createXmlReporter((LintCliClient)client2, (File)xml, (boolean)false, (boolean)flags.isIncludeXmlFixes()));
                }
                catch (IOException e) {
                    String string = e.getMessage();
                    if (string == null) {
                        string = e.toString();
                    }
                    throw (Throwable)new GradleException(string, (Throwable)e);
                }
            }
        }
        if (!report || fatalOnly) {
            flags.setQuiet(true);
        }
        flags.setWriteBaselineIfMissing(report && !fatalOnly && !autoFixing);
        Pair<List<Warning>, LintBaseline> warnings = null;
        if (autoFixing) {
            flags.setAutoFix(true);
            flags.setSetExitCode(false);
        }
        try {
            warnings = client2.run(registry);
        }
        catch (IOException e) {
            throw (Throwable)new GradleException("Invalid arguments.", (Throwable)e);
        }
        if (dispose) {
            client2.disposeProjects(CollectionsKt.emptyList());
        }
        if (report && client2.haveErrors() && flags.isSetExitCode()) {
            this.abort(client2, (List)warnings.getFirst(), isAndroid);
        }
        return warnings;
    }

    private final void lintSingleVariant(String variantName) {
        VariantInputs variantInputs = this.descriptor.getVariantInputs(variantName);
        if (variantInputs == null) {
            return;
        }
        VariantInputs variantInputs2 = variantInputs;
        this.runLint(variantName, variantInputs2, true, true, true, true);
    }

    private final void lintNonAndroid() {
        VariantInputs variantInputs = this.descriptor.getVariantInputs("");
        if (variantInputs == null) {
            return;
        }
        VariantInputs variantInputs2 = variantInputs;
        this.runLint(null, variantInputs2, true, false, true, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void lintAllVariants(Set<String> variantNames) {
        Object warnings;
        Iterator pair;
        Object variantInputs;
        UnusedResourceDetector.sIncludeInactiveReferences = false;
        boolean bl = false;
        Map warningMap = new LinkedHashMap();
        boolean bl2 = false;
        List baselines = new ArrayList();
        boolean first = true;
        for (String variantName : variantNames) {
            variantInputs = this.descriptor.getVariantInputs(variantName);
            if (variantInputs == null) continue;
            pair = this.runLint(variantName, (VariantInputs)variantInputs, false, true, first, false);
            first = false;
            warnings = (List)pair.getFirst();
            warningMap.put(variantName, warnings);
            LintBaseline baseline = (LintBaseline)pair.getSecond();
            if (baseline == null) continue;
            baselines.add(baseline);
        }
        LintModelLintOptions lintOptions = this.getLintOptions();
        boolean quiet = false;
        if (lintOptions != null) {
            quiet = lintOptions.getQuiet();
        }
        warnings = warningMap;
        boolean baseline = false;
        pair = warnings.entrySet().iterator();
        while (pair.hasNext()) {
            void variantName;
            Object object = variantInputs = pair.next();
            boolean bl3 = false;
            warnings = (String)object.getKey();
            object = variantInputs;
            bl3 = false;
            List warnings2 = (List)object.getValue();
            if (this.isFatalOnly() || quiet) continue;
            this.descriptor.warn("Ran lint on variant {}: {} issues found", new Object[]{variantName, warnings2.size()});
        }
        List<Warning> mergedWarnings = this.mergeWarnings(warningMap, variantNames);
        LintStats stats = LintStats.Companion.create(mergedWarnings, baselines);
        int errorCount = stats.getErrorCount();
        Collection warnings2 = variantNames;
        boolean bl4 = false;
        if (!warnings2.isEmpty()) {
            LintBaseline firstBaseline;
            TreeSet treeSet = Sets.newTreeSet();
            Intrinsics.checkExpressionValueIsNotNull((Object)treeSet, (String)"Sets.newTreeSet()");
            Set allVariants = treeSet;
            allVariants.addAll((Collection)variantNames);
            String variantName = (String)allVariants.iterator().next();
            IssueRegistry registry = (IssueRegistry)new BuiltinIssueRegistry();
            LintCliFlags flags = new LintCliFlags();
            VariantInputs variantInputs2 = this.descriptor.getVariantInputs(variantName);
            if (variantInputs2 == null) {
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException(variantName.toString());
            }
            VariantInputs variantInputs3 = variantInputs2;
            LintGradleClient client2 = new LintGradleClient(this.descriptor.getGradlePluginVersion(), registry, flags, this.descriptor.getProject(), this.getSdkHome(), variantName, variantInputs3, this.descriptor.getBuildToolsRevision(), new KotlinSourceFoldersResolver((Function2<? super String, ? super Project, ? extends List<? extends File>>)((Function2)new Function2<String, Project, List<? extends File>>(this){
                final /* synthetic */ LintGradleExecution this$0;

                @NotNull
                public final List<File> invoke(@NotNull String name, @Nullable Project project) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    return LintGradleExecution.access$getDescriptor$p(this.this$0).getKotlinSourceFolders(name, project);
                }
                {
                    this.this$0 = lintGradleExecution;
                    super(2);
                }
            })), true, this.isFatalOnly() ? "fatal" : "all");
            this.syncOptions(lintOptions, client2, flags, null, this.descriptor.getProject(), this.getReportsDir(), true, this.isFatalOnly(), true);
            if (flags.isAutoFix()) {
                flags.setSetExitCode(false);
                new LintFixPerformer((LintCliClient)client2, !flags.isQuiet()).fix(mergedWarnings);
            }
            for (Reporter reporter : flags.getReporters()) {
                reporter.write(stats, mergedWarnings);
            }
            File baselineFile = flags.getBaselineFile();
            if (baselineFile != null && !baselineFile.exists() && !flags.isAutoFix()) {
                File dir = baselineFile.getParentFile();
                boolean ok = true;
                File file = dir;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dir");
                if (!file.isDirectory()) {
                    ok = dir.mkdirs();
                }
                if (!ok) {
                    System.err.println("Couldn't create baseline folder " + dir);
                } else {
                    XmlReporter reporter = Reporter.createXmlReporter((LintCliClient)client2, (File)baselineFile, (boolean)true, (boolean)false);
                    reporter.setBaselineAttributes((LintClient)client2, flags.isFatalOnly() ? "fatal" : "all");
                    reporter.write(stats, mergedWarnings);
                    System.err.println("Created baseline file " + baselineFile);
                    if (LintCliClient.Companion.continueAfterBaseLineCreated()) {
                        return;
                    }
                    System.err.println("(Also breaking build in case this was not intentional.)");
                    String message = client2.getBaselineCreationMessage(baselineFile);
                    throw (Throwable)new GradleException(message);
                }
            }
            LintBaseline lintBaseline = firstBaseline = baselines.isEmpty() ? null : (LintBaseline)baselines.get(0);
            if (baselineFile != null && firstBaseline != null) {
                client2.emitBaselineDiagnostics(firstBaseline, baselineFile, stats);
            }
            if (flags.isSetExitCode() && errorCount > 0) {
                this.abort(client2, mergedWarnings, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Warning> mergeWarnings(Map<String, ? extends List<? extends Warning>> warningMap, Set<String> allVariants) {
        if (warningMap.size() == 1) {
            return (List)CollectionsKt.first((Iterable)warningMap.values());
        }
        int maxCount = 0;
        for (List<? extends Warning> list : warningMap.values()) {
            int size = list.size();
            boolean iterator = false;
            maxCount = Math.max(size, maxCount);
        }
        if (maxCount == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)(2 * maxCount));
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayListWithExpectedSize(2 * maxCount)");
        List list = arrayList;
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)(2 * maxCount));
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMapWithExpectedSize(2 * maxCount)");
        Map map = hashMap;
        Object object = warningMap;
        boolean bl = false;
        Iterator<Map.Entry<String, List<Object>>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends List<? extends Warning>> size;
            Map.Entry<String, ? extends List<? extends Warning>> entry = size = iterator.next();
            boolean bl2 = false;
            object = entry.getKey();
            Map.Entry<String, ? extends List<? extends Warning>> entry2 = size;
            bl2 = false;
            List<? extends Warning> warnings = entry2.getValue();
            for (Warning warning : warnings) {
                void variantName;
                String fileName;
                File parent;
                boolean $this$run32;
                LintGradleExecution $this$run222;
                boolean bl3;
                Map map2 = (Map)map.get(warning.issue);
                if (map2 == null) {
                    LintGradleExecution lintGradleExecution = this;
                    boolean bl4 = false;
                    bl3 = false;
                    $this$run222 = lintGradleExecution;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Map map32 = new LinkedHashMap();
                    Issue issue = warning.issue;
                    Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"warning.issue");
                    map.put(issue, map32);
                    map2 = map32;
                }
                Map messageMap = map2;
                Map map3 = (Map)messageMap.get(warning.message);
                if (map3 == null) {
                    LintGradleExecution lintGradleExecution = this;
                    bl3 = false;
                    boolean $this$run222 = false;
                    LintGradleExecution $this$run32 = lintGradleExecution;
                    boolean bl7 = false;
                    boolean map32 = false;
                    Map new2 = new LinkedHashMap();
                    String string = warning.message;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"warning.message");
                    messageMap.put(string, new2);
                    map3 = new2;
                }
                Map lineMap = map3;
                Map map4 = (Map)lineMap.get(warning.line);
                if (map4 == null) {
                    LintGradleExecution lintGradleExecution = this;
                    boolean $this$run222 = false;
                    $this$run32 = false;
                    LintGradleExecution $this$run4 = lintGradleExecution;
                    boolean bl8 = false;
                    boolean new2 = false;
                    Map new3 = new LinkedHashMap();
                    lineMap.put(warning.line, new3);
                    map4 = new3;
                }
                Map columnMap = map4;
                Map map5 = (Map)columnMap.get(warning.offset);
                if (map5 == null) {
                    $this$run222 = this;
                    $this$run32 = false;
                    boolean $this$run4 = false;
                    LintGradleExecution $this$run5 = $this$run222;
                    boolean bl9 = false;
                    boolean bl7 = false;
                    Map new4 = new LinkedHashMap();
                    columnMap.put(warning.offset, new4);
                    map5 = new4;
                }
                Map fileMap = map5;
                File file = warning.file;
                String string = file != null ? ((parent = file.getParentFile()) != null ? parent.getName() + "/" + file.getName() : file.getName()) : (fileName = "<unknown>");
                Warning warning2 = (Warning)fileMap.get(fileName);
                if (warning2 == null) {
                    LintGradleExecution lintGradleExecution = this;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    LintGradleExecution $this$run6 = lintGradleExecution;
                    boolean bl13 = false;
                    String string2 = fileName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fileName");
                    fileMap.put(string2, warning);
                    warning.variants = Sets.newHashSet();
                    warning.allVariants = allVariants;
                    list.add(warning);
                    warning2 = warning;
                }
                Warning canonical = warning2;
                canonical.variants.add(variantName);
            }
        }
        for (Warning warning : list) {
            if (warning.variants == null || warning.variants.size() != allVariants.size()) continue;
            warning.variants = null;
        }
        CollectionsKt.sort((List)list);
        return list;
    }

    private final void syncOptions(LintModelLintOptions options, LintGradleClient client2, LintCliFlags flags, String variantName, Project project, File reportsDir, boolean report, boolean fatalOnly, boolean allowAutoFix) {
        if (options != null) {
            SyncOptionsKt.syncTo(options, client2, flags, variantName, project, reportsDir, report);
        }
        client2.syncConfigOptions();
        if (!allowAutoFix && flags.isAutoFix()) {
            flags.setAutoFix(false);
        }
        boolean displayEmpty = !fatalOnly && !flags.isQuiet();
        Iterator iterator = flags.getReporters().iterator();
        while (iterator.hasNext()) {
            Reporter reporter;
            Reporter reporter2 = reporter = (Reporter)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)reporter2, (String)"reporter");
            reporter2.setDisplayEmpty(displayEmpty);
        }
    }

    private final BuiltinIssueRegistry createIssueRegistry(boolean isAndroid) {
        return isAndroid ? new BuiltinIssueRegistry() : (BuiltinIssueRegistry)new NonAndroidIssueRegistry();
    }

    public LintGradleExecution(@NotNull LintExecutionRequest descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        this.descriptor = descriptor;
    }

    public static final /* synthetic */ LintExecutionRequest access$getDescriptor$p(LintGradleExecution $this) {
        return $this.descriptor;
    }
}

