/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle;

import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class GroovyGradleVisitor
extends GradleVisitor {
    public void visitBuildScript(GradleContext context, List<? extends GradleScanner> detectors) {
        try {
            GroovyGradleVisitor.visitQuietly(context, detectors);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void visitQuietly(final GradleContext context, final List<? extends GradleScanner> detectors) {
        CharSequence sequence = context.getContents();
        if (sequence == null) {
            return;
        }
        final String source = sequence.toString();
        List astNodes = new AstBuilder().buildFromString(source);
        CodeVisitorSupport visitor = new CodeVisitorSupport(){
            private final List<MethodCallExpression> mMethodCallStack = new ArrayList<MethodCallExpression>();

            public void visitMethodCallExpression(MethodCallExpression expression) {
                this.mMethodCallStack.add(expression);
                super.visitMethodCallExpression(expression);
                assert (!this.mMethodCallStack.isEmpty());
                assert (this.mMethodCallStack.get(this.mMethodCallStack.size() - 1) == expression);
                this.mMethodCallStack.remove(this.mMethodCallStack.size() - 1);
            }

            public void visitTupleExpression(TupleExpression tupleExpression) {
                MethodCallExpression call;
                if (!this.mMethodCallStack.isEmpty() && (call = this.mMethodCallStack.get(this.mMethodCallStack.size() - 1)).getArguments() == tupleExpression) {
                    String parent = call.getMethodAsString();
                    String parentParent = this.getParentParent();
                    String parent3 = this.getParentN(2);
                    if (tupleExpression instanceof ArgumentListExpression) {
                        ArgumentListExpression ale = (ArgumentListExpression)tupleExpression;
                        List expressions = ale.getExpressions();
                        if (expressions.size() == 1 && expressions.get(0) instanceof ClosureExpression) {
                            ClosureExpression closureExpression = (ClosureExpression)expressions.get(0);
                            Statement block = closureExpression.getCode();
                            if (block instanceof BlockStatement) {
                                BlockStatement bs = (BlockStatement)block;
                                for (Statement statement : bs.getStatements()) {
                                    ExpressionStatement e;
                                    if (statement instanceof ExpressionStatement) {
                                        e = (ExpressionStatement)statement;
                                        if (!(e.getExpression() instanceof MethodCallExpression)) continue;
                                        this.checkDslProperty(parent, (MethodCallExpression)e.getExpression(), parentParent, detectors);
                                        continue;
                                    }
                                    if (!(statement instanceof ReturnStatement) || !((e = (ReturnStatement)statement).getExpression() instanceof MethodCallExpression)) continue;
                                    this.checkDslProperty(parent, (MethodCallExpression)e.getExpression(), parentParent, detectors);
                                }
                            }
                        } else {
                            HashMap<String, String> namedArguments = new HashMap<String, String>();
                            ArrayList<String> unnamedArguments = new ArrayList<String>();
                            this.extractMethodCallArguments(tupleExpression, unnamedArguments, namedArguments);
                            for (GradleScanner scanner : detectors) {
                                scanner.checkMethodCall(context, parent, parentParent, parent3, namedArguments, unnamedArguments, (Object)call);
                            }
                        }
                    } else {
                        HashMap<String, String> namedArguments = new HashMap<String, String>();
                        ArrayList<String> unnamedArguments = new ArrayList<String>();
                        this.extractMethodCallArguments(tupleExpression, unnamedArguments, namedArguments);
                        for (GradleScanner scanner : detectors) {
                            scanner.checkMethodCall(context, parent, parentParent, parent3, namedArguments, unnamedArguments, (Object)call);
                        }
                    }
                }
                super.visitTupleExpression(tupleExpression);
            }

            private void extractMethodCallArguments(TupleExpression tupleExpression, List<String> unnamedArguments, Map<String, String> namedArguments) {
                for (Expression subExpr : tupleExpression.getExpressions()) {
                    if (!(subExpr instanceof NamedArgumentListExpression)) continue;
                    NamedArgumentListExpression nale = (NamedArgumentListExpression)subExpr;
                    for (MapEntryExpression mae : nale.getMapEntryExpressions()) {
                        namedArguments.put(mae.getKeyExpression().getText(), mae.getValueExpression().getText());
                    }
                }
            }

            private String getParentN(int n) {
                int nParent = 0;
                for (int i = this.mMethodCallStack.size() - 2; i >= 0; --i) {
                    ArgumentListExpression ale;
                    List expressions;
                    MethodCallExpression expression = this.mMethodCallStack.get(i);
                    Expression arguments = expression.getArguments();
                    if (arguments instanceof ArgumentListExpression && (expressions = (ale = (ArgumentListExpression)arguments).getExpressions()).size() == 1 && expressions.get(0) instanceof ClosureExpression) {
                        ++nParent;
                    }
                    if (nParent != n) continue;
                    return expression.getMethodAsString();
                }
                return null;
            }

            private String getParentParent() {
                return this.getParentN(1);
            }

            private void checkDslProperty(String parent, MethodCallExpression c, String parentParent, List<? extends GradleScanner> detectors2) {
                String property = c.getMethodAsString();
                String value = this.getText((ASTNode)c.getArguments());
                for (GradleScanner gradleScanner : detectors2) {
                    gradleScanner.checkDslPropertyAssignment(context, property, value, parent, parentParent, (Object)c.getMethod(), (Object)c, (Object)c);
                }
            }

            private String getText(ASTNode node) {
                Pair offsets = GroovyGradleVisitor.getOffsets(node, (Context)context);
                return source.substring((Integer)offsets.getFirst(), (Integer)offsets.getSecond());
            }
        };
        for (ASTNode node : astNodes) {
            node.visit((GroovyCodeVisitor)visitor);
        }
    }

    private static Pair<Integer, Integer> getOffsets(ASTNode node, Context context) {
        List expressions;
        TupleExpression exp;
        List expressions2;
        if (node.getLastLineNumber() == -1 && node instanceof TupleExpression && !(expressions2 = (exp = (TupleExpression)node).getExpressions()).isEmpty()) {
            return Pair.of((Object)GroovyGradleVisitor.getOffsets((ASTNode)expressions2.get(0), context).getFirst(), (Object)GroovyGradleVisitor.getOffsets((ASTNode)expressions2.get(expressions2.size() - 1), context).getSecond());
        }
        if (node instanceof ArgumentListExpression && (expressions = ((ArgumentListExpression)node).getExpressions()).size() == 1) {
            return GroovyGradleVisitor.getOffsets((ASTNode)expressions.get(0), context);
        }
        CharSequence source = context.getContents();
        assert (source != null);
        int start = 0;
        int end = source.length();
        int line = 1;
        int startLine = node.getLineNumber();
        int startColumn = node.getColumnNumber();
        int endLine = node.getLastLineNumber();
        int endColumn = node.getLastColumnNumber();
        int column = 1;
        int len = end;
        for (int index = 0; index < len; ++index) {
            if (line == startLine && column == startColumn) {
                start = index;
            }
            if (line == endLine && column == endColumn) {
                end = index;
                break;
            }
            char c = source.charAt(index);
            if (c == '\n') {
                ++line;
                column = 1;
                continue;
            }
            ++column;
        }
        return Pair.of((Object)start, (Object)end);
    }

    public int getStartOffset(GradleContext context, Object cookie) {
        ASTNode node = (ASTNode)cookie;
        Pair<Integer, Integer> offsets = GroovyGradleVisitor.getOffsets(node, (Context)context);
        return (Integer)offsets.getFirst();
    }

    public Location createLocation(GradleContext context, Object cookie) {
        ASTNode node = (ASTNode)cookie;
        Pair<Integer, Integer> offsets = GroovyGradleVisitor.getOffsets(node, (Context)context);
        int fromLine = node.getLineNumber() - 1;
        int fromColumn = node.getColumnNumber() - 1;
        int toLine = node.getLastLineNumber() - 1;
        int toColumn = node.getLastColumnNumber() - 1;
        return Location.create((File)context.file, (Position)new DefaultPosition(fromLine, fromColumn, ((Integer)offsets.getFirst()).intValue()), (Position)new DefaultPosition(toLine, toColumn, ((Integer)offsets.getSecond()).intValue()));
    }

    public Object getPropertyKeyCookie(Object cookie) {
        return cookie;
    }

    public Object getPropertyPairCookie(Object cookie) {
        return cookie;
    }
}

