/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle;

import com.android.tools.lint.KotlinLintAnalyzerFacade;
import com.android.tools.lint.UastEnvironment;
import com.android.tools.lint.annotations.Extractor;
import com.android.tools.lint.gradle.api.ExtractAnnotationRequest;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/gradle/LintExtractAnnotations;", "", "()V", "extractAnnotations", "", "request", "Lcom/android/tools/lint/gradle/api/ExtractAnnotationRequest;", "lint-gradle"})
public final class LintExtractAnnotations {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extractAnnotations(@NotNull ExtractAnnotationRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        File typedefFile = request.getTypedefFile();
        Logger logger = request.getLogger();
        FileCollection classDir = request.getClassDir();
        File output = request.getOutput();
        List sourceFiles = request.getSourceFiles();
        List roots = request.getRoots();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
        Disposable parentDisposable = disposable;
        UastEnvironment environment = UastEnvironment.Companion.create(parentDisposable);
        try {
            UastEnvironment.ProjectEnvironment projectEnvironment = environment.getProjectEnvironment();
            projectEnvironment.registerPaths(roots);
            List<? extends PsiFile> parsedUnits = Extractor.createUnitsForFiles((Project)projectEnvironment.getProject(), sourceFiles);
            ArrayList<File> ktFiles = new ArrayList<File>();
            for (File file : sourceFiles) {
                String string = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                if (!StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null)) continue;
                ktFiles.add(file);
            }
            KotlinLintAnalyzerFacade facade = new KotlinLintAnalyzerFacade(null, 1, null);
            List list = ktFiles;
            MockProject mockProject = projectEnvironment.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)mockProject, (String)"projectEnvironment.project");
            KotlinLintAnalyzerFacade.analyze$default((KotlinLintAnalyzerFacade)facade, (List)list, (List)roots, (MockProject)mockProject, (UastEnvironment)environment, null, null, (int)48, null);
            boolean displayInfo = logger.isEnabled(LogLevel.INFO);
            Extractor extractor = new Extractor(null, classDir.getFiles(), displayInfo, false, false);
            extractor.extractFromProjectSource(parsedUnits);
            extractor.export(output, null);
            extractor.writeTypedefFile(typedefFile);
        }
        catch (IOException e) {
            throw (Throwable)new UncheckedIOException(e);
        }
        finally {
            Disposer.dispose((Disposable)parentDisposable);
        }
    }
}

