/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle.api;

import com.android.tools.lint.gradle.api.ExtractAnnotationRequest;
import com.android.tools.lint.gradle.api.LintClassLoaderProvider;
import com.android.tools.lint.gradle.api.LintExecutionRequest;
import com.google.common.base.Throwables;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ$\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/gradle/api/ReflectiveLintRunner;", "", "()V", "extractAnnotations", "", "classLoaderProvider", "Lcom/android/tools/lint/gradle/api/LintClassLoaderProvider;", "request", "Lcom/android/tools/lint/gradle/api/ExtractAnnotationRequest;", "lintClassPath", "", "Ljava/io/File;", "runLint", "Lcom/android/tools/lint/gradle/api/LintExecutionRequest;", "wrapExceptionAsString", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "t", "", "ExtractErrorException", "lint-gradle-api"})
public final class ReflectiveLintRunner {
    public final void runLint(@NotNull LintClassLoaderProvider classLoaderProvider, @NotNull LintExecutionRequest request, @NotNull Set<? extends File> lintClassPath) {
        Intrinsics.checkParameterIsNotNull((Object)classLoaderProvider, (String)"classLoaderProvider");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(lintClassPath, (String)"lintClassPath");
        try {
            ClassLoader loader = classLoaderProvider.getClassLoader(lintClassPath);
            Class<?> cls = loader.loadClass("com.android.tools.lint.gradle.LintGradleExecution");
            Constructor<?> constructor = cls.getConstructor(LintExecutionRequest.class);
            Object driver = constructor.newInstance(request);
            Method analyzeMethod = driver.getClass().getDeclaredMethod("analyze", new Class[0]);
            analyzeMethod.invoke(driver, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof GradleException) {
                Throwable throwable = e.getTargetException();
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"e.targetException");
                throw throwable;
            }
            throw (Throwable)this.wrapExceptionAsString(e);
        }
        catch (Throwable t) {
            throw (Throwable)this.wrapExceptionAsString(t);
        }
    }

    public final void extractAnnotations(@NotNull LintClassLoaderProvider classLoaderProvider, @NotNull ExtractAnnotationRequest request, @NotNull Set<? extends File> lintClassPath) {
        Intrinsics.checkParameterIsNotNull((Object)classLoaderProvider, (String)"classLoaderProvider");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(lintClassPath, (String)"lintClassPath");
        try {
            ClassLoader loader = classLoaderProvider.getClassLoader(lintClassPath);
            Class<?> cls = loader.loadClass("com.android.tools.lint.gradle.LintExtractAnnotations");
            Object driver = cls.newInstance();
            Method analyzeMethod = driver.getClass().getDeclaredMethod("extractAnnotations", ExtractAnnotationRequest.class);
            analyzeMethod.invoke(driver, request);
        }
        catch (ExtractErrorException e) {
            throw (Throwable)new GradleException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof GradleException) {
                Throwable throwable = e.getTargetException();
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"e.targetException");
                throw throwable;
            }
            throw (Throwable)this.wrapExceptionAsString(e);
        }
        catch (Throwable t) {
            throw (Throwable)this.wrapExceptionAsString(t);
        }
    }

    private final RuntimeException wrapExceptionAsString(Throwable t) {
        return new RuntimeException("Lint infrastructure error\nCaused by: " + Throwables.getStackTraceAsString((Throwable)t) + '\n');
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/gradle/api/ReflectiveLintRunner$ExtractErrorException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "lint-gradle-api"})
    public static final class ExtractErrorException
    extends RuntimeException {
        @NotNull
        private final String message;

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        public ExtractErrorException(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            super(message);
            this.message = message;
        }
    }
}

