/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle.api;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/gradle/api/DelegatingClassLoader;", "Ljava/net/URLClassLoader;", "urls", "", "Ljava/net/URL;", "([Ljava/net/URL;)V", "delegate", "Ljava/lang/ClassLoader;", "kotlin.jvm.PlatformType", "findClass", "Ljava/lang/Class;", "name", "", "findResource", "findResources", "Ljava/util/Enumeration;", "mustBeLoadedByDelegate", "", "lint-gradle-api"})
public final class DelegatingClassLoader
extends URLClassLoader {
    private final ClassLoader delegate;

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (this.mustBeLoadedByDelegate(name)) {
            Class<?> clazz2 = this.delegate.loadClass(name);
            Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"delegate.loadClass(name)");
            return clazz2;
        }
        try {
            Class<?> clazz3 = super.findClass(name);
            Intrinsics.checkExpressionValueIsNotNull(clazz3, (String)"super.findClass(name)");
            clazz = clazz3;
        }
        catch (ClassNotFoundException e) {
            Class<?> clazz4 = this.delegate.loadClass(name);
            Intrinsics.checkExpressionValueIsNotNull(clazz4, (String)"delegate.loadClass(name)");
            clazz = clazz4;
        }
        return clazz;
    }

    @Override
    @Nullable
    public URL findResource(@Nullable String name) {
        URL resource = super.findResource(name);
        if (resource != null) {
            return resource;
        }
        return this.delegate.getResource(name);
    }

    @Override
    @NotNull
    public Enumeration<URL> findResources(@Nullable String name) {
        Enumeration<URL> resources = super.findResources(name);
        if (resources != null && resources.hasMoreElements()) {
            return resources;
        }
        Enumeration<URL> enumeration = this.delegate.getResources(name);
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"delegate.getResources(name)");
        return enumeration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean mustBeLoadedByDelegate(String name) {
        if (!StringsKt.startsWith$default((String)name, (String)"kotlin.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)name, (String)"kotlin.jvm.functions.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"kotlin.reflect.", (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)name, (char)'.', (int)15, (boolean)false, (int)4, null) < 0) {
            return true;
        }
        String string = name;
        switch (string.hashCode()) {
            case -1706826127: {
                if (!string.equals("kotlin.Unit")) return false;
                return true;
            }
            case 754835865: {
                if (!string.equals("kotlin.jvm.internal.ClassBasedDeclarationContainer")) return false;
                return true;
            }
            case 1046462858: {
                if (!string.equals("kotlin.jvm.internal.DefaultConstructorMarker")) return false;
                return true;
            }
            case 1412220810: {
                if (!string.equals("kotlin.sequences.Sequence")) return false;
                return true;
            }
            case -1706987577: {
                if (!string.equals("kotlin.Pair")) return false;
                return true;
            }
            case -131986843: {
                if (!string.equals("kotlin.properties.ReadOnlyProperty")) return false;
                return true;
            }
            case 371773072: {
                if (!string.equals("kotlin.properties.ReadWriteProperty")) return false;
                return true;
            }
            case 392663563: {
                if (!string.equals("kotlin.Triple")) return false;
                return true;
            }
            case -1707106207: {
                if (!string.equals("kotlin.Lazy")) return false;
                return true;
            }
        }
        return false;
    }

    public DelegatingClassLoader(@NotNull URL[] urls) {
        Intrinsics.checkParameterIsNotNull((Object)urls, (String)"urls");
        super(urls, (ClassLoader)null);
        this.delegate = this.getClass().getClassLoader();
    }
}

