/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.utils.DomExtensions;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0012\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0013\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\rH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0016J \u0010'\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010(\u001a\u00020#H\u0016J \u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006,"}, d2={"Lcom/android/tools/lint/checks/SliceDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "checkHasContent", "", "qualifiedName", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lorg/jetbrains/uast/UMethod;", "checkListBuilder", "listBuilder", "checkRowBuilder", "ensureSingleToggleType", "endActionItems", "", "Lorg/jetbrains/uast/UExpression;", "message", "findRows", "findSliceActionConstructor", "Lorg/jetbrains/uast/UElement;", "getApplicableConstructorTypes", "isAddRowMethod", "", "methodName", "isBuildConsumer", "call", "isContentMethod", "isCustomToggle", "Lcom/intellij/psi/PsiMethod;", "visitClass", "declaration", "Lorg/jetbrains/uast/UClass;", "visitConstructor", "constructor", "warnMissingContent", "builder", "Companion", "lint-checks"})
public final class SliceDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final String ICON_CLASS = "android.graphics.drawable.Icon";
    private static final String ICON_COMPAT_CLASS_1 = "androidx.core.graphics.drawable.IconCompat";
    private static final String ICON_COMPAT_CLASS_2 = "android.support.v4.graphics.drawable.IconCompat";
    private static final String SLICE_PROVIDER_CLASS_1 = "androidx.slice.SliceProvider";
    private static final String SLICE_PROVIDER_CLASS_2 = "android.app.slice.SliceProvider";
    private static final String SLICE_ACTION_CLASS = "androidx.slice.builders.SliceAction";
    private static final String LIST_BUILDER_CLASS = "androidx.slice.builders.ListBuilder";
    private static final String LIST_INPUT_RANGE_BUILDER_CLASS = "androidx.slice.builders.ListBuilder.InputRangeBuilder";
    private static final String LIST_RANGE_BUILDER_CLASS = "androidx.slice.builders.ListBuilder.RangeBuilder";
    private static final String LIST_HEADER_BUILDER_CLASS = "androidx.slice.builders.ListBuilder.HeaderBuilder";
    private static final String GRID_ROW_BUILDER_CLASS = "androidx.slice.builders.GridRowBuilder";
    private static final String GRID_ROW_CELL_BUILDER_CLASS = "androidx.slice.builders.GridRowBuilder.CellBuilder";
    private static final String ROW_BUILDER_CLASS = "androidx.slice.builders.ListBuilder.RowBuilder";
    private static final String CATEGORY_SLICE = "android.app.slice.category.SLICE";
    public static final boolean WARN_ABOUT_TOO_MANY_ROWS = false;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object[])new String[]{SLICE_PROVIDER_CLASS_1, SLICE_PROVIDER_CLASS_2});
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        UMethod onMapMethod;
        int n;
        Element firstCategory;
        String sliceProvider;
        block17: {
            UMethod uMethod;
            String manifestName;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            String string = declaration.getQualifiedName();
            if (string == null) {
                return;
            }
            sliceProvider = string;
            if (context.getMainProject().isLibrary()) {
                return;
            }
            Project mainProject = context.getMainProject();
            Document document = mainProject.getMergedManifest();
            if (document == null) {
                return;
            }
            Document mergedManifest = document;
            Element element = mergedManifest.getDocumentElement();
            if (element == null) {
                return;
            }
            Element root = element;
            Element element2 = DomExtensions.subtag((Element)root, (String)"application");
            if (element2 == null) {
                return;
            }
            Element application = element2;
            Element provider = DomExtensions.subtag((Element)application, (String)"provider");
            while (provider != null && !Intrinsics.areEqual((Object)sliceProvider, (Object)(manifestName = Lint.resolveManifestName((Element)provider)))) {
                provider = DomExtensions.next((Element)provider, (String)"provider");
            }
            if (provider == null) {
                return;
            }
            firstCategory = null;
            Element intentFilter = XmlUtils.getFirstSubTagByName((Node)provider, (String)"intent-filter");
            while (intentFilter != null) {
                boolean foundCategory = false;
                Element category = XmlUtils.getFirstSubTagByName((Node)intentFilter, (String)"category");
                while (category != null) {
                    String name = category.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if (Intrinsics.areEqual((Object)CATEGORY_SLICE, (Object)name)) {
                        foundCategory = true;
                        if (firstCategory != null) break;
                        firstCategory = category;
                        break;
                    }
                    category = XmlUtils.getNextTagByName((Node)category, (String)"category");
                }
                if (!foundCategory) {
                    Location location;
                    Location location2 = context.getClient().findManifestSourceLocation((Node)intentFilter);
                    Location location3 = location = location2 != null ? Location.withSecondary$default((Location)location2, (Location)context.getNameLocation(declaration), (String)"SliceProvider declaration", (boolean)false, (int)4, null) : null;
                    if (location != null) {
                        context.report(ISSUE, location, "All `SliceProvider` filters require category slice to be set:  <category android:name=\"android.app.slice.category.SLICE\" />", null);
                    }
                }
                intentFilter = XmlUtils.getNextTagByName((Node)intentFilter, (String)"intent-filter");
            }
            UMethod[] $this$firstOrNull$iv = declaration.getMethods();
            boolean $i$f$firstOrNull = false;
            UMethod[] uMethodArray = $this$firstOrNull$iv;
            n = uMethodArray.length;
            for (int i = 0; i < n; ++i) {
                UMethod element$iv;
                UMethod it = element$iv = uMethodArray[i];
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"onMapIntentToUri") && it.getUastParameters().size() == 1)) continue;
                uMethod = element$iv;
                break block17;
            }
            uMethod = onMapMethod = null;
        }
        if (onMapMethod != null && firstCategory == null) {
            context.report(ISSUE, declaration, context.getNameLocation(onMapMethod), "Define intent filters in your manifest on your " + "`<provider android:name=\"" + sliceProvider + "\">`; otherwise " + "`onMapIntentToUri` will not be called");
        } else if (firstCategory != null && onMapMethod == null) {
            Location location = context.getNameLocation(declaration);
            Location location4 = context.getClient().findManifestSourceLocation((Node)firstCategory);
            if (location4 != null) {
                Location location5 = location4;
                boolean bl = false;
                n = 0;
                Location it = location5;
                boolean bl2 = false;
                location.setSecondary(it);
            }
            context.report(ISSUE, declaration, location, "Implement `SliceProvider#onMapIntentToUri` to handle the intents defined on your slice `<provider>` in your manifest");
        }
    }

    @Nullable
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object[])new String[]{LIST_BUILDER_CLASS, ROW_BUILDER_CLASS, GRID_ROW_BUILDER_CLASS, GRID_ROW_CELL_BUILDER_CLASS, LIST_HEADER_BUILDER_CLASS, LIST_INPUT_RANGE_BUILDER_CLASS, LIST_RANGE_BUILDER_CLASS});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Object name;
        UMethod method;
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
            UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)((UElement)node), UMethod.class, (boolean)true);
            if (uMethod == null) {
                return;
            }
            method = uMethod;
            Object object = constructor.getContainingClass();
            if (object == null || (object = object.getQualifiedName()) == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"constructor.containingCl\u2026?.qualifiedName ?: return");
            Object object2 = name = object;
            switch (((String)object2).hashCode()) {
                case -631842329: {
                    if (!((String)object2).equals(ROW_BUILDER_CLASS)) return;
                    break;
                }
                case 991555848: {
                    if (!((String)object2).equals(LIST_HEADER_BUILDER_CLASS)) return;
                    break block8;
                }
                case 1661209095: {
                    if (!((String)object2).equals(GRID_ROW_CELL_BUILDER_CLASS)) return;
                    break block8;
                }
                case 843941960: {
                    if (!((String)object2).equals(LIST_BUILDER_CLASS)) return;
                    this.checkListBuilder(context, node, method);
                    return;
                }
            }
            this.checkRowBuilder(context, node, method);
            return;
        }
        this.checkHasContent((String)name, context, node, method);
        return;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkListBuilder(JavaContext context, UCallExpression listBuilder, UMethod method) {
        void rowCount;
        void primaryAction;
        List<UCallExpression> rows = this.findRows(listBuilder, method);
        if (rows.isEmpty()) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)listBuilder), (Location)context.getLocation((UElement)listBuilder), (String)"A slice should have at least one row added to it", null, (int)16, null);
            return;
        }
        boolean bl = false;
        List initialReferences = new ArrayList();
        for (UCallExpression call : rows) {
            PsiParameter parameter;
            UExpression lambda2;
            if (UastExpressionUtils.isConstructorCall((UElement)((UElement)call)) || !this.isBuildConsumer(call) || !((lambda2 = (UExpression)call.getValueArguments().get(0)) instanceof ULambdaExpression)) continue;
            List parameters = ((ULambdaExpression)lambda2).getValueParameters();
            PsiElement psiElement = ((UParameter)parameters.get(0)).getSourcePsi();
            if (!(psiElement instanceof PsiParameter)) {
                psiElement = null;
            }
            if ((PsiParameter)psiElement == null) {
                continue;
            }
            initialReferences.add(parameter);
        }
        Ref.BooleanRef call = new Ref.BooleanRef();
        call.element = false;
        method.accept((UastVisitor)new DataFlowAnalyzer((Ref.BooleanRef)primaryAction, rows, initialReferences, rows, initialReferences){
            final /* synthetic */ Ref.BooleanRef $primaryAction;
            final /* synthetic */ List $rows;
            final /* synthetic */ List $initialReferences;

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                if (Intrinsics.areEqual((Object)call.getMethodName(), (Object)"setPrimaryAction")) {
                    this.$primaryAction.element = true;
                }
            }
            {
                this.$primaryAction = $captured_local_variable$0;
                this.$rows = $captured_local_variable$1;
                this.$initialReferences = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        });
        if (!primaryAction.element) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)listBuilder), (Location)context.getLocation((UElement)listBuilder), (String)"A slice should have a primary action set on one of its rows", null, (int)16, null);
            return;
        }
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        boolean bl2 = false;
        List endActionItems = new ArrayList();
        method.accept((UastVisitor)new DataFlowAnalyzer(this, (Ref.BooleanRef)primaryAction, endActionItems, (Ref.IntRef)rowCount, context, listBuilder, CollectionsKt.listOf((Object)listBuilder)){
            final /* synthetic */ SliceDetector this$0;
            final /* synthetic */ Ref.BooleanRef $primaryAction;
            final /* synthetic */ List $endActionItems;
            final /* synthetic */ Ref.IntRef $rowCount;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ UCallExpression $listBuilder;

            public void receiver(@NotNull UCallExpression call) {
                block3: {
                    String type;
                    String methodName;
                    block2: {
                        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                        methodName = call.getMethodName();
                        if (!Intrinsics.areEqual((Object)call.getMethodName(), (Object)"setPrimaryAction")) break block2;
                        this.$primaryAction.element = true;
                        break block3;
                    }
                    if (!Intrinsics.areEqual((Object)methodName, (Object)"addAction")) break block3;
                    List arguments = call.getValueArguments();
                    if (arguments.isEmpty()) {
                        return;
                    }
                    UExpression first = (UExpression)arguments.get(0);
                    PsiType psiType = first.getExpressionType();
                    String string = type = psiType != null ? psiType.getCanonicalText() : null;
                    if (Intrinsics.areEqual((Object)type, (Object)"androidx.slice.builders.SliceAction")) {
                        this.$endActionItems.add(first);
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$primaryAction = $captured_local_variable$1;
                this.$endActionItems = $captured_local_variable$2;
                this.$rowCount = $captured_local_variable$3;
                this.$context = $captured_local_variable$4;
                this.$listBuilder = $captured_local_variable$5;
                super($super_call_param$6, null, 2, null);
            }
        });
        this.ensureSingleToggleType(endActionItems, context, "A mixture of slice actions and icons are not supported on a list, add either actions or icons but not both");
    }

    private final boolean isAddRowMethod(String methodName) {
        return Intrinsics.areEqual((Object)methodName, (Object)"addRow") || Intrinsics.areEqual((Object)methodName, (Object)"addInputRange") || Intrinsics.areEqual((Object)methodName, (Object)"addRange") || Intrinsics.areEqual((Object)methodName, (Object)"addGridRow");
    }

    private final void ensureSingleToggleType(List<UExpression> endActionItems, JavaContext context, String message2) {
        if (endActionItems.size() >= 2) {
            UExpression custom = null;
            UExpression uExpression = null;
            for (UExpression action : endActionItems) {
                PsiMethod constructorMethod;
                UCallExpression constructorCall;
                if (this.findSliceActionConstructor((UElement)action) == null) {
                    continue;
                }
                if (constructorCall.resolve() == null) {
                    continue;
                }
                if (this.isCustomToggle(constructorMethod)) {
                    custom = action;
                } else {
                    uExpression = action;
                }
                if (custom == null || uExpression == null) continue;
                Location location = Location.withSecondary$default((Location)context.getLocation((UElement)custom), (Location)context.getLocation((UElement)uExpression), (String)"Conflicting action type here", (boolean)false, (int)4, null);
                JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)custom), (Location)location, (String)message2, null, (int)16, null);
                break;
            }
        }
    }

    private final List<UCallExpression> findRows(UCallExpression node, UMethod method) {
        boolean bl = false;
        List rows = new ArrayList();
        method.accept((UastVisitor)new DataFlowAnalyzer(this, rows, node, CollectionsKt.listOf((Object)node)){
            final /* synthetic */ SliceDetector this$0;
            final /* synthetic */ List $rows;
            final /* synthetic */ UCallExpression $node;

            /*
             * Unable to fully structure code
             */
            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                block9: {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                    if (!UastExpressionUtils.isConstructorCall((UElement)((UElement)call))) break block9;
                    v0 = call.resolve();
                    if (v0 == null || (v0 = v0.getContainingClass()) == null || (v0 = v0.getQualifiedName()) == null) {
                        return;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"call.resolve()?.containi\u2026?.qualifiedName ?: return");
                    var4_4 = qualifiedName = v0;
                    switch (var4_4.hashCode()) {
                        case -715879516: {
                            if (!var4_4.equals("androidx.slice.builders.ListBuilder.RangeBuilder")) break;
                            ** GOTO lbl27
                        }
                        case 991555848: {
                            if (!var4_4.equals("androidx.slice.builders.ListBuilder.HeaderBuilder")) break;
                            ** GOTO lbl27
                        }
                        case -631842329: {
                            if (!var4_4.equals("androidx.slice.builders.ListBuilder.RowBuilder")) break;
                            ** GOTO lbl27
                        }
                        case 1661209095: {
                            if (!var4_4.equals("androidx.slice.builders.GridRowBuilder.CellBuilder")) break;
                            ** GOTO lbl27
                        }
                        case 1064244290: {
                            if (!var4_4.equals("androidx.slice.builders.ListBuilder.InputRangeBuilder")) break;
                            ** GOTO lbl27
                        }
                        case 324114748: {
                            if (!var4_4.equals("androidx.slice.builders.GridRowBuilder")) break;
lbl27:
                            // 6 sources

                            this.$rows.add(call);
                            break;
                        }
                    }
                }
            }

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                if (SliceDetector.access$isBuildConsumer(this.this$0, call)) {
                    this.$rows.add(call);
                }
                if (SliceDetector.access$isAddRowMethod(this.this$0, Lint.getMethodName((UCallExpression)call))) {
                    UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)call.getValueArguments());
                    if (uExpression != null) {
                        UExpression uExpression2 = uExpression;
                        boolean bl = false;
                        boolean bl2 = false;
                        UExpression it = uExpression2;
                        boolean bl3 = false;
                        if (it instanceof UCallExpression) {
                            this.argument((UCallExpression)it, (UElement)it);
                        } else if (it instanceof UQualifiedReferenceExpression) {
                            UElement curr = (UElement)it;
                            while (curr instanceof UQualifiedReferenceExpression) {
                                if (((UQualifiedReferenceExpression)curr).getReceiver() instanceof UQualifiedReferenceExpression) {
                                    curr = (UElement)((UQualifiedReferenceExpression)curr).getReceiver();
                                    continue;
                                }
                                if (((UQualifiedReferenceExpression)curr).getReceiver() instanceof UCallExpression) {
                                    UExpression uExpression3 = ((UQualifiedReferenceExpression)curr).getReceiver();
                                    if (uExpression3 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                                    }
                                    this.argument((UCallExpression)uExpression3, curr);
                                    return;
                                }
                                if (!(((UQualifiedReferenceExpression)curr).getSelector() instanceof UCallExpression)) break;
                                UExpression uExpression4 = ((UQualifiedReferenceExpression)curr).getSelector();
                                if (uExpression4 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                                }
                                this.argument((UCallExpression)uExpression4, curr);
                                return;
                            }
                        }
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$rows = $captured_local_variable$1;
                this.$node = $captured_local_variable$2;
                super($super_call_param$3, null, 2, null);
            }
        });
        return rows;
    }

    private final boolean isBuildConsumer(UCallExpression call) {
        if (call.getValueArgumentCount() != 1) {
            return false;
        }
        PsiMethod psiMethod = call.resolve();
        if (psiMethod == null) {
            return false;
        }
        PsiMethod calledMethod = psiMethod;
        PsiParameterList psiParameterList = calledMethod.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"calledMethod.parameterList");
        Object[] objectArray = psiParameterList.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"calledMethod.parameterList.parameters");
        PsiParameter psiParameter = (PsiParameter)ArraysKt.firstOrNull((Object[])objectArray);
        if (psiParameter == null) {
            return false;
        }
        PsiParameter arg = psiParameter;
        PsiType psiType = arg.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"arg.type");
        String string = psiType.getCanonicalText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"arg.type.canonicalText");
        String type = string;
        return StringsKt.startsWith$default((String)type, (String)"androidx.core.util.Consumer<", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)type, (String)"Builder>", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isContentMethod(String methodName) {
        String string = methodName;
        switch (string.hashCode()) {
            case 1116025060: {
                if (!string.equals("setSummary")) return false;
                return true;
            }
            case 300673709: {
                if (!string.equals("addEndItem")) return false;
                return true;
            }
            case -596682935: {
                if (!string.equals("setTitleItem")) return false;
                return true;
            }
            case 290558358: {
                if (!string.equals("setPrimaryAction")) return false;
                return true;
            }
            case -1148585618: {
                if (!string.equals("addText")) return false;
                return true;
            }
            case -1256358598: {
                if (!string.equals("addImage")) return false;
                return true;
            }
            case 1405084438: {
                if (!string.equals("setTitle")) return false;
                return true;
            }
            case -71177574: {
                if (!string.equals("setSubtitle")) return false;
                return true;
            }
            case 1481751836: {
                if (!string.equals("setSummarySubtitle")) return false;
                return true;
            }
            case 2021309444: {
                if (!string.equals("addTitleText")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkHasContent(String qualifiedName, JavaContext context, UCallExpression node, UMethod method) {
        void hasContent;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        method.accept((UastVisitor)new DataFlowAnalyzer(this, (Ref.BooleanRef)hasContent, node, CollectionsKt.listOf((Object)node)){
            final /* synthetic */ SliceDetector this$0;
            final /* synthetic */ Ref.BooleanRef $hasContent;
            final /* synthetic */ UCallExpression $node;

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                String string = call.getMethodName();
                if (string == null) {
                    return;
                }
                String methodName = string;
                if (SliceDetector.access$isContentMethod(this.this$0, methodName)) {
                    this.$hasContent.element = true;
                }
            }
            {
                this.this$0 = this$0;
                this.$hasContent = $captured_local_variable$1;
                this.$node = $captured_local_variable$2;
                super($super_call_param$3, null, 2, null);
            }
        });
        if (!hasContent.element) {
            String string = qualifiedName;
            int n = StringsKt.lastIndexOf$default((CharSequence)qualifiedName, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String name = string3;
            this.warnMissingContent(name, context, node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRowBuilder(JavaContext context, UCallExpression node, UMethod method) {
        void endActionItem;
        void endIconItem;
        void timestamp;
        void hasContent;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        boolean bl = false;
        List endActionItems = new ArrayList();
        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
        objectRef3.element = null;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        method.accept((UastVisitor)new DataFlowAnalyzer(this, (Ref.BooleanRef)hasContent, (Ref.ObjectRef)timestamp, context, (Ref.ObjectRef)endIconItem, (Ref.ObjectRef)endActionItem, endActionItems, node, CollectionsKt.listOf((Object)node)){
            final /* synthetic */ SliceDetector this$0;
            final /* synthetic */ Ref.BooleanRef $hasContent;
            final /* synthetic */ Ref.ObjectRef $timestamp;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ Ref.ObjectRef $endIconItem;
            final /* synthetic */ Ref.ObjectRef $endActionItem;
            final /* synthetic */ List $endActionItems;
            final /* synthetic */ UCallExpression $node;

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                String string = call.getMethodName();
                if (string == null) {
                    return;
                }
                String methodName = string;
                if (Intrinsics.areEqual((Object)methodName, (Object)"addEndItem") || Intrinsics.areEqual((Object)methodName, (Object)"setTitleItem")) {
                    String type;
                    this.$hasContent.element = true;
                    List arguments = call.getValueArguments();
                    if (arguments.isEmpty()) {
                        return;
                    }
                    UExpression first = (UExpression)arguments.get(0);
                    PsiType psiType = first.getExpressionType();
                    String string2 = type = psiType != null ? psiType.getCanonicalText() : null;
                    if (arguments.size() == 1 && Intrinsics.areEqual((Object)type, (Object)"long")) {
                        if ((UCallExpression)this.$timestamp.element != null) {
                            Location location = this.$context.getLocation((UElement)call);
                            UCallExpression uCallExpression = (UCallExpression)this.$timestamp.element;
                            if (uCallExpression == null) {
                                Intrinsics.throwNpe();
                            }
                            Location location2 = Location.withSecondary$default((Location)location, (Location)this.$context.getLocation((UElement)uCallExpression), (String)"Earlier timestamp here", (boolean)false, (int)4, null);
                            JavaContext.report$default((JavaContext)this.$context, (Issue)SliceDetector.ISSUE, (UElement)((UElement)call), (Location)location2, (String)"`RowBuilder` can only have one timestamp added to it, remove one of your timestamps", null, (int)16, null);
                        } else {
                            this.$timestamp.element = call;
                        }
                    } else if (Intrinsics.areEqual((Object)type, (Object)"androidx.slice.builders.SliceAction")) {
                        if ((UCallExpression)this.$endIconItem.element != null) {
                            Location location = this.$context.getLocation((UElement)call);
                            UCallExpression uCallExpression = (UCallExpression)this.$endIconItem.element;
                            if (uCallExpression == null) {
                                Intrinsics.throwNpe();
                            }
                            Location location3 = Location.withSecondary$default((Location)location, (Location)this.$context.getLocation((UElement)uCallExpression), (String)"Earlier icon here", (boolean)false, (int)4, null);
                            JavaContext.report$default((JavaContext)this.$context, (Issue)SliceDetector.ISSUE, (UElement)((UElement)call), (Location)location3, (String)"`RowBuilder` cannot have a mixture of icons and slice actions added to the end items", null, (int)16, null);
                        }
                        this.$endActionItem.element = call;
                        this.$endActionItems.add(first);
                    } else if (Intrinsics.areEqual((Object)type, (Object)"android.graphics.drawable.Icon") || Intrinsics.areEqual((Object)type, (Object)"androidx.core.graphics.drawable.IconCompat") || Intrinsics.areEqual((Object)type, (Object)"android.support.v4.graphics.drawable.IconCompat")) {
                        if ((UCallExpression)this.$endActionItem.element != null) {
                            Location location = this.$context.getLocation((UElement)call);
                            UCallExpression uCallExpression = (UCallExpression)this.$endActionItem.element;
                            if (uCallExpression == null) {
                                Intrinsics.throwNpe();
                            }
                            Location location4 = Location.withSecondary$default((Location)location, (Location)this.$context.getLocation((UElement)uCallExpression), (String)"Earlier slice action here", (boolean)false, (int)4, null);
                            JavaContext.report$default((JavaContext)this.$context, (Issue)SliceDetector.ISSUE, (UElement)((UElement)call), (Location)location4, (String)"`RowBuilder` cannot have a mixture of icons and slice actions added to the end items", null, (int)16, null);
                        }
                        this.$endIconItem.element = call;
                    }
                } else if (SliceDetector.access$isContentMethod(this.this$0, methodName)) {
                    this.$hasContent.element = true;
                }
            }
            {
                this.this$0 = this$0;
                this.$hasContent = $captured_local_variable$1;
                this.$timestamp = $captured_local_variable$2;
                this.$context = $captured_local_variable$3;
                this.$endIconItem = $captured_local_variable$4;
                this.$endActionItem = $captured_local_variable$5;
                this.$endActionItems = $captured_local_variable$6;
                this.$node = $captured_local_variable$7;
                super($super_call_param$8, null, 2, null);
            }
        });
        String message2 = "`RowBuilder` should not have a mixture of default and custom toggles";
        this.ensureSingleToggleType(endActionItems, context, message2);
        if (!hasContent.element) {
            this.warnMissingContent("RowBuilder", context, node);
        }
    }

    private final void warnMissingContent(String builder, JavaContext context, UCallExpression node) {
        JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)('`' + builder + "` should have a piece of content added to it"), null, (int)16, null);
    }

    private final boolean isCustomToggle(PsiMethod method) {
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        return psiParameterList.getParametersCount() == 3;
    }

    private final UCallExpression findSliceActionConstructor(UElement node) {
        if (node instanceof UReferenceExpression) {
            PsiElement psiElement = ((UReferenceExpression)node).resolve();
            if (psiElement == null) {
                return null;
            }
            PsiElement resolved = psiElement;
            if (resolved instanceof ULocalVariable) {
                UExpression uExpression = ((ULocalVariable)resolved).getUastInitializer();
                if (uExpression == null) {
                    return null;
                }
                UExpression initializer = uExpression;
                return this.findSliceActionConstructor((UElement)initializer);
            }
            if (resolved instanceof PsiLocalVariable) {
                UExpression uExpression = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, node);
                if (uExpression == null) {
                    return null;
                }
                UExpression initializer = uExpression;
                return this.findSliceActionConstructor((UElement)initializer);
            }
        } else if (node instanceof UCallExpression && UastExpressionUtils.isConstructorCall((UElement)node)) {
            String name;
            PsiMethod psiMethod = ((UCallExpression)node).resolve();
            String string = psiMethod != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : (name = null);
            if (Intrinsics.areEqual((Object)name, (Object)SLICE_ACTION_CLASS)) {
                return (UCallExpression)node;
            }
        }
        return null;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(SliceDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 6;
        String string = null;
        Category category = Category.CORRECTNESS;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"Slices", (String)"Slices", (String)"\n            This check analyzes usages of the Slices API and offers suggestions based\n            on best practices.\n            ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    public static final /* synthetic */ boolean access$isAddRowMethod(SliceDetector $this, String methodName) {
        return $this.isAddRowMethod(methodName);
    }

    public static final /* synthetic */ boolean access$isBuildConsumer(SliceDetector $this, UCallExpression call) {
        return $this.isBuildConsumer(call);
    }

    public static final /* synthetic */ boolean access$isContentMethod(SliceDetector $this, String methodName) {
        return $this.isContentMethod(methodName);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/SliceDetector$Companion;", "", "()V", "CATEGORY_SLICE", "", "GRID_ROW_BUILDER_CLASS", "GRID_ROW_CELL_BUILDER_CLASS", "ICON_CLASS", "ICON_COMPAT_CLASS_1", "ICON_COMPAT_CLASS_2", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "LIST_BUILDER_CLASS", "LIST_HEADER_BUILDER_CLASS", "LIST_INPUT_RANGE_BUILDER_CLASS", "LIST_RANGE_BUILDER_CLASS", "ROW_BUILDER_CLASS", "SLICE_ACTION_CLASS", "SLICE_PROVIDER_CLASS_1", "SLICE_PROVIDER_CLASS_2", "WARN_ABOUT_TOO_MANY_ROWS", "", "isSliceProvider", "provider", "Lorg/w3c/dom/Element;", "lint-checks"})
    public static final class Companion {
        public final boolean isSliceProvider(@NotNull Element provider) {
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            Element intentFilter = XmlUtils.getFirstSubTagByName((Node)provider, (String)"intent-filter");
            while (intentFilter != null) {
                Element category = XmlUtils.getFirstSubTagByName((Node)intentFilter, (String)"category");
                while (category != null) {
                    String name = category.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if (Intrinsics.areEqual((Object)SliceDetector.CATEGORY_SLICE, (Object)name)) {
                        return true;
                    }
                    category = XmlUtils.getNextTagByName((Node)category, (String)"category");
                }
                intentFilter = XmlUtils.getNextTagByName((Node)intentFilter, (String)"intent-filter");
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

