/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebViewDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(WebViewDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"WebViewLayout", (String)"WebViews in wrap_content parents", (String)"Ensures that WebViews are not placed in parents with wrap_content layout", (String)"The WebView implementation has certain performance optimizations which will not work correctly if the parent view is using `wrap_content` rather than `match_parent`. This can lead to subtle UI bugs.", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("WebView");
    }

    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        Node parentNode = element.getParentNode();
        if (parentNode != null && parentNode.getNodeType() == 1) {
            Element parent = (Element)parentNode;
            Attr width = parent.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_width");
            Attr height = parent.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_height");
            Attr attr = null;
            if (width != null && "wrap_content".equals(height.getValue())) {
                attr = width;
            }
            if (height != null && "wrap_content".equals(height.getValue())) {
                attr = height;
            }
            if (attr != null) {
                String message = "Placing a <WebView> in a parent element that uses a wrap_content size can lead to subtle bugs; use match_parent";
                Location location = context.getLocation((Node)element);
                location.setSecondary(context.getLocation((Node)attr));
                context.report(ISSUE, (Node)element, location, message, null);
            }
        }
    }
}

