/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintTomlValue;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastBinaryOperator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u001a2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dJ2\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u00172\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/detector/api/GradleContext;", "Lcom/android/tools/lint/detector/api/Context;", "gradleVisitor", "Lcom/android/tools/lint/client/api/GradleVisitor;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "main", "file", "Ljava/io/File;", "(Lcom/android/tools/lint/client/api/GradleVisitor;Lcom/android/tools/lint/client/api/LintDriver;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/detector/api/Project;Ljava/io/File;)V", "getGradleVisitor", "()Lcom/android/tools/lint/client/api/GradleVisitor;", "getLocation", "Lcom/android/tools/lint/detector/api/Location;", "cookie", "", "getPropertyKeyCookie", "getPropertyPairCookie", "getTomlValue", "Lcom/android/tools/lint/client/api/LintTomlValue;", "key", "", "source", "", "", "isSuppressedWithComment", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "report", "", "location", "message", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "Companion", "lint-api"})
public class GradleContext
extends Context {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GradleVisitor gradleVisitor;
    private static final Pattern DIGITS = Pattern.compile("\\d+");

    public GradleContext(@NotNull GradleVisitor gradleVisitor, @NotNull LintDriver driver, @NotNull Project project, @Nullable Project main, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)gradleVisitor, (String)"gradleVisitor");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(driver, project, main, file, null, 16, null);
        this.gradleVisitor = gradleVisitor;
    }

    @NotNull
    public final GradleVisitor getGradleVisitor() {
        return this.gradleVisitor;
    }

    @NotNull
    public final Location getLocation(@NotNull Object cookie) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        return this.gradleVisitor.createLocation(this, cookie);
    }

    public final boolean isSuppressedWithComment(@NotNull Object cookie, @NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        int startOffset = this.gradleVisitor.getStartOffset(this, cookie);
        return startOffset >= 0 && this.isSuppressedWithComment(startOffset, issue);
    }

    @Deprecated(message="unused", replaceWith=@ReplaceWith(expression="cookie", imports={}))
    @NotNull
    public final Object getPropertyKeyCookie(@NotNull Object cookie) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        return cookie;
    }

    @Deprecated(message="unused", replaceWith=@ReplaceWith(expression="cookie", imports={}))
    @NotNull
    public final Object getPropertyPairCookie(@NotNull Object cookie) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        return cookie;
    }

    @Nullable
    public LintTomlValue getTomlValue(@NotNull String key, boolean source) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return null;
    }

    public static /* synthetic */ LintTomlValue getTomlValue$default(GradleContext gradleContext, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getTomlValue");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return gradleContext.getTomlValue(string, bl);
    }

    @Nullable
    public LintTomlValue getTomlValue(@NotNull List<String> key, boolean source) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return null;
    }

    public static /* synthetic */ LintTomlValue getTomlValue$default(GradleContext gradleContext, List list2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getTomlValue");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return gradleContext.getTomlValue(list2, bl);
    }

    public final void report(@NotNull Issue issue, @NotNull Object cookie, @NotNull Location location2, @NotNull String message2, @Nullable LintFix fix) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Incident incident = new Incident(issue, cookie, location2, message2, fix);
        LintClient.report$default(this.getDriver().getClient(), this, incident, null, 4, null);
    }

    public static /* synthetic */ void report$default(GradleContext gradleContext, Issue issue, Object object, Location location2, String string, LintFix lintFix, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        gradleContext.report(issue, object, location2, string, lintFix);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0001J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/detector/api/GradleContext$Companion;", "", "()V", "DIGITS", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "appendIntoKotlinString", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "expression", "Lorg/jetbrains/uast/UExpression;", "getIntLiteralValue", "", "value", "", "defaultValue", "getKotlinStringLiteralValue", "getStringLiteralValue", "valueCookie", "isNonNegativeInteger", "", "token", "isStringLiteral", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getStringLiteralValue(@NotNull String value, @NotNull Object valueCookie) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)valueCookie, (String)"valueCookie");
            if (value.length() > 2) {
                if (StringsKt.startsWith$default((CharSequence)value, (char)'\'', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)value, (char)'\'', (boolean)false, (int)2, null)) {
                    return StringsKt.removeSurrounding((String)value, (CharSequence)"'");
                }
                if (StringsKt.startsWith$default((CharSequence)value, (char)'\"', (boolean)false, (int)2, null)) {
                    if (valueCookie instanceof UExpression) {
                        return this.getKotlinStringLiteralValue((UExpression)valueCookie);
                    }
                    if (StringsKt.endsWith$default((CharSequence)value, (char)'\"', (boolean)false, (int)2, null)) {
                        return StringsKt.removeSurrounding((String)value, (CharSequence)"\"");
                    }
                }
                if (valueCookie instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)valueCookie).getOperator(), (Object)UastBinaryOperator.PLUS)) {
                    PsiType psiType = ((UPolyadicExpression)valueCookie).getExpressionType();
                    if (Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)"java.lang.String")) {
                        return this.getKotlinStringLiteralValue((UExpression)valueCookie);
                    }
                }
            }
            return null;
        }

        private final String getKotlinStringLiteralValue(UExpression expression) {
            PsiElement psiElement = expression.getSourcePsi();
            if (psiElement == null) {
                return StringsKt.removeSurrounding((String)expression.asSourceString(), (CharSequence)"\"");
            }
            PsiElement sourcePsi = psiElement;
            String text = sourcePsi.getText();
            if (expression instanceof ULiteralExpression) {
                Object value = ((ULiteralExpression)expression).getValue();
                if (value instanceof String) {
                    return (String)value;
                }
            } else if (expression instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)expression).getOperator(), (Object)UastBinaryOperator.PLUS)) {
                StringBuilder sb = new StringBuilder();
                for (UExpression part : ((UPolyadicExpression)expression).getOperands()) {
                    this.appendIntoKotlinString(sb, part);
                }
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                return string;
            }
            Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
            return text;
        }

        private final void appendIntoKotlinString(StringBuilder sb, UExpression expression) {
            if (expression instanceof ULiteralExpression && ((ULiteralExpression)expression).getValue() instanceof String) {
                Object object = ((ULiteralExpression)expression).getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                sb.append((String)object);
            } else if (expression instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)expression).getOperator(), (Object)UastBinaryOperator.PLUS)) {
                for (UExpression part : ((UPolyadicExpression)expression).getOperands()) {
                    this.appendIntoKotlinString(sb, part);
                }
            } else if (expression instanceof UParenthesizedExpression) {
                this.appendIntoKotlinString(sb, ((UParenthesizedExpression)expression).getExpression());
            } else {
                String constant = ConstantEvaluator.evaluateString(null, (UElement)expression, false);
                if (constant != null) {
                    sb.append(constant);
                } else {
                    sb.append("${");
                    sb.append(this.getKotlinStringLiteralValue(expression));
                    sb.append("}");
                }
            }
        }

        public final int getIntLiteralValue(@NotNull String value, int defaultValue) {
            int n;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                n = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                n = defaultValue;
            }
            return n;
        }

        public final boolean isNonNegativeInteger(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return DIGITS.matcher(token).matches();
        }

        public final boolean isStringLiteral(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return StringsKt.startsWith$default((String)token, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)token, (String)"\"", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)token, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)token, (String)"'", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

