/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u001c\u001dB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0010J\"\u0010\u0015\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u0019\u001a\u00020\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/client/api/ClassEntry;", "", "file", "Ljava/io/File;", "jarFile", "binDir", "bytes", "", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;[B)V", "getBinDir", "()Ljava/io/File;", "getBytes", "()[B", "getFile", "getJarFile", "compareTo", "", "other", "path", "", "toString", "visit", "Lorg/objectweb/asm/tree/ClassNode;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "flags", "Lorg/objectweb/asm/ClassVisitor;", "visitor", "Companion", "SuperclassVisitor", "lint-api"})
public final class ClassEntry
implements Comparable<ClassEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @Nullable
    private final File jarFile;
    @NotNull
    private final File binDir;
    @NotNull
    private final byte[] bytes;

    public ClassEntry(@NotNull File file, @Nullable File jarFile, @NotNull File binDir, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)binDir, (String)"binDir");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.file = file;
        this.jarFile = jarFile;
        this.binDir = binDir;
        this.bytes = bytes;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Nullable
    public final File getJarFile() {
        return this.jarFile;
    }

    @NotNull
    public final File getBinDir() {
        return this.binDir;
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    @NotNull
    public final String path() {
        Object object;
        if (this.jarFile != null) {
            object = this.jarFile.getPath() + ":" + this.file.getPath();
        } else {
            String string = this.file.getPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n      file.path\n    }");
        }
        return object;
    }

    @Override
    public int compareTo(@NotNull ClassEntry other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String p1 = this.file.getPath();
        String p2 = other.file.getPath();
        int m1 = p1.length();
        int m2 = p2.length();
        if (m1 == m2 && Intrinsics.areEqual((Object)p1, (Object)p2)) {
            return 0;
        }
        int m = Math.min(m1, m2);
        for (int i = 0; i < m; ++i) {
            char c2;
            char c1 = p1.charAt(i);
            if (c1 == (c2 = p2.charAt(i))) continue;
            return c1 == '.' ? -1 : (c2 == '.' ? 1 : c1 - c2);
        }
        return m == m1 ? -1 : 1;
    }

    @NotNull
    public String toString() {
        String string = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        return string;
    }

    @Nullable
    public final ClassNode visit(@NotNull LintClient client, int flags) {
        ClassVisitor classVisitor;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        File file = this.jarFile;
        if (file == null) {
            file = this.file;
        }
        return (classVisitor = Companion.visit(client, file, this.file.getPath(), this.bytes, (ClassVisitor)new ClassNode(), flags)) instanceof ClassNode ? (ClassNode)classVisitor : null;
    }

    public static /* synthetic */ ClassNode visit$default(ClassEntry classEntry, LintClient lintClient, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return classEntry.visit(lintClient, n);
    }

    @Nullable
    public final ClassVisitor visit(@NotNull LintClient client, @NotNull ClassVisitor visitor, int flags) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        File file = this.jarFile;
        if (file == null) {
            file = this.file;
        }
        return Companion.visit(client, file, this.file.getPath(), this.bytes, visitor, flags);
    }

    public static /* synthetic */ ClassVisitor visit$default(ClassEntry classEntry, LintClient lintClient, ClassVisitor classVisitor, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return classEntry.visit(lintClient, classVisitor, n);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J,\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J&\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J(\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ6\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fJ\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fJ\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001c2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fJ<\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00062\b\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u001e2\b\b\u0002\u0010#\u001a\u00020$\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/client/api/ClassEntry$Companion;", "", "()V", "addClassFiles", "", "dir", "Ljava/io/File;", "classFiles", "", "addEntries", "client", "Lcom/android/tools/lint/client/api/LintClient;", "entries", "Lcom/android/tools/lint/client/api/ClassEntry;", "classPath", "", "addSuperClasses", "visitor", "Lcom/android/tools/lint/client/api/ClassEntry$SuperclassVisitor;", "createSuperClassMap", "", "", "libraryEntries", "classEntries", "fromClassFiles", "classFolders", "fromClassPath", "fromLazyClassPath", "", "visit", "Lorg/objectweb/asm/ClassVisitor;", "file", "relative", "bytes", "", "flags", "", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ClassEntry> fromClassPath(@NotNull LintClient client, @NotNull List<? extends File> classPath) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(classPath, (String)"classPath");
            if (!((Collection)classPath).isEmpty()) {
                void var3_3;
                List libraryEntries = new ArrayList(64);
                this.addEntries(client, libraryEntries, classPath);
                CollectionsKt.sort((List)libraryEntries);
                list2 = var3_3;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        @NotNull
        public final List<ClassEntry> fromClassFiles(@NotNull LintClient client, @NotNull List<? extends File> classFiles, @NotNull List<? extends File> classFolders) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(classFiles, (String)"classFiles");
            Intrinsics.checkNotNullParameter(classFolders, (String)"classFolders");
            List entries = new ArrayList(classFiles.size());
            if (!((Collection)classFolders).isEmpty()) {
                for (File file : classFiles) {
                    String path2 = file.getPath();
                    if (!file.isFile()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                    if (!StringsKt.endsWith$default((String)path2, (String)".class", (boolean)false, (int)2, null)) continue;
                    try {
                        byte[] bytes = client.readBytes(file);
                        for (File file2 : classFolders) {
                            String string = file2.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dir.path");
                            if (!StringsKt.startsWith$default((String)path2, (String)string, (boolean)false, (int)2, null)) continue;
                            entries.add(new ClassEntry(file, null, file2, bytes));
                        }
                    }
                    catch (IOException e) {
                        client.log(e, null, new Object[0]);
                    }
                }
                if (!((Collection)entries).isEmpty()) {
                    CollectionsKt.sort((List)entries);
                }
            }
            return entries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void addEntries(LintClient client, List<ClassEntry> entries, List<? extends File> classPath) {
            for (File file : classPath) {
                Object[] objectArray;
                String name = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                if (StringsKt.endsWith$default((String)name, (String)".jar", (boolean)false, (int)2, null)) {
                    Object object;
                    if (!file.exists()) continue;
                    try {
                        objectArray = (Object[])new ZipFile(file);
                        object = null;
                        try {
                            ZipFile jar = (ZipFile)objectArray;
                            boolean bl = false;
                            Enumeration<? extends ZipEntry> enumeration = jar.entries();
                            while (enumeration.hasMoreElements()) {
                                ZipEntry entry = enumeration.nextElement();
                                String string = entry.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                                if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                                try {
                                    Closeable closeable = jar.getInputStream(entry);
                                    Throwable throwable = null;
                                    try {
                                        InputStream stream = (InputStream)closeable;
                                        boolean bl2 = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
                                        byte[] bytes = ByteStreamsKt.readBytes((InputStream)stream);
                                        File file2 = new File(entry.getName());
                                        boolean bl3 = entries.add(new ClassEntry(file2, file, file, bytes));
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                    }
                                }
                                catch (Throwable e) {
                                    client.log(e, null, new Object[0]);
                                }
                            }
                            jar = Unit.INSTANCE;
                        }
                        catch (Throwable jar) {
                            object = jar;
                            throw jar;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)objectArray, (Throwable)object);
                        }
                    }
                    catch (IOException e) {
                        object = new Object[]{file};
                        client.log(e, "Could not read jar file contents from %1$s", (Object[])object);
                    }
                    continue;
                }
                if (file.isDirectory()) {
                    List classFiles = new ArrayList();
                    this.addClassFiles(file, classFiles);
                    for (File file3 : classFiles) {
                        try {
                            byte[] bytes = client.readBytes(file3);
                            entries.add(new ClassEntry(file3, null, file, bytes));
                        }
                        catch (IOException e) {
                            client.log(e, null, new Object[0]);
                        }
                    }
                    continue;
                }
                if (StringsKt.endsWith$default((String)name, (String)".srcjar", (boolean)false, (int)2, null)) continue;
                objectArray = new Object[]{file};
                client.log(null, "Ignoring class path entry %1$s", objectArray);
            }
        }

        private final void addClassFiles(File dir, List<File> classFiles) {
            File[] fileArray = dir.listFiles();
            if (fileArray == null) {
                return;
            }
            File[] files = fileArray;
            if (!(files.length == 0)) {
                for (File file : files) {
                    if (file.isFile()) {
                        String string = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                        if (StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) {
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                            classFiles.add(file);
                            continue;
                        }
                    }
                    if (!file.isDirectory()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    this.addClassFiles(file, classFiles);
                }
            }
        }

        @NotNull
        public final Iterator<ClassEntry> fromLazyClassPath(@NotNull LintClient client, @NotNull List<? extends File> classPath) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(classPath, (String)"classPath");
            if (classPath.isEmpty()) {
                Iterator<ClassEntry> iterator = Collections.emptyIterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"emptyIterator()");
                return iterator;
            }
            Sequence lazySequence2 = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super ClassEntry>, Continuation<? super Unit>, Object>(classPath, client, null){
                Object L$1;
                Object L$2;
                Object L$3;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ List<File> $classPath;
                final /* synthetic */ LintClient $client;
                {
                    this.$classPath = $classPath;
                    this.$client = $client;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    block11: {
                        block12: {
                            var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            block2 : switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $this$sequence = (SequenceScope)this.L$0;
                                    var3_4 = this.$classPath.iterator();
lbl7:
                                    // 6 sources

                                    while (var3_4.hasNext()) {
                                        classPathEntry = (File)var3_4.next();
                                        path = classPathEntry.getPath();
                                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                                        if (!StringsKt.endsWith$default((String)path, (String)".jar", (boolean)false, (int)2, null) || !classPathEntry.isFile()) break block2;
                                        zipClassEntries = ClassEntry.Companion.fromClassPath(this.$client, CollectionsKt.listOf((Object)classPathEntry));
                                        this.L$0 = $this$sequence;
                                        this.L$1 = var3_4;
                                        this.L$2 = null;
                                        this.L$3 = null;
                                        this.label = 1;
                                        v0 = $this$sequence.yieldAll((Iterable)zipClassEntries, (Continuation)this);
                                        if (v0 != var11_2) continue;
                                        return var11_2;
                                    }
                                    break block11;
                                }
                                case 1: {
                                    var3_4 = (Iterator)this.L$1;
                                    $this$sequence = (SequenceScope)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
                                    ** GOTO lbl7
                                }
                            }
                            if (!classPathEntry.isDirectory()) break block12;
                            classFiles = new ArrayList<E>(64);
                            com.android.tools.lint.client.api.ClassEntry$Companion.access$addClassFiles(ClassEntry.Companion, classPathEntry, classFiles);
                            CollectionsKt.sort((List)classFiles);
                            var7_8 = classFiles.iterator();
lbl33:
                            // 4 sources

                            while (var7_8.hasNext()) {
                                classFile = (File)var7_8.next();
                                Intrinsics.checkNotNullExpressionValue((Object)classFile, (String)"classFile");
                                bytes = this.$client.readBytes(classFile);
                                classEntry = new ClassEntry(classFile, null, classPathEntry, bytes);
                                this.L$0 = $this$sequence;
                                this.L$1 = var3_4;
                                this.L$2 = classPathEntry;
                                this.L$3 = var7_8;
                                this.label = 2;
                                v1 = $this$sequence.yield((Object)classEntry, (Continuation)this);
                                ** if (v1 != var11_2) goto lbl48
lbl47:
                                // 1 sources

                                return var11_2;
lbl48:
                                // 1 sources

                            }
                            {
                                ** GOTO lbl7
                                case 2: {
                                    var7_8 = (Iterator<E>)this.L$3;
                                    classPathEntry = (File)this.L$2;
                                    var3_4 = (Iterator)this.L$1;
                                    $this$sequence = (SequenceScope)this.L$0;
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
                                    }
                                    catch (IOException e) {
                                        this.$client.log(e, null, new Object[0]);
                                    }
                                    ** GOTO lbl33
                                }
                            }
                        }
                        if (StringsKt.endsWith$default((String)path, (String)".srcjar", (boolean)false, (int)2, null)) ** GOTO lbl7
                        var6_7 = new Object[]{classPathEntry};
                        this.$client.log(null, "Ignoring class path entry %1$s", var6_7);
                        ** GOTO lbl7
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super ClassEntry> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            return SequencesKt.asIterable((Sequence)lazySequence2).iterator();
        }

        @NotNull
        public final Map<String, String> createSuperClassMap(@NotNull LintClient client, @NotNull List<ClassEntry> libraryEntries, @NotNull List<ClassEntry> classEntries) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(libraryEntries, (String)"libraryEntries");
            Intrinsics.checkNotNullParameter(classEntries, (String)"classEntries");
            int size = libraryEntries.size() + classEntries.size();
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)size);
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMapWithExpectedSize(size)");
            Map map = hashMap;
            SuperclassVisitor visitor = new SuperclassVisitor(map);
            this.addSuperClasses(client, visitor, libraryEntries);
            this.addSuperClasses(client, visitor, classEntries);
            return map;
        }

        @NotNull
        public final Map<String, String> createSuperClassMap(@NotNull LintClient client, @NotNull List<ClassEntry> entries) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)entries.size());
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMapWithExpectedSize(entries.size)");
            Map map = hashMap;
            SuperclassVisitor visitor = new SuperclassVisitor(map);
            this.addSuperClasses(client, visitor, entries);
            return map;
        }

        private final void addSuperClasses(LintClient client, SuperclassVisitor visitor, List<ClassEntry> entries) {
            int flags = 7;
            for (ClassEntry entry : entries) {
                entry.visit(client, visitor, flags);
            }
        }

        @Nullable
        public final ClassVisitor visit(@NotNull LintClient client, @NotNull File file, @Nullable String relative, @NotNull byte[] bytes, @NotNull ClassVisitor visitor, int flags) {
            ClassVisitor classVisitor;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            try {
                ClassReader reader = new ClassReader(bytes);
                reader.accept(visitor, flags);
                classVisitor = visitor;
            }
            catch (Throwable t) {
                String message2;
                String string = t.getMessage();
                if (string == null) {
                    string = message2 = t.toString();
                }
                if (relative != null && t instanceof IllegalArgumentException && StringsKt.startsWith$default((String)message2, (String)"Unsupported class file", (boolean)false, (int)2, null) && (StringsKt.startsWith$default((String)relative, (String)"META-INF/versions/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)relative, (String)"META-INF\\versions\\", (boolean)false, (int)2, null))) {
                    return null;
                }
                Object[] objectArray = new Object[2];
                String string2 = relative;
                objectArray[0] = file.getPath() + (String)(string2 != null ? ":" + string2 : "");
                objectArray[1] = message2;
                client.log(null, "Error processing %1$s: broken class file? (%2$s)", objectArray);
                classVisitor = null;
            }
            return classVisitor;
        }

        public static /* synthetic */ ClassVisitor visit$default(Companion companion, LintClient lintClient, File file, String string, byte[] byArray, ClassVisitor classVisitor, int n, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                n = 0;
            }
            return companion.visit(lintClient, file, string, byArray, classVisitor, n);
        }

        public static final /* synthetic */ void access$addClassFiles(Companion $this, File dir, List classFiles) {
            $this.addClassFiles(dir, classFiles);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005JI\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/client/api/ClassEntry$SuperclassVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "map", "", "", "(Ljava/util/Map;)V", "visit", "", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "lint-api"})
    private static final class SuperclassVisitor
    extends ClassVisitor {
        @NotNull
        private final Map<String, String> map;

        public SuperclassVisitor(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(589824);
            this.map = map;
        }

        public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (superName != null && !Intrinsics.areEqual((Object)"java/lang/Object", (Object)superName)) {
                this.map.put(name, superName);
            }
        }
    }
}

