/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.internal.ImplementationUtilsKt;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0007\u001a\u001e\u0010\b\u001a\u00020\t*\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\t\u001a\u001c\u0010\b\u001a\u00020\t*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\t\u001a\n\u0010\r\u001a\u00020\t*\u00020\u000e\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0007\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\u0007\u00a8\u0006\u0012"}, d2={"acceptMultiFileClass", "", "Lorg/jetbrains/uast/UFile;", "visitor", "Lorg/jetbrains/uast/visitor/UastVisitor;", "acceptSourceFile", "findSelector", "Lorg/jetbrains/uast/UElement;", "isBelow", "", "Lcom/intellij/psi/PsiElement;", "parent", "strict", "isReceiver", "Lcom/intellij/psi/PsiParameter;", "nextStatement", "Lorg/jetbrains/uast/UExpression;", "previousStatement", "lint-api"})
public final class UastLintUtilsKt {
    public static final boolean isReceiver(@NotNull PsiParameter $this$isReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$isReceiver, (String)"<this>");
        String string = $this$isReceiver.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        String name = string;
        return StringsKt.startsWith$default((String)name, (String)"$this", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"$self", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final UElement findSelector(@NotNull UElement $this$findSelector) {
        Intrinsics.checkNotNullParameter((Object)$this$findSelector, (String)"<this>");
        UElement curr = $this$findSelector;
        while (true) {
            UElement uElement;
            UElement uElement2;
            if ((uElement2 = curr) instanceof UQualifiedReferenceExpression) {
                uElement = (UElement)((UQualifiedReferenceExpression)curr).getSelector();
            } else {
                if (!(uElement2 instanceof UParenthesizedExpression)) break;
                uElement = (UElement)((UParenthesizedExpression)curr).getExpression();
            }
            curr = uElement;
        }
        return curr;
    }

    @Nullable
    public static final UExpression nextStatement(@NotNull UElement $this$nextStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$nextStatement, (String)"<this>");
        UElement prev = $this$nextStatement;
        for (UElement curr = prev.getUastParent(); curr != null; curr = curr.getUastParent()) {
            if (curr instanceof UBlockExpression) {
                List expressions = ((UBlockExpression)curr).getExpressions();
                int index = CollectionsKt.indexOf((List)expressions, (Object)prev);
                return index != -1 && index < expressions.size() - 1 ? (UExpression)expressions.get(index + 1) : (UExpression)null;
            }
            prev = curr;
        }
        return null;
    }

    @Nullable
    public static final UExpression previousStatement(@NotNull UElement $this$previousStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$previousStatement, (String)"<this>");
        UElement prev = $this$previousStatement;
        for (UElement curr = prev.getUastParent(); curr != null; curr = curr.getUastParent()) {
            if (curr instanceof UBlockExpression) {
                List expressions = ((UBlockExpression)curr).getExpressions();
                int index = CollectionsKt.indexOf((List)expressions, (Object)prev);
                return index > 0 ? (UExpression)expressions.get(index - 1) : (UExpression)null;
            }
            prev = curr;
        }
        return null;
    }

    public static final boolean isBelow(@NotNull UElement $this$isBelow, @NotNull UElement parent, boolean strict) {
        UElement curr;
        Intrinsics.checkNotNullParameter((Object)$this$isBelow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        UElement uElement = curr = strict ? $this$isBelow.getUastParent() : $this$isBelow;
        while (curr != null) {
            if (Intrinsics.areEqual((Object)curr, (Object)parent)) {
                return true;
            }
            curr = curr.getUastParent();
        }
        return false;
    }

    public static /* synthetic */ boolean isBelow$default(UElement uElement, UElement uElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UastLintUtilsKt.isBelow(uElement, uElement2, bl);
    }

    public static final boolean isBelow(@Nullable PsiElement $this$isBelow, @NotNull PsiElement parent, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if ($this$isBelow == null) {
            return false;
        }
        return PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)$this$isBelow, (boolean)strict);
    }

    public static /* synthetic */ boolean isBelow$default(PsiElement psiElement, PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UastLintUtilsKt.isBelow(psiElement, psiElement2, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void acceptSourceFile(@NotNull UFile $this$acceptSourceFile, @NotNull UastVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)$this$acceptSourceFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        PsiFile sourcePsi = $this$acceptSourceFile.getSourcePsi();
        if (sourcePsi instanceof KtFile) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = ((KtFile)sourcePsi).getAnnotationEntries();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)String.valueOf(it.getShortName()), (Object)"JvmMultifileClass")) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                UastLintUtilsKt.acceptMultiFileClass($this$acceptSourceFile, visitor);
                return;
            }
        }
        $this$acceptSourceFile.accept(visitor);
    }

    private static final void acceptMultiFileClass(UFile $this$acceptMultiFileClass, UastVisitor visitor) {
        VirtualFile targetFile = $this$acceptMultiFileClass.getSourcePsi().getVirtualFile();
        if (visitor.visitFile($this$acceptMultiFileClass)) {
            return;
        }
        ImplementationUtilsKt.acceptList((List)$this$acceptMultiFileClass.getUAnnotations(), (UastVisitor)visitor);
        ImplementationUtilsKt.acceptList((List)$this$acceptMultiFileClass.getImports(), (UastVisitor)visitor);
        for (UClass uClass : $this$acceptMultiFileClass.getClasses()) {
            if (visitor.visitClass(uClass)) {
                return;
            }
            ImplementationUtilsKt.acceptList((List)uClass.getUAnnotations(), (UastVisitor)visitor);
            for (UDeclaration declaration : uClass.getUastDeclarations()) {
                VirtualFile declarationFile;
                PsiElement psiElement = declaration.getSourcePsi();
                VirtualFile virtualFile = psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : (declarationFile = null);
                if (declarationFile != null && !Intrinsics.areEqual((Object)declarationFile, (Object)targetFile)) continue;
                declaration.accept(visitor);
            }
            visitor.afterVisitClass(uClass);
        }
        visitor.afterVisitFile($this$acceptMultiFileClass);
    }
}

