/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 X2\u00020\u0001:\u0001XB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u00101\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\n\u00108\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u00109\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u00106\u001a\u000207J\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020\u00152\u0006\u0010<\u001a\u00020=J\u0006\u0010?\u001a\u00020\u0015J\u0016\u0010@\u001a\u00020\u00152\u0006\u0010A\u001a\u00020 2\u0006\u0010<\u001a\u00020=J3\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010E2\b\u0010F\u001a\u0004\u0018\u00010.2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010H\"\u00020\u0001\u00a2\u0006\u0002\u0010IJ\u000e\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020LJ\u0016\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NJ\u0016\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020L2\u0006\u0010O\u001a\u00020PJ,\u0010J\u001a\u00020C2\u0006\u0010<\u001a\u00020=2\u0006\u0010Q\u001a\u0002032\u0006\u0010R\u001a\u00020.2\n\b\u0002\u0010S\u001a\u0004\u0018\u00010TH\u0017J\u001e\u0010U\u001a\u00020C2\u0006\u0010V\u001a\u00020W2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001eR\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0016\u0010-\u001a\u0004\u0018\u00010.8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006Y"}, d2={"Lcom/android/tools/lint/detector/api/Context;", "", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "main", "file", "Ljava/io/File;", "contents", "", "(Lcom/android/tools/lint/client/api/LintDriver;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/detector/api/Project;Ljava/io/File;Ljava/lang/CharSequence;)V", "client", "Lcom/android/tools/lint/client/api/LintClient;", "getClient", "()Lcom/android/tools/lint/client/api/LintClient;", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "getConfiguration", "()Lcom/android/tools/lint/client/api/Configuration;", "containsCommentSuppress", "", "Ljava/lang/Boolean;", "getDriver", "()Lcom/android/tools/lint/client/api/LintDriver;", "forbidMainAccess", "getForbidMainAccess", "()Z", "mainProject", "getMainProject", "()Lcom/android/tools/lint/detector/api/Project;", "phase", "", "getPhase", "()I", "getProject", "scope", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "getScope", "()Ljava/util/EnumSet;", "sdkInfo", "Lcom/android/tools/lint/client/api/SdkInfo;", "getSdkInfo", "()Lcom/android/tools/lint/client/api/SdkInfo;", "suppressCommentPrefix", "", "getSuppressCommentPrefix", "()Ljava/lang/String;", "findConfiguration", "findNodeInProject", "Lcom/android/tools/lint/detector/api/Location;", "node", "Lorg/w3c/dom/Node;", "type", "Lcom/android/tools/lint/detector/api/LocationType;", "getContents", "getLocation", "getPartialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "isEnabled", "isGlobalAnalysis", "isSuppressedWithComment", "startOffset", "log", "", "exception", "", "format", "args", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "report", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "constraint", "Lcom/android/tools/lint/detector/api/Constraint;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "location", "message", "quickfixData", "Lcom/android/tools/lint/detector/api/LintFix;", "requestRepeat", "detector", "Lcom/android/tools/lint/detector/api/Detector;", "Companion", "lint-api"})
public class Context {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintDriver driver;
    @NotNull
    private final Project project;
    @Nullable
    private final Project main;
    @JvmField
    @NotNull
    public final File file;
    @Nullable
    private CharSequence contents;
    @NotNull
    private final Configuration configuration;
    @Nullable
    private Boolean containsCommentSuppress;
    @NotNull
    public static final String SUPPRESS_XML_COMMENT_PREFIX = "<!--suppress ";
    @NotNull
    public static final String SUPPRESS_JAVA_COMMENT_PREFIX = "noinspection ";
    @Nullable
    private static Set<String> detectorsWarned;

    public Context(@NotNull LintDriver driver, @NotNull Project project, @Nullable Project main, @NotNull File file, @Nullable CharSequence contents) {
        Configuration configuration;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.driver = driver;
        this.project = project;
        this.main = main;
        this.file = file;
        this.contents = contents;
        Configuration configuration2 = this.getClient().getConfiguration(this.file);
        if (configuration2 == null) {
            Configuration configuration3 = this.project.getConfiguration(this.driver);
            Intrinsics.checkNotNullExpressionValue((Object)configuration3, (String)"project.getConfiguration(driver)");
            configuration = configuration3;
        } else {
            configuration = configuration2;
        }
        this.configuration = configuration;
    }

    public /* synthetic */ Context(LintDriver lintDriver, Project project, Project project2, File file, CharSequence charSequence, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            charSequence = null;
        }
        this(lintDriver, project, project2, file, charSequence);
    }

    @NotNull
    public final LintDriver getDriver() {
        return this.driver;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final EnumSet<Scope> getScope() {
        return this.driver.getScope();
    }

    @NotNull
    public final Project getMainProject() {
        boolean forbidden;
        if (this.getForbidMainAccess() && (forbidden = Companion.checkForbidden("context.getMainProject()", this.file, this.driver))) {
            return this.project;
        }
        Project project = this.main;
        if (project == null) {
            project = this.project;
        }
        return project;
    }

    @NotNull
    public final LintClient getClient() {
        return this.driver.getClient();
    }

    @Nullable
    public CharSequence getContents() {
        if (this.contents == null) {
            this.contents = this.driver.getClient().readFile(this.file);
        }
        return this.contents;
    }

    @NotNull
    public final SdkInfo getSdkInfo() {
        SdkInfo sdkInfo = this.project.getSdkInfo();
        Intrinsics.checkNotNullExpressionValue((Object)sdkInfo, (String)"project.getSdkInfo()");
        return sdkInfo;
    }

    @NotNull
    public final Location getLocation(@Nullable Object node, @NotNull LocationType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (node == null) {
            return Location.NONE;
        }
        Object object = node;
        if (object instanceof UElement) {
            Location location2;
            JavaContext javaContext;
            if (this instanceof JavaContext) {
                javaContext = (JavaContext)this;
            } else {
                File file;
                PsiElement psiElement = ((UElement)node).getSourcePsi();
                if (psiElement == null) {
                    file = null;
                } else {
                    PsiFile psiFile = psiElement.getContainingFile();
                    if (psiFile == null) {
                        file = null;
                    } else {
                        VirtualFile virtualFile = psiFile.getVirtualFile();
                        if (virtualFile == null) {
                            file = null;
                        } else {
                            VirtualFile it = virtualFile;
                            boolean bl = false;
                            file = VfsUtilCore.virtualToIoFile((VirtualFile)it);
                        }
                    }
                }
                File file2 = file;
                File file3 = file2 == null ? this.file : file2;
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"node.sourcePsi?.containi\u2026                } ?: file");
                File file4 = file3;
                javaContext = new JavaContext(this.driver, this.project, this.main, file4);
            }
            JavaContext context2 = javaContext;
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    location2 = context2.getLocation((UElement)node);
                    break;
                }
                case 2: {
                    if (node instanceof UCallExpression) {
                        location2 = context2.getCallLocation((UCallExpression)node, true, true);
                        break;
                    }
                    location2 = context2.getUastParser().getLocation(context2, (UElement)node);
                    break;
                }
                case 3: {
                    location2 = context2.getNameLocation((UElement)node);
                    break;
                }
                case 4: {
                    location2 = context2.getCallLocation((UCallExpression)node, false, true);
                    break;
                }
                case 5: {
                    location2 = context2.getCallLocation((UCallExpression)node, true, false);
                    break;
                }
                case 6: {
                    throw (Throwable)new IllegalStateException(((Object)((Object)type) + " not supported for " + node.getClass()).toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return location2;
        }
        if (object instanceof PsiElement) {
            Location location3;
            JavaContext javaContext;
            if (this instanceof JavaContext) {
                javaContext = (JavaContext)this;
            } else {
                File file;
                PsiFile psiFile = ((PsiElement)node).getContainingFile();
                if (psiFile == null) {
                    file = null;
                } else {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (virtualFile == null) {
                        file = null;
                    } else {
                        VirtualFile it = virtualFile;
                        boolean bl = false;
                        file = VfsUtilCore.virtualToIoFile((VirtualFile)it);
                    }
                }
                File file5 = file;
                File file6 = file5 == null ? this.file : file5;
                Intrinsics.checkNotNullExpressionValue((Object)file6, (String)"node.containingFile?.vir\u2026                } ?: file");
                File file7 = file6;
                javaContext = new JavaContext(this.driver, this.project, this.main, file7);
            }
            JavaContext context3 = javaContext;
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    location3 = context3.getLocation((PsiElement)node);
                    break;
                }
                case 2: {
                    location3 = context3.getLocation((PsiElement)node);
                    break;
                }
                case 3: {
                    location3 = context3.getNameLocation((PsiElement)node);
                    break;
                }
                case 4: 
                case 5: {
                    location3 = context3.getLocation((PsiElement)node);
                    break;
                }
                case 6: {
                    throw (Throwable)new IllegalStateException(((Object)((Object)type) + " not supported for " + node.getClass()).toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return location3;
        }
        if (object instanceof Node) {
            Location location4;
            XmlContext xmlContext;
            com.android.utils.Pair<File, ? extends Node> source;
            if (this.getClient().isMergeManifestNode((Node)node)) {
                if (Intrinsics.areEqual((Object)((Node)node).getNodeName(), (Object)"application")) {
                    Node node2 = ((Node)node).getParentNode();
                    if (Intrinsics.areEqual((Object)(node2 == null ? null : node2.getNodeName()), (Object)"manifest")) {
                        return this.findNodeInProject((Node)node, type);
                    }
                }
                if ((source = this.getClient().findManifestSourceNode((Node)node)) != null && source.getSecond() != node) {
                    if (Intrinsics.areEqual((Object)source.getFirst(), (Object)this.file)) {
                        return this.getLocation(source.getSecond(), type);
                    }
                    Document doc = ((Node)node).getOwnerDocument();
                    Object object2 = source.getFirst();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"source.first");
                    File file = (File)object2;
                    Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
                    XmlContext xmlContext2 = new XmlContext(this.driver, this.project, this.main, file, null, null, doc);
                    return xmlContext2.getLocation(source.getSecond(), type);
                }
            }
            source = this.file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)source, (String)"file.path");
            if (!StringsKt.endsWith$default(source, (String)".xml", (boolean)false, (int)2, null)) {
                return this.findNodeInProject((Node)node, type);
            }
            if (this instanceof XmlContext) {
                xmlContext = (XmlContext)this;
            } else {
                Document doc = ((Node)node).getOwnerDocument();
                Object object3 = doc.getUserData(File.class.getName());
                Object object4 = object3 instanceof File ? (File)object3 : null;
                if (object4 == null) {
                    File file;
                    Object object5 = doc.getUserData(PsiFile.class.getName());
                    PsiFile psiFile = object5 instanceof PsiFile ? (PsiFile)object5 : null;
                    if (psiFile == null) {
                        file = null;
                    } else {
                        VirtualFile virtualFile = psiFile.getVirtualFile();
                        if (virtualFile == null) {
                            file = null;
                        } else {
                            VirtualFile it = virtualFile;
                            boolean bl = false;
                            file = VfsUtilCore.virtualToIoFile((VirtualFile)it);
                        }
                    }
                    object3 = file;
                    if (object3 == null) {
                        List<File> list2 = this.project.getManifestFiles();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"project.getManifestFiles()");
                        File file8 = (File)CollectionsKt.firstOrNull(list2);
                        if (file8 == null) {
                            file8 = this.project.dir;
                        }
                        File file9 = file8;
                        Intrinsics.checkNotNullExpressionValue((Object)file9, (String)"project.getManifestFiles\u2026stOrNull() ?: project.dir");
                        return Location.Companion.create(file9);
                    }
                    object4 = object3;
                }
                File file = object4;
                Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
                xmlContext = new XmlContext(this.driver, this.project, this.main, file, null, null, doc);
            }
            XmlContext context4 = xmlContext;
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 2: {
                    location4 = context4.getLocation((Node)node);
                    break;
                }
                case 1: {
                    if (node instanceof Element) {
                        location4 = context4.getElementLocation((Element)node);
                        break;
                    }
                    location4 = context4.getLocation((Node)node);
                    break;
                }
                case 3: {
                    location4 = context4.getNameLocation((Node)node);
                    break;
                }
                case 6: {
                    if (node instanceof Attr) {
                        location4 = context4.getValueLocation((Attr)node);
                        break;
                    }
                    location4 = context4.getLocation((Node)node);
                    break;
                }
                case 4: 
                case 5: {
                    throw (Throwable)new IllegalStateException(((Object)((Object)type) + " not supported for " + node.getClass()).toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return location4;
        }
        if (object instanceof ClassNode) {
            if (this instanceof ClassContext) {
                return ((ClassContext)this).getLocation((ClassNode)node);
            }
            throw (Throwable)new IllegalStateException("Can only get ClassNode locations on a ClassContext".toString());
        }
        if (object instanceof AbstractInsnNode) {
            if (this instanceof ClassContext) {
                return ((ClassContext)this).getLocation((AbstractInsnNode)node);
            }
            throw (Throwable)new IllegalStateException("Can only get AbstractInsnNode locations on a ClassContext".toString());
        }
        if (this instanceof GradleContext) {
            return ((GradleContext)this).getLocation(node);
        }
        return Location.Companion.create(this.file);
    }

    public static /* synthetic */ Location getLocation$default(Context context2, Object object, LocationType locationType, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLocation");
        }
        if ((n & 2) != 0) {
            locationType = LocationType.DEFAULT;
        }
        return context2.getLocation(object, locationType);
    }

    /*
     * WARNING - void declaration
     */
    private final Location findNodeInProject(Node node, LocationType type) {
        Element element;
        Object object = node;
        Element element2 = object instanceof Element ? (Element)node : (element = object instanceof Attr ? ((Attr)node).getOwnerElement() : null);
        if (element != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object object2 = new Project[]{this.project};
            Sequence sequence = SequencesKt.sequenceOf((Object[])object2);
            object2 = this.project.allLibraries;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.allLibraries");
            object2 = (Iterable)object2;
            Sequence sequence2 = sequence;
            boolean $i$f$filter = false;
            Iterator<File> iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Project it = (Project)element$iv$iv;
                boolean bl = false;
                if (!(!it.isExternalLibrary())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Sequence projects = SequencesKt.plus((Sequence)sequence2, (Iterable)((List)destination$iv$iv));
            for (Project p : projects) {
                for (File manifest : p.getManifestFiles()) {
                    try {
                        Document document;
                        Node sourceNode;
                        XmlParser xmlParser = this.getClient().getXmlParser();
                        Intrinsics.checkNotNullExpressionValue((Object)manifest, (String)"manifest");
                        if (xmlParser.parseXml(manifest) == null || (sourceNode = (Node)Lint.matchXmlElement(element, document)) == null || sourceNode == element) continue;
                        Document doc = node.getOwnerDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)p, (String)"p");
                        Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
                        XmlContext xmlContext = new XmlContext(this.driver, p, this.main, manifest, null, null, doc);
                        return xmlContext.getLocation(sourceNode, type);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        List<File> list2 = this.project.getManifestFiles();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"project.getManifestFiles()");
        File file = (File)CollectionsKt.firstOrNull(list2);
        if (file == null) {
            file = this.project.dir;
        }
        object = file;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getManifestFiles\u2026stOrNull() ?: project.dir");
        return Location.Companion.create((File)object);
    }

    public final boolean isEnabled(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        return this.configuration.isEnabled(issue);
    }

    @JvmOverloads
    public void report(@NotNull Issue issue, @NotNull Location location2, @NotNull String message2, @Nullable LintFix quickfixData) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Incident incident = new Incident(issue, location2, message2, quickfixData);
        LintClient.report$default(this.driver.getClient(), this, incident, null, 4, null);
    }

    public static /* synthetic */ void report$default(Context context2, Issue issue, Location location2, String string, LintFix lintFix, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 8) != 0) {
            lintFix = null;
        }
        context2.report(issue, location2, string, lintFix);
    }

    public final void report(@NotNull Incident incident) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        LintClient.report$default(this.driver.getClient(), this, incident, null, 4, null);
    }

    public final boolean isGlobalAnalysis() {
        return this.driver.isGlobalAnalysis();
    }

    public final void report(@NotNull Incident incident, @NotNull Constraint constraint2) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)constraint2, (String)"constraint");
        this.getClient().report(this, incident, constraint2);
    }

    public final void report(@NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        this.getClient().report(this, incident, map);
    }

    @NotNull
    public final PartialResult getPartialResults(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        return this.getClient().getPartialResults(this.project, issue);
    }

    @NotNull
    public final Configuration findConfiguration(@NotNull File file) {
        Configuration configuration;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ConfigurationHierarchy configurations = this.driver.getClient().getConfigurations();
        File dir = file.getParentFile();
        Configuration configuration2 = ConfigurationHierarchy.getConfigurationForFolder$default(configurations, dir, null, 2, null);
        if (configuration2 == null) {
            Project project;
            Context $this$findConfiguration_u24lambda_u2d4 = this;
            boolean bl = false;
            Project project2 = project = $this$findConfiguration_u24lambda_u2d4.getDriver().findProjectFor(file);
            Configuration configuration3 = project2 == null ? null : project2.getConfiguration($this$findConfiguration_u24lambda_u2d4.getDriver());
            if (configuration3 == null) {
                configuration3 = $this$findConfiguration_u24lambda_u2d4.getConfiguration();
            }
            Configuration configuration4 = configuration3;
            Intrinsics.checkNotNullExpressionValue((Object)configuration4, (String)"project?.getConfiguration(driver) ?: configuration");
            configuration = configuration4;
        } else {
            configuration = configuration2;
        }
        return configuration;
    }

    public final void log(@Nullable Throwable exception, @Nullable String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.driver.getClient().log(exception, format, Arrays.copyOf(args, args.length));
    }

    public final int getPhase() {
        return this.driver.getPhase();
    }

    public final void requestRepeat(@NotNull Detector detector, @Nullable EnumSet<Scope> scope) {
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        this.driver.requestRepeat(detector, scope);
    }

    @Nullable
    protected String getSuppressCommentPrefix() {
        String path2 = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        if (StringsKt.endsWith$default((String)path2, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".gradle", (boolean)false, (int)2, null)) {
            return SUPPRESS_JAVA_COMMENT_PREFIX;
        }
        if (StringsKt.endsWith$default((String)path2, (String)".xml", (boolean)false, (int)2, null)) {
            return SUPPRESS_XML_COMMENT_PREFIX;
        }
        if (StringsKt.endsWith$default((String)path2, (String)".cfg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".pro", (boolean)false, (int)2, null)) {
            return "#suppress ";
        }
        return null;
    }

    public final boolean containsCommentSuppress() {
        if (this.containsCommentSuppress == null) {
            CharSequence contents;
            this.containsCommentSuppress = false;
            String prefix = this.getSuppressCommentPrefix();
            if (prefix != null && (contents = this.getContents()) != null) {
                this.containsCommentSuppress = CharSequences.indexOf((CharSequence)contents, (CharSequence)prefix) != -1;
            }
        }
        Boolean bl = this.containsCommentSuppress;
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    public final boolean isSuppressedWithComment(int startOffset, @NotNull Issue issue) {
        CharSequence contents;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        String string = this.getSuppressCommentPrefix();
        if (string == null) {
            return false;
        }
        String prefix = string;
        if (startOffset <= 0) {
            return false;
        }
        CharSequence charSequence = this.getContents();
        if (charSequence == null) {
            charSequence = "";
        }
        if (startOffset >= (contents = charSequence).length()) {
            return false;
        }
        int lineStart = StringsKt.lastIndexOf$default((CharSequence)contents, (char)'\n', (int)startOffset, (boolean)false, (int)4, null) + 1;
        if (lineStart <= 1) {
            return false;
        }
        int index = Context.Companion.findPrefixOnPreviousLine(contents, lineStart, prefix);
        if (index != -1 && index + prefix.length() < lineStart) {
            String line = ((Object)contents.subSequence(index + prefix.length(), lineStart)).toString();
            return Companion.isSuppressedWithComment(line, issue);
        }
        return false;
    }

    private final boolean getForbidMainAccess() {
        return this.driver.getMode() == LintDriver.DriverMode.ANALYSIS_ONLY;
    }

    @JvmOverloads
    public final void report(@NotNull Issue issue, @NotNull Location location2, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Context.report$default(this, issue, location2, message2, null, 8, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\"\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0012H\u0007J \u0010\u001e\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/detector/api/Context$Companion;", "", "()V", "SUPPRESS_JAVA_COMMENT_PREFIX", "", "SUPPRESS_XML_COMMENT_PREFIX", "detectorsWarned", "", "checkForbidden", "", "methodName", "file", "Ljava/io/File;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "findCallingDetector", "Lkotlin/Pair;", "", "Lcom/android/tools/lint/detector/api/Issue;", "findPrefixOnPreviousLine", "", "contents", "", "lineStart", "prefix", "isSuppressedWithComment", "line", "category", "Lcom/android/tools/lint/detector/api/Category;", "issue", "isWord", "word", "index", "isWordDelimiter", "c", "", "lineContainsId", "id", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final boolean isSuppressedWithComment(@NotNull String line, @NotNull Issue issue) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            List<String> list2 = issue.getAliases();
            if (list2 != null) {
                boolean bl;
                block5: {
                    List<String> aliases = list2;
                    boolean bl2 = false;
                    Iterable $this$any$iv = aliases;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String alias = (String)element$iv;
                            boolean bl3 = false;
                            if (!Companion.lineContainsId(line, alias)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return true;
                }
            }
            return this.lineContainsId(line, issue.getId()) || this.lineContainsId(line, "all") || this.isSuppressedWithComment(line, issue.getCategory());
        }

        private final boolean isSuppressedWithComment(String line, Category category) {
            return this.lineContainsId(line, category.getName()) || this.lineContainsId(line, category.getFullName()) || category.getParent() != null && this.isSuppressedWithComment(line, category.getParent());
        }

        private final boolean lineContainsId(String line, String id) {
            for (int index = 0; index < line.length(); index += id.length()) {
                if ((index = StringsKt.indexOf((CharSequence)line, (String)id, (int)index, (boolean)true)) == -1) {
                    return false;
                }
                if (!this.isWord(line, id, index)) continue;
                return true;
            }
            return false;
        }

        private final boolean isWord(String line, String word, int index) {
            int end = index + word.length();
            if (end < line.length() && !this.isWordDelimiter(line.charAt(end))) {
                return false;
            }
            if (index > 0 && !this.isWordDelimiter(line.charAt(index - 1))) {
                int prefixStart = index - "AndroidLint".length();
                return index >= "AndroidLint".length() && StringsKt.regionMatches$default((String)line, (int)prefixStart, (String)"AndroidLint", (int)0, (int)"AndroidLint".length(), (boolean)false, (int)16, null) && (prefixStart == 0 || this.isWordDelimiter(line.charAt(prefixStart - 1)));
            }
            return true;
        }

        private final boolean isWordDelimiter(char c) {
            return !Character.isJavaIdentifierPart(c);
        }

        private final int findPrefixOnPreviousLine(CharSequence contents, int lineStart, String prefix) {
            char first = prefix.charAt(0);
            int offset = lineStart - 2;
            boolean seenNonWhitespace = false;
            while (offset >= 0) {
                char c = contents.charAt(offset);
                if (seenNonWhitespace && c == '\n') {
                    return -1;
                }
                if (!seenNonWhitespace && !Character.isWhitespace(c)) {
                    seenNonWhitespace = true;
                }
                if (c == first && CharSequences.regionMatches((CharSequence)contents, (int)offset, (CharSequence)prefix, (int)0, (int)prefix.length())) {
                    return offset;
                }
                int n = offset;
                offset = n + -1;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean checkForbidden(@NotNull String methodName, @NotNull File file, @Nullable LintDriver driver) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            LintDriver lintDriver = driver;
            if (lintDriver == null) {
                lintDriver = (LintDriver)CollectionsKt.firstOrNull(LintDriver.Companion.getCurrentDrivers());
            }
            if (lintDriver == null) {
                return true;
            }
            LintDriver currentDriver = lintDriver;
            if (currentDriver.getMode() == LintDriver.DriverMode.ANALYSIS_ONLY) {
                Set warnings;
                Set set;
                Pair<String, List<Issue>> pair = this.findCallingDetector(currentDriver);
                if (pair == null) {
                    return false;
                }
                Pair<String, List<Issue>> pair2 = pair;
                String detector = (String)pair2.component1();
                List issues = (List)pair2.component2();
                Set set2 = detectorsWarned;
                if (set2 == null) {
                    HashSet hashSet;
                    HashSet it = hashSet = new HashSet();
                    boolean bl = false;
                    detectorsWarned = it;
                    set = hashSet;
                } else {
                    set = warnings = set2;
                }
                if (warnings.add(detector)) {
                    String string;
                    String string2;
                    String string3;
                    void $this$sortedBy$iv;
                    void $this$mapNotNullTo$iv$iv;
                    StringBuilder stack = new StringBuilder();
                    LintDriver.Companion.appendStackTraceSummary(new RuntimeException(), stack, 1, 20);
                    Iterable $this$mapNotNull$iv = issues;
                    boolean $i$f$mapNotNull = false;
                    Object object = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Vendor vendor;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        Issue it = (Issue)element$iv$iv;
                        boolean bl2 = false;
                        Vendor vendor2 = it.getVendor();
                        if (vendor2 == null) {
                            IssueRegistry issueRegistry = it.getRegistry();
                            vendor2 = issueRegistry == null ? null : issueRegistry.getVendor();
                        }
                        if (vendor2 == null) continue;
                        Vendor it$iv$iv = vendor = vendor2;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    boolean $i$f$sortedBy22 = false;
                    List vendors = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Vendor it = (Vendor)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getIdentifier());
                            it = (Vendor)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getIdentifier())));
                        }
                    });
                    if (!((Collection)issues).isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("\nIssue Vendors:\n");
                        for (Vendor vendor : vendors) {
                            String it;
                            if (vendor.getVendorName() != null) {
                                boolean bl = false;
                                sb.append("Vendor: " + it + '\n');
                            }
                            if (vendor.getIdentifier() != null) {
                                boolean bl = false;
                                sb.append("Identifier: " + it + '\n');
                            }
                            if (vendor.getContact() != null) {
                                boolean bl = false;
                                sb.append("Contact: " + it + '\n');
                            }
                            if (vendor.getFeedbackUrl() != null) {
                                boolean bl = false;
                                sb.append("Feedback: " + it + '\n');
                            }
                            sb.append("\n");
                        }
                        string3 = sb.toString();
                    } else {
                        string3 = "";
                    }
                    String $i$f$sortedBy22 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$sortedBy22, (String)"if (issues.isNotEmpty())\u2026 \"\"\n                    }");
                    String vendorString = $i$f$sortedBy22;
                    StringBuilder stringBuilder = new StringBuilder();
                    StringBuilder stringBuilder2 = new StringBuilder().append("\n                        The lint detector\n                            `").append(detector).append("`\n                        called `").append(methodName).append("` during module analysis.\n\n                        This does not work correctly when running in ");
                    LintDriver lintDriver2 = driver;
                    if (lintDriver2 == null) {
                        string2 = null;
                    } else {
                        LintClient lintClient = lintDriver2.getClient();
                        string2 = string = lintClient == null ? null : lintClient.getClientDisplayName();
                    }
                    if (string2 == null) {
                        string = LintClient.Companion.getClientName();
                    }
                    String message2 = stringBuilder.append(StringsKt.trimIndent((String)stringBuilder2.append(string).append(".\n\n                        In particular, there may be false positives or false negatives because\n                        the lint check may be using the minSdkVersion or manifest information\n                        from the library instead of any consuming app module.\n\n                        Contact the vendor of the lint issue to get it fixed/updated (if\n                        known, listed below), and in the meantime you can try to work around\n                        this by disabling the following issues:\n\n                        ").append(CollectionsKt.joinToString$default((Iterable)issues, (CharSequence)",", null, null, (int)0, null, (Function1)checkForbidden.message.1.INSTANCE, (int)30, null)).append("\n                        ").toString())).append('\n').append(vendorString).append("Call stack: ").append((Object)stack).toString();
                    object = LintClient.Companion;
                    LintClient lintClient = currentDriver.getClient();
                    Issue issue = IssueRegistry.LINT_ERROR;
                    Location location2 = Location.Companion.create(file);
                    LintClient.Companion.report$default((LintClient.Companion)object, lintClient, issue, message2, null, null, null, null, null, null, null, null, currentDriver, location2, 2040, null);
                }
                return true;
            }
            return false;
        }

        @Nullable
        public final Pair<String, List<Issue>> findCallingDetector(@NotNull LintDriver driver) {
            StackTraceElement callerCaller;
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Throwable throwable = new Throwable().fillInStackTrace();
            StackTraceElement[] frames = throwable.getStackTrace();
            if (frames.length >= 4 && (Intrinsics.areEqual((Object)(callerCaller = frames[3]).getMethodName(), (Object)"beforeCheckEachProject") || Intrinsics.areEqual((Object)callerCaller.getMethodName(), (Object)"afterCheckEachProject"))) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"throwable");
            Pair<String, List<Issue>> result = LintDriver.Companion.getAssociatedDetector(throwable, driver);
            if (result != null) {
                return result;
            }
            Intrinsics.checkNotNullExpressionValue((Object)frames, (String)"frames");
            for (StackTraceElement element : frames) {
                String detectorClass = element.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)detectorClass, (String)"detectorClass");
                if (StringsKt.startsWith$default((String)detectorClass, (String)"com.android.tools.lint.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)detectorClass, (String)"com.android.tools.lint.checks.", (boolean)false, (int)2, null)) continue;
                return new Pair((Object)detectorClass, LintDriver.Companion.getDetectorIssues(detectorClass, driver));
            }
            return new Pair((Object)"unknown detector", (Object)CollectionsKt.emptyList());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LocationType.values().length];
            nArray[LocationType.DEFAULT.ordinal()] = 1;
            nArray[LocationType.ALL.ordinal()] = 2;
            nArray[LocationType.NAME.ordinal()] = 3;
            nArray[LocationType.CALL_WITH_ARGUMENTS.ordinal()] = 4;
            nArray[LocationType.CALL_WITH_RECEIVER.ordinal()] = 5;
            nArray[LocationType.VALUE.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

