/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.FileOption;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000  2\u00020\u0001:\u0001 B#\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0003H&J\u001a\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0004J\u0010\u0010\u0017\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001dH&J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u001f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0005!\"#$%\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/detector/api/Option;", "", "name", "", "description", "explanation", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "getIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "setIssue", "(Lcom/android/tools/lint/detector/api/Issue;)V", "getName", "()Ljava/lang/String;", "defaultAsString", "describe", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "includeExample", "", "ensureRegistered", "", "getDescription", "getExplanation", "getValue", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "context", "Lcom/android/tools/lint/detector/api/Context;", "rangeAsString", "toString", "Companion", "Lcom/android/tools/lint/detector/api/StringOption;", "Lcom/android/tools/lint/detector/api/BooleanOption;", "Lcom/android/tools/lint/detector/api/IntOption;", "Lcom/android/tools/lint/detector/api/FloatOption;", "Lcom/android/tools/lint/detector/api/FileOption;", "lint-api"})
public abstract class Option {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @Nullable
    private final String explanation;
    public Issue issue;

    private Option(String name, String description, String explanation) {
        this.name = name;
        this.description = description;
        this.explanation = explanation;
    }

    public /* synthetic */ Option(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        this(string, string2, string3, null);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public abstract Object getValue(@NotNull Configuration var1);

    @Nullable
    public abstract Object getValue(@NotNull Context var1);

    @Nullable
    public abstract String defaultAsString();

    @Nullable
    public String rangeAsString() {
        return null;
    }

    @NotNull
    public final String getDescription(@NotNull TextFormat format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        String trimmed = StringsKt.trimIndent((String)this.description);
        return TextFormat.RAW.convertTo(trimmed, format);
    }

    public static /* synthetic */ String getDescription$default(Option option, TextFormat textFormat, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDescription");
        }
        if ((n & 1) != 0) {
            textFormat = TextFormat.RAW;
        }
        return option.getDescription(textFormat);
    }

    @Nullable
    public final String getExplanation(@NotNull TextFormat format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        if (this.explanation == null) {
            return null;
        }
        String trimmed = StringsKt.trimIndent((String)this.explanation);
        String message2 = StringsKt.replace$default((String)trimmed, (String)"\\\n", (String)"", (boolean)false, (int)4, null);
        return TextFormat.RAW.convertTo(message2, format);
    }

    public static /* synthetic */ String getExplanation$default(Option option, TextFormat textFormat, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getExplanation");
        }
        if ((n & 1) != 0) {
            textFormat = TextFormat.RAW;
        }
        return option.getExplanation(textFormat);
    }

    @NotNull
    public final String describe(@NotNull TextFormat format, boolean includeExample) {
        String explanation;
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        StringBuilder sb = new StringBuilder();
        sb.append("**").append(this.name).append("**");
        String defaultValue = this.defaultAsString();
        if (defaultValue != null) {
            String esc = this instanceof FileOption ? "`" : "";
            sb.append(" (default is ").append(esc).append(defaultValue).append(esc).append(")");
        }
        sb.append(":");
        String desc = Option.getDescription$default(this, null, 1, null);
        int maxLineWidth = 72;
        if (desc.length() + sb.length() > maxLineWidth) {
            sb.append("\n");
        } else {
            sb.append(" ");
        }
        sb.append(desc).append(".\n");
        String range = this.rangeAsString();
        if (range != null) {
            sb.append(range).append(".\n");
        }
        if ((string = Option.getExplanation$default(this, null, 1, null)) == null) {
            string = "";
        }
        if (!StringsKt.isBlank((CharSequence)(explanation = string))) {
            sb.append("\n");
            if (format == TextFormat.TEXT) {
                sb.append(SdkUtils.wrap((String)explanation, (int)maxLineWidth, (String)""));
            } else {
                sb.append(explanation);
                sb.append("\n");
            }
        }
        if (includeExample) {
            sb.append("\n");
            sb.append("To configure this option, use a `lint.xml` file with an <option> like this:\n\n");
            StringBuilder stringBuilder = new StringBuilder().append("\n                ```xml\n                <lint>\n                    <issue id=\"").append(this.getIssue().getId()).append("\">\n                        <option name=\"").append(this.name).append("\" value=\"");
            String string2 = defaultValue;
            if (string2 == null) {
                string2 = "some string";
            }
            sb.append(StringsKt.trimIndent((String)stringBuilder.append(string2).append("\" />\n                    </issue>\n                </lint>\n                ```\n                ").toString()));
        }
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sb.toString()");
        return TextFormat.RAW.convertTo(string3, format);
    }

    public static /* synthetic */ String describe$default(Option option, TextFormat textFormat, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: describe");
        }
        if ((n & 1) != 0) {
            textFormat = TextFormat.RAW;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return option.describe(textFormat, bl);
    }

    @NotNull
    public String toString() {
        return Option.describe$default(this, TextFormat.TEXT, false, 2, null);
    }

    @NotNull
    public final Issue getIssue() {
        Issue issue = this.issue;
        if (issue != null) {
            return issue;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"issue");
        return null;
    }

    public final void setIssue(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"<set-?>");
        this.issue = issue;
    }

    protected final void ensureRegistered() {
        if (this.issue == null) {
            throw (Throwable)new IllegalStateException(("Option " + this.name + " has not been registered with an associated `Issue`; see `Issue.options()`").toString());
        }
    }

    public /* synthetic */ Option(String name, String description, String explanation, DefaultConstructorMarker $constructor_marker) {
        this(name, description, explanation);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/detector/api/Option$Companion;", "", "()V", "describe", "", "options", "", "Lcom/android/tools/lint/detector/api/Option;", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "includeExample", "", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String describe(@NotNull List<? extends Option> options, @NotNull TextFormat format, boolean includeExample) {
            Intrinsics.checkNotNullParameter(options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            if (!((Collection)options).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Available options:\n");
                for (Option option : options) {
                    sb.append('\n').append(option.describe(TextFormat.RAW, includeExample)).append('\n');
                }
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                return TextFormat.RAW.convertTo(string, format);
            }
            return "";
        }

        public static /* synthetic */ String describe$default(Companion companion, List list2, TextFormat textFormat, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                textFormat = TextFormat.RAW;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.describe(list2, textFormat, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

