/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.support.AndroidxNameUtils;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.LintModelModuleProject;
import com.android.tools.lint.detector.api.LintModelModuleProjectKt;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelJavaArtifact;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelSourceProvider;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0001J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u001cH\u0016J\n\u0010#\u001a\u0004\u0018\u00010\bH\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010(\u001a\u00020\u001aH\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\b\u0010+\u001a\u00020,H\u0016J\n\u0010-\u001a\u0004\u0018\u00010\u001cH\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\b\u00100\u001a\u00020,H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\b\u00103\u001a\u00020\u001aH\u0016J\b\u00104\u001a\u00020\u0017H\u0014J\b\u00105\u001a\u00020\u001aH\u0016J\b\u00106\u001a\u00020\u001aH\u0016J\u0010\u00107\u001a\u00020\u00172\u0006\u00108\u001a\u00020\u0005H\u0002J\u000e\u00109\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\u001aJ\u000e\u0010;\u001a\u00020\u00172\u0006\u0010<\u001a\u00020=R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/android/tools/lint/detector/api/LintModelModuleProject;", "Lcom/android/tools/lint/detector/api/Project;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dir", "Ljava/io/File;", "referenceDir", "variant", "Lcom/android/tools/lint/model/LintModelVariant;", "mergedManifest", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;Lcom/android/tools/lint/model/LintModelVariant;Ljava/io/File;)V", "model", "Lcom/android/tools/lint/model/LintModelModule;", "getModel", "()Lcom/android/tools/lint/model/LintModelModule;", "sourceProviders", "", "Lcom/android/tools/lint/model/LintModelSourceProvider;", "getSourceProviders", "()Ljava/util/List;", "testSourceProviders", "getTestSourceProviders", "addDirectLibrary", "", "project", "dependsOn", "", "artifact", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getAssetFolders", "getBuildModule", "getBuildSdk", "", "getBuildTargetHash", "getBuildVariant", "getGeneratedResourceFolders", "getGeneratedSourceFolders", "getJavaClassFolders", "getJavaLibraries", "includeProvided", "getJavaSourceFolders", "getManifestFiles", "getMinSdkVersion", "Lcom/android/sdklib/AndroidVersion;", "getPackage", "getProguardFiles", "getResourceFolders", "getTargetSdkVersion", "getTestLibraries", "getTestSourceFolders", "hasDynamicFeatures", "initialize", "isAndroidProject", "isLibrary", "readManifest", "manifest", "setExternalLibrary", "external", "setMavenCoordinates", "mc", "Lcom/android/tools/lint/model/LintModelMavenName;", "lint-api"})
public class LintModelModuleProject
extends Project {
    private final LintModelVariant variant;

    private final LintModelModule getModel() {
        return this.variant.getModule();
    }

    public final void setExternalLibrary(boolean external) {
        this.externalLibrary = external;
    }

    public final void setMavenCoordinates(@NotNull LintModelMavenName mc) {
        Intrinsics.checkParameterIsNotNull((Object)mc, (String)"mc");
        this.mavenCoordinates = mc;
    }

    public final void addDirectLibrary(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.directLibraries.add(project);
    }

    private final void readManifest(File manifest) {
        if (manifest.exists()) {
            try {
                Document document;
                String xml = FilesKt.readText$default((File)manifest, null, (int)1, null);
                Document document2 = document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document2 != null) {
                    Document document3 = document2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Document it = document3;
                    boolean bl3 = false;
                    this.readManifest(it);
                }
            }
            catch (IOException e) {
                this.client.log(e, "Could not read manifest %1$s", manifest);
            }
        }
    }

    @Override
    protected void initialize() {
    }

    private final List<LintModelSourceProvider> getSourceProviders() {
        return this.variant.getSourceProviders();
    }

    private final List<LintModelSourceProvider> getTestSourceProviders() {
        return this.variant.getTestSourceProviders();
    }

    @Override
    @NotNull
    public LintModelModule getBuildModule() {
        return this.variant.getModule();
    }

    @Override
    @Nullable
    public LintModelVariant getBuildVariant() {
        return this.variant;
    }

    @Override
    public boolean isLibrary() {
        return this.getModel().getType() == LintModelModuleType.LIBRARY || this.getModel().getType() == LintModelModuleType.JAVA_LIBRARY;
    }

    @Override
    public boolean isAndroidProject() {
        return this.getType() != LintModelModuleType.JAVA_LIBRARY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasDynamicFeatures() {
        if (this.getModel().getType() != LintModelModuleType.APP) return false;
        Collection collection = this.getModel().getDynamicFeatures();
        boolean bl = false;
        if (collection.isEmpty()) return false;
        return true;
    }

    @Override
    @NotNull
    public List<File> getManifestFiles() {
        if (this.manifestFiles == null) {
            this.manifestFiles = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl = false;
                File manifestFile = provider.getManifestFile();
                if (!manifestFile.exists()) continue;
                this.manifestFiles.add(manifestFile);
            }
        }
        List list2 = this.manifestFiles;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"manifestFiles");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getProguardFiles() {
        if (this.proguardFiles == null) {
            this.proguardFiles = CollectionsKt.plus((Collection)this.variant.getProguardFiles(), (Iterable)this.variant.getConsumerProguardFiles());
        }
        List list2 = this.proguardFiles;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"proguardFiles");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getResourceFolders() {
        if (this.resourceFolders == null) {
            this.resourceFolders = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl = false;
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)provider.getResDirectories()), (Function1)getResourceFolders.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it = (File)element$iv2;
                    boolean bl2 = false;
                    this.resourceFolders.add(it);
                }
            }
        }
        List list2 = this.resourceFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"resourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getGeneratedResourceFolders() {
        if (this.generatedResourceFolders == null) {
            this.generatedResourceFolders = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.variant.getMainArtifact().getGeneratedResourceFolders()), (Function1)getGeneratedResourceFolders.1.INSTANCE));
        }
        List list2 = this.generatedResourceFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"generatedResourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getAssetFolders() {
        if (this.assetFolders == null) {
            this.assetFolders = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl = false;
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)provider.getAssetsDirectories()), (Function1)getAssetFolders.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it = (File)element$iv2;
                    boolean bl2 = false;
                    this.assetFolders.add(it);
                }
            }
        }
        List list2 = this.assetFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"assetFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getJavaSourceFolders() {
        if (this.javaSourceFolders == null) {
            this.javaSourceFolders = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl = false;
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)provider.getJavaDirectories()), (Function1)getJavaSourceFolders.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it = (File)element$iv2;
                    boolean bl2 = false;
                    this.javaSourceFolders.add(it);
                }
            }
        }
        List list2 = this.javaSourceFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"javaSourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getGeneratedSourceFolders() {
        if (this.generatedSourceFolders == null) {
            LintModelAndroidArtifact artifact = this.variant.getMainArtifact();
            this.generatedSourceFolders = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)artifact.getGeneratedSourceFolders()), (Function1)getGeneratedSourceFolders.1.INSTANCE));
        }
        List list2 = this.generatedSourceFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"generatedSourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getTestSourceFolders() {
        if (this.testSourceFolders == null) {
            this.testSourceFolders = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getTestSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl = false;
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)provider.getJavaDirectories()), (Function1)getTestSourceFolders.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it = (File)element$iv2;
                    boolean bl2 = false;
                    this.testSourceFolders.add(it);
                }
            }
        }
        List list2 = this.testSourceFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"testSourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getJavaClassFolders() {
        if (this.javaClassFolders == null) {
            this.javaClassFolders = new ArrayList(3);
            LintModelAndroidArtifact mainArtifact = this.variant.getMainArtifact();
            for (File outputClassFolder : mainArtifact.getClassOutputs()) {
                if (!outputClassFolder.exists()) continue;
                this.javaClassFolders.add(outputClassFolder);
            }
            if (this.javaClassFolders.isEmpty() && this.isLibrary()) {
                for (LintModelVariant variant : this.getModel().getVariants()) {
                    if (!(Intrinsics.areEqual((Object)variant, (Object)this.variant) ^ true)) continue;
                    mainArtifact = variant.getMainArtifact();
                    boolean found = false;
                    for (File outputClassFolder : mainArtifact.getClassOutputs()) {
                        if (!outputClassFolder.exists()) continue;
                        this.javaClassFolders.add(outputClassFolder);
                        found = true;
                    }
                    if (!found) continue;
                    break;
                }
            }
        }
        List list2 = this.javaClassFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"javaClassFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getJavaLibraries(boolean includeProvided) {
        List list2;
        if (includeProvided) {
            if (this.javaLibraries == null) {
                LintModelDependencies dependencies = this.variant.getMainArtifact().getDependencies();
                List direct = dependencies.getCompileDependencies().getRoots();
                this.javaLibraries = Lists.newArrayListWithExpectedSize((int)direct.size());
                for (LintModelDependency graphItem : direct) {
                    LintModelLibrary library;
                    if (graphItem.findLibrary() == null) {
                        continue;
                    }
                    if (!(library instanceof LintModelExternalLibrary)) continue;
                    LintModelExternalLibrary lintModelExternalLibrary = (LintModelExternalLibrary)library;
                    List list3 = this.javaLibraries;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"javaLibraries");
                    LintModelModuleProjectKt.addJars(lintModelExternalLibrary, list3, false);
                }
            }
            List list4 = this.javaLibraries;
            list2 = list4;
            Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"javaLibraries");
        } else {
            if (this.nonProvidedJavaLibraries == null) {
                LintModelDependencies dependencies = this.variant.getMainArtifact().getDependencies();
                List direct = dependencies.getPackageDependencies().getRoots();
                this.nonProvidedJavaLibraries = Lists.newArrayListWithExpectedSize((int)direct.size());
                for (LintModelDependency graphItem : direct) {
                    LintModelLibrary library;
                    if (graphItem.findLibrary() == null) {
                        continue;
                    }
                    if (!(library instanceof LintModelExternalLibrary)) continue;
                    LintModelExternalLibrary lintModelExternalLibrary = (LintModelExternalLibrary)library;
                    List list5 = this.nonProvidedJavaLibraries;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list5, (String)"nonProvidedJavaLibraries");
                    LintModelModuleProjectKt.addJars(lintModelExternalLibrary, list5, true);
                }
            }
            List list6 = this.nonProvidedJavaLibraries;
            list2 = list6;
            Intrinsics.checkExpressionValueIsNotNull((Object)list6, (String)"nonProvidedJavaLibraries");
        }
        return list2;
    }

    @Override
    @NotNull
    public List<File> getTestLibraries() {
        if (this.testLibraries == null) {
            LintModelAndroidArtifact artifact;
            boolean bl;
            boolean bl2;
            LintModelAndroidArtifact lintModelAndroidArtifact;
            this.testLibraries = Lists.newArrayListWithExpectedSize((int)6);
            LintModelAndroidArtifact lintModelAndroidArtifact2 = this.variant.getAndroidTestArtifact();
            if (lintModelAndroidArtifact2 != null) {
                lintModelAndroidArtifact = lintModelAndroidArtifact2;
                bl2 = false;
                bl = false;
                artifact = lintModelAndroidArtifact;
                boolean bl3 = false;
                for (LintModelLibrary library : artifact.getDependencies().getAll()) {
                    if (!(library instanceof LintModelExternalLibrary)) continue;
                    LintModelExternalLibrary lintModelExternalLibrary = (LintModelExternalLibrary)library;
                    List list2 = this.testLibraries;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"testLibraries");
                    LintModelModuleProjectKt.addJars(lintModelExternalLibrary, list2, false);
                }
            }
            LintModelJavaArtifact lintModelJavaArtifact = this.variant.getTestArtifact();
            if (lintModelJavaArtifact != null) {
                lintModelAndroidArtifact = lintModelJavaArtifact;
                bl2 = false;
                bl = false;
                artifact = lintModelAndroidArtifact;
                boolean bl4 = false;
                for (LintModelLibrary library : artifact.getDependencies().getAll()) {
                    if (!(library instanceof LintModelExternalLibrary)) continue;
                    LintModelExternalLibrary lintModelExternalLibrary = (LintModelExternalLibrary)library;
                    List list3 = this.testLibraries;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"testLibraries");
                    LintModelModuleProjectKt.addJars(lintModelExternalLibrary, list3, false);
                }
            }
        }
        List list4 = this.testLibraries;
        Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"testLibraries");
        return list4;
    }

    @Override
    @Nullable
    public String getPackage() {
        String packageName;
        if (this.pkg == null && (packageName = this.variant.getPackage()) != null) {
            return packageName;
        }
        return this.pkg;
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion androidVersion = this.manifestMinSdk;
        if (androidVersion == null) {
            AndroidVersion minSdk;
            LintModelModuleProject lintModelModuleProject = this;
            boolean bl = false;
            boolean bl2 = false;
            LintModelModuleProject $this$run = lintModelModuleProject;
            boolean bl3 = false;
            AndroidVersion androidVersion2 = $this$run.variant.getMinSdkVersion();
            if (androidVersion2 == null) {
                AndroidVersion androidVersion3 = super.getMinSdkVersion();
                androidVersion2 = androidVersion3;
                Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion3, (String)"super.getMinSdkVersion()");
            }
            $this$run.manifestMinSdk = minSdk = androidVersion2;
            androidVersion = minSdk;
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion androidVersion = this.manifestTargetSdk;
        if (androidVersion == null) {
            AndroidVersion targetSdk;
            LintModelModuleProject lintModelModuleProject = this;
            boolean bl = false;
            boolean bl2 = false;
            LintModelModuleProject $this$run = lintModelModuleProject;
            boolean bl3 = false;
            AndroidVersion androidVersion2 = $this$run.variant.getTargetSdkVersion();
            if (androidVersion2 == null) {
                androidVersion2 = $this$run.getMinSdkVersion();
            }
            $this$run.manifestTargetSdk = targetSdk = androidVersion2;
            androidVersion = targetSdk;
        }
        return androidVersion;
    }

    @Override
    public int getBuildSdk() {
        if (this.buildSdk == -1) {
            AndroidVersion version;
            String compileTarget = this.getModel().getCompileTarget();
            AndroidVersion androidVersion = version = AndroidTargetHash.getPlatformVersion((String)compileTarget);
            this.buildSdk = androidVersion != null ? androidVersion.getFeatureLevel() : super.getBuildSdk();
        }
        return this.buildSdk;
    }

    @Override
    @Nullable
    public String getBuildTargetHash() {
        return this.getModel().getCompileTarget();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Boolean dependsOn(@NotNull String artifact) {
        Boolean bl;
        String id;
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        String string = id = AndroidxNameUtils.getCoordinateMapping((String)artifact);
        if (string != null) {
            switch (string) {
                case "androidx.legacy:legacy-support-v4": {
                    if (this.supportLib == null) {
                        LintModelAndroidArtifact a = this.variant.getMainArtifact();
                        this.supportLib = a.findCompileDependency("androidx.legacy:legacy-support-v4") != null || a.findCompileDependency("com.android.support:support-v4") != null;
                    }
                    bl = this.supportLib;
                    return bl;
                }
                case "androidx.appcompat:appcompat": {
                    if (this.appCompat == null) {
                        LintModelAndroidArtifact a = this.variant.getMainArtifact();
                        this.appCompat = a.findCompileDependency("androidx.appcompat:appcompat") != null || a.findCompileDependency("com.android.support:appcompat-v7") != null;
                    }
                    bl = this.appCompat;
                    return bl;
                }
                case "androidx.leanback:leanback": {
                    if (this.leanback == null) {
                        LintModelAndroidArtifact a = this.variant.getMainArtifact();
                        this.leanback = a.findCompileDependency("androidx.leanback:leanback") != null || a.findCompileDependency("com.android.support:leanback-v17") != null;
                    }
                    bl = this.leanback;
                    return bl;
                }
            }
        }
        bl = super.dependsOn(id);
        return bl;
    }

    public LintModelModuleProject(@NotNull LintClient client, @NotNull File dir, @NotNull File referenceDir, @NotNull LintModelVariant variant, @Nullable File mergedManifest) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)referenceDir, (String)"referenceDir");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        super(client, dir, referenceDir);
        this.variant = variant;
        this.gradleProject = true;
        this.mergeManifests = true;
        boolean bl = false;
        this.directLibraries = new ArrayList();
        File file = mergedManifest;
        if (file != null) {
            File file2 = file;
            boolean bl2 = false;
            boolean bl3 = false;
            File it = file2;
            boolean bl4 = false;
            this.readManifest(it);
        }
        this.manifestMinSdk = this.variant.getMinSdkVersion();
        this.manifestTargetSdk = this.variant.getTargetSdkVersion();
    }
}

