/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.tools.lint.detector.api.CharSequences;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Position;
import com.google.common.annotations.Beta;
import java.io.File;

@Beta
public class Location {
    private static final String SUPER_KEYWORD = "super";
    private final File file;
    private final Position start;
    private final Position end;
    private String message;
    private Location secondary;
    private Object clientData;
    private boolean visible = true;
    private boolean selfExplanatory = true;
    public static final Location NONE = new Location(new File("NONE"), null, null){

        @Override
        public Location setVisible(boolean visible) {
            return this;
        }

        @Override
        public Location setMessage(String message, boolean selfExplanatory) {
            return this;
        }

        @Override
        public Location setClientData(Object clientData) {
            return this;
        }

        @Override
        public Location setSelfExplanatory(boolean selfExplanatory) {
            return this;
        }

        @Override
        public Location setSecondary(Location secondary) {
            return this;
        }
    };

    protected Location(File file, Position start, Position end) {
        this.file = file;
        this.start = start;
        this.end = end;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Location setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public Position getStart() {
        return this.start;
    }

    public Position getEnd() {
        return this.end;
    }

    public Location getSecondary() {
        return this.secondary;
    }

    public Location setSecondary(Location secondary) {
        this.secondary = secondary;
        return this;
    }

    public Location withSecondary(Location secondary, String message) {
        return this.withSecondary(secondary, message, false);
    }

    public Location withSecondary(Location secondary, String message, boolean selfExplanatory) {
        secondary.setMessage(message, selfExplanatory);
        this.setSecondary(secondary);
        return this;
    }

    public Location setMessage(String message) {
        return this.setMessage(message, false);
    }

    public Location setMessage(String message, boolean selfExplanatory) {
        this.message = message;
        this.setSelfExplanatory(selfExplanatory);
        return this;
    }

    public boolean isSelfExplanatory() {
        return this.selfExplanatory;
    }

    public Location setSelfExplanatory(boolean selfExplanatory) {
        this.selfExplanatory = selfExplanatory;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Location setClientData(Object clientData) {
        this.clientData = clientData;
        return this;
    }

    public Object getClientData() {
        return this.clientData;
    }

    public String toString() {
        return "Location [file=" + this.file + ", start=" + this.start + ", end=" + this.end + ", message=" + this.message + ']';
    }

    public static Location create(File file) {
        return new Location(file, null, null);
    }

    public static Location create(File file, SourcePosition position) {
        if (position.equals((Object)SourcePosition.UNKNOWN)) {
            return new Location(file, null, null);
        }
        return new Location(file, new DefaultPosition(position.getStartLine(), position.getStartColumn(), position.getStartOffset()), new DefaultPosition(position.getEndLine(), position.getEndColumn(), position.getEndOffset()));
    }

    public static Location create(File file, Position start, Position end) {
        return new Location(file, start, end);
    }

    public static Location create(File file, CharSequence contents, int startOffset, int endOffset) {
        if (startOffset < 0 || endOffset < startOffset) {
            throw new IllegalArgumentException("Invalid offsets");
        }
        if (contents == null) {
            return new Location(file, new DefaultPosition(-1, -1, startOffset), new DefaultPosition(-1, -1, endOffset));
        }
        int size = contents.length();
        endOffset = Math.min(endOffset, size);
        startOffset = Math.min(startOffset, endOffset);
        DefaultPosition start = null;
        int line = 0;
        int lineOffset = 0;
        char prev = '\u0000';
        for (int offset = 0; offset <= size; ++offset) {
            if (offset == startOffset) {
                start = new DefaultPosition(line, offset - lineOffset, offset);
            }
            if (offset == endOffset) {
                DefaultPosition end = new DefaultPosition(line, offset - lineOffset, offset);
                return new Location(file, start, end);
            }
            char c = contents.charAt(offset);
            if (c == '\n') {
                lineOffset = offset + 1;
                if (prev != '\r') {
                    ++line;
                }
            } else if (c == '\r') {
                ++line;
                lineOffset = offset + 1;
            }
            prev = c;
        }
        return Location.create(file);
    }

    public static Location create(File file, String contents, int line) {
        return Location.create(file, contents, line, null, null, null);
    }

    public static Location create(File file, CharSequence contents, int line, String patternStart, String patternEnd, SearchHints hints) {
        int currentLine = 0;
        int offset = 0;
        while (currentLine < line) {
            if ((offset = CharSequences.indexOf(contents, '\n', offset)) == -1) {
                return Location.create(file);
            }
            ++currentLine;
            ++offset;
        }
        if (line == currentLine) {
            if (patternStart != null) {
                int lineEnd;
                int index;
                SearchDirection direction = SearchDirection.NEAREST;
                if (hints != null) {
                    direction = hints.direction;
                }
                if (direction == SearchDirection.BACKWARD) {
                    index = Location.findPreviousMatch(contents, offset, patternStart, hints);
                    line = Location.adjustLine(contents, line, offset, index);
                } else if (direction == SearchDirection.EOL_BACKWARD) {
                    lineEnd = CharSequences.indexOf(contents, '\n', offset);
                    if (lineEnd == -1) {
                        lineEnd = contents.length();
                    }
                    index = Location.findPreviousMatch(contents, lineEnd, patternStart, hints);
                    line = Location.adjustLine(contents, line, offset, index);
                } else if (direction == SearchDirection.FORWARD) {
                    index = Location.findNextMatch(contents, offset, patternStart, hints);
                    line = Location.adjustLine(contents, line, offset, index);
                } else {
                    assert (direction == SearchDirection.NEAREST || direction == SearchDirection.EOL_NEAREST);
                    lineEnd = CharSequences.indexOf(contents, '\n', offset);
                    if (lineEnd == -1) {
                        lineEnd = contents.length();
                    }
                    offset = lineEnd;
                    int before = Location.findPreviousMatch(contents, offset, patternStart, hints);
                    int after = Location.findNextMatch(contents, offset, patternStart, hints);
                    if (before == -1) {
                        index = after;
                        line = Location.adjustLine(contents, line, offset, index);
                    } else if (after == -1) {
                        index = before;
                        line = Location.adjustLine(contents, line, offset, index);
                    } else {
                        int newLinesBefore = 0;
                        for (int i = before; i < offset; ++i) {
                            if (contents.charAt(i) != '\n') continue;
                            ++newLinesBefore;
                        }
                        int newLinesAfter = 0;
                        for (int i = offset; i < after; ++i) {
                            if (contents.charAt(i) != '\n') continue;
                            ++newLinesAfter;
                        }
                        if (newLinesBefore < newLinesAfter || newLinesBefore == newLinesAfter && offset - before < after - offset) {
                            index = before;
                            line = Location.adjustLine(contents, line, offset, index);
                        } else {
                            index = after;
                            line = Location.adjustLine(contents, line, offset, index);
                        }
                    }
                }
                if (index != -1) {
                    int lineStart = CharSequences.lastIndexOf(contents, 10, index);
                    lineStart = lineStart == -1 ? 0 : ++lineStart;
                    int column = index - lineStart;
                    if (patternEnd != null) {
                        int end = CharSequences.indexOf(contents, patternEnd, offset + patternStart.length());
                        if (end != -1) {
                            return new Location(file, new DefaultPosition(line, column, index), new DefaultPosition(line, -1, end + patternEnd.length()));
                        }
                    } else if (hints != null && (hints.isJavaSymbol() || hints.isWholeWord())) {
                        if (hints.isConstructor() && CharSequences.startsWith(contents, SUPER_KEYWORD, index)) {
                            patternStart = SUPER_KEYWORD;
                        }
                        return new Location(file, new DefaultPosition(line, column, index), new DefaultPosition(line, column + patternStart.length(), index + patternStart.length()));
                    }
                    return new Location(file, new DefaultPosition(line, column, index), new DefaultPosition(line, column, index + patternStart.length()));
                }
            }
            DefaultPosition position = new DefaultPosition(line, -1, offset);
            return new Location(file, position, position);
        }
        return Location.create(file);
    }

    private static int findPreviousMatch(CharSequence contents, int offset, String pattern, SearchHints hints) {
        int loopDecrement = Math.max(1, pattern.length());
        int index;
        while ((index = CharSequences.lastIndexOf(contents, pattern, offset)) != -1) {
            if (Location.isMatch(contents, index, pattern, hints)) {
                return index;
            }
            offset = index - loopDecrement;
        }
        return -1;
    }

    private static int findNextMatch(CharSequence contents, int offset, String pattern, SearchHints hints) {
        int constructorIndex = -1;
        if (hints != null && hints.isConstructor()) {
            assert (hints.isWholeWord());
            int index = CharSequences.indexOf(contents, SUPER_KEYWORD, offset);
            if (index != -1 && Location.isMatch(contents, index, SUPER_KEYWORD, hints)) {
                constructorIndex = index;
            }
        }
        int loopIncrement = Math.max(1, pattern.length());
        int index;
        while ((index = CharSequences.indexOf(contents, pattern, offset)) != -1 && index != contents.length()) {
            if (Location.isMatch(contents, index, pattern, hints)) {
                if (constructorIndex != -1) {
                    return Math.min(constructorIndex, index);
                }
                return index;
            }
            offset = index + loopIncrement;
        }
        return constructorIndex;
    }

    private static boolean isMatch(CharSequence contents, int offset, String pattern, SearchHints hints) {
        if (!CharSequences.startsWith(contents, pattern, offset)) {
            return false;
        }
        if (hints != null) {
            char nextChar;
            char prevChar = offset > 0 ? contents.charAt(offset - 1) : (char)'\u0000';
            int lastIndex = offset + pattern.length() - 1;
            char c = nextChar = lastIndex < contents.length() - 1 ? contents.charAt(lastIndex + 1) : (char)'\u0000';
            if (hints.isWholeWord() && (Character.isLetter(prevChar) || Character.isLetter(nextChar))) {
                return false;
            }
            if (hints.isJavaSymbol()) {
                if (Character.isJavaIdentifierPart(prevChar) || Character.isJavaIdentifierPart(nextChar)) {
                    return false;
                }
                if (prevChar == '\"') {
                    return false;
                }
            }
            if (hints.isConstructor() && SUPER_KEYWORD.equals(pattern)) {
                char c2;
                for (int index = lastIndex + 1; index < contents.length() - 1 && (c2 = contents.charAt(index)) != '('; ++index) {
                    if (Character.isWhitespace(c2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static int adjustLine(CharSequence doc, int line, int offset, int newOffset) {
        if (newOffset == -1) {
            return line;
        }
        if (newOffset < offset) {
            return line - Location.countLines(doc, newOffset, offset);
        }
        return line + Location.countLines(doc, offset, newOffset);
    }

    private static int countLines(CharSequence doc, int start, int end) {
        int lines = 0;
        for (int offset = start; offset < end; ++offset) {
            char c = doc.charAt(offset);
            if (c != '\n') continue;
            ++lines;
        }
        return lines;
    }

    public static Location reverse(Location location) {
        Location next = location.getSecondary();
        location.setSecondary(null);
        while (next != null) {
            Location nextNext = next.getSecondary();
            next.setSecondary(location);
            location = next;
            next = nextNext;
        }
        return location;
    }

    public static class SearchHints {
        private final SearchDirection direction;
        private boolean wholeWord;
        private boolean javaSymbol;
        private boolean constructor;

        private SearchHints(SearchDirection direction) {
            this.direction = direction;
        }

        public static SearchHints create(SearchDirection direction) {
            return new SearchHints(direction);
        }

        public SearchHints matchWholeWord() {
            this.wholeWord = true;
            return this;
        }

        public boolean isWholeWord() {
            return this.wholeWord;
        }

        public SearchHints matchJavaSymbol() {
            this.javaSymbol = true;
            this.wholeWord = true;
            return this;
        }

        public boolean isJavaSymbol() {
            return this.javaSymbol;
        }

        public SearchHints matchConstructor() {
            this.constructor = true;
            this.wholeWord = true;
            this.javaSymbol = true;
            return this;
        }

        public boolean isConstructor() {
            return this.constructor;
        }
    }

    public static enum SearchDirection {
        FORWARD,
        BACKWARD,
        EOL_BACKWARD,
        NEAREST,
        EOL_NEAREST;

    }

    public static class ResourceItemHandle
    implements Handle {
        private final ResourceItem item;

        public ResourceItemHandle(ResourceItem item) {
            this.item = item;
        }

        @Override
        public Location resolve() {
            ResourceFile source = (ResourceFile)this.item.getSource();
            assert (source != null) : this.item;
            return Location.create(source.getFile());
        }

        @Override
        public void setClientData(Object clientData) {
        }

        @Override
        public Object getClientData() {
            return null;
        }
    }

    public static class DefaultLocationHandle
    implements Handle {
        private final File file;
        private final CharSequence contents;
        private final int startOffset;
        private final int endOffset;
        private Object clientData;

        public DefaultLocationHandle(Context context, int startOffset, int endOffset) {
            this.file = context.file;
            this.contents = context.getContents();
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        @Override
        public Location resolve() {
            return Location.create(this.file, this.contents, this.startOffset, this.endOffset);
        }

        @Override
        public void setClientData(Object clientData) {
            this.clientData = clientData;
        }

        @Override
        public Object getClientData() {
            return this.clientData;
        }
    }

    public static interface Handle {
        public Location resolve();

        public void setClientData(Object var1);

        public Object getClientData();
    }
}

