/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.repository.api.ProgressIndicator;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.lint.client.api.AsmVisitor;
import com.android.tools.lint.client.api.CircularDependencyException;
import com.android.tools.lint.client.api.ClassEntry;
import com.android.tools.lint.client.api.CompositeIssueRegistry;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.JavaPsiVisitor;
import com.android.tools.lint.client.api.JavaVisitor;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintListener;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.client.api.OtherFileVisitor;
import com.android.tools.lint.client.api.ResourceVisitor;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.ast.Annotation;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.AnnotationValue;
import lombok.ast.ArrayInitializer;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.Expression;
import lombok.ast.MethodDeclaration;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeReference;
import lombok.ast.VariableDefinition;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@Beta
public class LintDriver {
    private static final int MAX_PHASES = 3;
    private static final String SUPPRESS_LINT_VMSIG = "/SuppressLint;";
    private static final String STUDIO_ID_PREFIX = "AndroidLint";
    private final LintClient client;
    private LintRequest request;
    private IssueRegistry registry;
    private volatile boolean canceled;
    private EnumSet<Scope> scope;
    private List<? extends Detector> applicableDetectors;
    private Map<Scope, List<Detector>> scopeDetectors;
    private List<LintListener> listeners;
    private int phase;
    private List<Detector> repeatingDetectors;
    private EnumSet<Scope> repeatScope;
    private Project[] currentProjects;
    private Project currentProject;
    private boolean abbreviating = true;
    private boolean parserErrors;
    private Map<Object, Object> properties;
    private boolean runCompatChecks = true;
    private LintBaseline baseline;
    private static int exceptionCount;
    private static final int MAX_REPORTED_CRASHES = 20;
    private Set<Issue> myCustomIssues;
    private Deque<ClassNode> mOuterClasses;
    private ResourceFolderType currentFolderType;
    private List<ResourceXmlDetector> currentXmlDetectors;
    private List<Detector> currentBinaryDetectors;
    private ResourceVisitor currentVisitor;
    public static final String SUPPRESS_WARNINGS_FQCN = "java.lang.SuppressWarnings";
    private File cachedFolder = null;
    private int cachedFolderVersion = -1;
    private static final Pattern VERSION_PATTERN;

    public LintDriver(IssueRegistry registry, LintClient client) {
        this.registry = registry;
        this.client = new LintClientWrapper(client);
    }

    public static void handleDetectorError(Context context, RuntimeException e) {
        String simpleClassName = e.getClass().getSimpleName();
        if (simpleClassName.equals("IndexNotReadyException")) {
            return;
        }
        if (e instanceof ProcessCanceledException || simpleClassName.equals("ProcessCanceledException")) {
            context.getDriver().cancel();
            return;
        }
        if (exceptionCount++ > 20) {
            return;
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append("Unexpected failure during lint analysis of ");
        sb.append(context.file.getName());
        sb.append(" (this is a bug in lint or one of the libraries it depends on)\n");
        sb.append(simpleClassName);
        sb.append(':');
        StackTraceElement[] stackTrace = e.getStackTrace();
        int count = 0;
        for (StackTraceElement frame : stackTrace) {
            if (count > 0) {
                sb.append("<-");
            }
            String className = frame.getClassName();
            sb.append(className.substring(className.lastIndexOf(46) + 1));
            sb.append('.').append(frame.getMethodName());
            sb.append('(');
            sb.append(frame.getFileName()).append(':').append(frame.getLineNumber());
            sb.append(')');
            if (++count == 4) break;
        }
        Throwable throwable = null;
        context.log(throwable, sb.toString(), new Object[0]);
    }

    public static int getCrashCount() {
        return exceptionCount;
    }

    public static void clearCrashCount() {
        exceptionCount = 0;
    }

    public void cancel() {
        this.canceled = true;
    }

    public EnumSet<Scope> getScope() {
        return this.scope;
    }

    public void setScope(EnumSet<Scope> scope) {
        this.scope = scope;
    }

    public LintClient getClient() {
        return this.client;
    }

    public LintRequest getRequest() {
        return this.request;
    }

    public void putProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = Maps.newHashMap();
        }
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public Object getProperty(Object key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public LintBaseline getBaseline() {
        return this.baseline;
    }

    public void setBaseline(LintBaseline baseline) {
        this.baseline = baseline;
    }

    public int getPhase() {
        return this.phase;
    }

    public IssueRegistry getRegistry() {
        return this.registry;
    }

    public Project findProjectFor(File file) {
        if (this.currentProjects != null) {
            if (this.currentProjects.length == 1) {
                return this.currentProjects[0];
            }
            String path = file.getPath();
            for (Project project : this.currentProjects) {
                if (!path.startsWith(project.getDir().getPath())) continue;
                return project;
            }
        }
        return null;
    }

    public void setAbbreviating(boolean abbreviating) {
        this.abbreviating = abbreviating;
    }

    public boolean isAbbreviating() {
        return this.abbreviating;
    }

    public boolean hasParserErrors() {
        return this.parserErrors;
    }

    public void setHasParserErrors(boolean hasErrors) {
        this.parserErrors = hasErrors;
    }

    public List<Project> getProjects() {
        if (this.currentProjects != null) {
            return Arrays.asList(this.currentProjects);
        }
        return Collections.emptyList();
    }

    @Deprecated
    public void analyze(List<File> files, EnumSet<Scope> scope) {
        this.analyze(new LintRequest(this.client, files).setScope(scope));
    }

    public void analyze(LintRequest request) {
        try {
            this.request = request;
            this.analyze();
        }
        finally {
            this.request = null;
        }
    }

    private void analyze() {
        Object lastProject;
        Configuration mainConfiguration;
        File baselineFile;
        Collection<Project> projects;
        this.canceled = false;
        this.scope = this.request.getScope();
        assert (this.scope == null || !this.scope.contains((Object)Scope.ALL_RESOURCE_FILES) || this.scope.contains((Object)Scope.RESOURCE_FILE));
        try {
            projects = this.request.getProjects();
            if (projects == null) {
                projects = this.computeProjects(this.request.getFiles());
            }
        }
        catch (CircularDependencyException e) {
            this.currentProject = e.getProject();
            if (this.currentProject != null) {
                Location location = e.getLocation();
                File file = location != null ? location.getFile() : this.currentProject.getDir();
                Context context = new Context(this, this.currentProject, null, file);
                context.report(IssueRegistry.LINT_ERROR, e.getLocation(), e.getMessage());
                this.currentProject = null;
            }
            return;
        }
        if (projects.isEmpty()) {
            this.client.log(null, "No projects found for %1$s", this.request.getFiles().toString());
            return;
        }
        if (this.canceled) {
            return;
        }
        this.registerCustomDetectors(projects);
        if (this.scope == null) {
            this.scope = Scope.infer(projects);
        }
        if (this.baseline == null && this.scope.size() > 2 && (baselineFile = (mainConfiguration = this.client.getConfiguration((Project)(lastProject = (Project)Iterables.getLast(projects)), this)).getBaselineFile()) != null) {
            this.baseline = new LintBaseline(this.client, baselineFile);
        }
        this.fireEvent(LintListener.EventType.STARTING, null);
        for (Project project : projects) {
            this.phase = 1;
            Project main = this.request.getMainProject(project);
            this.computeDetectors(project);
            if (this.applicableDetectors.isEmpty()) continue;
            this.checkProject(project, main);
            if (this.canceled) break;
            this.runExtraPhases(project, main);
        }
        if (this.baseline != null) {
            lastProject = (Project)Iterables.getLast(projects);
            Project main = this.request.getMainProject((Project)lastProject);
            this.baseline.reportBaselineIssues(this, main);
        }
        this.fireEvent(this.canceled ? LintListener.EventType.CANCELED : LintListener.EventType.COMPLETED, null);
    }

    public boolean isCustomIssue(Issue issue) {
        return this.myCustomIssues != null && this.myCustomIssues.contains(issue);
    }

    private void registerCustomDetectors(Collection<Project> projects) {
        HashSet jarFiles = Sets.newHashSet();
        for (Project project : projects) {
            jarFiles.addAll(this.client.findRuleJars(project));
            for (Project library : project.getAllLibraries()) {
                jarFiles.addAll(this.client.findRuleJars(library));
            }
        }
        jarFiles.addAll(this.client.findGlobalRuleJars());
        if (!jarFiles.isEmpty()) {
            ArrayList registries = Lists.newArrayListWithExpectedSize((int)jarFiles.size());
            registries.add(this.registry);
            for (File jarFile : jarFiles) {
                try {
                    JarFileIssueRegistry registry = JarFileIssueRegistry.get(this.client, jarFile);
                    if (registry.hasLegacyDetectors()) {
                        this.runCompatChecks = true;
                    }
                    if (this.myCustomIssues == null) {
                        this.myCustomIssues = Sets.newHashSet();
                    }
                    this.myCustomIssues.addAll(registry.getIssues());
                    registries.add(registry);
                }
                catch (Throwable e) {
                    this.client.log(e, "Could not load custom rule jar file %1$s", jarFile);
                }
            }
            if (registries.size() > 1) {
                this.registry = new CompositeIssueRegistry(registries);
            }
        }
    }

    private void runExtraPhases(Project project, Project main) {
        if (this.repeatingDetectors != null) {
            EnumSet<Scope> oldScope = this.scope;
            do {
                ++this.phase;
                this.fireEvent(LintListener.EventType.NEW_PHASE, new Context(this, project, null, project.getDir()));
                if (this.repeatScope == null) {
                    this.repeatScope = Scope.ALL;
                }
                this.scope = Scope.intersect(this.scope, this.repeatScope);
                if (this.scope.isEmpty()) break;
                this.computeRepeatingDetectors(this.repeatingDetectors, project);
                if (this.applicableDetectors.isEmpty()) continue;
                this.checkProject(project, main);
                if (this.canceled) break;
            } while (this.phase < 3 && this.repeatingDetectors != null);
            this.scope = oldScope;
        }
    }

    private void computeRepeatingDetectors(List<Detector> detectors, Project project) {
        this.currentFolderType = null;
        this.currentVisitor = null;
        this.currentXmlDetectors = null;
        this.currentBinaryDetectors = null;
        List<Issue> issues = this.registry.getIssues();
        ArrayListMultimap issueMap = ArrayListMultimap.create((int)issues.size(), (int)3);
        for (Issue issue : issues) {
            issueMap.put(issue.getImplementation().getDetectorClass(), (Object)issue);
        }
        HashMap detectorToScope = new HashMap();
        EnumMap<Scope, List<Detector>> scopeToDetectors = new EnumMap<Scope, List<Detector>>(Scope.class);
        ArrayList<? extends Detector> detectorList = new ArrayList<Detector>();
        Configuration configuration = project.getConfiguration(this);
        for (Detector detector : detectors) {
            Class<?> detectorClass = detector.getClass();
            Collection detectorIssues = issueMap.get(detectorClass);
            if (detectorIssues == null) continue;
            boolean add = false;
            for (Issue issue : detectorIssues) {
                if (!configuration.isEnabled(issue)) continue;
                add = true;
                Object s = (EnumSet)detectorToScope.get(detectorClass);
                EnumSet<Scope> issueScope = issue.getImplementation().getScope();
                if (s == null) {
                    detectorToScope.put(detectorClass, issueScope);
                    continue;
                }
                if (s.containsAll(issueScope)) continue;
                EnumSet<Scope> union = EnumSet.copyOf(s);
                union.addAll(issueScope);
                detectorToScope.put(detectorClass, union);
            }
            if (!add) continue;
            detectorList.add(detector);
            EnumSet union = (EnumSet)detectorToScope.get(detector.getClass());
            for (Object s : union) {
                ArrayList<Detector> list = (ArrayList<Detector>)scopeToDetectors.get(s);
                if (list == null) {
                    list = new ArrayList<Detector>();
                    scopeToDetectors.put((Scope)((Object)s), list);
                }
                list.add(detector);
            }
        }
        this.applicableDetectors = detectorList;
        this.scopeDetectors = scopeToDetectors;
        this.repeatingDetectors = null;
        this.repeatScope = null;
        this.validateScopeList();
    }

    private void computeDetectors(Project project) {
        this.currentFolderType = null;
        this.currentVisitor = null;
        Configuration configuration = project.getConfiguration(this);
        this.scopeDetectors = new EnumMap<Scope, List<Detector>>(Scope.class);
        this.applicableDetectors = this.registry.createDetectors(this.client, configuration, this.scope, this.scopeDetectors);
        this.validateScopeList();
    }

    private void validateScopeList() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertionsEnabled) {
            List<Detector> list;
            List<Detector> list2;
            List<Detector> list3;
            List<Detector> list4;
            List<Detector> list5;
            List<Detector> list6;
            List<Detector> list7;
            List<Detector> list8;
            List<Detector> manifestDetectors;
            List<Detector> resourceFileDetectors = this.scopeDetectors.get((Object)Scope.RESOURCE_FILE);
            if (resourceFileDetectors != null) {
                for (Detector detector : resourceFileDetectors) {
                    assert (detector instanceof ResourceXmlDetector) : detector;
                }
            }
            if ((manifestDetectors = this.scopeDetectors.get((Object)Scope.MANIFEST)) != null) {
                for (Detector detector : manifestDetectors) {
                    assert (detector instanceof Detector.XmlScanner) : detector;
                }
            }
            if ((list8 = this.scopeDetectors.get((Object)Scope.ALL_JAVA_FILES)) != null) {
                for (Detector detector : list8) {
                    assert (detector instanceof Detector.JavaScanner || detector instanceof Detector.JavaPsiScanner) : detector;
                }
            }
            if ((list7 = this.scopeDetectors.get((Object)Scope.JAVA_FILE)) != null) {
                for (Detector detector : list7) {
                    assert (detector instanceof Detector.JavaScanner || detector instanceof Detector.JavaPsiScanner) : detector;
                }
            }
            if ((list6 = this.scopeDetectors.get((Object)Scope.CLASS_FILE)) != null) {
                for (Detector detector : list6) {
                    assert (detector instanceof Detector.ClassScanner) : detector;
                }
            }
            if ((list5 = this.scopeDetectors.get((Object)Scope.ALL_CLASS_FILES)) != null) {
                for (Detector detector : list5) {
                    assert (detector instanceof Detector.ClassScanner) : detector;
                }
            }
            if ((list4 = this.scopeDetectors.get((Object)Scope.GRADLE_FILE)) != null) {
                for (Detector detector : list4) {
                    assert (detector instanceof Detector.GradleScanner) : detector;
                }
            }
            if ((list3 = this.scopeDetectors.get((Object)Scope.OTHER)) != null) {
                for (Detector detector : list3) {
                    assert (detector instanceof Detector.OtherFileScanner) : detector;
                }
            }
            if ((list2 = this.scopeDetectors.get((Object)Scope.RESOURCE_FOLDER)) != null) {
                for (Detector detector : list2) {
                    assert (detector instanceof Detector.ResourceFolderScanner) : detector;
                }
            }
            if ((list = this.scopeDetectors.get((Object)Scope.BINARY_RESOURCE_FILE)) != null) {
                for (Detector detector : list) {
                    assert (detector instanceof Detector.BinaryResourceScanner) : detector;
                }
            }
        }
    }

    private void registerProjectFile(Map<File, Project> fileToProject, File file, File projectDir, File rootDir) {
        fileToProject.put(file, this.client.getProject(projectDir, rootDir));
    }

    private Collection<Project> computeProjects(List<File> files) {
        LinkedHashMap<File, Project> fileToProject = new LinkedHashMap<File, Project>();
        File sharedRoot = null;
        ArrayList<File> absolute = new ArrayList<File>(files.size());
        for (File file : files) {
            absolute.add(file.getAbsoluteFile());
        }
        files = absolute;
        if (files.size() > 1 && (sharedRoot = LintUtils.getCommonParent(files)) != null && sharedRoot.getParentFile() == null) {
            sharedRoot = null;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                File rootDir = sharedRoot;
                if (rootDir == null) {
                    rootDir = file;
                    if (files.size() > 1 && (rootDir = file.getParentFile()) == null) {
                        rootDir = file;
                    }
                }
                if (this.client.isProjectDirectory(file)) {
                    this.registerProjectFile(fileToProject, file, file, rootDir);
                    continue;
                }
                File parent = file.getParentFile();
                if (parent != null) {
                    if (this.client.isProjectDirectory(parent)) {
                        this.registerProjectFile(fileToProject, file, parent, parent);
                        continue;
                    }
                    if ((parent = parent.getParentFile()) != null && this.client.isProjectDirectory(parent)) {
                        this.registerProjectFile(fileToProject, file, parent, parent);
                        continue;
                    }
                }
                this.addProjects(file, fileToProject, rootDir);
            } else {
                for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
                    if (!this.client.isProjectDirectory(parent)) continue;
                    this.registerProjectFile(fileToProject, file, parent, parent);
                    break;
                }
            }
            if (!this.canceled) continue;
            return Collections.emptySet();
        }
        for (Map.Entry entry : fileToProject.entrySet()) {
            Object project;
            File file = (File)entry.getKey();
            if (file.equals(((Project)(project = (Project)entry.getValue())).getDir())) continue;
            if (file.isDirectory()) {
                try {
                    File dir = file.getCanonicalFile();
                    if (dir.equals(((Project)project).getDir())) {
                        continue;
                    }
                }
                catch (IOException dir) {
                    // empty catch block
                }
            }
            ((Project)project).addFile(file);
        }
        Collection allProjects = fileToProject.values();
        HashSet<Project> hashSet = new HashSet<Project>(allProjects);
        for (Object project : allProjects) {
            hashSet.removeAll(((Project)project).getAllLibraries());
        }
        for (Object project : allProjects) {
            ((Project)project).setReportIssues(true);
        }
        if (LintUtils.assertionsEnabled()) {
            IdentityHashMap<Project, Project> projects = new IdentityHashMap<Project, Project>();
            for (Project project : hashSet) {
                projects.put(project, project);
                for (Project library : project.getAllLibraries()) {
                    projects.put(library, library);
                }
            }
            HashSet<File> dirs = new HashSet<File>();
            for (Project project : projects.keySet()) {
                assert (!dirs.contains(project.getDir()));
                dirs.add(project.getDir());
            }
        }
        return hashSet;
    }

    private void addProjects(File dir, Map<File, Project> fileToProject, File rootDir) {
        if (this.canceled) {
            return;
        }
        if (this.client.isProjectDirectory(dir)) {
            this.registerProjectFile(fileToProject, dir, dir, rootDir);
        } else {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isDirectory()) continue;
                    this.addProjects(file, fileToProject, rootDir);
                }
            }
        }
    }

    private void checkProject(Project project, Project main) {
        File projectDir = project.getDir();
        Context projectContext = new Context(this, project, null, projectDir);
        this.fireEvent(LintListener.EventType.SCANNING_PROJECT, projectContext);
        List<Project> allLibraries = project.getAllLibraries();
        HashSet<Project> allProjects = new HashSet<Project>(allLibraries.size() + 1);
        allProjects.add(project);
        allProjects.addAll(allLibraries);
        this.currentProjects = allProjects.toArray(new Project[allProjects.size()]);
        this.currentProject = project;
        for (Detector detector : this.applicableDetectors) {
            detector.beforeCheckProject(projectContext);
            if (!this.canceled) continue;
            return;
        }
        assert (this.currentProject == project);
        this.runFileDetectors(project, main);
        if (!Scope.checkSingleFile(this.scope)) {
            List<Project> libraries = project.getAllLibraries();
            for (Project library : libraries) {
                Context libraryContext = new Context(this, library, project, projectDir);
                this.fireEvent(LintListener.EventType.SCANNING_LIBRARY_PROJECT, libraryContext);
                this.currentProject = library;
                for (Detector detector : this.applicableDetectors) {
                    detector.beforeCheckLibraryProject(libraryContext);
                    if (!this.canceled) continue;
                    return;
                }
                assert (this.currentProject == library);
                this.runFileDetectors(library, main);
                if (this.canceled) {
                    return;
                }
                assert (this.currentProject == library);
                for (Detector detector : this.applicableDetectors) {
                    detector.afterCheckLibraryProject(libraryContext);
                    if (!this.canceled) continue;
                    return;
                }
            }
        }
        this.currentProject = project;
        for (Detector detector : this.applicableDetectors) {
            detector.afterCheckProject(projectContext);
            if (!this.canceled) continue;
            return;
        }
        if (this.canceled) {
            this.client.report(projectContext, IssueRegistry.CANCELLED, Severity.INFORMATIONAL, Location.create(project.getDir()), "Lint canceled by user", TextFormat.RAW);
        }
        this.currentProjects = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFileDetectors(Project project, Project main) {
        List<Detector> checks;
        if (project.isAndroidProject()) {
            for (File manifestFile : project.getManifestFiles()) {
                XmlParser parser = this.client.getXmlParser();
                if (parser == null) continue;
                XmlContext context = new XmlContext(this, project, main, manifestFile, null, parser);
                context.document = parser.parseXml(context);
                if (context.document == null) continue;
                try {
                    List<Detector> detectors;
                    project.readManifest(context.document);
                    if (project.isLibrary() && (main == null || !main.isMergingManifests()) || !this.scope.contains((Object)Scope.MANIFEST) || (detectors = this.scopeDetectors.get((Object)Scope.MANIFEST)) == null) continue;
                    ResourceVisitor v = new ResourceVisitor(parser, detectors, null);
                    this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                    v.visitFile(context, manifestFile);
                }
                finally {
                    if (context.document == null) continue;
                    parser.dispose(context, context.document);
                }
            }
            if (this.scope.contains((Object)Scope.ALL_RESOURCE_FILES) || this.scope.contains((Object)Scope.RESOURCE_FILE) || this.scope.contains((Object)Scope.RESOURCE_FOLDER) || this.scope.contains((Object)Scope.BINARY_RESOURCE_FILE)) {
                List<ResourceXmlDetector> xmlDetectors;
                boolean haveXmlChecks;
                List<Detector> dirChecks = this.scopeDetectors.get((Object)Scope.RESOURCE_FOLDER);
                List<Detector> binaryChecks = this.scopeDetectors.get((Object)Scope.BINARY_RESOURCE_FILE);
                List<Detector> checks2 = LintDriver.union(this.scopeDetectors.get((Object)Scope.RESOURCE_FILE), this.scopeDetectors.get((Object)Scope.ALL_RESOURCE_FILES));
                boolean bl = haveXmlChecks = checks2 != null && !checks2.isEmpty();
                if (haveXmlChecks) {
                    xmlDetectors = new ArrayList(checks2.size());
                    for (Detector detector : checks2) {
                        if (!(detector instanceof ResourceXmlDetector)) continue;
                        xmlDetectors.add((ResourceXmlDetector)detector);
                    }
                    haveXmlChecks = !xmlDetectors.isEmpty();
                } else {
                    xmlDetectors = Collections.emptyList();
                }
                if (haveXmlChecks || dirChecks != null && !dirChecks.isEmpty() || binaryChecks != null && !binaryChecks.isEmpty()) {
                    List<File> files = project.getSubset();
                    if (files != null) {
                        this.checkIndividualResources(project, main, xmlDetectors, dirChecks, binaryChecks, files);
                    } else {
                        List<File> resourceFolders = project.getResourceFolders();
                        if (!resourceFolders.isEmpty()) {
                            for (File res : resourceFolders) {
                                this.checkResFolder(project, main, res, xmlDetectors, dirChecks, binaryChecks);
                            }
                        }
                    }
                }
            }
            if (this.canceled) {
                return;
            }
        }
        if ((this.scope.contains((Object)Scope.JAVA_FILE) || this.scope.contains((Object)Scope.ALL_JAVA_FILES)) && (checks = LintDriver.union(this.scopeDetectors.get((Object)Scope.JAVA_FILE), this.scopeDetectors.get((Object)Scope.ALL_JAVA_FILES))) != null && !checks.isEmpty()) {
            List<File> files = project.getSubset();
            if (files != null) {
                this.checkIndividualJavaFiles(project, main, checks, files);
            } else {
                List<File> sourceFolders = project.getJavaSourceFolders();
                List<File> testFolders = this.scope.contains((Object)Scope.TEST_SOURCES) ? project.getTestSourceFolders() : Collections.emptyList();
                this.checkJava(project, main, sourceFolders, testFolders, checks);
            }
        }
        if (this.canceled) {
            return;
        }
        if (this.scope.contains((Object)Scope.CLASS_FILE) || this.scope.contains((Object)Scope.ALL_CLASS_FILES) || this.scope.contains((Object)Scope.JAVA_LIBRARIES)) {
            this.checkClasses(project, main);
        }
        if (this.canceled) {
            return;
        }
        if (this.scope.contains((Object)Scope.GRADLE_FILE)) {
            this.checkBuildScripts(project, main);
        }
        if (this.canceled) {
            return;
        }
        if (this.scope.contains((Object)Scope.OTHER) && (checks = this.scopeDetectors.get((Object)Scope.OTHER)) != null) {
            OtherFileVisitor visitor = new OtherFileVisitor(checks);
            visitor.scan(this, project, main);
        }
        if (this.canceled) {
            return;
        }
        if (project == main && this.scope.contains((Object)Scope.PROGUARD_FILE) && project.isAndroidProject()) {
            this.checkProGuard(project, main);
        }
        if (project == main && this.scope.contains((Object)Scope.PROPERTY_FILE)) {
            this.checkProperties(project, main);
        }
    }

    private void checkBuildScripts(Project project, Project main) {
        List<Detector> detectors = this.scopeDetectors.get((Object)Scope.GRADLE_FILE);
        if (detectors != null) {
            List<File> files = project.getSubset();
            if (files == null) {
                files = project.getGradleBuildScripts();
            }
            for (File file : files) {
                Context context = new Context(this, project, main, file);
                this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                for (Detector detector : detectors) {
                    detector.beforeCheckFile(context);
                    detector.visitBuildScript(context, Maps.newHashMap());
                    detector.afterCheckFile(context);
                }
            }
        }
    }

    private void checkProGuard(Project project, Project main) {
        List<Detector> detectors = this.scopeDetectors.get((Object)Scope.PROGUARD_FILE);
        if (detectors != null) {
            List<File> files = project.getProguardFiles();
            for (File file : files) {
                Context context = new Context(this, project, main, file);
                this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                for (Detector detector : detectors) {
                    detector.beforeCheckFile(context);
                    detector.run(context);
                    detector.afterCheckFile(context);
                }
            }
        }
    }

    private void checkProperties(Project project, Project main) {
        List<Detector> detectors = this.scopeDetectors.get((Object)Scope.PROPERTY_FILE);
        if (detectors != null) {
            this.checkPropertyFile(project, main, detectors, "local.properties");
            this.checkPropertyFile(project, main, detectors, SdkConstants.FD_GRADLE_WRAPPER + File.separator + "gradle-wrapper.properties");
        }
    }

    private void checkPropertyFile(Project project, Project main, List<Detector> detectors, String relativePath) {
        File file = new File(project.getDir(), relativePath);
        if (file.exists()) {
            Context context = new Context(this, project, main, file);
            this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
            for (Detector detector : detectors) {
                detector.beforeCheckFile(context);
                detector.run(context);
                detector.afterCheckFile(context);
            }
        }
    }

    boolean isCanceled() {
        return this.canceled;
    }

    public String getSuperClass(String name) {
        return this.client.getSuperClass(this.currentProject, name);
    }

    public boolean isSubclassOf(ClassNode classNode, String superClassName) {
        Boolean isSub;
        if (superClassName.equals(classNode.superName)) {
            return true;
        }
        if (this.currentProject != null && (isSub = this.client.isSubclassOf(this.currentProject, classNode.name, superClassName)) != null) {
            return isSub;
        }
        String className = classNode.name;
        while (className != null) {
            if (className.equals(superClassName)) {
                return true;
            }
            className = this.getSuperClass(className);
        }
        return false;
    }

    private static List<Detector> union(List<Detector> list1, List<Detector> list2) {
        if (list1 == null) {
            return list2;
        }
        if (list2 == null) {
            return list1;
        }
        HashSet<Detector> set = new HashSet<Detector>(list1.size() + list2.size());
        set.addAll(list1);
        set.addAll(list2);
        return new ArrayList<Detector>(set);
    }

    private void checkClasses(Project project, Project main) {
        List<ClassEntry> classEntries;
        List<File> files = project.getSubset();
        if (files != null) {
            this.checkIndividualClassFiles(project, main, files);
            return;
        }
        List<File> libraries = project.getJavaLibraries(false);
        List<ClassEntry> libraryEntries = ClassEntry.fromClassPath(this.client, libraries, true);
        List<File> classFolders = project.getJavaClassFolders();
        if (classFolders.isEmpty()) {
            String message = String.format("No `.class` files were found in project \"%1$s\", so none of the classfile based checks could be run. Does the project need to be built first?", project.getName());
            Location location = Location.create(project.getDir());
            this.client.report(new Context(this, project, main, project.getDir()), IssueRegistry.LINT_ERROR, project.getConfiguration(this).getSeverity(IssueRegistry.LINT_ERROR), location, message, TextFormat.RAW);
            classEntries = Collections.emptyList();
        } else {
            classEntries = ClassEntry.fromClassPath(this.client, classFolders, true);
        }
        this.runClassDetectors(Scope.JAVA_LIBRARIES, libraryEntries, project, main);
        if (this.canceled) {
            return;
        }
        this.runClassDetectors(Scope.CLASS_FILE, classEntries, project, main);
        this.runClassDetectors(Scope.ALL_CLASS_FILES, classEntries, project, main);
    }

    private void checkIndividualClassFiles(Project project, Project main, List<File> files) {
        List<ClassEntry> entries;
        ArrayList classFiles = Lists.newArrayListWithExpectedSize((int)files.size());
        List<File> classFolders = project.getJavaClassFolders();
        if (!classFolders.isEmpty()) {
            for (File file : files) {
                String path = file.getPath();
                if (!file.isFile() || !path.endsWith(".class")) continue;
                classFiles.add(file);
            }
        }
        if (!(entries = ClassEntry.fromClassFiles(this.client, classFiles, classFolders, true)).isEmpty()) {
            Collections.sort(entries);
            this.runClassDetectors(Scope.CLASS_FILE, entries, project, main);
        }
    }

    private void runClassDetectors(Scope scope, List<ClassEntry> entries, Project project, Project main) {
        List<Detector> classDetectors;
        if (this.scope.contains((Object)scope) && (classDetectors = this.scopeDetectors.get((Object)scope)) != null && !classDetectors.isEmpty() && !entries.isEmpty()) {
            AsmVisitor visitor = new AsmVisitor(this.client, classDetectors);
            CharSequence sourceContents = null;
            String sourceName = "";
            this.mOuterClasses = new ArrayDeque<ClassNode>();
            ClassEntry prev = null;
            for (ClassEntry entry : entries) {
                ClassNode peek;
                ClassNode classNode;
                if (prev != null && prev.compareTo(entry) == 0) continue;
                prev = entry;
                try {
                    ClassReader reader = new ClassReader(entry.bytes);
                    classNode = new ClassNode();
                    reader.accept((ClassVisitor)classNode, 0);
                }
                catch (Throwable t) {
                    this.client.log(null, "Error processing %1$s: broken class file?", entry.path());
                    continue;
                }
                while ((peek = this.mOuterClasses.peek()) != null && !classNode.name.startsWith(peek.name)) {
                    this.mOuterClasses.pop();
                }
                this.mOuterClasses.push(classNode);
                if (this.isSuppressed(null, classNode)) continue;
                if (sourceContents != null) {
                    int oldRootLength;
                    String newName = classNode.name;
                    int newRootLength = newName.indexOf(36);
                    if (newRootLength == -1) {
                        newRootLength = newName.length();
                    }
                    if ((oldRootLength = sourceName.indexOf(36)) == -1) {
                        oldRootLength = sourceName.length();
                    }
                    if (newRootLength != oldRootLength || !sourceName.regionMatches(0, newName, 0, newRootLength)) {
                        sourceContents = null;
                    }
                }
                ClassContext context = new ClassContext(this, project, main, entry.file, entry.jarFile, entry.binDir, entry.bytes, classNode, scope == Scope.JAVA_LIBRARIES, sourceContents);
                try {
                    visitor.runClassDetectors(context);
                }
                catch (Exception e) {
                    this.client.log(e, null, new Object[0]);
                }
                if (this.canceled) {
                    return;
                }
                sourceContents = context.getSourceContents(false);
                sourceName = classNode.name;
            }
            this.mOuterClasses = null;
        }
    }

    public ClassNode getOuterClassNode(ClassNode classNode) {
        String outerName = classNode.outerClass;
        Iterator<ClassNode> iterator = this.mOuterClasses.iterator();
        while (iterator.hasNext()) {
            ClassNode node = iterator.next();
            if (outerName != null) {
                if (!node.name.equals(outerName)) continue;
                return node;
            }
            if (node != classNode) continue;
            return iterator.hasNext() ? iterator.next() : null;
        }
        return null;
    }

    public ClassNode findClass(ClassContext context, String type, int flags) {
        String relative = type.replace('/', File.separatorChar) + ".class";
        File classFile = this.findClassFile(context.getProject(), relative);
        if (classFile != null) {
            if (classFile.getPath().endsWith(".jar")) {
                return null;
            }
            try {
                byte[] bytes = this.client.readBytes(classFile);
                ClassReader reader = new ClassReader(bytes);
                ClassNode classNode = new ClassNode();
                reader.accept((ClassVisitor)classNode, flags);
                return classNode;
            }
            catch (Throwable t) {
                this.client.log(null, "Error processing %1$s: broken class file?", classFile.getPath());
            }
        }
        return null;
    }

    private File findClassFile(Project project, String relativePath) {
        File path;
        for (File root : this.client.getJavaClassFolders(project)) {
            path = new File(root, relativePath);
            if (!path.exists()) continue;
            return path;
        }
        for (File root : this.client.getJavaLibraries(project, true)) {
            path = new File(root, relativePath);
            if (!path.exists()) continue;
            return path;
        }
        for (Project library : project.getDirectLibraries()) {
            path = this.findClassFile(library, relativePath);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    private void checkJava(Project project, Project main, List<File> sourceFolders, List<File> testSourceFolders, List<Detector> checks) {
        JavaContext context;
        JavaParser javaParser = this.client.getJavaParser(project);
        if (javaParser == null) {
            this.client.log(null, "No java parser provided to lint: not running Java checks", new Object[0]);
            return;
        }
        assert (!checks.isEmpty());
        ArrayList<File> sources = new ArrayList<File>(100);
        for (File folder : sourceFolders) {
            LintDriver.gatherJavaFiles(folder, sources);
        }
        ArrayList contexts = Lists.newArrayListWithExpectedSize((int)(2 * sources.size()));
        for (File file : sources) {
            context = new JavaContext(this, project, main, file, javaParser);
            contexts.add(context);
        }
        sources.clear();
        for (File folder : testSourceFolders) {
            LintDriver.gatherJavaFiles(folder, sources);
        }
        for (File file : sources) {
            context = new JavaContext(this, project, main, file, javaParser);
            context.setTestSource(true);
            contexts.add(context);
        }
        if (!contexts.isEmpty()) {
            this.visitJavaFiles(checks, javaParser, contexts);
        }
    }

    private void visitJavaFiles(List<Detector> checks, JavaParser javaParser, List<JavaContext> contexts) {
        ArrayList scanners = Lists.newArrayListWithCapacity((int)checks.size());
        for (Detector detector : checks) {
            if (!(detector instanceof Detector.JavaPsiScanner)) continue;
            scanners.add(detector);
        }
        JavaPsiVisitor visitor = new JavaPsiVisitor(javaParser, scanners);
        if (this.runCompatChecks) {
            visitor.setDisposeUnitsAfterUse(false);
        }
        this.parserErrors = !visitor.prepare(contexts);
        for (JavaContext javaContext : contexts) {
            this.fireEvent(LintListener.EventType.SCANNING_FILE, javaContext);
            visitor.visitFile(javaContext);
            if (!this.canceled) continue;
            return;
        }
        if (this.runCompatChecks) {
            try {
                javaParser.getClass().getMethod("disposePsi", new Class[0]).invoke((Object)javaParser, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)checks.size());
            for (Detector detector : checks) {
                if (!(detector instanceof Detector.JavaScanner)) continue;
                assert (!(detector instanceof Detector.JavaPsiScanner));
                arrayList.add(detector);
            }
            if (!arrayList.isEmpty()) {
                ArrayList arrayList2 = Lists.newArrayListWithCapacity((int)arrayList.size());
                for (Detector detector : arrayList) {
                    arrayList2.add(detector.getClass().getName());
                }
                Collections.sort(arrayList2);
                JavaVisitor javaVisitor = new JavaVisitor(javaParser, arrayList);
                for (JavaContext context : contexts) {
                    this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                    javaVisitor.visitFile(context);
                    if (!this.canceled) continue;
                    return;
                }
            }
        }
        visitor.dispose();
    }

    private void checkIndividualJavaFiles(Project project, Project main, List<Detector> checks, List<File> files) {
        JavaParser javaParser = this.client.getJavaParser(project);
        if (javaParser == null) {
            this.client.log(null, "No java parser provided to lint: not running Java checks", new Object[0]);
            return;
        }
        ArrayList contexts = Lists.newArrayListWithExpectedSize((int)files.size());
        for (File file : files) {
            if (!file.isFile() || !file.getPath().endsWith(".java")) continue;
            contexts.add(new JavaContext(this, project, main, file, javaParser));
        }
        if (contexts.isEmpty()) {
            return;
        }
        this.visitJavaFiles(checks, javaParser, contexts);
    }

    private static void gatherJavaFiles(File dir, List<File> result) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile() && file.getName().endsWith(".java")) {
                    result.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                LintDriver.gatherJavaFiles(file, result);
            }
        }
    }

    private ResourceVisitor getVisitor(ResourceFolderType type, List<ResourceXmlDetector> checks, List<Detector> binaryChecks) {
        if (type != this.currentFolderType) {
            this.currentFolderType = type;
            ArrayList<ResourceXmlDetector> applicableXmlChecks = new ArrayList<ResourceXmlDetector>(checks.size());
            for (ResourceXmlDetector resourceXmlDetector : checks) {
                if (!resourceXmlDetector.appliesTo(type)) continue;
                applicableXmlChecks.add(resourceXmlDetector);
            }
            ArrayList<Detector> applicableBinaryChecks = null;
            if (binaryChecks != null) {
                applicableBinaryChecks = new ArrayList<Detector>(binaryChecks.size());
                for (Detector check : binaryChecks) {
                    if (!check.appliesTo(type)) continue;
                    applicableBinaryChecks.add(check);
                }
            }
            if (this.currentXmlDetectors != null && this.currentXmlDetectors.equals(applicableXmlChecks) && Objects.equal(this.currentBinaryDetectors, applicableBinaryChecks)) {
                return this.currentVisitor;
            }
            this.currentXmlDetectors = applicableXmlChecks;
            this.currentBinaryDetectors = applicableBinaryChecks;
            if (applicableXmlChecks.isEmpty() && (applicableBinaryChecks == null || applicableBinaryChecks.isEmpty())) {
                this.currentVisitor = null;
                return null;
            }
            XmlParser xmlParser = this.client.getXmlParser();
            this.currentVisitor = xmlParser != null ? new ResourceVisitor(xmlParser, applicableXmlChecks, applicableBinaryChecks) : null;
        }
        return this.currentVisitor;
    }

    private void checkResFolder(Project project, Project main, File res, List<ResourceXmlDetector> xmlChecks, List<Detector> dirChecks, List<Detector> binaryChecks) {
        Object[] resourceDirs = res.listFiles();
        if (resourceDirs == null) {
            return;
        }
        Arrays.sort(resourceDirs);
        for (Object dir : resourceDirs) {
            ResourceFolderType type = ResourceFolderType.getFolderType((String)((File)dir).getName());
            if (type != null) {
                this.checkResourceFolder(project, main, (File)dir, type, xmlChecks, dirChecks, binaryChecks);
            }
            if (!this.canceled) continue;
            return;
        }
    }

    private void checkResourceFolder(Project project, Project main, File dir, ResourceFolderType type, List<ResourceXmlDetector> xmlChecks, List<Detector> dirChecks, List<Detector> binaryChecks) {
        Object[] files;
        if (dirChecks != null && !dirChecks.isEmpty()) {
            ResourceContext context = new ResourceContext(this, project, main, dir, type);
            String folderName = dir.getName();
            this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
            for (Detector check : dirChecks) {
                if (!check.appliesTo(type)) continue;
                check.beforeCheckFile(context);
                check.checkFolder(context, folderName);
                check.afterCheckFile(context);
            }
            if (binaryChecks == null && xmlChecks.isEmpty()) {
                return;
            }
        }
        if ((files = dir.listFiles()) == null || files.length <= 0) {
            return;
        }
        ResourceVisitor visitor = this.getVisitor(type, xmlChecks, binaryChecks);
        if (visitor != null) {
            Arrays.sort(files);
            for (Object file : files) {
                ResourceContext context;
                if (LintUtils.isXmlFile((File)file)) {
                    context = new XmlContext(this, project, main, (File)file, type, visitor.getParser());
                    this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                    visitor.visitFile((XmlContext)context, (File)file);
                } else if (binaryChecks != null && (LintUtils.isBitmapFile((File)file) || type == ResourceFolderType.RAW)) {
                    context = new ResourceContext(this, project, main, (File)file, type);
                    this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                    visitor.visitBinaryResource(context);
                }
                if (!this.canceled) continue;
                return;
            }
        }
    }

    private void checkIndividualResources(Project project, Project main, List<ResourceXmlDetector> xmlDetectors, List<Detector> dirChecks, List<Detector> binaryChecks, List<File> files) {
        for (File file : files) {
            ResourceContext context;
            ResourceVisitor visitor;
            ResourceFolderType type;
            String folderName;
            if (file.isDirectory()) {
                ResourceFolderType type2 = ResourceFolderType.getFolderType((String)file.getName());
                if (type2 != null && new File(file.getParentFile(), "res").exists()) {
                    this.checkResourceFolder(project, main, file, type2, xmlDetectors, dirChecks, binaryChecks);
                    continue;
                }
                if (file.getName().equals("res")) {
                    this.checkResFolder(project, main, file, xmlDetectors, dirChecks, binaryChecks);
                    continue;
                }
                this.client.log(null, "Unexpected folder %1$s; should be project, \"res\" folder or resource folder", file.getPath());
                continue;
            }
            if (file.isFile() && LintUtils.isXmlFile(file)) {
                folderName = file.getParentFile().getName();
                type = ResourceFolderType.getFolderType((String)folderName);
                if (type == null || (visitor = this.getVisitor(type, xmlDetectors, binaryChecks)) == null) continue;
                context = new XmlContext(this, project, main, file, type, visitor.getParser());
                this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
                visitor.visitFile((XmlContext)context, file);
                continue;
            }
            if (binaryChecks == null || !file.isFile() || !LintUtils.isBitmapFile(file) || (type = ResourceFolderType.getFolderType((String)(folderName = file.getParentFile().getName()))) == null || (visitor = this.getVisitor(type, xmlDetectors, binaryChecks)) == null) continue;
            context = new ResourceContext(this, project, main, file, type);
            this.fireEvent(LintListener.EventType.SCANNING_FILE, context);
            visitor.visitBinaryResource(context);
            if (!this.canceled) continue;
            return;
        }
    }

    public void addLintListener(LintListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<LintListener>(1);
        }
        this.listeners.add(listener);
    }

    public void removeLintListener(LintListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    private void fireEvent(LintListener.EventType type, Context context) {
        if (this.listeners != null) {
            for (LintListener listener : this.listeners) {
                listener.update(this, type, context);
            }
        }
    }

    public void requestRepeat(Detector detector, EnumSet<Scope> scope) {
        if (this.repeatingDetectors == null) {
            this.repeatingDetectors = new ArrayList<Detector>();
        }
        this.repeatingDetectors.add(detector);
        if (scope != null) {
            if (this.repeatScope == null) {
                this.repeatScope = scope;
            } else {
                this.repeatScope = EnumSet.copyOf(this.repeatScope);
                this.repeatScope.addAll(scope);
            }
        } else {
            this.repeatScope = Scope.ALL;
        }
    }

    public boolean isSuppressed(Issue issue, ClassNode classNode, MethodNode method, AbstractInsnNode instruction) {
        if (method.invisibleAnnotations != null) {
            List annotations = method.invisibleAnnotations;
            return LintDriver.isSuppressed(issue, annotations);
        }
        if (instruction != null && method.name.charAt(0) == '<') {
            AbstractInsnNode next = LintUtils.getNextInstruction(instruction);
            if (next != null && next.getType() == 4) {
                FieldInsnNode fieldRef = (FieldInsnNode)next;
                FieldNode field = this.findField(classNode, fieldRef.owner, fieldRef.name);
                if (field != null && this.isSuppressed(issue, field)) {
                    return true;
                }
            } else if (classNode.outerClass != null && classNode.outerMethod == null && LintUtils.isAnonymousClass(classNode) && this.isSuppressed(issue, classNode)) {
                return true;
            }
        }
        return false;
    }

    private static MethodInsnNode findConstructorInvocation(MethodNode method, String className) {
        InsnList nodes = method.instructions;
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            AbstractInsnNode instruction = nodes.get(i);
            if (instruction.getOpcode() != 183) continue;
            MethodInsnNode call = (MethodInsnNode)instruction;
            if (!className.equals(call.owner)) continue;
            return call;
        }
        return null;
    }

    private FieldNode findField(ClassNode classNode, String owner, String name) {
        ClassNode current = classNode;
        while (current != null) {
            if (owner.equals(current.name)) {
                List fieldList = current.fields;
                for (Object f : fieldList) {
                    FieldNode field = (FieldNode)f;
                    if (!field.name.equals(name)) continue;
                    return field;
                }
                return null;
            }
            current = this.getOuterClassNode(current);
        }
        return null;
    }

    private MethodNode findMethod(ClassNode classNode, String name, boolean includeInherited) {
        ClassNode current = classNode;
        while (current != null) {
            List methodList = current.methods;
            for (Object f : methodList) {
                MethodNode method = (MethodNode)f;
                if (!method.name.equals(name)) continue;
                return method;
            }
            if (!includeInherited) break;
            current = this.getOuterClassNode(current);
        }
        return null;
    }

    public boolean isSuppressed(Issue issue, FieldNode field) {
        if (field.invisibleAnnotations != null) {
            List annotations = field.invisibleAnnotations;
            return LintDriver.isSuppressed(issue, annotations);
        }
        return false;
    }

    public boolean isSuppressed(Issue issue, ClassNode classNode) {
        ClassNode outer;
        if (classNode.invisibleAnnotations != null) {
            List annotations = classNode.invisibleAnnotations;
            return LintDriver.isSuppressed(issue, annotations);
        }
        if (classNode.outerClass != null && classNode.outerMethod == null && LintUtils.isAnonymousClass(classNode) && (outer = this.getOuterClassNode(classNode)) != null) {
            MethodInsnNode call;
            MethodNode m = this.findMethod(outer, "<init>", false);
            if (m != null && (call = LintDriver.findConstructorInvocation(m, classNode.name)) != null && this.isSuppressed(issue, outer, m, (AbstractInsnNode)call)) {
                return true;
            }
            m = this.findMethod(outer, "<clinit>", false);
            if (m != null && (call = LintDriver.findConstructorInvocation(m, classNode.name)) != null && this.isSuppressed(issue, outer, m, (AbstractInsnNode)call)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isSuppressed(Issue issue, List<AnnotationNode> annotations) {
        for (AnnotationNode annotation : annotations) {
            String desc = annotation.desc;
            if (!desc.endsWith(SUPPRESS_LINT_VMSIG) || annotation.values == null) continue;
            int n = annotation.values.size();
            for (int i = 0; i < n; i += 2) {
                String key = (String)annotation.values.get(i);
                if (!key.equals("value")) continue;
                Object value = annotation.values.get(i + 1);
                if (value instanceof String) {
                    String id = (String)value;
                    if (!LintDriver.matches(issue, id)) continue;
                    return true;
                }
                if (!(value instanceof List)) continue;
                List list = (List)value;
                for (Object v : list) {
                    String id;
                    if (!(v instanceof String) || !LintDriver.matches(issue, id = (String)v)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean matches(Issue issue, String id) {
        if (id.equalsIgnoreCase("all")) {
            return true;
        }
        if (issue != null) {
            String issueId = issue.getId();
            if (id.equalsIgnoreCase(issueId)) {
                return true;
            }
            if (id.startsWith(STUDIO_ID_PREFIX) && id.regionMatches(true, STUDIO_ID_PREFIX.length(), issueId, 0, issueId.length()) && id.substring(STUDIO_ID_PREFIX.length()).equalsIgnoreCase(issueId)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isSuppressed(Issue issue, String string) {
        if (string.isEmpty()) {
            return false;
        }
        if (string.indexOf(44) == -1) {
            if (LintDriver.matches(issue, string)) {
                return true;
            }
        } else {
            for (String id : Splitter.on((char)',').trimResults().split((CharSequence)string)) {
                if (!LintDriver.matches(issue, id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSuppressed(JavaContext context, Issue issue, Node scope) {
        boolean checkComments;
        boolean bl = checkComments = this.client.checkForSuppressComments() && context != null && context.containsCommentSuppress();
        while (scope != null) {
            VariableDefinition declaration;
            Class<?> type = scope.getClass();
            if (type == VariableDefinition.class ? LintDriver.isSuppressed(issue, (declaration = (VariableDefinition)scope).astModifiers()) : (type == MethodDeclaration.class ? LintDriver.isSuppressed(issue, (declaration = (MethodDeclaration)scope).astModifiers()) : (type == ConstructorDeclaration.class ? LintDriver.isSuppressed(issue, (declaration = (ConstructorDeclaration)scope).astModifiers()) : (TypeDeclaration.class.isAssignableFrom(type) ? LintDriver.isSuppressed(issue, (declaration = (TypeDeclaration)scope).astModifiers()) : type == AnnotationMethodDeclaration.class && LintDriver.isSuppressed(issue, (declaration = (AnnotationMethodDeclaration)scope).astModifiers()))))) {
                return true;
            }
            if (checkComments && context.isSuppressedWithComment(scope, issue)) {
                return true;
            }
            scope = scope.getParent();
        }
        return false;
    }

    public boolean isSuppressed(JavaContext context, Issue issue, PsiElement scope) {
        boolean checkComments;
        boolean bl = checkComments = this.client.checkForSuppressComments() && context != null && context.containsCommentSuppress();
        while (scope != null) {
            PsiModifierListOwner owner;
            if (scope instanceof PsiModifierListOwner && LintDriver.isSuppressed(issue, (owner = (PsiModifierListOwner)scope).getModifierList())) {
                return true;
            }
            if (checkComments && context.isSuppressedWithComment(scope, issue)) {
                return true;
            }
            if (!((scope = scope.getParent()) instanceof PsiFile)) continue;
            return false;
        }
        return false;
    }

    private static boolean isSuppressed(Issue issue, Modifiers modifiers) {
        if (modifiers == null) {
            return false;
        }
        StrictListAccessor annotations = modifiers.astAnnotations();
        if (annotations == null) {
            return false;
        }
        for (Annotation annotation : annotations) {
            StrictListAccessor values;
            TypeReference t = annotation.astAnnotationTypeReference();
            String typeName = t.getTypeName();
            if (!typeName.endsWith("SuppressLint") && !typeName.endsWith("SuppressWarnings") || (values = annotation.astElements()) == null) continue;
            for (AnnotationElement element : values) {
                ArrayInitializer array;
                StrictListAccessor expressions;
                AnnotationValue valueNode = element.astValue();
                if (valueNode == null) continue;
                if (valueNode instanceof StringLiteral) {
                    StringLiteral literal = (StringLiteral)valueNode;
                    String value = literal.astValue();
                    if (!LintDriver.matches(issue, value)) continue;
                    return true;
                }
                if (!(valueNode instanceof ArrayInitializer) || (expressions = (array = (ArrayInitializer)valueNode).astExpressions()) == null) continue;
                for (Expression arrayElement : expressions) {
                    String value;
                    if (!(arrayElement instanceof StringLiteral) || !LintDriver.matches(issue, value = ((StringLiteral)arrayElement).astValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isSuppressed(Issue issue, PsiModifierList modifierList) {
        if (modifierList == null) {
            return false;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            String fqcn = annotation.getQualifiedName();
            if (fqcn == null || !fqcn.equals("android.annotation.SuppressLint") && !fqcn.equals(SUPPRESS_WARNINGS_FQCN) && !fqcn.equals("SuppressLint")) continue;
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            for (PsiNameValuePair pair : parameterList.getAttributes()) {
                if (!LintDriver.isSuppressed(issue, pair.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSuppressed(Issue issue, PsiAnnotationMemberValue value) {
        block4: {
            PsiExpression[] initializers;
            block5: {
                block3: {
                    if (!(value instanceof PsiLiteral)) break block3;
                    PsiLiteral literal = (PsiLiteral)value;
                    Object literalValue = literal.getValue();
                    if (literalValue instanceof String && LintDriver.isSuppressed(issue, (String)literalValue)) {
                        return true;
                    }
                    break block4;
                }
                if (!(value instanceof PsiArrayInitializerMemberValue)) break block5;
                PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)value;
                for (PsiAnnotationMemberValue mmv : mv.getInitializers()) {
                    if (!LintDriver.isSuppressed(issue, mmv)) continue;
                    return true;
                }
                break block4;
            }
            if (!(value instanceof PsiArrayInitializerExpression)) break block4;
            PsiArrayInitializerExpression expression = (PsiArrayInitializerExpression)value;
            for (PsiExpression e : initializers = expression.getInitializers()) {
                if (!LintDriver.isSuppressed(issue, (PsiAnnotationMemberValue)e)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSuppressed(XmlContext context, Issue issue, org.w3c.dom.Node node) {
        boolean checkComments;
        if (node instanceof Attr) {
            node = ((Attr)node).getOwnerElement();
        }
        boolean bl = checkComments = this.client.checkForSuppressComments() && context != null && context.containsCommentSuppress();
        while (node != null) {
            String ignore;
            Element element;
            if (node.getNodeType() == 1 && ((element = (Element)node).hasAttributeNS("http://schemas.android.com/tools", "ignore") ? LintDriver.isSuppressed(issue, ignore = element.getAttributeNS("http://schemas.android.com/tools", "ignore")) : checkComments && context.isSuppressedWithComment(node, issue))) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    public int getResourceFolderVersion(File resourceFile) {
        File parent = resourceFile.getParentFile();
        if (parent == null) {
            return -1;
        }
        if (parent.equals(this.cachedFolder)) {
            return this.cachedFolderVersion;
        }
        this.cachedFolder = parent;
        this.cachedFolderVersion = -1;
        for (String qualifier : FolderConfiguration.QUALIFIER_SPLITTER.split((CharSequence)parent.getName())) {
            Matcher matcher = VERSION_PATTERN.matcher(qualifier);
            if (!matcher.matches()) continue;
            String group = matcher.group(1);
            assert (group != null);
            this.cachedFolderVersion = Integer.parseInt(group);
            break;
        }
        return this.cachedFolderVersion;
    }

    static {
        VERSION_PATTERN = Pattern.compile("^v(\\d+)$");
    }

    private class LintClientWrapper
    extends LintClient {
        private final LintClient mDelegate;

        public LintClientWrapper(LintClient delegate) {
            super(LintClientWrapper.getClientName());
            this.mDelegate = delegate;
        }

        @Override
        public void report(Context context, Issue issue, Severity severity, Location location, String message, TextFormat format) {
            boolean filtered;
            if (location == null) {
                assert (false) : issue;
                return;
            }
            assert (LintDriver.this.currentProject != null);
            if (!LintDriver.this.currentProject.getReportIssues()) {
                return;
            }
            Configuration configuration = context.getConfiguration();
            if (!configuration.isEnabled(issue)) {
                if (issue != IssueRegistry.PARSER_ERROR && issue != IssueRegistry.LINT_ERROR) {
                    this.mDelegate.log(null, "Incorrect detector reported disabled issue %1$s", issue.toString());
                }
                return;
            }
            if (configuration.isIgnored(context, issue, location, message)) {
                return;
            }
            if (severity == Severity.IGNORE) {
                return;
            }
            if (LintDriver.this.baseline != null && (filtered = LintDriver.this.baseline.findAndMark(issue, location, message, severity, context.getProject()))) {
                return;
            }
            this.mDelegate.report(context, issue, severity, location, message, format);
        }

        @Override
        public Configuration getConfiguration(Project project, LintDriver driver) {
            return this.mDelegate.getConfiguration(project, driver);
        }

        @Override
        public void log(Severity severity, Throwable exception, String format, Object ... args) {
            this.mDelegate.log(exception, format, args);
        }

        @Override
        public List<File> getTestLibraries(Project project) {
            return this.mDelegate.getTestLibraries(project);
        }

        @Override
        public String getClientRevision() {
            return this.mDelegate.getClientRevision();
        }

        @Override
        public void runReadAction(Runnable runnable) {
            this.mDelegate.runReadAction(runnable);
        }

        @Override
        public CharSequence readFile(File file) {
            return this.mDelegate.readFile(file);
        }

        @Override
        public byte[] readBytes(File file) throws IOException {
            return this.mDelegate.readBytes(file);
        }

        @Override
        public List<File> getJavaSourceFolders(Project project) {
            return this.mDelegate.getJavaSourceFolders(project);
        }

        @Override
        public List<File> getJavaClassFolders(Project project) {
            return this.mDelegate.getJavaClassFolders(project);
        }

        @Override
        public List<File> getJavaLibraries(Project project, boolean includeProvided) {
            return this.mDelegate.getJavaLibraries(project, includeProvided);
        }

        @Override
        public List<File> getTestSourceFolders(Project project) {
            return this.mDelegate.getTestSourceFolders(project);
        }

        @Override
        public Collection<Project> getKnownProjects() {
            return this.mDelegate.getKnownProjects();
        }

        @Override
        public BuildToolInfo getBuildTools(Project project) {
            return this.mDelegate.getBuildTools(project);
        }

        @Override
        public Map<String, String> createSuperClassMap(Project project) {
            return this.mDelegate.createSuperClassMap(project);
        }

        @Override
        public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
            return this.mDelegate.getResourceVisibilityProvider();
        }

        @Override
        public List<File> getResourceFolders(Project project) {
            return this.mDelegate.getResourceFolders(project);
        }

        @Override
        public XmlParser getXmlParser() {
            return this.mDelegate.getXmlParser();
        }

        @Override
        public Class<? extends Detector> replaceDetector(Class<? extends Detector> detectorClass) {
            return this.mDelegate.replaceDetector(detectorClass);
        }

        @Override
        public SdkInfo getSdkInfo(Project project) {
            return this.mDelegate.getSdkInfo(project);
        }

        @Override
        public Project getProject(File dir, File referenceDir) {
            return this.mDelegate.getProject(dir, referenceDir);
        }

        @Override
        public JavaParser getJavaParser(Project project) {
            return this.mDelegate.getJavaParser(project);
        }

        @Override
        public File findResource(String relativePath) {
            return this.mDelegate.findResource(relativePath);
        }

        @Override
        public File getCacheDir(boolean create) {
            return this.mDelegate.getCacheDir(create);
        }

        @Override
        protected LintClient.ClassPathInfo getClassPath(Project project) {
            return this.mDelegate.getClassPath(project);
        }

        @Override
        public void log(Throwable exception, String format, Object ... args) {
            this.mDelegate.log(exception, format, args);
        }

        @Override
        public File getSdkHome() {
            return this.mDelegate.getSdkHome();
        }

        @Override
        public IAndroidTarget[] getTargets() {
            return this.mDelegate.getTargets();
        }

        @Override
        public AndroidSdkHandler getSdk() {
            return this.mDelegate.getSdk();
        }

        @Override
        public IAndroidTarget getCompileTarget(Project project) {
            return this.mDelegate.getCompileTarget(project);
        }

        @Override
        public int getHighestKnownApiLevel() {
            return this.mDelegate.getHighestKnownApiLevel();
        }

        @Override
        public String getSuperClass(Project project, String name) {
            return this.mDelegate.getSuperClass(project, name);
        }

        @Override
        public Boolean isSubclassOf(Project project, String name, String superClassName) {
            return this.mDelegate.isSubclassOf(project, name, superClassName);
        }

        @Override
        public String getProjectName(Project project) {
            return this.mDelegate.getProjectName(project);
        }

        @Override
        public boolean isGradleProject(Project project) {
            return this.mDelegate.isGradleProject(project);
        }

        @Override
        protected Project createProject(File dir, File referenceDir) {
            return this.mDelegate.createProject(dir, referenceDir);
        }

        @Override
        public List<File> findGlobalRuleJars() {
            return this.mDelegate.findGlobalRuleJars();
        }

        @Override
        public List<File> findRuleJars(Project project) {
            return this.mDelegate.findRuleJars(project);
        }

        @Override
        public boolean isProjectDirectory(File dir) {
            return this.mDelegate.isProjectDirectory(dir);
        }

        @Override
        public void registerProject(File dir, Project project) {
            this.log(Severity.WARNING, null, "Too late to register projects", new Object[0]);
            this.mDelegate.registerProject(dir, project);
        }

        @Override
        public IssueRegistry addCustomLintRules(IssueRegistry registry) {
            return this.mDelegate.addCustomLintRules(registry);
        }

        @Override
        public List<File> getAssetFolders(Project project) {
            return this.mDelegate.getAssetFolders(project);
        }

        @Override
        public ClassLoader createUrlClassLoader(URL[] urls, ClassLoader parent) {
            return this.mDelegate.createUrlClassLoader(urls, parent);
        }

        @Override
        public boolean checkForSuppressComments() {
            return this.mDelegate.checkForSuppressComments();
        }

        @Override
        public boolean supportsProjectResources() {
            return this.mDelegate.supportsProjectResources();
        }

        @Override
        public AbstractResourceRepository getProjectResources(Project project, boolean includeDependencies) {
            return this.mDelegate.getProjectResources(project, includeDependencies);
        }

        @Override
        public AbstractResourceRepository getResourceRepository(Project project, boolean includeModuleDependencies, boolean includeLibraries) {
            return this.mDelegate.getResourceRepository(project, includeModuleDependencies, includeLibraries);
        }

        @Override
        public ProgressIndicator getRepositoryLogger() {
            return this.mDelegate.getRepositoryLogger();
        }

        @Override
        public Location.Handle createResourceItemHandle(ResourceItem item) {
            return this.mDelegate.createResourceItemHandle(item);
        }

        @Override
        public URLConnection openConnection(URL url) throws IOException {
            return this.mDelegate.openConnection(url);
        }

        @Override
        public void closeConnection(URLConnection connection) throws IOException {
            this.mDelegate.closeConnection(connection);
        }
    }
}

