/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Beta
public abstract class IssueRegistry {
    private static volatile List<Category> categories;
    private static volatile Map<String, Issue> idToIssue;
    private static Map<EnumSet<Scope>, List<Issue>> scopeIssues;
    private static final Implementation DUMMY_IMPLEMENTATION;
    public static final Issue PARSER_ERROR;
    public static final Issue LINT_ERROR;
    public static final Issue CANCELLED;
    public static final Issue BASELINE;

    protected IssueRegistry() {
    }

    public abstract List<Issue> getIssues();

    protected int getIssueCapacity(EnumSet<Scope> scope) {
        return 20;
    }

    protected List<Issue> getIssuesForScope(EnumSet<Scope> scope) {
        List<Issue> list = scopeIssues.get(scope);
        if (list == null) {
            List<Issue> issues = this.getIssues();
            if (scope.equals(Scope.ALL)) {
                list = issues;
            } else {
                list = new ArrayList<Issue>(this.getIssueCapacity(scope));
                for (Issue issue : issues) {
                    if (!issue.getImplementation().isAdequate(scope)) continue;
                    list.add(issue);
                }
            }
            scopeIssues.put(scope, list);
        }
        return list;
    }

    final List<? extends Detector> createDetectors(LintClient client, Configuration configuration, EnumSet<Scope> scope, Map<Scope, List<Detector>> scopeToDetectors) {
        List<Issue> issues = this.getIssuesForScope(scope);
        if (issues.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Class<? extends Detector>> detectorClasses = new HashSet<Class<? extends Detector>>();
        HashMap<Class<? extends Detector>, EnumSet<Scope>> detectorToScope = new HashMap<Class<? extends Detector>, EnumSet<Scope>>();
        for (Issue issue : issues) {
            Implementation implementation = issue.getImplementation();
            Class<? extends Detector> detectorClass = implementation.getDetectorClass();
            EnumSet<Scope> issueScope = implementation.getScope();
            if (!detectorClasses.contains(detectorClass)) {
                if (!configuration.isEnabled(issue)) continue;
                assert (implementation.isAdequate(scope));
                detectorClass = client.replaceDetector(detectorClass);
                assert (detectorClass != null) : issue.getId();
                detectorClasses.add(detectorClass);
            }
            if (scopeToDetectors == null) continue;
            EnumSet s = (EnumSet)detectorToScope.get(detectorClass);
            if (s == null) {
                detectorToScope.put(detectorClass, issueScope);
                continue;
            }
            if (s.containsAll(issueScope)) continue;
            EnumSet<Scope> union = EnumSet.copyOf(s);
            union.addAll(issueScope);
            detectorToScope.put(detectorClass, union);
        }
        ArrayList<Detector> detectors = new ArrayList<Detector>(detectorClasses.size());
        for (Class clazz : detectorClasses) {
            try {
                Detector detector = (Detector)clazz.newInstance();
                detectors.add(detector);
                if (scopeToDetectors == null) continue;
                EnumSet union = (EnumSet)detectorToScope.get(clazz);
                for (Scope s : union) {
                    List<Detector> list = scopeToDetectors.get((Object)s);
                    if (list == null) {
                        list = new ArrayList<Detector>();
                        scopeToDetectors.put(s, list);
                    }
                    list.add(detector);
                }
            }
            catch (Throwable t) {
                client.log(t, "Can't initialize detector %1$s", clazz.getName());
            }
        }
        return detectors;
    }

    public final boolean isIssueId(String id) {
        return this.getIssue(id) != null;
    }

    public final boolean isCategoryName(String name) {
        for (Category category : this.getCategories()) {
            if (!category.getName().equals(name) && !category.getFullName().equals(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Category> getCategories() {
        List<Category> categories = IssueRegistry.categories;
        if (categories != null) return categories;
        Class<IssueRegistry> clazz = IssueRegistry.class;
        synchronized (IssueRegistry.class) {
            categories = IssueRegistry.categories;
            if (categories != null) return categories;
            IssueRegistry.categories = categories = Collections.unmodifiableList(this.createCategoryList());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return categories;
        }
    }

    private List<Category> createCategoryList() {
        HashSet categorySet = Sets.newHashSetWithExpectedSize((int)20);
        for (Issue issue : this.getIssues()) {
            categorySet.add(issue.getCategory());
        }
        ArrayList<Category> sorted = new ArrayList<Category>(categorySet);
        Collections.sort(sorted);
        return sorted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Issue getIssue(String id) {
        Map<String, Issue> map = idToIssue;
        if (map != null) return map.get(id);
        Class<IssueRegistry> clazz = IssueRegistry.class;
        synchronized (IssueRegistry.class) {
            map = idToIssue;
            if (map != null) return map.get(id);
            idToIssue = map = this.createIdToIssueMap();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return map.get(id);
        }
    }

    private Map<String, Issue> createIdToIssueMap() {
        List<Issue> issues = this.getIssues();
        HashMap map = Maps.newHashMapWithExpectedSize((int)(issues.size() + 2));
        for (Issue issue : issues) {
            map.put(issue.getId(), issue);
        }
        map.put(PARSER_ERROR.getId(), PARSER_ERROR);
        map.put(LINT_ERROR.getId(), LINT_ERROR);
        map.put(BASELINE.getId(), BASELINE);
        return map;
    }

    protected static void reset() {
        idToIssue = null;
        categories = null;
        scopeIssues = Maps.newHashMap();
    }

    static {
        scopeIssues = Maps.newHashMap();
        DUMMY_IMPLEMENTATION = new Implementation(Detector.class, EnumSet.noneOf(Scope.class));
        PARSER_ERROR = Issue.create("ParserError", "Parser Errors", "Lint will ignore any files that contain fatal parsing errors. These may contain other errors, or contain code which affects issues in other files.", Category.CORRECTNESS, 10, Severity.ERROR, DUMMY_IMPLEMENTATION);
        LINT_ERROR = Issue.create("LintError", "Lint Failure", "This issue type represents a problem running lint itself. Examples include failure to find bytecode for source files (which means certain detectors could not be run), parsing errors in lint configuration files, etc.\nThese errors are not errors in your own code, but they are shown to make it clear that some checks were not completed.", Category.LINT, 10, Severity.ERROR, DUMMY_IMPLEMENTATION);
        CANCELLED = Issue.create("LintCanceled", "Lint Canceled", "Lint canceled by user; the issue report may not be complete.", Category.LINT, 0, Severity.INFORMATIONAL, DUMMY_IMPLEMENTATION);
        BASELINE = Issue.create("LintBaseline", "Baseline Issues", "Lint can be configured with a \"baseline\"; a set of current issues found in a codebase, which future runs of lint will silently ignore. Only new issues not found in the baseline are reported.\n\nNote that while opening files in the IDE, baseline issues are not filtered out; the purpose of baselines is to allow you to get started using lint and break the build on all newly introduced errors, without having to go back and fix the entire codebase up front. However, when you open up existing files you still want to be aware of and fix issues as you come across them.\n\nThis issue type is used to emit two types of informational messages in reports: first, whether any issues were filtered out so you don't have a false sense of security if you forgot that you've checked in a baseline file, and second, whether any issues in the baseline file appear to have been fixed such that you can stop filtering them out and get warned if the issues are re-introduced.", Category.LINT, 10, Severity.INFORMATIONAL, DUMMY_IMPLEMENTATION);
    }
}

