/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public enum ResourceType {
    ANIM("anim", "Animation", new String[0]),
    ANIMATOR("animator", "Animator", new String[0]),
    ARRAY("array", "Array", "string-array", "integer-array"),
    ATTR("attr", "Attr", new String[0]),
    BOOL("bool", "Boolean", new String[0]),
    COLOR("color", "Color", new String[0]),
    DIMEN("dimen", "Dimension", new String[0]),
    DRAWABLE("drawable", "Drawable", new String[0]),
    FONT("font", "Font", new String[0]),
    FRACTION("fraction", "Fraction", new String[0]),
    ID("id", "ID", new String[0]),
    INTEGER("integer", "Integer", new String[0]),
    INTERPOLATOR("interpolator", "Interpolator", new String[0]),
    LAYOUT("layout", "Layout", new String[0]),
    MENU("menu", "Menu", new String[0]),
    MIPMAP("mipmap", "Mip Map", new String[0]),
    NAVIGATION("navigation", "Navigation", new String[0]),
    PLURALS("plurals", "Plurals", new String[0]),
    RAW("raw", "Raw", new String[0]),
    STRING("string", "String", new String[0]),
    STYLE("style", "Style", new String[0]),
    STYLEABLE("styleable", "Styleable", Kind.STYLEABLE),
    TRANSITION("transition", "Transition", new String[0]),
    XML("xml", "XML", new String[0]),
    PUBLIC("public", "Public visibility modifier", Kind.SYNTHETIC),
    AAPT("_aapt", "Aapt Attribute", Kind.SYNTHETIC),
    OVERLAYABLE("overlayable", "Overlayable tag", Kind.SYNTHETIC),
    STYLE_ITEM("item", "Style Item", Kind.SYNTHETIC),
    SAMPLE_DATA("sample", "Sample data", Kind.SYNTHETIC),
    MACRO("macro", "Macro resource replacement", Kind.SYNTHETIC);

    private final String mName;
    private final Kind mKind;
    private final String mDisplayName;
    private final String[] mAlternateXmlNames;
    public static final ImmutableSet<ResourceType> REFERENCEABLE_TYPES;
    private static final ImmutableMap<String, ResourceType> TAG_NAMES;
    private static final ImmutableMap<String, ResourceType> CLASS_NAMES;

    private ResourceType(String name, String displayName, String ... alternateXmlNames) {
        this.mName = name;
        this.mKind = Kind.REAL;
        this.mDisplayName = displayName;
        this.mAlternateXmlNames = alternateXmlNames;
    }

    private ResourceType(String name, String displayName, Kind kind) {
        this.mName = name;
        this.mKind = kind;
        this.mDisplayName = displayName;
        this.mAlternateXmlNames = new String[0];
    }

    public String getName() {
        return this.mName;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public static ResourceType fromClassName(String className) {
        return (ResourceType)((Object)CLASS_NAMES.get((Object)className));
    }

    public static ResourceType fromFolderName(String folderName) {
        return (ResourceType)((Object)CLASS_NAMES.get((Object)folderName));
    }

    public static ResourceType fromXmlTagName(String tagName) {
        return (ResourceType)((Object)TAG_NAMES.get((Object)tagName));
    }

    public static ResourceType fromXmlValue(String xmlValue) {
        if (xmlValue.equals("declare-styleable") || xmlValue.equals(ResourceType.STYLEABLE.mName)) {
            return null;
        }
        if (xmlValue.equals(ResourceType.SAMPLE_DATA.mName)) {
            return SAMPLE_DATA;
        }
        if (xmlValue.equals(ResourceType.AAPT.mName)) {
            return AAPT;
        }
        if (xmlValue.equals(ResourceType.OVERLAYABLE.mName)) {
            return OVERLAYABLE;
        }
        return (ResourceType)((Object)CLASS_NAMES.get((Object)xmlValue));
    }

    public static <T> ResourceType fromXmlTag(T tag, Function<T, String> nameFunction, BiFunction<? super T, ? super String, String> attributeFunction) {
        String tagName;
        switch (tagName = nameFunction.apply(tag)) {
            case "eat-comment": {
                return null;
            }
            case "item": {
                String typeAttribute = attributeFunction.apply(tag, "type");
                if (!Strings.isNullOrEmpty((String)typeAttribute)) {
                    return ResourceType.fromClassName(typeAttribute);
                }
                return null;
            }
        }
        return ResourceType.fromXmlTagName(tagName);
    }

    public static ResourceType fromXmlTag(Node domNode) {
        if (!(domNode instanceof Element)) {
            return null;
        }
        Element tag = (Element)domNode;
        return ResourceType.fromXmlTag(tag, element -> (String)MoreObjects.firstNonNull((Object)element.getLocalName(), (Object)element.getTagName()), Element::getAttribute);
    }

    public static Collection<String> getClassNames() {
        return CLASS_NAMES.keySet();
    }

    public boolean getHasInnerClass() {
        return this.mKind != Kind.SYNTHETIC;
    }

    public boolean getCanBeReferenced() {
        return this.mKind == Kind.REAL && this != ATTR;
    }

    public boolean isSynthetic() {
        return this.mKind == Kind.SYNTHETIC;
    }

    public String toString() {
        return this.getName();
    }

    static {
        ImmutableMap.Builder tagNames = ImmutableMap.builder();
        tagNames.put((Object)"declare-styleable", (Object)STYLEABLE);
        tagNames.put((Object)"public", (Object)PUBLIC);
        tagNames.put((Object)OVERLAYABLE.getName(), (Object)OVERLAYABLE);
        tagNames.put((Object)MACRO.getName(), (Object)MACRO);
        ImmutableMap.Builder classNames = ImmutableMap.builder();
        classNames.put((Object)ResourceType.STYLEABLE.mName, (Object)STYLEABLE);
        for (ResourceType type : ResourceType.values()) {
            if (type.mKind != Kind.REAL || type == STYLEABLE) continue;
            classNames.put((Object)type.getName(), (Object)type);
            tagNames.put((Object)type.getName(), (Object)type);
            for (String alternateName : type.mAlternateXmlNames) {
                tagNames.put((Object)alternateName, (Object)type);
            }
        }
        TAG_NAMES = tagNames.build();
        CLASS_NAMES = classNames.build();
        REFERENCEABLE_TYPES = (ImmutableSet)Arrays.stream(ResourceType.values()).filter(ResourceType::getCanBeReferenced).collect(Sets.toImmutableEnumSet());
    }

    private static enum Kind {
        REAL,
        STYLEABLE,
        SYNTHETIC;

    }
}

