/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jetbrains.uast.java

import com.intellij.psi.PsiAssignmentExpression
import org.jetbrains.annotations.ApiStatus
import org.jetbrains.uast.*

@ApiStatus.Internal
class JavaUAssignmentExpression(
  override val sourcePsi: PsiAssignmentExpression,
  givenParent: UElement?
) : JavaAbstractUExpression(givenParent), UBinaryExpression {

  private val leftOperandPart = UastLazyPart<UExpression>()
  private val rightOperandPart = UastLazyPart<UExpression>()
  private val operatorPart = UastLazyPart<UastBinaryOperator>()

  override val leftOperand: UExpression
    get() = leftOperandPart.getOrBuild { JavaConverter.convertOrEmpty(sourcePsi.lExpression, this) }

  override val rightOperand: UExpression
    get() = rightOperandPart.getOrBuild { JavaConverter.convertOrEmpty(sourcePsi.rExpression, this) }

  override val operator: UastBinaryOperator
    get() = operatorPart.getOrBuild { sourcePsi.operationTokenType.getOperatorType() }

  override fun resolveOperator(): Nothing? = null

  override val operatorIdentifier: UIdentifier
    get() = UIdentifier(sourcePsi.operationSign, this)
}
