/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u001a \u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0015"}, d2={"parentAnyway", "Lorg/jetbrains/uast/UElement;", "getParentAnyway", "(Lorg/jetbrains/uast/UElement;)Lorg/jetbrains/uast/UElement;", "getContainingAnnotationEntry", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiAnnotation;", "", "uElement", "getContainingUAnnotationEntry", "Lorg/jetbrains/uast/UAnnotation;", "getIdentifierAnnotationOwner", "Lorg/jetbrains/uast/UDeclaration;", "identifier", "Lcom/intellij/psi/PsiElement;", "getNameElement", "getUParentForAnnotationIdentifier", "isResolvedToAnnotation", "", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "intellij.platform.uast"})
@JvmName(name="UAnnotationUtils")
@SourceDebugExtension(value={"SMAP\nUAnnotationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UAnnotationUtils.kt\norg/jetbrains/uast/UAnnotationUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,112:1\n1#2:113\n169#3:114\n*S KotlinDebug\n*F\n+ 1 UAnnotationUtils.kt\norg/jetbrains/uast/UAnnotationUtils\n*L\n77#1:114\n*E\n"})
public final class UAnnotationUtils {
    @Nullable
    public static final PsiElement getNameElement(@Nullable UElement uElement) {
        PsiElement psiElement;
        UElement uElement2 = uElement;
        if (uElement2 instanceof UAnnotation) {
            psiElement = UAnnotationKt.getNamePsiElement((UAnnotation)uElement);
        } else if (uElement2 instanceof USimpleNameReferenceExpression) {
            psiElement = ((USimpleNameReferenceExpression)uElement).getSourcePsi();
        } else if (uElement2 instanceof UCallExpression) {
            UIdentifier uIdentifier = ((UCallExpression)uElement).getMethodIdentifier();
            if (uIdentifier != null && (uIdentifier = uIdentifier.getSourcePsi()) != null) {
                UIdentifier it = uIdentifier;
                boolean bl = false;
                psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)it);
            } else {
                psiElement = null;
            }
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    public static final UDeclaration getIdentifierAnnotationOwner(@NotNull PsiElement identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        UElement uElement = UAnnotationUtils.getUParentForAnnotationIdentifier(identifier);
        return uElement != null ? UDeclarationKt.getContainingDeclaration(uElement) : null;
    }

    @Nullable
    public static final UElement getUParentForAnnotationIdentifier(@NotNull PsiElement identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        UElement uElement = UastUtils.getUParentForIdentifier(identifier);
        if (uElement == null) {
            return null;
        }
        UElement originalParent = uElement;
        UElement uElement2 = originalParent;
        if (uElement2 instanceof UAnnotation) {
            return originalParent;
        }
        if (uElement2 instanceof UCallExpression) {
            return UAnnotationUtils.isResolvedToAnnotation(((UCallExpression)originalParent).getClassReference()) ? originalParent : null;
        }
        if (uElement2 instanceof UReferenceExpression && UAnnotationUtils.isResolvedToAnnotation((UReferenceExpression)originalParent)) {
            UElement uElement3 = UAnnotationUtils.getParentAnyway(originalParent);
            if (uElement3 == null) {
                return null;
            }
            UElement parentAnyway2 = uElement3;
            UElement uElement4 = (UElement)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile(UElementKt.getWithContainingElements(parentAnyway2), (Function1)getUParentForAnnotationIdentifier.annotationLikeParent.1.INSTANCE));
            if (uElement4 == null) {
                return parentAnyway2;
            }
            UElement annotationLikeParent2 = uElement4;
            if (!(annotationLikeParent2 instanceof UAnnotation) && annotationLikeParent2.getUastParent() instanceof UAnnotation) {
                return annotationLikeParent2.getUastParent();
            }
            return annotationLikeParent2;
        }
        return null;
    }

    @Nullable
    public static final Pair<UAnnotation, String> getContainingUAnnotationEntry(@Nullable UElement uElement) {
        return UAnnotationUtils.getContainingUAnnotationEntry$retrievePsiAnnotationEntry(uElement, null);
    }

    @Nullable
    public static final Pair<PsiAnnotation, String> getContainingAnnotationEntry(@Nullable UElement uElement) {
        Pair<UAnnotation, String> pair = UAnnotationUtils.getContainingUAnnotationEntry(uElement);
        if (pair == null) {
            return null;
        }
        Pair<UAnnotation, String> pair2 = pair;
        UAnnotation uAnnotation2 = (UAnnotation)pair2.component1();
        String name = (String)pair2.component2();
        PsiAnnotation psiAnnotation = uAnnotation2.getJavaPsi();
        if (psiAnnotation == null) {
            return null;
        }
        PsiAnnotation psiAnnotation2 = psiAnnotation;
        return TuplesKt.to((Object)psiAnnotation2, (Object)name);
    }

    private static final boolean isResolvedToAnnotation(UReferenceExpression reference) {
        UReferenceExpression uReferenceExpression = reference;
        PsiElement psiElement = uReferenceExpression != null ? uReferenceExpression.resolve() : null;
        PsiClass psiClass2 = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        return psiClass2 != null ? psiClass2.isAnnotationType() : false;
    }

    private static final UElement getParentAnyway(UElement $this$parentAnyway) {
        UElement uElement = $this$parentAnyway.getUastParent();
        if (uElement == null) {
            PsiElement psiElement = $this$parentAnyway.getSourcePsi();
            uElement = (UElement)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)(psiElement != null ? psiElement.getParent() : null), (Function1)parentAnyway.1.INSTANCE), (Function1)parentAnyway.2.INSTANCE));
        }
        return uElement;
    }

    private static final Pair<UAnnotation, String> getContainingUAnnotationEntry$tryConvertToEntry(UElement uElement, UElement parent, String name) {
        if (!(uElement instanceof UExpression)) {
            return null;
        }
        PsiElement $this$toUElementOfType$iv = parent.getSourcePsi();
        boolean $i$f$toUElementOfType = false;
        UAnnotation uAnnotation2 = UastContextKt.toUElement($this$toUElementOfType$iv, UAnnotation.class);
        if (uAnnotation2 == null) {
            return null;
        }
        UAnnotation uAnnotation3 = uAnnotation2;
        PsiElement argumentSourcePsi = UastLiteralUtils.wrapULiteral((UExpression)uElement).getSourcePsi();
        UAnnotation uAnnotation4 = uAnnotation3;
        String string = name;
        if (string == null) {
            Object v3;
            UAnnotation uAnnotation5;
            block4: {
                Iterable iterable = uAnnotation3.getAttributeValues();
                uAnnotation5 = uAnnotation4;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    UNamedExpression it = (UNamedExpression)t;
                    boolean bl = false;
                    if (!(UastLiteralUtils.wrapULiteral(it.getExpression()).getSourcePsi() == argumentSourcePsi)) continue;
                    v3 = t;
                    break block4;
                }
                v3 = null;
            }
            uAnnotation4 = uAnnotation5;
            UNamedExpression uNamedExpression = v3;
            string = uNamedExpression != null ? uNamedExpression.getName() : null;
        }
        return TuplesKt.to((Object)uAnnotation4, (Object)string);
    }

    private static final Pair<UAnnotation, String> getContainingUAnnotationEntry$retrievePsiAnnotationEntry(UElement uElement, String name) {
        Pair<UAnnotation, String> pair;
        block8: {
            while (true) {
                UElement parent;
                if (uElement == null) {
                    return null;
                }
                if (uElement.getUastParent() == null) {
                    return null;
                }
                UElement uElement2 = parent;
                if (uElement2 instanceof UAnnotation) {
                    pair = TuplesKt.to((Object)parent, (Object)name);
                    break block8;
                }
                if (uElement2 instanceof UReferenceExpression) {
                    pair = UAnnotationUtils.getContainingUAnnotationEntry$tryConvertToEntry(uElement, parent, name);
                    break block8;
                }
                if (uElement2 instanceof UCallExpression) {
                    if (Intrinsics.areEqual((Object)((UCallExpression)parent).getKind(), (Object)UastCallKind.NESTED_ARRAY_INITIALIZER)) {
                        uElement = parent;
                        name = null;
                        continue;
                    }
                    pair = UAnnotationUtils.getContainingUAnnotationEntry$tryConvertToEntry(uElement, parent, name);
                    break block8;
                }
                if (uElement2 instanceof UPolyadicExpression) {
                    uElement = parent;
                    name = null;
                    continue;
                }
                if (!(uElement2 instanceof UNamedExpression)) break;
                String string = ((UNamedExpression)parent).getName();
                uElement = parent;
                name = string;
            }
            pair = null;
        }
        return pair;
    }
}

