/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns.uast;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.UElementPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UMultiResolvable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00002\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u001c\u0010\u0004\u001a\u00020\u00002\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0004\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u00002\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0006J\u0014\u0010\u000f\u001a\u00020\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000bJ\u0014\u0010\u0012\u001a\u00020\u00002\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u001e\u0010\u0013\u001a\u00020\u00002\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u00062\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/patterns/uast/UCallExpressionPattern;", "Lcom/intellij/patterns/uast/UElementPattern;", "Lorg/jetbrains/uast/UCallExpression;", "()V", "constructor", "classPattern", "Lcom/intellij/patterns/ElementPattern;", "Lcom/intellij/psi/PsiClass;", "parameterCount", "", "className", "", "withAnyResolvedMethod", "method", "Lcom/intellij/psi/PsiMethod;", "withMethodName", "namePattern", "methodName", "withReceiver", "withResolvedMethod", "multiResolve", "", "intellij.platform.uast"})
public final class UCallExpressionPattern
extends UElementPattern<UCallExpression, UCallExpressionPattern> {
    public UCallExpressionPattern() {
        super(UCallExpression.class);
    }

    @NotNull
    public final UCallExpressionPattern withReceiver(@NotNull ElementPattern<PsiClass> classPattern) {
        Intrinsics.checkNotNullParameter(classPattern, (String)"classPattern");
        return (UCallExpressionPattern)((Object)this.filterWithContext((Function2)new Function2<UCallExpression, ProcessingContext, Boolean>(classPattern){
            final /* synthetic */ ElementPattern<PsiClass> $classPattern;
            {
                this.$classPattern = $classPattern;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull UCallExpression it, @NotNull ProcessingContext context) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                PsiType psiType = it.getReceiverType();
                PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                if (psiClassType != null && (psiClassType = psiClassType.resolve()) != null) {
                    PsiClassType psiClassType2 = psiClassType;
                    ElementPattern<PsiClass> elementPattern = this.$classPattern;
                    PsiClassType it2 = psiClassType2;
                    boolean bl2 = false;
                    bl = elementPattern.accepts((Object)it2, context);
                } else {
                    bl = false;
                }
                return bl;
            }
        }));
    }

    @NotNull
    public final UCallExpressionPattern withMethodName(@NotNull String methodName2) {
        Intrinsics.checkNotNullParameter((Object)methodName2, (String)"methodName");
        ObjectPattern objectPattern = StandardPatterns.string().equalTo((Object)methodName2);
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"string().equalTo(methodName)");
        return this.withMethodName((ElementPattern<String>)((ElementPattern)objectPattern));
    }

    @NotNull
    public final UCallExpressionPattern withAnyResolvedMethod(@NotNull ElementPattern<? extends PsiMethod> method) {
        Intrinsics.checkNotNullParameter(method, (String)"method");
        return this.withResolvedMethod(method, true);
    }

    @NotNull
    public final UCallExpressionPattern withResolvedMethod(@NotNull ElementPattern<? extends PsiMethod> method, boolean multiResolve) {
        Intrinsics.checkNotNullParameter(method, (String)"method");
        PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)ContainerUtil.findInstance((Iterable)method.getCondition().getConditions(), PsiNamePatternCondition.class);
        return (UCallExpressionPattern)((Object)this.filterWithContext((Function2)new Function2<UCallExpression, ProcessingContext, Boolean>(nameCondition, multiResolve, method){
            final /* synthetic */ PsiNamePatternCondition<?> $nameCondition;
            final /* synthetic */ boolean $multiResolve;
            final /* synthetic */ ElementPattern<? extends PsiMethod> $method;
            {
                this.$nameCondition = $nameCondition;
                this.$multiResolve = $multiResolve;
                this.$method = $method;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull UCallExpression uCallExpression, @NotNull ProcessingContext context) {
                boolean bl;
                block6: {
                    Object methodName2;
                    Intrinsics.checkNotNullParameter((Object)uCallExpression, (String)"uCallExpression");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    if (this.$nameCondition != null && (methodName2 = uCallExpression.getMethodName()) != null && !this.$nameCondition.getNamePattern().accepts(methodName2)) {
                        return false;
                    }
                    if (this.$multiResolve && uCallExpression instanceof UMultiResolvable) {
                        void $this$any$iv;
                        methodName2 = ((UMultiResolvable)((Object)uCallExpression)).multiResolve();
                        ElementPattern<? extends PsiMethod> elementPattern = this.$method;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                ResolveResult it = (ResolveResult)element$iv;
                                boolean bl2 = false;
                                if (!elementPattern.accepts((Object)it.getElement(), context)) continue;
                                bl = true;
                                break block6;
                            }
                            bl = false;
                        }
                    } else {
                        PsiMethod psiMethod = uCallExpression.resolve();
                        ElementPattern<? extends PsiMethod> elementPattern = this.$method;
                        PsiMethod it = psiMethod;
                        boolean bl3 = false;
                        bl = elementPattern.accepts((Object)it, context);
                    }
                }
                return bl;
            }
        }));
    }

    @NotNull
    public final UCallExpressionPattern withMethodName(@NotNull ElementPattern<String> namePattern) {
        Intrinsics.checkNotNullParameter(namePattern, (String)"namePattern");
        return (UCallExpressionPattern)((Object)this.filterWithContext((Function2)new Function2<UCallExpression, ProcessingContext, Boolean>(namePattern){
            final /* synthetic */ ElementPattern<String> $namePattern;
            {
                this.$namePattern = $namePattern;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull UCallExpression it, @NotNull ProcessingContext context) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                String string = it.getMethodName();
                if (string != null) {
                    String string2 = string;
                    ElementPattern<String> elementPattern = this.$namePattern;
                    String it2 = string2;
                    boolean bl2 = false;
                    bl = elementPattern.accepts((Object)it2, context);
                } else {
                    bl = false;
                }
                return bl;
            }
        }));
    }

    @NotNull
    public final UCallExpressionPattern constructor(@NotNull ElementPattern<PsiClass> classPattern, int parameterCount) {
        Intrinsics.checkNotNullParameter(classPattern, (String)"classPattern");
        return (UCallExpressionPattern)((Object)this.filterWithContext((Function2)new Function2<UCallExpression, ProcessingContext, Boolean>(parameterCount, classPattern){
            final /* synthetic */ int $parameterCount;
            final /* synthetic */ ElementPattern<PsiClass> $classPattern;
            {
                this.$parameterCount = $parameterCount;
                this.$classPattern = $classPattern;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull UCallExpression it, @NotNull ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (it.getClassReference() == null) {
                    return false;
                }
                PsiMethod psiMethod = it.resolve();
                if (psiMethod == null) {
                    return false;
                }
                PsiMethod psiMethod2 = psiMethod;
                return psiMethod2.isConstructor() && psiMethod2.getParameterList().getParametersCount() == this.$parameterCount && this.$classPattern.accepts((Object)psiMethod2.getContainingClass(), context);
            }
        }));
    }

    @NotNull
    public final UCallExpressionPattern constructor(@NotNull ElementPattern<PsiClass> classPattern) {
        Intrinsics.checkNotNullParameter(classPattern, (String)"classPattern");
        return (UCallExpressionPattern)((Object)this.filterWithContext((Function2)new Function2<UCallExpression, ProcessingContext, Boolean>(classPattern){
            final /* synthetic */ ElementPattern<PsiClass> $classPattern;
            {
                this.$classPattern = $classPattern;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull UCallExpression it, @NotNull ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (it.getClassReference() == null) {
                    return false;
                }
                PsiMethod psiMethod = it.resolve();
                if (psiMethod == null) {
                    return false;
                }
                PsiMethod psiMethod2 = psiMethod;
                return psiMethod2.isConstructor() && this.$classPattern.accepts((Object)psiMethod2.getContainingClass(), context);
            }
        }));
    }

    @NotNull
    public final UCallExpressionPattern constructor(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        PsiClassPattern psiClassPattern = PsiJavaPatterns.psiClass().withQualifiedName(className);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassPattern, (String)"psiClass().withQualifiedName(className)");
        return this.constructor((ElementPattern<PsiClass>)((ElementPattern)psiClassPattern));
    }

    @NotNull
    public final UCallExpressionPattern constructor(@NotNull String className, int parameterCount) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        PsiClassPattern psiClassPattern = PsiJavaPatterns.psiClass().withQualifiedName(className);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassPattern, (String)"psiClass().withQualifiedName(className)");
        return this.constructor((ElementPattern<PsiClass>)((ElementPattern)psiClassPattern), parameterCount);
    }

    @Override
    @NotNull
    public Object clone() {
        return super.clone();
    }
}

