/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.CompilationUnit;
import lombok.ast.Identifier;
import lombok.ast.ImportDeclarationTemplate;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;

public class ImportDeclaration
extends AbstractNode {
    private boolean staticImport = false;
    ListAccessor<Identifier, ImportDeclaration> parts = ListAccessor.of(this, Identifier.class, "ImportDeclaration.parts");
    private boolean starImport = false;

    public CompilationUnit upToCompilationUnit() {
        if (!(this.getParent() instanceof CompilationUnit)) {
            return null;
        }
        CompilationUnit out = (CompilationUnit)this.getParent();
        if (!out.rawImportDeclarations().contains(this)) {
            return null;
        }
        return out;
    }

    public boolean astStaticImport() {
        return this.staticImport;
    }

    public ImportDeclaration astStaticImport(boolean staticImport) {
        this.staticImport = staticImport;
        return this;
    }

    public RawListAccessor<Identifier, ImportDeclaration> rawParts() {
        return this.parts.asRaw();
    }

    public StrictListAccessor<Identifier, ImportDeclaration> astParts() {
        return this.parts.asStrict();
    }

    public boolean astStarImport() {
        return this.starImport;
    }

    public ImportDeclaration astStarImport(boolean starImport) {
        this.starImport = starImport;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.parts.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        return this.rawParts().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        return this.rawParts().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitImportDeclaration(this)) {
            return;
        }
        for (AbstractNode child : this.parts.asIterable()) {
            child.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public ImportDeclaration copy() {
        ImportDeclaration result = new ImportDeclaration();
        result.staticImport = this.staticImport;
        for (AbstractNode n : this.parts.backingList()) {
            result.rawParts().addToEnd(n == null ? null : n.copy());
        }
        result.starImport = this.starImport;
        return result;
    }

    public String asFullyQualifiedName() {
        return ImportDeclarationTemplate.asFullyQualifiedName(this);
    }
}

