/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationTemplate;
import lombok.ast.AnnotationValue;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.DescribedNode;
import lombok.ast.ListAccessor;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReference;

public class Annotation
extends AbstractNode
implements DescribedNode,
AnnotationValue {
    private AbstractNode annotationTypeReference = null;
    ListAccessor<AnnotationElement, Annotation> elements = ListAccessor.of(this, AnnotationElement.class, "Annotation.elements");

    public Modifiers upToModifiers() {
        if (!(this.getParent() instanceof Modifiers)) {
            return null;
        }
        Modifiers out = (Modifiers)this.getParent();
        if (!out.rawAnnotations().contains(this)) {
            return null;
        }
        return out;
    }

    public TypeReference astAnnotationTypeReference() {
        if (!(this.annotationTypeReference instanceof TypeReference)) {
            return null;
        }
        return (TypeReference)this.annotationTypeReference;
    }

    public Annotation astAnnotationTypeReference(TypeReference annotationTypeReference) {
        if (annotationTypeReference == null) {
            throw new NullPointerException("annotationTypeReference is mandatory");
        }
        return this.rawAnnotationTypeReference(annotationTypeReference);
    }

    public Node rawAnnotationTypeReference() {
        return this.annotationTypeReference;
    }

    public Annotation rawAnnotationTypeReference(Node annotationTypeReference) {
        if (annotationTypeReference == this.annotationTypeReference) {
            return this;
        }
        if (annotationTypeReference != null) {
            this.adopt((AbstractNode)annotationTypeReference);
        }
        if (this.annotationTypeReference != null) {
            this.disown(this.annotationTypeReference);
        }
        this.annotationTypeReference = (AbstractNode)annotationTypeReference;
        return this;
    }

    public RawListAccessor<AnnotationElement, Annotation> rawElements() {
        return this.elements.asRaw();
    }

    public StrictListAccessor<AnnotationElement, Annotation> astElements() {
        return this.elements.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.annotationTypeReference != null) {
            result.add(this.annotationTypeReference);
        }
        result.addAll(this.elements.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.annotationTypeReference == original) {
            this.rawAnnotationTypeReference(replacement);
            return true;
        }
        return this.rawElements().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        if (this.annotationTypeReference == child) {
            this.disown((AbstractNode)child);
            this.annotationTypeReference = null;
            return true;
        }
        return this.rawElements().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitAnnotation(this)) {
            return;
        }
        if (this.annotationTypeReference != null) {
            this.annotationTypeReference.accept(visitor);
        }
        for (AbstractNode child : this.elements.asIterable()) {
            child.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public Annotation copy() {
        Annotation result = new Annotation();
        if (this.annotationTypeReference != null) {
            result.rawAnnotationTypeReference(this.annotationTypeReference.copy());
        }
        for (AbstractNode n : this.elements.backingList()) {
            result.rawElements().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return AnnotationTemplate.getDescription(this);
    }

    public List<Node> getValueValues() {
        return AnnotationTemplate.getValueValues(this);
    }

    public List<Node> getValues(String key) {
        return AnnotationTemplate.getValues(this, key);
    }
}

