/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import lombok.ast.libs.org.parboiled.asm.Opcodes;
import lombok.ast.libs.org.parboiled.asm.tree.InsnList;
import lombok.ast.libs.org.parboiled.asm.tree.InsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.MethodInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.MethodNode;
import lombok.ast.libs.org.parboiled.asm.tree.TypeInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.VarInsnNode;
import lombok.ast.libs.org.parboiled.support.Checks;
import lombok.ast.libs.org.parboiled.transform.AsmUtils;
import lombok.ast.libs.org.parboiled.transform.ParserClassNode;
import lombok.ast.libs.org.parboiled.transform.Types;
import org.jetbrains.annotations.NotNull;

class ConstructorGenerator
implements Opcodes,
Types {
    ConstructorGenerator() {
    }

    public void process(@NotNull ParserClassNode classNode) {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.ConstructorGenerator.process(...) corresponds to @NotNull parameter and must not be null");
        }
        Checks.ensure(!classNode.getConstructors().isEmpty(), "Could not extend parser class '%s', no constructor visible to derived classes found", classNode.getParentType().getClassName());
        for (MethodNode constructor : classNode.getConstructors()) {
            this.createConstuctor(classNode, constructor);
        }
        this.createNewInstanceMethod(classNode);
    }

    private void createConstuctor(ParserClassNode classNode, MethodNode constructor) {
        MethodNode newConstructor = new MethodNode(1, constructor.name, constructor.desc, constructor.signature, constructor.exceptions.toArray(new String[constructor.exceptions.size()]));
        InsnList instructions = newConstructor.instructions;
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(AsmUtils.createArgumentLoaders(constructor.desc));
        instructions.add(new MethodInsnNode(183, classNode.getParentType().getInternalName(), "<init>", constructor.desc));
        instructions.add(new InsnNode(177));
        classNode.methods.add(newConstructor);
    }

    private void createNewInstanceMethod(ParserClassNode classNode) {
        MethodNode method = new MethodNode(1, "newInstance", "()L" + BASE_PARSER.getInternalName() + ';', null, null);
        InsnList instructions = method.instructions;
        instructions.add(new TypeInsnNode(187, classNode.name));
        instructions.add(new InsnNode(89));
        instructions.add(new MethodInsnNode(183, classNode.name, "<init>", "()V"));
        instructions.add(new InsnNode(176));
        classNode.methods.add(method);
    }
}

