/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.support;

import java.util.Collection;
import java.util.List;
import lombok.ast.libs.org.parboiled.Node;
import lombok.ast.libs.org.parboiled.common.StringUtils;
import lombok.ast.libs.org.parboiled.google.base.Predicate;
import lombok.ast.libs.org.parboiled.google.collect.Iterables;
import lombok.ast.libs.org.parboiled.support.InputBuffer;
import lombok.ast.libs.org.parboiled.support.IsSingleCharMatcherVisitor;
import lombok.ast.libs.org.parboiled.support.NodeFormatter;
import lombok.ast.libs.org.parboiled.support.ParsingResult;
import lombok.ast.libs.org.parboiled.trees.Filter;
import lombok.ast.libs.org.parboiled.trees.GraphUtils;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParseTreeUtils {
    private ParseTreeUtils() {
    }

    public static <V> Node<V> findNodeByPath(Node<V> parent, @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.ParseTreeUtils.findNodeByPath(...) corresponds to @NotNull parameter and must not be null");
        }
        return parent != null && GraphUtils.hasChildren(parent) ? ParseTreeUtils.findNodeByPath(parent.getChildren(), path) : null;
    }

    public static <V> Node<V> findNodeByPath(List<Node<V>> parents, @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.ParseTreeUtils.findNodeByPath(...) corresponds to @NotNull parameter and must not be null");
        }
        if (parents != null && !parents.isEmpty()) {
            int separatorIndex = path.indexOf(47);
            String prefix = separatorIndex != -1 ? path.substring(0, separatorIndex) : path;
            Iterable<Node<V>> iterable = parents;
            if (prefix.startsWith("last:")) {
                prefix = prefix.substring(5);
                iterable = Iterables.reverse(parents);
            }
            for (Node<V> child : iterable) {
                if (!StringUtils.startsWith(child.getLabel(), prefix)) continue;
                return separatorIndex == -1 ? child : ParseTreeUtils.findNodeByPath(child, path.substring(separatorIndex + 1));
            }
        }
        return null;
    }

    public static <V, C extends Collection<Node<V>>> C collectNodesByPath(Node<V> parent, @NotNull String path, @NotNull C collection) {
        if (path == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.ParseTreeUtils.collectNodesByPath(...) corresponds to @NotNull parameter and must not be null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("3rd argument of method org.parboiled.support.ParseTreeUtils.collectNodesByPath(...) corresponds to @NotNull parameter and must not be null");
        }
        return parent != null && GraphUtils.hasChildren(parent) ? ParseTreeUtils.collectNodesByPath(parent.getChildren(), path, collection) : collection;
    }

    public static <V, C extends Collection<Node<V>>> C collectNodesByPath(List<Node<V>> parents, @NotNull String path, @NotNull C collection) {
        if (path == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.ParseTreeUtils.collectNodesByPath(...) corresponds to @NotNull parameter and must not be null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("3rd argument of method org.parboiled.support.ParseTreeUtils.collectNodesByPath(...) corresponds to @NotNull parameter and must not be null");
        }
        if (parents != null && !parents.isEmpty()) {
            int separatorIndex = path.indexOf(47);
            String prefix = separatorIndex != -1 ? path.substring(0, separatorIndex) : path;
            for (Node<V> child : parents) {
                if (!StringUtils.startsWith(child.getLabel(), prefix)) continue;
                if (separatorIndex == -1) {
                    collection.add(child);
                    continue;
                }
                ParseTreeUtils.collectNodesByPath(child, path.substring(separatorIndex + 1), collection);
            }
        }
        return collection;
    }

    public static <V> Node<V> findNode(Node<V> parent, @NotNull Predicate<Node<V>> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.ParseTreeUtils.findNode(...) corresponds to @NotNull parameter and must not be null");
        }
        if (parent != null) {
            Node<V> found;
            if (predicate.apply(parent)) {
                return parent;
            }
            if (GraphUtils.hasChildren(parent) && (found = ParseTreeUtils.findNode(parent.getChildren(), predicate)) != null) {
                return found;
            }
        }
        return null;
    }

    public static <V> Node<V> findNode(List<Node<V>> parents, @NotNull Predicate<Node<V>> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.ParseTreeUtils.findNode(...) corresponds to @NotNull parameter and must not be null");
        }
        if (parents != null && !parents.isEmpty()) {
            for (Node<V> child : parents) {
                Node<V> found = ParseTreeUtils.findNode(child, predicate);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public static <V> Node<V> findLastNode(Node<V> parent, @NotNull Predicate<Node<V>> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.ParseTreeUtils.findLastNode(...) corresponds to @NotNull parameter and must not be null");
        }
        if (parent != null) {
            Node<V> found;
            if (predicate.apply(parent)) {
                return parent;
            }
            if (GraphUtils.hasChildren(parent) && (found = ParseTreeUtils.findLastNode(parent.getChildren(), predicate)) != null) {
                return found;
            }
        }
        return null;
    }

    public static <V> Node<V> findLastNode(List<Node<V>> parents, @NotNull Predicate<Node<V>> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.ParseTreeUtils.findLastNode(...) corresponds to @NotNull parameter and must not be null");
        }
        if (parents != null && !parents.isEmpty()) {
            for (Node<V> child : Iterables.reverse(parents)) {
                Node<V> found = ParseTreeUtils.findLastNode(child, predicate);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public static <V, C extends Collection<Node<V>>> C collectNodes(Node<V> parent, @NotNull Predicate<Node<V>> predicate, @NotNull C collection) {
        if (predicate == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.ParseTreeUtils.collectNodes(...) corresponds to @NotNull parameter and must not be null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("3rd argument of method org.parboiled.support.ParseTreeUtils.collectNodes(...) corresponds to @NotNull parameter and must not be null");
        }
        return parent != null && GraphUtils.hasChildren(parent) ? ParseTreeUtils.collectNodes(parent.getChildren(), predicate, collection) : collection;
    }

    public static <V, C extends Collection<Node<V>>> C collectNodes(List<Node<V>> parents, @NotNull Predicate<Node<V>> predicate, @NotNull C collection) {
        if (predicate == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.ParseTreeUtils.collectNodes(...) corresponds to @NotNull parameter and must not be null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("3rd argument of method org.parboiled.support.ParseTreeUtils.collectNodes(...) corresponds to @NotNull parameter and must not be null");
        }
        if (parents != null && !parents.isEmpty()) {
            for (Node<V> child : parents) {
                if (predicate.apply(child)) {
                    collection.add(child);
                }
                ParseTreeUtils.collectNodes(child, predicate, collection);
            }
        }
        return collection;
    }

    public static <V> String getNodeText(Node<V> node, @NotNull InputBuffer inputBuffer) {
        if (inputBuffer == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.ParseTreeUtils.getNodeText(...) corresponds to @NotNull parameter and must not be null");
        }
        if (node == null) {
            return null;
        }
        if (!node.hasError()) {
            return ParseTreeUtils.getRawNodeText(node, inputBuffer);
        }
        if (((Boolean)node.getMatcher().accept(new IsSingleCharMatcherVisitor())).booleanValue()) {
            return String.valueOf(inputBuffer.charAt(node.getStartIndex()));
        }
        StringBuilder sb = new StringBuilder();
        int index = node.getStartIndex();
        for (Node child : node.getChildren()) {
            ParseTreeUtils.addInputLocations(inputBuffer, sb, index, child.getStartIndex());
            sb.append(ParseTreeUtils.getNodeText(child, inputBuffer));
            index = child.getEndIndex();
        }
        ParseTreeUtils.addInputLocations(inputBuffer, sb, index, node.getEndIndex());
        return sb.toString();
    }

    private static void addInputLocations(InputBuffer inputBuffer, StringBuilder sb, int start, int end) {
        block5: for (int i = start; i < end; ++i) {
            char c = inputBuffer.charAt(i);
            switch (c) {
                case '\ufdef': {
                    ++i;
                    continue block5;
                }
                case '\ufdee': {
                    continue block5;
                }
                case '\ufded': {
                    return;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    public static <V> String getRawNodeText(Node<V> node, @NotNull InputBuffer inputBuffer) {
        if (inputBuffer == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.ParseTreeUtils.getRawNodeText(...) corresponds to @NotNull parameter and must not be null");
        }
        return node == null ? null : inputBuffer.extract(node.getStartIndex(), node.getEndIndex());
    }

    public static <V> String printNodeTree(@NotNull ParsingResult<V> parsingResult) {
        if (parsingResult == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.support.ParseTreeUtils.printNodeTree(...) corresponds to @NotNull parameter and must not be null");
        }
        return ParseTreeUtils.printNodeTree(parsingResult, null);
    }

    public static <V> String printNodeTree(@NotNull ParsingResult<V> parsingResult, Filter filter) {
        if (parsingResult == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.support.ParseTreeUtils.printNodeTree(...) corresponds to @NotNull parameter and must not be null");
        }
        return GraphUtils.printTree(parsingResult.parseTreeRoot, new NodeFormatter(parsingResult.inputBuffer), filter);
    }
}

